package org.maachang.sharedTest ;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

import org.maachang.shm.ServerShm;
import org.maachang.shm.ShmConnector;

public class ServerTest2 {
    public static final String SEM_NAME = "semTest" ;
    public static final String SHM_NAME = "shmTest" ;
    public static final int LENGTH = 10 ;
    public static final int TIMEOUT = 60000 ;
    
    public static final void main( String[] args ) throws Exception {
        new ServerTest2().execution( args ) ;
    }
    
    private void execution( String[] args ) throws Exception {
        ArrayList<ServerThread> lst = new ArrayList<ServerThread>() ;
        ServerShm serverShm = new ServerShm( SEM_NAME,SHM_NAME,LENGTH,TIMEOUT ) ;
        System.out.println( "*** startup Server *** " ) ;
        for( ;; ) {
            if( serverShm.isUse() == false ) {
                break ;
            }
            ShmConnector con = serverShm.accept( TIMEOUT ) ;
            if( con != null ) {
                System.out.println( " ### accept:" + con ) ;
                lst.add( new ServerThread( con ) ) ;
            }
        }
    }
}

class ServerThread extends Thread {
    private volatile boolean stopFlag = true ;
    private ShmConnector con = null ;
    
    public ServerThread( ShmConnector con ) throws Exception {
        this.con = con ;
        this.stopFlag = false ;
        this.setDaemon( true ) ;
        this.start() ;
    }
    
    public void destroy() {
        setStop( true ) ;
    }
    
    public synchronized boolean isStop() {
        return stopFlag ;
    }
    
    private synchronized void setStop( boolean mode ) {
        this.stopFlag = mode ;
    }
    
    public void run() {
        boolean endFlag = false ;
        ThreadDeath threadDeach = null ;
        InputStream in = con.getInputStream() ;
        OutputStream out = con.getOutputStream() ;
        for( ;; ) {
        	if( con == null || con.isConnect() == false ) {
        		break ;
        	}
            if( endFlag == true || isStop() == true ) {
                break ;
            }
            try {
                Thread.sleep( 30L ) ;
                int len = in.available() ;
                if( len > 0 ) {
                    ByteArrayOutputStream bo = new ByteArrayOutputStream() ;
                    for( ;; ) {
                        if( in.available() <= 0 ) {
                            break ;
                        }
                        int n = in.read() ;
                        if( n <= -1 ) {
                            break ;
                        }
                        bo.write( n ) ;
                    }
                    byte[] bin = bo.toByteArray() ;
                    bo.close() ;
                    System.out.println( "read("+con.getId()+"):len:" + bin.length + "=" + new String( bin,"UTF8" ) ) ;
                    out.write( "server:".getBytes( "UTF8" ) ) ;
                    out.write( bin ) ;
                    out.flush() ;
                }
            } catch( OutOfMemoryError mem ) {
            } catch( Exception e ) {
            	e.printStackTrace() ;
                try {
                    con.close() ;
                } catch( Exception ee ) {
                    
                }
                con = null ;
            } catch( ThreadDeath td ) {
                endFlag = true ;
                threadDeach = td ;
            }
        }
        con = null ;
        setStop( true ) ;
        if( threadDeach != null ) {
            throw threadDeach ;
        }
        System.out.println( "exit thread("+ Thread.currentThread().getName() + ")" ) ;
    }
}

