package org.maachang.sharedTest ;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;

import org.maachang.shm.ClientShm;
import org.maachang.shm.ShmConnector;

public class ClientTest2 {
    public static final String SEM_NAME = "semTest" ;
    public static final String SHM_NAME = "shmTest" ;
    public static final int LENGTH = 10 ;
    public static final int TIMEOUT = 60000 ;
    public static final void main( String[] args ) throws Exception {
        new ClientTest2().execution( args ) ;
    }
    
    /**
     * クライアントでは、入力や、出力をコントロールできる.
     */
    private void execution( String[] args ) throws Exception {
        System.out.println( "*** startup Client *** " ) ;
        BufferedReader be = new BufferedReader( new InputStreamReader( System.in ) ) ;
        ClientShm shm = new ClientShm( SEM_NAME,SHM_NAME,LENGTH,TIMEOUT ) ;
        ShmConnector conn = shm.connect() ;
        System.out.println( "## connect:" + conn ) ;
        for( ;; ) {
            OutputStream output = conn.getOutputStream() ;
            InputStream input = conn.getInputStream() ;
            System.out.print( "send:" ) ;
            String in = getInput( be ) ;
            if( in == null || in.length() <= 0 ) {
            	continue ;
            }
            if( "output".equals( in ) ) {
            	conn.debugOutFile( "/outout.txt" ) ;
            	continue ;
            }
            System.out.println( "length:" + in.getBytes( "UTF8" ).length ) ;
            output.write( in.getBytes( "UTF8" ) ) ;
            output.flush() ;
            for( ;; ) {
                int len = input.available() ;
                if( len > 0 ) {
                    ByteArrayOutputStream bo = new ByteArrayOutputStream() ;
                    for( ;; ) {
                        if( input.available() <= 0 ) {
                            break ;
                        }
                        int n = input.read() ;
                        if( n <= -1 ) {
                            break ;
                        }
                        bo.write( n ) ;
                    }
                    byte[] bin = bo.toByteArray() ;
                    System.out.println( "read("+conn.getId()+"):" + new String( bin,"UTF8" ) ) ;
                    bo.close() ;
                    break ;
                }
                Thread.sleep( 30L ) ;
            }
            
        }
    }
    
    private static final String getInput( BufferedReader be )
        throws Exception {
        String one = be.readLine() ;
        if( one == null || ( one = one.trim() ).length() <= 0 ) {
            return null ;
        }
        return one ;
    }
}
