package org.maachang.sharedTest ;

import java.io.BufferedReader;
import java.io.InputStreamReader;

import org.maachang.shm.SharedMemory;

public class ClientTest {
    public static final void main( String[] args ) throws Exception {
        new ClientTest().execution( args ) ;
    }
    
    /**
     * クライアントでは、入力や、出力をコントロールできる.
     */
    private void execution( String[] args ) throws Exception {
        SharedMemory memory = new SharedMemory( false,ServerTest.SEM_NAME,ServerTest.SHM_NAME,ServerTest.LENGTH ) ;
        System.out.println( "*** startup Client *** " ) ;
        BufferedReader be = new BufferedReader( new InputStreamReader( System.in ) ) ;
        System.out.println( "1: メモリ内容表示" ) ;
        System.out.println( "2: データ入力" ) ;
        System.out.println( "3: 速度調査" ) ;
        System.out.println( "9: クローズ" ) ;
        for( ;; ) {
            if( memory.isUse() == false ) {
                break ;
            }
            System.out.print( ">" ) ;
            String one = getInput( be ) ;
            if( one == null || ( one = one.trim() ).length() <= 0 ||
                ( "1".equals( one ) == false && "2".equals( one ) == false &&
                "3".equals( one ) == false && "9".equals( one ) == false) ) {
                System.out.println( "1: メモリ内容表示" ) ;
                System.out.println( "2: データ入力" ) ;
                System.out.println( "3: 速度調査" ) ;
                System.out.println( "9: クローズ" ) ;
                continue ;
            }
            // メモリ内容表示.
            if( "1".equals( one ) ) {
                outputMemory( memory ) ;
            }
            // データ入力.
            else if( "2".equals( one ) ) {
                inputMemory( be,memory ) ;
            }
            // 速度調査.
            else if( "3".equals( one ) ) {
            	waitMemory( be,memory ) ;
            }
            // クローズ.
            else {
            	memory.destroy() ;
            	return ;
            }
        }
    }
    
    public void outputMemory( SharedMemory memory ) throws Exception {
        byte[] b = new byte[ 4 ] ;
        memory.read( b,0,0,4 ) ;
        int len = ( b[ 0 ] & 0x000000ff ) |
            ( ( b[ 1 ] & 0x000000ff ) << 8 ) |
            ( ( b[ 2 ] & 0x000000ff ) << 16 ) |
            ( ( b[ 3 ] & 0x000000ff ) << 24 ) ;
        if( len <= 0 ) {
            System.out.println( "*** NO DATA ***" ) ;
        }
        else {
            b = new byte[ len ] ;
            memory.read( b,4,0,len ) ;
            System.out.println( "*** DATA(" + len + ") ***" ) ;
            System.out.println( new String( b ) ) ;
            b = null ;
        }
    }
    
    public void inputMemory( BufferedReader be,SharedMemory memory )
        throws Exception {
        String one = getInput( be ) ;
    	if( one == null ) return ;
    	writeBinary( one.getBytes(),memory ) ;
        System.out.println( "*** output ***" ) ;
    }
    
    public void waitMemory( BufferedReader be,SharedMemory memory )
    	throws Exception {
    	System.out.print( "[速度チェック]書き込み回数を設定(数値入力):" ) ;
        String one = getInput( be ) ;
    	if( one == null ) return ;
        int len = -1 ;
        try {
        	len = Integer.parseInt( one ) ;
        } catch( Exception e ) {
        	len = -1 ;
        }
        if( len <= -1 ) {
        	System.out.println( "書き込み回数は数値で入力してね." ) ;
        	return ;
        }
        System.out.print( "書き込みデータ:" ) ;
        one = getInput( be ) ;
    	if( one == null ) return ;
    	byte[] b = one.getBytes() ;
    	long t = System.currentTimeMillis() ;
    	for( int i = 0 ; i < len ; i ++ ) {
    		writeBinary( b,memory ) ;
    	}
    	t = System.currentTimeMillis() - t ;
    	System.out.println( "** 書き込み回数:" + len + " 時間(ms):" + t ) ;
    }
    
    private void writeBinary( byte[] b,SharedMemory memory )
    	throws Exception {
        if( b.length <= 0 ) {
            return ;
        }
        int len = b.length ;
        byte[] all = new byte[ len + 4 ] ;
        if( len >= memory.getShareLength() ) {
            return ;
        }
        all[ 0 ] = ( byte )( len & 0x000000ff ) ;
        all[ 1 ] = ( byte )( ( len & 0x0000ff00 ) >> 8 ) ;
        all[ 2 ] = ( byte )( ( len & 0x00ff0000 ) >> 16 ) ;
        all[ 3 ] = ( byte )( ( len & 0xff000000 ) >> 24 ) ;
        System.arraycopy( b,0,all,4,len ) ;
        b = null ;
        memory.write( all,0,0,all.length ) ;
    }
    
    private static final String getInput( BufferedReader be )
    	throws Exception {
        String one = be.readLine() ;
        if( one == null || ( one = one.trim() ).length() <= 0 ) {
            return null ;
        }
        return one ;
    }
}
