package org.maachang.shm.core ;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * Native共有メモリ.
 *  
 * @version 2008/02/11
 * @author  masahito suzuki
 * @since  SharedMemory 1.00
 */
class NativeSharedMemory {
    private static boolean initFlag = false ;
    private static final boolean LIB_COPY = true ;
    static {
        String lib = null ;
        switch( Os.getInstance().getOS() ) {
            case Os.OS_WINNT :
                lib = "WinShareMemory.dll" ;
                System.load( targetDynamincLib( LIB_COPY,lib ) ) ;
                initFlag = true ;
                break ;
            case Os.OS_UNIX :
                lib = "libshm.so" ;
                System.load( targetDynamincLib( LIB_COPY,lib ) ) ;
                initFlag = true ;
                break ;
            default :
                initFlag = false ;
                break ;
        }
    }
    
    private static final String targetDynamincLib( boolean mode,String lib ) {
        String sp = System.getProperty( "file.separator" ) ;
        File targetDir = null ;
        if( System.getProperty( "org.maachang.share.dir" ) == null ) {
            targetDir = new File( new StringBuilder().
                append( System.getProperty( "user.home" ) ).
                append( sp ).
                append( ".lib_work" ).
                toString() );
        }
        else {
            targetDir = new File( System.getProperty( "org.maachang.share.dir" ) );
        }
        if( targetDir.exists() == false ) {
            targetDir.mkdirs() ;
        }
        File outFile = new File( targetDir,lib );
        if( mode == true ) {
            InputStream is = new BufferedInputStream( Thread.currentThread().getContextClassLoader().getResourceAsStream(
                "org/maachang/shm/core/" + lib ) ) ;
            if( isLibFile( outFile,is ) ) {
                try{
                    OutputStream os = new BufferedOutputStream( new FileOutputStream( outFile ) ) ;
                    try{
                        try{
                            for(;;) {
                                int n = is.read();
                                if( n <= -1 ) {
                                    break;
                                }
                                os.write( n );
                            }
                            os.flush() ;
                        }
                        finally{
                            is.close();
                            is = null ;
                        }
                    }
                    finally{
                        os.close();
                        os = null ;
                    }
                }
                catch( Exception e ) {
                    outFile = null ;
                }
            }
            if( is != null ) {
                try {
                    is.close() ;
                } catch( Exception e ) {
                }
                is = null ;
            }
        }
        if( outFile != null ) {
            return outFile.getAbsolutePath() ;
        }
        return null ;
    }
    
    private static final boolean isLibFile( File f,InputStream in ) {
        boolean ret = false ;
        try {
            if( f.exists() == false ) {
                ret = true ;
            }
            else {
                int len = ( int )f.length() ;
                ret = ( len <= 0 || len != in.available() ) ;
            }
        } catch( Exception e ) {
            ret = true ;
        }
        return ret ;
    }
    
    private NativeSharedMemory() {
        
    }
    
    public NativeSharedMemory( int mode,String semName,String shareName,int size )
        throws Exception {
        switch( Os.getInstance().getOS() ) {
            case Os.OS_WINNT :
            case Os.OS_UNIX :
                break ;
            default :
                throw new IOException( "ShareMemoryは、現在動作中のOSでは対応していません" ) ;
        }
        if( initFlag == false ) {
            throw new IOException( "ShareMemoryは、現在動作中のOSでは対応していません" ) ;
        }
        if( semName == null || ( semName = semName.trim() ).length() <= 0 ||
            shareName == null || ( shareName = shareName.trim() ).length() <= 0 ||
            size <= 0 ) {
            throw new IllegalArgumentException( "引数は不正です" ) ;
        }
        if( initShareMemory( mode,convertBinary( semName ),convertBinary( shareName ),size ) <= -1 ) {
            throw new IOException( "初期化処理時にエラーが発生しました" ) ;
        }
    }
    
    protected void finalize() throws Exception {
        this.destroy() ;
    }
    
    public void destroy() {
        destroyShareMemory() ;
    }
    
    public synchronized void read( int mode,byte[] output,int pos,int offset,int length )
        throws Exception {
        if( readShareMemory( mode,output,pos,offset,length ) <= -1 ) {
            throw new IOException( "読み込み処理中にエラーが発生しました" ) ;
        }
    }
    
    public synchronized void write( int mode,byte[] input,int pos,int offset,int length )
        throws Exception {
        if( writeShareMemory( mode,input,pos,offset,length ) <= -1 ) {
            throw new IOException( "書き込み処理中にエラーが発生しました" ) ;
        }
    }
    
    public synchronized void semLock()
        throws Exception {
        if( startLock() <= -1 ) {
            throw new IOException( "ロック処理に失敗しました" ) ;
        }
    }
    
    public synchronized void semUnLock()
        throws Exception {
        if( endLock() <= -1 ) {
            throw new IOException( "ロック解除処理に失敗しました" ) ;
        }
    }
    
    public synchronized int size() {
        return sizeShareMemory() ;
    }
    
    private byte[] convertBinary( String string ) {
        byte[] b = string.getBytes() ;
        int len = b.length ;
        byte[] ret = new byte[ len+1 ] ;
        System.arraycopy( b,0,ret,0,len ) ;
        b = null ;
        ret[ len ] = 0 ;
        return ret ;
    }
    
    protected native int initShareMemory( int mode,byte[] semName,byte[] shareName,int size ) ;
    
    protected native int destroyShareMemory() ;
    
    protected native int writeShareMemory( int md,byte[] input,int pos,int offset,int length ) ;
    
    protected native int readShareMemory( int md,byte[] output,int pos,int offset,int length ) ;
    
    protected native int sizeShareMemory() ;
    
    protected native int startLock() ;
    
    protected native int endLock() ;
}
