package org.maachang.shm;

/**
 * SharedMemory用定数定義.
 *  
 * @version 2008/02/16
 * @author  masahito suzuki
 * @since  SharedMemory 1.01
 */
class ShmDefine {
    
    /**
     * 最大共有I/O数.
     */
    public static final int MAX_IO_LENGTH = 255 ;
    
    /**
     * 予約接続管理数.
     */
    public static final int USE_CONNECT_SIZE = 8 ;
    
    /**
     * シーケンス管理.
     */
    public static final int SEQUENCE_LENGTH = 4 ;
    
    /**
     * 予約接続管理.
     */
    public static final int USE_CONNECT_NO = USE_CONNECT_SIZE * 4 ;
    
    /**
     * ヘッダデータ長.
     * 1(ステータス).
     * 4(シーケンスID).
     * 2(現在の長さ).
     */
    public static final int ONE_HEADER_LENGTH = 7 ;
    
    /**
     * １つのデータ長.
     * 512(データ領域).
     */
    public static final int ONE_DATA_LENGTH = 512 ;
    
    /**
     * 無効なシーケンスID.
     */
    public static final int NOT_SEQUENCE = -1 ;
    
    /**
     * ステータス : 未使用領域.
     */
    public static final int STATE_FREE = 0 ;
    
    /**
     * ステータス : 予約.
     */
    public static final int STATE_RES = 1 ;
    
    /**
     * ステータス : データセット.
     */
    public static final int STATE_SET = 2 ;
    
    /**
     * ステータス : データ要求.
     */
    public static final int STATE_NEXT = 3 ;
    
}
