package org.maachang.shm;

import java.io.InputStream;
import java.io.OutputStream;

/**
 * SharedMemory用接続インターフェイス.
 *  
 * @version 2008/02/16
 * @author  masahito suzuki
 * @since  SharedMemory 1.01
 */
public interface ShmConnector {
    
    /**
     * コネクションクローズ.
     * <BR>
     * @exception Exception 例外.
     */
    public void close() throws Exception ;
    
    /**
     * InputStreamを取得.
     * <BR>
     * @return InputStream InputStreamが返されます.
     */
    public InputStream getInputStream() ;
    
    /**
     * OutputStreamを取得.
     * <BR>
     * @return OutputStream OutputStreamが返されます.
     */
    public OutputStream getOutputStream() ;
    
    /**
     * 接続IDを取得.
     * <BR>
     * @return int 接続IDが返されます.
     */
    public int getId() ;
    
    /**
     * 接続タイムアウトを取得.
     * <BR>
     * @return int 接続タイムアウトが返されます.
     */
    public int getTimeout() ;
    
    /**
     * 接続状態を確認.
     * <BR>
     * @return boolean [true]の場合、接続中です.
     */
    public boolean isConnect() ;
    
    /**
     * デバッグ出力.
     * <BR>
     * @param name 出力先ファイル名を設定します.
     * @exception Exception 例外.
     */
    public void debugOutFile( String name ) throws Exception ;
    
    /**
     * 現在の共有メモリ内容を出力.
     * <BR>
     * @param output 出力先のオブジェクトを設定します.
     * @exception Exception 例外.
     */
    public void debugOutputStream( OutputStream output ) throws Exception ;
}
