//
// WindowspSharedMemoyɂ́ACreateFileMapping𗘗pB
//
#include <windows.h>
#include "../../include/org_maachang_shm_core_NativeSharedMemory.h"

#pragma comment(lib,"jvm.lib")

///////////////////////////////////////////////////////////////////////////////
// ShareMemory.
///////////////////////////////////////////////////////////////////////////////

//#define MAX_SEMAPHOREWAIT		(5000)
#define DEF_SEMAPHORE			(1)
#define DEF_MAXSEMAPHORE		(1)
#define MODE_NOT_SYNC			(0)

// L.
static HANDLE hInitSem = NULL ;
static HANDLE hShare = NULL ;
static HANDLE hSem = NULL ;
static char* semName = NULL ;
static unsigned char* shareData = NULL ;
static int shareSize = -1 ;

// Z}tH.
inline int InitSemaphoreHandle(char* name) {
//	hInitSem = CreateSemaphore(NULL,
//			DEF_SEMAPHORE, DEF_MAXSEMAPHORE, name);
//	if(hInitSem == NULL){
//		if(GetLastError() != ERROR_ALREADY_EXISTS){
//			return -1;
//		}
//	}
	int len = strlen( name ) ;
	semName = ( char* )malloc( len+1 ) ;
	memset( semName,'\0',len+1 ) ;
	memcpy( semName,name,len ) ;
	return 0 ;
}

// Z}tHI.
inline void CloseSemaphoreHandle() {
//	if( hInitSem != NULL ) {
//		CloseHandle(hInitSem);
//	}
	if( semName != NULL ) {
		free( semName ) ;
		semName = NULL ;
	}
}

// Z}tHbN.
inline HANDLE LockSharedMemory() {
//	HANDLE	hSemaphore = NULL;
//	hSemaphore = OpenSemaphore(SEMAPHORE_ALL_ACCESS, FALSE, semName);
//	if(hSemaphore){
//		if(WaitForSingleObject(hSemaphore, MAX_SEMAPHOREWAIT)==WAIT_TIMEOUT){
//			CloseHandle(hSemaphore);
//			hSemaphore = NULL;
//		}
//	}
//	return hSemaphore;*/
	for( ;; ) {
		HANDLE h = ::CreateMutex(NULL,TRUE,semName) ;
		if( h != NULL ) {
			return h ;
		}
		::Sleep( 5L ) ;
	}
}

// Z}tHAbN.
inline void UnLockSharedMemory(HANDLE hSemaphore) {
//	if( hSemaphore != NULL ) {
//		ReleaseSemaphore(hSemaphore, 1, NULL);
//		CloseHandle(hSemaphore);
//	}
	::ReleaseMutex(hSemaphore) ;
}

// LI[v.
inline int OpenShare(int mode,char* shareName,int size) {
	hShare = CreateFileMapping((HANDLE)0xFFFFFFFF,0,PAGE_READWRITE,0,size,shareName);
	if( hShare == NULL ) {
		return -1 ;
	}
	shareData = ( unsigned char* )MapViewOfFile(hShare,FILE_MAP_WRITE,0,0,size);
	if( shareData == NULL ) {
		return -1 ;
	}
	if( mode == 0 ) {
		memset( shareData,'\0',size ) ;
	}
	return 0 ;
}

// LN[Y.
inline void CloseShare() {
	if( hShare != NULL ) {
		UnmapViewOfFile(hShare);
		CloseHandle(hShare);
	}
}

// LSʏ.
inline int InitShareMemory( int mode,char* semName,char* shareName,int size ) {
	if( InitSemaphoreHandle( semName ) <= -1 ) {
		return -1 ;
	}
	HANDLE h = LockSharedMemory() ;
	if( h != NULL ) {
		if( OpenShare( mode,shareName,size ) <= -1 ) {
			UnLockSharedMemory( h ) ;
			return -1 ;
		}
		UnLockSharedMemory( h ) ;
	}
	h = NULL ;
	shareSize = size ;
	return 0 ;
}

// LSʏI.
inline int DestroyShareMemory() {
	HANDLE h = LockSharedMemory() ;
	if( h != NULL ) {
		CloseShare() ;
		UnLockSharedMemory( h ) ;
	}
	else {
		return -1 ;
	}
	h = NULL ;
	CloseSemaphoreHandle() ;
	return 0 ;
}

// Lɏǉ.
inline int PutShareData( int md,unsigned char* data,int pos,int off,int len ) {
	if( md == MODE_NOT_SYNC ) {
		memcpy( shareData+pos,data+off,len ) ;
	}
	else {
		HANDLE h = LockSharedMemory() ;
		if( h != NULL ) {
			memcpy( shareData+pos,data+off,len ) ;
			UnLockSharedMemory( h ) ;
		}
		else {
			return -1 ;
		}
		h = NULL ;
	}
	return 0 ;
}

// L擾.
inline int GetShareData( int md,unsigned char* data,int pos,int off,int len ) {
	if( md == MODE_NOT_SYNC ) {
		memcpy( data+off,shareData+pos,len ) ;
	}
	else {
		HANDLE h = LockSharedMemory() ;
		if( h != NULL ) {
			memcpy( data+off,shareData+pos,len ) ;
			UnLockSharedMemory( h ) ;
		}
		else {
			return -1 ;
		}
		h = NULL ;
	}
	return 0 ;
}

// LS̒擾.
inline int MaxShreSize() {
	return shareSize ;
}

///////////////////////////////////////////////////////////////////////////////
// JNI.
///////////////////////////////////////////////////////////////////////////////

// NativeShareMemory.initShareMemoryĂяo.
JNIEXPORT jint JNICALL Java_org_maachang_shm_core_NativeSharedMemory_initShareMemory
  (JNIEnv* env, jobject o, jint mode,jbyteArray n1, jbyteArray n2, jint sz ) {
	jboolean b ;
	jbyte* semName=(*env).GetByteArrayElements(n1,&b);
	jbyte* shareName=(*env).GetByteArrayElements(n2,&b);
	jint ret = InitShareMemory( mode,( char* )semName,( char* )shareName,sz ) ;
	(*env).ReleaseByteArrayElements(n1, semName, 0);
	(*env).ReleaseByteArrayElements(n2, shareName, 0);
	return ret ;
}

// NativeShareMemory.destroyShareMemoryĂяo.
JNIEXPORT jint JNICALL Java_org_maachang_shm_core_NativeSharedMemory_destroyShareMemory
  (JNIEnv* env, jobject o) {
	shareSize = -1 ;
	return DestroyShareMemory() ;
}

// NativeShareMemory.writeShareMemoryĂяo.
JNIEXPORT jint JNICALL Java_org_maachang_shm_core_NativeSharedMemory_writeShareMemory
  (JNIEnv* env, jobject o, jint md, jbyteArray in, jint ps, jint of, jint sz) {
	jboolean b ;
	jbyte* input=(*env).GetByteArrayElements(in,&b);
	jint ret = PutShareData( md,( unsigned char* )input,ps,of,sz ) ;
	(*env).ReleaseByteArrayElements(in, input, 0);
	return ret ;
}

// NativeShareMemory.readShareMemoryĂяo.
JNIEXPORT jint JNICALL Java_org_maachang_shm_core_NativeSharedMemory_readShareMemory
  (JNIEnv* env, jobject o, jint md, jbyteArray ot, jint ps, jint of, jint sz) {
	jboolean b ;
	jbyte* output=(*env).GetByteArrayElements(ot,&b);
	jint ret = GetShareData( md,( unsigned char* )output,ps,of,sz ) ;
	(*env).ReleaseByteArrayElements(ot, output, 0);
	return ret ;
}

// NativeShareMemory.sizeShareMemoryĂяo.
JNIEXPORT jint JNICALL Java_org_maachang_shm_core_NativeSharedMemory_sizeShareMemory
  (JNIEnv* env, jobject o) {
	return MaxShreSize() ;
}

// NativeShareMemory.startLockĂяo.
JNIEXPORT jint JNICALL Java_org_maachang_shm_core_NativeSharedMemory_startLock
  (JNIEnv* env, jobject o) {
	HANDLE h = LockSharedMemory() ;
	if( h == NULL ) {
		return -1 ;
	}
	hSem = h ;
	return 0 ;
}

// NativeShareMemory.endLockĂяo.
JNIEXPORT jint JNICALL Java_org_maachang_shm_core_NativeSharedMemory_endLock
  (JNIEnv* env, jobject o) {
	if( hSem != NULL ) {
		UnLockSharedMemory( hSem ) ;
		hSem = NULL ;
		return 0 ;
	}
	return -1 ;
}
