/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.sharedTest;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.maachang.shm.ShmConnector;

class ServerThread
extends Thread {
    private volatile boolean stopFlag = true;
    private ShmConnector con = null;

    public ServerThread(ShmConnector con) throws Exception {
        this.con = con;
        this.stopFlag = false;
        this.setDaemon(true);
        this.start();
    }

    public void destroy() {
        this.setStop(true);
    }

    public synchronized boolean isStop() {
        return this.stopFlag;
    }

    private synchronized void setStop(boolean mode) {
        this.stopFlag = mode;
    }

    public void run() {
        boolean endFlag = false;
        ThreadDeath threadDeach = null;
        InputStream in = this.con.getInputStream();
        OutputStream out = this.con.getOutputStream();
        while (this.con != null && this.con.isConnect() && !endFlag && !this.isStop()) {
            try {
                int n;
                Thread.sleep(30L);
                int len = in.available();
                if (len <= 0) continue;
                ByteArrayOutputStream bo = new ByteArrayOutputStream();
                while (in.available() > 0 && (n = in.read()) > -1) {
                    bo.write(n);
                }
                byte[] bin = bo.toByteArray();
                bo.close();
                System.out.println("read(" + this.con.getId() + "):len:" + bin.length + "=" + new String(bin, "UTF8"));
                out.write("server:".getBytes("UTF8"));
                out.write(bin);
                out.flush();
            }
            catch (OutOfMemoryError len) {
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    this.con.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.con = null;
            }
            catch (ThreadDeath td) {
                endFlag = true;
                threadDeach = td;
            }
        }
        this.con = null;
        this.setStop(true);
        if (threadDeach != null) {
            throw threadDeach;
        }
        System.out.println("exit thread(" + Thread.currentThread().getName() + ")");
    }
}

