/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.sharedTest;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.maachang.shm.SharedMemory;

public class ClientTest {
    public static final void main(String[] args) throws Exception {
        new ClientTest().execution(args);
    }

    private void execution(String[] args) throws Exception {
        SharedMemory memory = new SharedMemory(false, "semTest", "shmTest", 4100);
        System.out.println("*** startup Client *** ");
        BufferedReader be = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("1: \u30e1\u30e2\u30ea\u5185\u5bb9\u8868\u793a");
        System.out.println("2: \u30c7\u30fc\u30bf\u5165\u529b");
        System.out.println("3: \u901f\u5ea6\u8abf\u67fb");
        System.out.println("9: \u30af\u30ed\u30fc\u30ba");
        while (memory.isUse()) {
            System.out.print(">");
            String one = ClientTest.getInput(be);
            if (one == null || (one = one.trim()).length() <= 0 || !"1".equals(one) && !"2".equals(one) && !"3".equals(one) && !"9".equals(one)) {
                System.out.println("1: \u30e1\u30e2\u30ea\u5185\u5bb9\u8868\u793a");
                System.out.println("2: \u30c7\u30fc\u30bf\u5165\u529b");
                System.out.println("3: \u901f\u5ea6\u8abf\u67fb");
                System.out.println("9: \u30af\u30ed\u30fc\u30ba");
                continue;
            }
            if ("1".equals(one)) {
                this.outputMemory(memory);
                continue;
            }
            if ("2".equals(one)) {
                this.inputMemory(be, memory);
                continue;
            }
            if ("3".equals(one)) {
                this.waitMemory(be, memory);
                continue;
            }
            memory.destroy();
            return;
        }
    }

    public void outputMemory(SharedMemory memory) throws Exception {
        byte[] b = new byte[4];
        memory.read(b, 0, 0, 4);
        int len = b[0] & 0xFF | (b[1] & 0xFF) << 8 | (b[2] & 0xFF) << 16 | (b[3] & 0xFF) << 24;
        if (len <= 0) {
            System.out.println("*** NO DATA ***");
        } else {
            b = new byte[len];
            memory.read(b, 4, 0, len);
            System.out.println("*** DATA(" + len + ") ***");
            System.out.println(new String(b));
            b = null;
        }
    }

    public void inputMemory(BufferedReader be, SharedMemory memory) throws Exception {
        String one = ClientTest.getInput(be);
        if (one == null) {
            return;
        }
        this.writeBinary(one.getBytes(), memory);
        System.out.println("*** output ***");
    }

    public void waitMemory(BufferedReader be, SharedMemory memory) throws Exception {
        System.out.print("[\u901f\u5ea6\u30c1\u30a7\u30c3\u30af]\u66f8\u304d\u8fbc\u307f\u56de\u6570\u3092\u8a2d\u5b9a(\u6570\u5024\u5165\u529b):");
        String one = ClientTest.getInput(be);
        if (one == null) {
            return;
        }
        int len = -1;
        try {
            len = Integer.parseInt(one);
        }
        catch (Exception e) {
            len = -1;
        }
        if (len <= -1) {
            System.out.println("\u66f8\u304d\u8fbc\u307f\u56de\u6570\u306f\u6570\u5024\u3067\u5165\u529b\u3057\u3066\u306d.");
            return;
        }
        System.out.print("\u66f8\u304d\u8fbc\u307f\u30c7\u30fc\u30bf:");
        one = ClientTest.getInput(be);
        if (one == null) {
            return;
        }
        byte[] b = one.getBytes();
        long t = System.currentTimeMillis();
        int i = 0;
        while (i < len) {
            this.writeBinary(b, memory);
            ++i;
        }
        t = System.currentTimeMillis() - t;
        System.out.println("** \u66f8\u304d\u8fbc\u307f\u56de\u6570:" + len + " \u6642\u9593(ms):" + t);
    }

    private void writeBinary(byte[] b, SharedMemory memory) throws Exception {
        if (b.length <= 0) {
            return;
        }
        int len = b.length;
        byte[] all = new byte[len + 4];
        if (len >= memory.getShareLength()) {
            return;
        }
        all[0] = (byte)(len & 0xFF);
        all[1] = (byte)((len & 0xFF00) >> 8);
        all[2] = (byte)((len & 0xFF0000) >> 16);
        all[3] = (byte)((len & 0xFF000000) >> 24);
        System.arraycopy(b, 0, all, 4, len);
        b = null;
        memory.write(all, 0, 0, all.length);
    }

    private static final String getInput(BufferedReader be) throws Exception {
        String one = be.readLine();
        if (one == null || (one = one.trim()).length() <= 0) {
            return null;
        }
        return one;
    }
}

