/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.shm.core;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.maachang.shm.core.NativeSharedMemory;

public class CoreShm {
    private NativeSharedMemory mem = null;
    private String semName = null;
    private String shareName = null;

    private CoreShm() {
    }

    public CoreShm(boolean mode, String semName, String shareName, int length) throws Exception {
        try {
            this.mem = new NativeSharedMemory(mode ? 0 : 1, semName, shareName, length);
            this.semName = semName;
            this.shareName = shareName;
            if (mode) {
                this.write(new byte[length], 0, 0, length);
            }
        }
        catch (Exception e) {
            this.destroy();
            throw e;
        }
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        if (this.getMem() != null) {
            this.getMem().destroy();
        }
        this.semName = null;
        this.shareName = null;
    }

    public String getSemaphoreName() {
        if (!this.isUse()) {
            return null;
        }
        return this.semName;
    }

    public String getShareName() {
        if (!this.isUse()) {
            return null;
        }
        return this.shareName;
    }

    public int getShareLength() {
        if (!this.isUse()) {
            return -1;
        }
        return this.getMem().size();
    }

    public int write(byte[] binary, int pos, int off, int length) throws Exception {
        return this.write(true, binary, pos, off, length);
    }

    public int write(boolean mode, byte[] binary, int pos, int off, int length) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        int ln = this.getMem().size();
        if (binary == null || binary.length <= 0 || pos <= -1 || pos >= ln || off <= -1 || off >= binary.length || length <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (off + length >= binary.length) {
            length = binary.length - off;
        }
        if (pos + length >= ln) {
            length = ln - pos;
        }
        this.getMem().write(!mode ? 0 : 1, binary, pos, off, length);
        return length;
    }

    public int read(byte[] binary, int pos, int off, int length) throws Exception {
        return this.read(true, binary, pos, off, length);
    }

    public int read(boolean mode, byte[] binary, int pos, int off, int length) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        int ln = this.getMem().size();
        if (binary == null || binary.length <= 0 || pos <= -1 || pos >= ln || off <= -1 || off >= binary.length || length <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (off + length >= binary.length) {
            length = binary.length - off;
        }
        if (pos + length >= ln) {
            length = ln - pos;
        }
        this.getMem().read(!mode ? 0 : 1, binary, pos, off, length);
        return length;
    }

    public void outputFile(String name) throws Exception {
        int len = this.getShareLength();
        byte[] b = new byte[len];
        this.getMem().read(1, b, 0, 0, len);
        BufferedOutputStream bo = new BufferedOutputStream(new FileOutputStream(name));
        bo.write(b);
        bo.flush();
        bo.close();
    }

    public void outputFile(OutputStream output) throws Exception {
        int len = this.getShareLength();
        byte[] b = new byte[len];
        this.getMem().read(1, b, 0, 0, len);
        output.write(b);
        output.flush();
    }

    public void lock() throws Exception {
        this.getMem().semLock();
    }

    public void unLock() throws Exception {
        this.getMem().semUnLock();
    }

    public boolean isUse() {
        return this.getMem() != null;
    }

    private synchronized NativeSharedMemory getMem() {
        if (this.mem == null) {
            return null;
        }
        if (this.mem.size() <= -1) {
            this.mem = null;
            return null;
        }
        return this.mem;
    }
}

