/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.shm;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import org.maachang.shm.AbstractShmConnector;
import org.maachang.shm.NotTargetAccessException;
import org.maachang.shm.ShmCommon;
import org.maachang.shm.core.CoreShm;

class ShmOutputStream
extends OutputStream {
    private CoreShm shm = null;
    private AbstractShmConnector conn = null;
    private boolean mode = false;
    private int no = -1;
    private int sequenceId = -1;
    private int length = -1;
    private int timeout = 0;
    private int pos = 0;
    private int beforeState = -1;
    private long beforeTimeout = -1L;
    private byte[] ioBinary = null;

    private ShmOutputStream() {
    }

    public ShmOutputStream(CoreShm shm, AbstractShmConnector conn, boolean mode, int timeout, int no, int sequenceId, int length) throws Exception {
        if (shm == null || !shm.isUse()) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (timeout <= -1) {
            timeout = 0;
        }
        this.shm = shm;
        this.conn = conn;
        this.mode = mode;
        this.no = no;
        this.sequenceId = sequenceId;
        this.length = length;
        this.timeout = timeout;
        this.ioBinary = new byte[512];
        this.beforeTimeout();
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        if (this.shm != null) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.shm = null;
        this.conn = null;
        this.mode = false;
        this.no = -1;
        this.sequenceId = -1;
        this.length = -1;
        this.timeout = 0;
        this.pos = 0;
        this.beforeState = -1;
        this.ioBinary = null;
    }

    public void close() throws IOException {
        if (this.shm != null && this.pos > 0) {
            this.flush(false);
        }
    }

    public void flush() throws IOException {
        this.flush(false);
    }

    public void flush(boolean overMode) throws IOException {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        this.beforeTimeout();
        try {
            long t = System.currentTimeMillis() + (long)this.timeout;
            while (!this.writeBody(overMode)) {
                if (this.timeout > 0 && t <= System.currentTimeMillis()) {
                    throw new InterruptedIOException("timeout");
                }
                Thread.sleep(15L);
            }
        }
        catch (NotTargetAccessException na) {
            this.conn.notTargetByDestroy();
            throw na;
        }
        catch (IOException io) {
            throw io;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public void write(int b) throws IOException {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        this.beforeTimeout();
        if (this.pos >= 512) {
            this.flush(true);
        }
        this.ioBinary[this.pos] = (byte)(b & 0xFF);
        ++this.pos;
    }

    public boolean getMode() {
        return this.mode;
    }

    public int getNo() {
        return this.no;
    }

    public int getSequenceId() {
        return this.sequenceId;
    }

    public int getLength() {
        return this.length;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getBeforeState() {
        return this.beforeState;
    }

    public boolean isTimeout() {
        long time = this.getBeforeTimeout();
        return this.timeout > 0 && time + (long)this.timeout <= System.currentTimeMillis();
    }

    public boolean isUse() {
        return this.shm != null && this.shm.isUse();
    }

    public String toString() {
        if (!this.isUse()) {
            return "ShmOutputStream is closed.";
        }
        return "ShmOutputStream" + "[" + this.shm.getSemaphoreName() + "," + this.shm.getShareName() + "," + this.shm.getShareLength() + "]" + " mode:" + this.mode + " no:" + this.no + " sequenceId:" + this.sequenceId + " length:" + this.length + " timeout:" + this.timeout + " pos:" + this.pos + " beforeState:" + this.beforeState;
    }

    private boolean writeBody(boolean overMode) throws Exception {
        int[] state = new int[1];
        if (ShmCommon.writeBody(this.mode, state, overMode, this.ioBinary, this.pos, this.shm, this.sequenceId, this.no, this.length)) {
            this.beforeState = state[0];
            this.pos = 0;
            return true;
        }
        if (state[0] == -1) {
            throw new IOException("\u7bc4\u56f2\u5916\u306e\u4f4d\u7f6e\u306bI/O\u51e6\u7406\u3092\u884c\u3063\u3066\u3044\u307e\u3059");
        }
        this.beforeState = state[0];
        return false;
    }

    private synchronized long getBeforeTimeout() {
        return this.beforeTimeout;
    }

    private synchronized void beforeTimeout() {
        this.beforeTimeout = System.currentTimeMillis();
    }
}

