/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.shm;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import org.maachang.shm.AbstractShmConnector;
import org.maachang.shm.NotTargetAccessException;
import org.maachang.shm.ShmCommon;
import org.maachang.shm.core.CoreShm;

class ShmInputStream
extends InputStream {
    private static final int MAX_RETRY_LOOP = 64;
    private CoreShm shm = null;
    private AbstractShmConnector conn = null;
    private boolean mode = false;
    private int no = -1;
    private int sequenceId = -1;
    private int length = -1;
    private int timeout = 0;
    private int pos = 0;
    private int bodyLen = -1;
    private int beforeState = -1;
    private long beforeTimeout = -1L;
    private int retryNextData = 0;
    private byte[] ioBinary = null;

    private ShmInputStream() {
    }

    protected ShmInputStream(CoreShm shm, AbstractShmConnector conn, boolean mode, int timeout, int no, int sequenceId, int length) throws Exception {
        if (shm == null || !shm.isUse()) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (timeout <= -1) {
            timeout = 0;
        }
        this.shm = shm;
        this.conn = conn;
        this.mode = mode;
        this.no = no;
        this.sequenceId = sequenceId;
        this.length = length;
        this.timeout = timeout;
        this.ioBinary = null;
        this.beforeTimeout();
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        this.shm = null;
        this.conn = null;
        this.mode = false;
        this.no = -1;
        this.sequenceId = -1;
        this.length = -1;
        this.timeout = 0;
        this.pos = 0;
        this.bodyLen = -1;
        this.beforeState = -1;
        this.ioBinary = null;
    }

    public void close() {
    }

    public int read() throws IOException {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        long t = System.currentTimeMillis() + (long)this.timeout;
        try {
            while (true) {
                this.readBody();
                if (this.bodyLen > -1 && this.bodyLen > this.pos) break;
                if (this.bodyLen >= 0 && this.bodyLen < 512) {
                    return -1;
                }
                if (this.timeout > 0 && t <= System.currentTimeMillis()) {
                    throw new InterruptedIOException("timeout");
                }
                Thread.sleep(5L);
            }
            int p = this.ioBinary[this.pos] & 0xFF;
            ++this.pos;
            this.beforeTimeout();
            return p;
        }
        catch (NotTargetAccessException na) {
            this.conn.notTargetByDestroy();
            throw na;
        }
        catch (IOException io) {
            throw io;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public int available() throws IOException {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        this.beforeTimeout();
        try {
            this.readBody();
            if (this.bodyLen <= -1) {
                return 0;
            }
            return this.bodyLen - this.pos;
        }
        catch (IOException io) {
            throw io;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public boolean getMode() {
        return this.mode;
    }

    public int getNo() {
        return this.no;
    }

    public int getSequenceId() {
        return this.sequenceId;
    }

    public int getLength() {
        return this.length;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getBeforeState() {
        return this.beforeState;
    }

    public boolean isTimeout() {
        long time = this.getBeforeTimeout();
        return this.timeout > 0 && time + (long)this.timeout <= System.currentTimeMillis();
    }

    public boolean isUse() {
        return this.shm != null && this.shm.isUse();
    }

    public String toString() {
        if (!this.isUse()) {
            return "ShmInputStream is closed.";
        }
        return "ShmInputStream" + "[" + this.shm.getSemaphoreName() + "," + this.shm.getShareName() + "," + this.shm.getShareLength() + "]" + " mode:" + this.mode + " no:" + this.no + " sequenceId:" + this.sequenceId + " length:" + this.length + " timeout:" + this.timeout + " pos:" + this.pos + " bodyLength:" + this.bodyLen + " beforeState:" + this.beforeState;
    }

    private boolean readBody() throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (this.bodyLen <= -1 || this.bodyLen >= 512 && this.bodyLen <= this.pos) {
            if (this.ioBinary == null) {
                this.ioBinary = new byte[512];
            }
            int[] state = new int[1];
            int len = -1;
            while (true) {
                len = ShmCommon.readBody(this.mode, state, this.ioBinary, this.shm, this.sequenceId, this.no, this.length);
                if (state[0] == -1) {
                    throw new IOException("\u7bc4\u56f2\u5916\u306e\u4f4d\u7f6e\u306bI/O\u51e6\u7406\u3092\u884c\u3063\u3066\u3044\u307e\u3059");
                }
                if (len > -1) break;
                if (state[0] == 0) {
                    throw new IOException("\u63a5\u7d9a\u306f\u65e2\u306b\u9589\u3058\u3089\u308c\u3066\u3044\u307e\u3059");
                }
                if (this.retryNextData <= 0) {
                    this.retryNextData = 0;
                    return false;
                }
                --this.retryNextData;
                Thread.sleep(5L);
            }
            if (this.retryNextData > 0) {
                this.retryNextData = 0;
            }
            if (state[0] == 2) {
                ShmCommon.setState(this.mode, 3, this.shm, this.no, this.length);
            }
            if (len > 512) {
                this.bodyLen = 512;
                this.retryNextData = 64;
            } else {
                this.bodyLen = len;
                this.retryNextData = 0;
            }
            this.pos = 0;
            return true;
        }
        if (this.bodyLen >= 0 && this.bodyLen < 512 && this.bodyLen <= this.pos) {
            int nowState = ShmCommon.getState(this.mode, this.shm, this.no, this.length);
            if (nowState == 0) {
                throw new IOException("\u63a5\u7d9a\u306f\u65e2\u306b\u9589\u3058\u3089\u308c\u3066\u3044\u307e\u3059");
            }
            if (nowState == 2) {
                ShmCommon.setState(this.mode, 3, this.shm, this.no, this.length);
            }
            this.bodyLen = -1;
            this.pos = 0;
        }
        return false;
    }

    private synchronized long getBeforeTimeout() {
        return this.beforeTimeout;
    }

    private synchronized void beforeTimeout() {
        this.beforeTimeout = System.currentTimeMillis();
    }
}

