/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.shm;

import java.util.ArrayList;
import org.maachang.shm.NotTargetAccessException;
import org.maachang.shm.core.CoreShm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ShmCommon {
    ShmCommon() {
    }

    public static final int maxIOLength(int length) throws Exception {
        if (length <= 0 || length > 255) {
            throw new IllegalArgumentException("\u5171\u6709I/O\u30b5\u30a4\u30ba(" + length + ")\u304c\u4e0d\u6b63\u3067\u3059");
        }
        length = ShmCommon.trimLength(length);
        int ret = 36 + length + 519 * (length * 8 * 2);
        return ret;
    }

    public static final int trimLength(int length) {
        return ((length & 7) == 0 ? 0 : 1) + ((length & 0x7FFFFFF8) >> 3);
    }

    public static final int startPoint(boolean mode, CoreShm shm, int no, int length) throws Exception {
        int pkt = 519;
        int ret = no * 2 * pkt + ShmCommon.trimLength(length) + 4 + 32;
        if (mode) {
            ret += pkt;
        }
        if (shm.getShareLength() <= ret) {
            return -1;
        }
        return ret;
    }

    public static final int nowSequenceId(CoreShm shm) throws Exception {
        byte[] b = new byte[4];
        shm.read(b, 0, 0, 4);
        return b[0] & 0xFF | (b[1] & 0xFF) << 8 | (b[2] & 0xFF) << 16 | (b[3] & 0xFF) << 24;
    }

    public static final int updateSequenceId(boolean sync, CoreShm shm) throws Exception {
        try {
            if (sync) {
                shm.lock();
            }
            byte[] b = new byte[4];
            shm.read(false, b, 0, 0, 4);
            int ret = b[0] & 0xFF | (b[1] & 0xFF) << 8 | (b[2] & 0xFF) << 16 | (b[3] & 0xFF) << 24;
            ret = ret >= Integer.MAX_VALUE ? 0 : ++ret;
            b[0] = (byte)(ret & 0xFF);
            b[1] = (byte)((ret & 0xFF00) >> 8);
            b[2] = (byte)((ret & 0xFF0000) >> 16);
            b[3] = (byte)((ret & 0xFF000000) >> 24);
            shm.write(false, b, 0, 0, 4);
            int n = ret;
            return n;
        }
        finally {
            if (sync) {
                shm.unLock();
            }
        }
    }

    public static final int getState(boolean mode, CoreShm shm, int no, int length) throws Exception {
        int p = ShmCommon.startPoint(mode, shm, no, length);
        if (p <= -1) {
            return -1;
        }
        byte[] b = new byte[1];
        shm.read(b, p, 0, 1);
        return b[0] & 0xFF;
    }

    public static final boolean setState(boolean mode, int state, CoreShm shm, int no, int length) throws Exception {
        int p = ShmCommon.startPoint(mode, shm, no, length);
        if (p <= -1) {
            return false;
        }
        byte[] b = new byte[]{(byte)(state & 0xFF)};
        shm.write(b, p, 0, 1);
        return true;
    }

    public static final int getBodySequenceId(boolean mode, CoreShm shm, int no, int length) throws Exception {
        int p = ShmCommon.startPoint(mode, shm, no, length);
        if (p <= -1) {
            return -1;
        }
        byte[] b = new byte[4];
        shm.read(b, ++p, 0, 4);
        return b[0] & 0xFF | (b[1] & 0xFF) << 8 | (b[2] & 0xFF) << 16 | (b[3] & 0xFF) << 24;
    }

    public static final boolean setBodySequenceId(boolean mode, int seq, CoreShm shm, int no, int length) throws Exception {
        int p = ShmCommon.startPoint(mode, shm, no, length);
        if (p <= -1) {
            return false;
        }
        byte[] b = new byte[]{(byte)(seq & 0xFF), (byte)((seq & 0xFF00) >> 8), (byte)((seq & 0xFF0000) >> 16), (byte)((seq & 0xFF000000) >> 24)};
        shm.write(b, ++p, 0, 4);
        return true;
    }

    public static final int getBodyLength(boolean mode, CoreShm shm, int no, int length) throws Exception {
        int p = ShmCommon.startPoint(mode, shm, no, length);
        if (p <= -1) {
            return -1;
        }
        byte[] b = new byte[2];
        shm.read(b, p += 5, 0, 2);
        return b[0] & 0xFF | (b[1] & 0xFF) << 8;
    }

    public static final boolean setBodyLength(boolean mode, int bodyLength, CoreShm shm, int no, int length) throws Exception {
        int p = ShmCommon.startPoint(mode, shm, no, length);
        if (p <= -1) {
            return false;
        }
        byte[] b = new byte[]{(byte)(bodyLength & 0xFF), (byte)((bodyLength & 0xFF00) >> 8)};
        shm.write(b, p += 5, 0, 2);
        return true;
    }

    public static final int readBody(boolean mode, int[] outState, byte[] binary, CoreShm shm, int sequenceId, int no, int length) throws Exception {
        try {
            int ret;
            shm.lock();
            byte[] b = null;
            int p = ShmCommon.startPoint(mode, shm, no, length);
            if (p <= -1) {
                if (outState != null) {
                    outState[0] = -1;
                }
                return -1;
            }
            b = new byte[4];
            shm.read(false, b, p + 1, 0, 4);
            int seqId = b[0] & 0xFF | (b[1] & 0xFF) << 8 | (b[2] & 0xFF) << 16 | (b[3] & 0xFF) << 24;
            b = null;
            if (seqId <= -1 || seqId != sequenceId) {
                throw new NotTargetAccessException("\u73fe\u5728\u306e\u63a5\u7d9a\u4f4d\u7f6e(" + no + ")\u306f\u3001\u5225\u306e\u63a5\u7d9a\u6761\u4ef6(this:" + sequenceId + " target:" + seqId + ")\u304c\u5229\u7528\u3057\u3066\u3044\u307e\u3059");
            }
            b = new byte[1];
            shm.read(false, b, p, 0, 1);
            int state = b[0] & 0xFF;
            if (outState != null) {
                outState[0] = state;
            }
            b = null;
            if (state != 2) {
                return -1;
            }
            b = new byte[2];
            shm.read(false, b, p + 5, 0, 2);
            int readLen = ret = b[0] & 0xFF | (b[1] & 0xFF) << 8;
            if (readLen >= 512) {
                readLen = 512;
            }
            shm.read(false, binary, p + 7, 0, readLen);
            int n = ret;
            return n;
        }
        finally {
            shm.unLock();
        }
    }

    public static final boolean writeBody(boolean mode, int[] outState, boolean overMode, byte[] binary, int bodyLen, CoreShm shm, int sequenceId, int no, int length) throws Exception {
        if (bodyLen <= 0) {
            return true;
        }
        try {
            shm.lock();
            byte[] b = null;
            int p = ShmCommon.startPoint(mode, shm, no, length);
            if (p <= -1) {
                if (outState != null) {
                    outState[0] = -1;
                }
                return false;
            }
            b = new byte[4];
            shm.read(false, b, p + 1, 0, 4);
            int seqId = b[0] & 0xFF | (b[1] & 0xFF) << 8 | (b[2] & 0xFF) << 16 | (b[3] & 0xFF) << 24;
            b = null;
            if (seqId <= -1 || seqId != sequenceId) {
                throw new NotTargetAccessException("\u73fe\u5728\u306e\u63a5\u7d9a\u4f4d\u7f6e(" + no + ")\u306f\u3001\u5225\u306e\u63a5\u7d9a\u6761\u4ef6(this:" + sequenceId + " target:" + seqId + ")\u304c\u5229\u7528\u3057\u3066\u3044\u307e\u3059");
            }
            b = new byte[1];
            shm.read(false, b, p, 0, 1);
            int state = b[0] & 0xFF;
            if (outState != null) {
                outState[0] = state;
            }
            b = null;
            if (state != 1 && state != 3) {
                return false;
            }
            b = new byte[2];
            if (overMode) {
                b[0] = (byte)(bodyLen + 1 & 0xFF);
                b[1] = (byte)((bodyLen + 1 & 0xFF00) >> 8);
            } else {
                b[0] = (byte)(bodyLen & 0xFF);
                b[1] = (byte)((bodyLen & 0xFF00) >> 8);
            }
            shm.write(false, b, p + 5, 0, 2);
            b = null;
            shm.write(false, binary, p + 7, 0, bodyLen);
            b = new byte[]{2};
            shm.write(false, b, p, 0, 1);
            return true;
        }
        finally {
            shm.unLock();
        }
    }

    public static final void freeSpace(CoreShm shm, int sequenceId, int no, int length) throws Exception {
        try {
            shm.lock();
            int p = ShmCommon.startPoint(false, shm, no, length);
            if (p <= -1) {
                return;
            }
            byte[] b = new byte[4];
            shm.read(false, b, p + 1, 0, 4);
            int seqId = b[0] & 0xFF | (b[1] & 0xFF) << 8 | (b[2] & 0xFF) << 16 | (b[3] & 0xFF) << 24;
            b = null;
            if (seqId <= -1 || seqId != sequenceId) {
                return;
            }
            int len = ShmCommon.trimLength(length);
            int n = ShmCommon.trimLength(no + 1) - 1;
            b = new byte[len];
            shm.read(false, b, 36, 0, len);
            b[n] = (byte)(b[n] & ~(1 << no - n * 8) & 0xFF);
            shm.write(false, b, 36, 0, len);
            b = null;
            b = new byte[]{0, -1, -1, -1, -1, 0, 0};
            shm.write(false, b, p, 0, 7);
            p = ShmCommon.startPoint(true, shm, no, length);
            shm.write(false, b, p, 0, 7);
        }
        finally {
            shm.unLock();
        }
    }

    public static final int[] reservationSpace(CoreShm shm, int length) throws Exception {
        try {
            shm.lock();
            int len = ShmCommon.trimLength(length);
            byte[] b = new byte[len];
            shm.read(false, b, 36, 0, len);
            int pos = ShmCommon.getFreeSpacePos(b, len, length);
            if (pos == -1) {
                int[] nArray = null;
                return nArray;
            }
            shm.write(false, b, 36, 0, len);
            b = null;
            int seqId = ShmCommon.updateSequenceId(false, shm);
            b = new byte[]{1, (byte)(seqId & 0xFF), (byte)((seqId & 0xFF00) >> 8), (byte)((seqId & 0xFF0000) >> 16), (byte)((seqId & 0xFF000000) >> 24)};
            int p = ShmCommon.startPoint(false, shm, pos, length);
            shm.write(false, b, p, 0, 5);
            p = ShmCommon.startPoint(true, shm, pos, length);
            shm.write(false, b, p, 0, 5);
            ShmCommon.useAcceptPos(shm, pos);
            int[] ret = new int[]{seqId, pos};
            int[] nArray = ret;
            return nArray;
        }
        finally {
            shm.unLock();
        }
    }

    public static final void readFreeSpace(boolean sync, byte[] out, CoreShm shm) throws Exception {
        try {
            if (sync) {
                shm.lock();
            }
            shm.read(false, out, 36, 0, out.length);
        }
        finally {
            if (sync) {
                shm.unLock();
            }
        }
    }

    private static final int getFreeSpacePos(byte[] b, int trimLen, int length) {
        int ln = trimLen - 1;
        int ret = -1;
        int i = 0;
        while (i < ln) {
            int cd = b[i] & 0xFF;
            if (cd != 255) {
                int lenJ = 8;
                int sft = 1;
                int j = 0;
                while (j < lenJ) {
                    if ((cd & sft << j) == 0) {
                        b[i] = (byte)((cd | sft << j) & 0xFF);
                        ret = i * 8 + j;
                        break;
                    }
                    ++j;
                }
                if (ret != -1) break;
            }
            ++i;
        }
        if (ret == -1) {
            int lenJ = 8;
            int sft = 1;
            byte cd = b[ln];
            int j = 0;
            while (j < lenJ) {
                if ((cd & sft << j) == 0) {
                    b[ln] = (byte)((cd | sft << j) & 0xFF);
                    ret = ln * 8 + j;
                    break;
                }
                ++j;
            }
        }
        return ret;
    }

    private static final void useAcceptPos(CoreShm shm, int position) throws Exception {
        byte[] bin = new byte[32];
        while (true) {
            boolean flg = false;
            shm.read(false, bin, 4, 0, bin.length);
            int i = 0;
            while (i < 8) {
                int p = i * 4;
                int x = bin[p] & 0xFF | (bin[p + 1] & 0xFF) << 8 | (bin[p + 2] & 0xFF) << 16 | (bin[p + 3] & 0xFF) << 24;
                if (x <= 0) {
                    byte[] b = new byte[]{(byte)(++position & 0xFF), (byte)((position & 0xFF00) >> 8), (byte)((position & 0xFF0000) >> 16), (byte)((position & 0xFF000000) >> 24)};
                    shm.write(false, b, 4 + p, 0, 4);
                    flg = true;
                    break;
                }
                ++i;
            }
            if (flg) break;
            shm.unLock();
            try {
                Thread.sleep(60L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            shm.lock();
        }
    }

    public static final void getAcceptPos(ArrayList<Integer> out, CoreShm shm) throws Exception {
        boolean lockFlag = true;
        try {
            shm.lock();
            byte[] bin = new byte[32];
            shm.read(false, bin, 4, 0, bin.length);
            shm.write(false, new byte[32], 4, 0, 32);
            shm.unLock();
            lockFlag = false;
            int i = 0;
            while (i < 8) {
                int p = i * 4;
                int x = bin[p] & 0xFF | (bin[p + 1] & 0xFF) << 8 | (bin[p + 2] & 0xFF) << 16 | (bin[p + 3] & 0xFF) << 24;
                if (x > 0) {
                    out.add(new Integer(x - 1));
                }
                ++i;
            }
        }
        finally {
            if (lockFlag) {
                shm.unLock();
            }
        }
    }
}

