/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.shm;

import java.io.IOException;
import java.io.OutputStream;
import org.maachang.shm.core.CoreShm;

public class SharedMemory {
    private CoreShm mem = null;

    private SharedMemory() {
    }

    public SharedMemory(CoreShm mem) throws Exception {
        if (mem == null || !mem.isUse()) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.mem = mem;
    }

    public SharedMemory(boolean mode, String semName, String shareName, int length) throws Exception {
        try {
            this.mem = new CoreShm(mode, semName, shareName, length);
        }
        catch (Exception e) {
            this.destroy();
            throw e;
        }
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        this.mem = null;
    }

    public String getSemaphoreName() {
        if (!this.isUse()) {
            return null;
        }
        return this.mem.getSemaphoreName();
    }

    public String getShareName() {
        if (!this.isUse()) {
            return null;
        }
        return this.mem.getShareName();
    }

    public int getShareLength() {
        if (!this.isUse()) {
            return -1;
        }
        return this.mem.getShareLength();
    }

    public CoreShm getCore() {
        if (!this.isUse()) {
            return null;
        }
        return this.mem;
    }

    public int write(byte[] binary, int pos, int off, int length) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        return this.mem.write(binary, pos, off, length);
    }

    public int read(byte[] binary, int pos, int off, int length) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        return this.mem.read(binary, pos, off, length);
    }

    public boolean isUse() {
        return this.mem != null && this.mem.isUse();
    }

    public void debugOutFile(String name) throws Exception {
        this.mem.outputFile(name);
    }

    public void debugOutputStream(OutputStream output) throws Exception {
        this.mem.outputFile(output);
    }
}

