/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.shm;

import java.io.IOException;
import java.util.ArrayList;
import org.maachang.shm.ShmCommon;
import org.maachang.shm.ShmConnector;
import org.maachang.shm.ShmConnectorImpl;
import org.maachang.shm.ShmServerAcceptThread;
import org.maachang.shm.ShmTimeoutConnectThread;
import org.maachang.shm.core.CoreShm;

public class ServerShm {
    private static final int DEF_TIMEOUT = 30000;
    private CoreShm shm = null;
    private ShmServerAcceptThread thread = null;
    private ShmTimeoutConnectThread timeoutThread = null;
    private ArrayList<ShmConnectorImpl> conns = null;
    private int timeout = -1;
    private int length = -1;
    private final Object sync = new Object();

    private ServerShm() {
    }

    public ServerShm(String semName, String shareName, int length, int timeout) throws Exception {
        if (timeout <= 0) {
            timeout = 30000;
        }
        this.shm = new CoreShm(true, semName, shareName, ShmCommon.maxIOLength(length));
        this.length = ShmCommon.trimLength(length) * 8;
        this.thread = new ShmServerAcceptThread(this.shm, this.sync, this.length, timeout);
        this.timeout = timeout;
        this.conns = new ArrayList();
        this.timeoutThread = new ShmTimeoutConnectThread(this.conns, this.sync);
    }

    protected void finalize() throws Exception {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.sync;
        synchronized (object) {
            if (this.thread != null) {
                this.thread.destroy();
            }
            if (this.timeoutThread != null) {
                this.timeoutThread.destroy();
            }
            if (this.shm != null) {
                this.shm.destroy();
            }
            if (this.conns != null) {
                this.conns.clear();
            }
            this.thread = null;
            this.shm = null;
            this.conns = null;
        }
    }

    public ShmConnector accept() throws Exception {
        return this.accept(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShmConnector accept(int timeout) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        long tm = System.currentTimeMillis();
        ShmConnectorImpl ret = null;
        while (true) {
            if ((ret = this.thread.getQueue()) != null) {
                Object object = this.sync;
                synchronized (object) {
                    this.conns.add(ret);
                }
                return ret;
            }
            if (timeout > 0 && tm + (long)timeout <= System.currentTimeMillis()) {
                return null;
            }
            Thread.sleep(5L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int maxLength() {
        Object object = this.sync;
        synchronized (object) {
            block4: {
                if (this.isUse()) break block4;
                return -1;
            }
            return this.shm.getShareLength();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTimeout() {
        Object object = this.sync;
        synchronized (object) {
            block4: {
                if (this.isUse()) break block4;
                return -1;
            }
            return this.timeout;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSemaphoreName() {
        Object object = this.sync;
        synchronized (object) {
            if (!this.isUse()) {
                return null;
            }
            return this.shm.getSemaphoreName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getShareName() {
        Object object = this.sync;
        synchronized (object) {
            if (!this.isUse()) {
                return null;
            }
            return this.shm.getShareName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.sync;
        synchronized (object) {
            block4: {
                if (this.isUse()) break block4;
                return -1;
            }
            return this.conns.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUse() {
        Object object = this.sync;
        synchronized (object) {
            return this.shm != null && this.shm.isUse() && this.thread != null && !this.thread.isStop() && this.conns != null;
        }
    }
}

