/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.shm;

import org.maachang.shm.ShmCommon;
import org.maachang.shm.ShmConnector;
import org.maachang.shm.ShmConnectorImpl;
import org.maachang.shm.core.CoreShm;

public class ClientShm {
    private static final int DEF_TIMEOUT = 30000;
    private CoreShm shm = null;
    private int timeout = -1;
    private int length = -1;
    private final Object sync = new Object();

    private ClientShm() {
    }

    public ClientShm(String semName, String shareName, int length, int timeout) throws Exception {
        this.open(semName, shareName, length, timeout);
    }

    protected void finalize() throws Exception {
        this.close();
    }

    public void open(String semName, String shareName, int length, int timeout) throws Exception {
        if (timeout <= 0) {
            timeout = 30000;
        }
        this.shm = new CoreShm(false, semName, shareName, ShmCommon.maxIOLength(length));
        this.length = ShmCommon.trimLength(length) * 8;
        this.timeout = timeout;
    }

    public void close() {
        if (this.shm != null) {
            this.shm.destroy();
        }
        this.shm = null;
    }

    public ShmConnector connect() throws Exception {
        return new ShmConnectorImpl(this.shm, this.length, this.timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int maxLength() {
        Object object = this.sync;
        synchronized (object) {
            block4: {
                if (this.isUse()) break block4;
                return -1;
            }
            return this.length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTimeout() {
        Object object = this.sync;
        synchronized (object) {
            block4: {
                if (this.isUse()) break block4;
                return -1;
            }
            return this.timeout;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSemaphoreName() {
        Object object = this.sync;
        synchronized (object) {
            if (!this.isUse()) {
                return null;
            }
            return this.shm.getSemaphoreName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getShareName() {
        Object object = this.sync;
        synchronized (object) {
            if (!this.isUse()) {
                return null;
            }
            return this.shm.getShareName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUse() {
        Object object = this.sync;
        synchronized (object) {
            return this.shm != null && this.shm.isUse();
        }
    }
}

