/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.shm;

import java.util.ArrayList;
import org.maachang.shm.ShmCommon;
import org.maachang.shm.ShmConnectorImpl;
import org.maachang.shm.core.CoreShm;

class ShmServerAcceptThread
extends Thread {
    private volatile boolean stopFlag = true;
    private int useSeqId = 0;
    private CoreShm shm = null;
    private int length = -1;
    private int timeout = -1;
    private ArrayList<ShmConnectorImpl> queue = null;
    private ArrayList<Integer> accepts = null;
    private Object sync = null;
    private static final long WAIT = 60L;

    public ShmServerAcceptThread(CoreShm shm, Object sync, int length, int timeout) throws Exception {
        this.useSeqId = ShmCommon.nowSequenceId(shm);
        this.shm = shm;
        this.length = length;
        this.timeout = timeout;
        this.queue = new ArrayList();
        this.accepts = new ArrayList();
        this.stopFlag = false;
        this.sync = sync;
        this.setDaemon(true);
        this.start();
    }

    public void destroy() {
        this.setStop(true);
    }

    public synchronized boolean isStop() {
        return this.stopFlag;
    }

    private synchronized void setStop(boolean mode) {
        this.stopFlag = mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ShmConnectorImpl getQueue() {
        ShmConnectorImpl ret = null;
        Object object = this.sync;
        synchronized (object) {
            if (this.queue.size() > 0) {
                ret = this.queue.remove(0);
            }
        }
        return ret;
    }

    public void run() {
        boolean endFlag = false;
        ThreadDeath threadDeach = null;
        while (!endFlag && !this.isStop()) {
            try {
                Thread.sleep(60L);
                int seq = ShmCommon.nowSequenceId(this.shm);
                if (seq == this.useSeqId) continue;
                this.useConnect(seq);
            }
            catch (OutOfMemoryError seq) {
            }
            catch (Exception seq) {
            }
            catch (ThreadDeath td) {
                endFlag = true;
                threadDeach = td;
            }
        }
        if (this.queue != null) {
            this.queue.clear();
        }
        this.shm = null;
        this.queue = null;
        this.setStop(true);
        if (threadDeach != null) {
            throw threadDeach;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void useConnect(int seq) throws Exception {
        ShmCommon.getAcceptPos(this.accepts, this.shm);
        int len = this.accepts.size();
        int i = 0;
        while (i < len) {
            int no = this.accepts.remove(0);
            Object object = this.sync;
            synchronized (object) {
                ShmConnectorImpl impl = new ShmConnectorImpl(this.shm, no, this.length, this.timeout);
                this.queue.add(impl);
            }
            ++i;
        }
        this.useSeqId = seq;
    }
}

