/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.shm;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.maachang.shm.AbstractShmConnector;
import org.maachang.shm.ShmCommon;
import org.maachang.shm.ShmConnector;
import org.maachang.shm.ShmInputStream;
import org.maachang.shm.ShmOutputStream;
import org.maachang.shm.core.CoreShm;

class ShmConnectorImpl
extends AbstractShmConnector
implements ShmConnector {
    private CoreShm shm = null;
    private ShmInputStream input = null;
    private ShmOutputStream output = null;
    private boolean mode = false;
    private int sequenceId = -1;
    private int position = -1;
    private int length = -1;
    private int timeout = -1;

    private ShmConnectorImpl() {
    }

    protected ShmConnectorImpl(CoreShm shm, int length, int timeout) throws Exception {
        int[] res;
        if (shm == null || !shm.isUse() || length <= 0 || length > 255) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (timeout <= 0) {
            timeout = 0;
        }
        if ((res = ShmCommon.reservationSpace(shm, length)) == null) {
            throw new IOException("\u63a5\u7d9a\u7a7a\u304d\u304c\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        try {
            this.shm = shm;
            this.mode = false;
            this.sequenceId = res[0];
            this.position = res[1];
            this.length = length;
            this.timeout = timeout;
            this.input = new ShmInputStream(this.shm, this, false, this.timeout, this.position, this.sequenceId, this.length);
            this.output = new ShmOutputStream(this.shm, this, true, this.timeout, this.position, this.sequenceId, this.length);
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
    }

    protected ShmConnectorImpl(CoreShm shm, int position, int length, int timeout) throws Exception {
        if (shm == null || !shm.isUse() || position < 0 || position >= 255 || length <= 0 || length > 255) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (timeout <= 0) {
            timeout = 0;
        }
        try {
            int sequenceId = ShmCommon.getBodySequenceId(false, shm, position, length);
            if (sequenceId <= -1) {
                throw new IOException("\u6307\u5b9a\u4f4d\u7f6e(" + position + ")\u306b\u306f\u3001\u63a5\u7d9a\u6761\u4ef6\u304c\u5b58\u5728\u3057\u307e\u305b\u3093");
            }
            this.shm = shm;
            this.mode = true;
            this.sequenceId = sequenceId;
            this.position = position;
            this.length = length;
            this.timeout = timeout;
            this.input = new ShmInputStream(this.shm, this, true, this.timeout, this.position, this.sequenceId, this.length);
            this.output = new ShmOutputStream(this.shm, this, false, this.timeout, this.position, this.sequenceId, this.length);
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
    }

    protected void finalize() throws Exception {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected synchronized void notTargetByDestroy() {
        if (this.input != null) {
            this.input.destroy();
        }
        if (this.output != null) {
            this.output.destroy();
        }
        this.shm = null;
        this.input = null;
        this.output = null;
        this.sequenceId = -1;
        this.position = -1;
        this.length = -1;
        this.timeout = -1;
    }

    public synchronized void close() throws Exception {
        if (this.shm != null) {
            ShmCommon.freeSpace(this.shm, this.sequenceId, this.position, this.length);
        }
        this.notTargetByDestroy();
    }

    public synchronized InputStream getInputStream() {
        if (!this.isConnect()) {
            return null;
        }
        return this.input;
    }

    public synchronized OutputStream getOutputStream() {
        if (!this.isConnect()) {
            return null;
        }
        return this.output;
    }

    public synchronized int getId() {
        return this.sequenceId;
    }

    public synchronized int getTimeout() {
        return this.timeout;
    }

    public synchronized boolean isMode() {
        return this.mode;
    }

    public synchronized boolean isTimeout() {
        return this.input.isTimeout() || this.output.isTimeout();
    }

    public synchronized boolean isConnect() {
        try {
            if (this.shm == null || !this.shm.isUse()) {
                return false;
            }
            int seqId = ShmCommon.getBodySequenceId(false, this.shm, this.position, this.length);
            int seqWId = ShmCommon.getBodySequenceId(true, this.shm, this.position, this.length);
            return seqId > -1 && seqId == this.sequenceId && seqWId > -1 && seqWId == this.sequenceId;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public synchronized String toString() {
        return "mode:" + this.mode + " sequenceId:" + this.sequenceId + " position:" + this.position + " length:" + this.length + " timeout:" + this.timeout;
    }

    public synchronized void debugOutFile(String name) throws Exception {
        this.shm.outputFile(name);
    }
}

