/*
 Copyright 2013 Andy Earnshaw, MIT License

 Implements the ECMAScript Internationalization API in ES5-compatible environments,
 following the ECMA-402 specification as closely as possible

 ECMA-402: http://ecma-international.org/ecma-402/1.0/

 CLDR format locale data should be provided using IntlPolyfill.__addLocaleData().
*/
var $jscomp=$jscomp||{};$jscomp.scope={};$jscomp.arrayIteratorImpl=function(m){var n=0;return function(){return n<m.length?{done:!1,value:m[n++]}:{done:!0}}};$jscomp.arrayIterator=function(m){return{next:$jscomp.arrayIteratorImpl(m)}};$jscomp.makeIterator=function(m){var n="undefined"!=typeof Symbol&&Symbol.iterator&&m[Symbol.iterator];return n?n.call(m):$jscomp.arrayIterator(m)};$jscomp.ASSUME_ES5=!1;$jscomp.ASSUME_NO_NATIVE_MAP=!1;$jscomp.ASSUME_NO_NATIVE_SET=!1;$jscomp.SIMPLE_FROUND_POLYFILL=!1;
$jscomp.ISOLATE_POLYFILLS=!1;$jscomp.FORCE_POLYFILL_PROMISE=!1;$jscomp.FORCE_POLYFILL_PROMISE_WHEN_NO_UNHANDLED_REJECTION=!1;$jscomp.getGlobal=function(m){m=["object"==typeof globalThis&&globalThis,m,"object"==typeof window&&window,"object"==typeof self&&self,"object"==typeof global&&global];for(var n=0;n<m.length;++n){var u=m[n];if(u&&u.Math==Math)return u}throw Error("Cannot find global object");};$jscomp.global=$jscomp.getGlobal(this);
$jscomp.defineProperty=$jscomp.ASSUME_ES5||"function"==typeof Object.defineProperties?Object.defineProperty:function(m,n,u){if(m==Array.prototype||m==Object.prototype)return m;m[n]=u.value;return m};$jscomp.IS_SYMBOL_NATIVE="function"===typeof Symbol&&"symbol"===typeof Symbol("x");$jscomp.TRUST_ES6_POLYFILLS=!$jscomp.ISOLATE_POLYFILLS||$jscomp.IS_SYMBOL_NATIVE;$jscomp.polyfills={};$jscomp.propertyToPolyfillSymbol={};$jscomp.POLYFILL_PREFIX="$jscp$";
var $jscomp$lookupPolyfilledValue=function(m,n){var u=$jscomp.propertyToPolyfillSymbol[n];if(null==u)return m[n];u=m[u];return void 0!==u?u:m[n]};$jscomp.polyfill=function(m,n,u,v){n&&($jscomp.ISOLATE_POLYFILLS?$jscomp.polyfillIsolated(m,n,u,v):$jscomp.polyfillUnisolated(m,n,u,v))};
$jscomp.polyfillUnisolated=function(m,n,u,v){u=$jscomp.global;m=m.split(".");for(v=0;v<m.length-1;v++){var t=m[v];if(!(t in u))return;u=u[t]}m=m[m.length-1];v=u[m];n=n(v);n!=v&&null!=n&&$jscomp.defineProperty(u,m,{configurable:!0,writable:!0,value:n})};
$jscomp.polyfillIsolated=function(m,n,u,v){var t=m.split(".");m=1===t.length;v=t[0];v=!m&&v in $jscomp.polyfills?$jscomp.polyfills:$jscomp.global;for(var x=0;x<t.length-1;x++){var r=t[x];if(!(r in v))return;v=v[r]}t=t[t.length-1];u=$jscomp.IS_SYMBOL_NATIVE&&"es6"===u?v[t]:null;n=n(u);null!=n&&(m?$jscomp.defineProperty($jscomp.polyfills,t,{configurable:!0,writable:!0,value:n}):n!==u&&(void 0===$jscomp.propertyToPolyfillSymbol[t]&&(u=1E9*Math.random()>>>0,$jscomp.propertyToPolyfillSymbol[t]=$jscomp.IS_SYMBOL_NATIVE?
$jscomp.global.Symbol(t):$jscomp.POLYFILL_PREFIX+u+"$"+t),$jscomp.defineProperty(v,$jscomp.propertyToPolyfillSymbol[t],{configurable:!0,writable:!0,value:n})))};
$jscomp.polyfill("Promise",function(m){function n(){this.batch_=null}function u(r){return r instanceof t?r:new t(function(w,y){w(r)})}if(m&&(!($jscomp.FORCE_POLYFILL_PROMISE||$jscomp.FORCE_POLYFILL_PROMISE_WHEN_NO_UNHANDLED_REJECTION&&"undefined"===typeof $jscomp.global.PromiseRejectionEvent)||!$jscomp.global.Promise||-1===$jscomp.global.Promise.toString().indexOf("[native code]")))return m;n.prototype.asyncExecute=function(r){if(null==this.batch_){this.batch_=[];var w=this;this.asyncExecuteFunction(function(){w.executeBatch_()})}this.batch_.push(r)};
var v=$jscomp.global.setTimeout;n.prototype.asyncExecuteFunction=function(r){v(r,0)};n.prototype.executeBatch_=function(){for(;this.batch_&&this.batch_.length;){var r=this.batch_;this.batch_=[];for(var w=0;w<r.length;++w){var y=r[w];r[w]=null;try{y()}catch(G){this.asyncThrow_(G)}}}this.batch_=null};n.prototype.asyncThrow_=function(r){this.asyncExecuteFunction(function(){throw r;})};var t=function(r){this.state_=0;this.result_=void 0;this.onSettledCallbacks_=[];this.isRejectionHandled_=!1;var w=this.createResolveAndReject_();
try{r(w.resolve,w.reject)}catch(y){w.reject(y)}};t.prototype.createResolveAndReject_=function(){function r(G){return function(H){y||(y=!0,G.call(w,H))}}var w=this,y=!1;return{resolve:r(this.resolveTo_),reject:r(this.reject_)}};t.prototype.resolveTo_=function(r){if(r===this)this.reject_(new TypeError("A Promise cannot resolve to itself"));else if(r instanceof t)this.settleSameAsPromise_(r);else{a:switch(typeof r){case "object":var w=null!=r;break a;case "function":w=!0;break a;default:w=!1}w?this.resolveToNonPromiseObj_(r):
this.fulfill_(r)}};t.prototype.resolveToNonPromiseObj_=function(r){var w=void 0;try{w=r.then}catch(y){this.reject_(y);return}"function"==typeof w?this.settleSameAsThenable_(w,r):this.fulfill_(r)};t.prototype.reject_=function(r){this.settle_(2,r)};t.prototype.fulfill_=function(r){this.settle_(1,r)};t.prototype.settle_=function(r,w){if(0!=this.state_)throw Error("Cannot settle("+r+", "+w+"): Promise already settled in state"+this.state_);this.state_=r;this.result_=w;2===this.state_&&this.scheduleUnhandledRejectionCheck_();
this.executeOnSettledCallbacks_()};t.prototype.scheduleUnhandledRejectionCheck_=function(){var r=this;v(function(){if(r.notifyUnhandledRejection_()){var w=$jscomp.global.console;"undefined"!==typeof w&&w.error(r.result_)}},1)};t.prototype.notifyUnhandledRejection_=function(){if(this.isRejectionHandled_)return!1;var r=$jscomp.global.CustomEvent,w=$jscomp.global.Event,y=$jscomp.global.dispatchEvent;if("undefined"===typeof y)return!0;"function"===typeof r?r=new r("unhandledrejection",{cancelable:!0}):
"function"===typeof w?r=new w("unhandledrejection",{cancelable:!0}):(r=$jscomp.global.document.createEvent("CustomEvent"),r.initCustomEvent("unhandledrejection",!1,!0,r));r.promise=this;r.reason=this.result_;return y(r)};t.prototype.executeOnSettledCallbacks_=function(){if(null!=this.onSettledCallbacks_){for(var r=0;r<this.onSettledCallbacks_.length;++r)x.asyncExecute(this.onSettledCallbacks_[r]);this.onSettledCallbacks_=null}};var x=new n;t.prototype.settleSameAsPromise_=function(r){var w=this.createResolveAndReject_();
r.callWhenSettled_(w.resolve,w.reject)};t.prototype.settleSameAsThenable_=function(r,w){var y=this.createResolveAndReject_();try{r.call(w,y.resolve,y.reject)}catch(G){y.reject(G)}};t.prototype.then=function(r,w){function y(M,O){return"function"==typeof M?function(J){try{G(M(J))}catch(P){H(P)}}:O}var G,H,Y=new t(function(M,O){G=M;H=O});this.callWhenSettled_(y(r,G),y(w,H));return Y};t.prototype.catch=function(r){return this.then(void 0,r)};t.prototype.callWhenSettled_=function(r,w){function y(){switch(G.state_){case 1:r(G.result_);
break;case 2:w(G.result_);break;default:throw Error("Unexpected state: "+G.state_);}}var G=this;null==this.onSettledCallbacks_?x.asyncExecute(y):this.onSettledCallbacks_.push(y);this.isRejectionHandled_=!0};t.resolve=u;t.reject=function(r){return new t(function(w,y){y(r)})};t.race=function(r){return new t(function(w,y){for(var G=$jscomp.makeIterator(r),H=G.next();!H.done;H=G.next())u(H.value).callWhenSettled_(w,y)})};t.all=function(r){var w=$jscomp.makeIterator(r),y=w.next();return y.done?u([]):new t(function(G,
H){function Y(J){return function(P){M[J]=P;O--;0==O&&G(M)}}var M=[],O=0;do M.push(void 0),O++,u(y.value).callWhenSettled_(Y(M.length-1),H),y=w.next();while(!y.done)})};return t},"es6","es3");$jscomp.owns=function(m,n){return Object.prototype.hasOwnProperty.call(m,n)};$jscomp.assign=$jscomp.TRUST_ES6_POLYFILLS&&"function"==typeof Object.assign?Object.assign:function(m,n){for(var u=1;u<arguments.length;u++){var v=arguments[u];if(v)for(var t in v)$jscomp.owns(v,t)&&(m[t]=v[t])}return m};
$jscomp.polyfill("Object.assign",function(m){return m||$jscomp.assign},"es6","es3");$jscomp.initSymbol=function(){};
$jscomp.polyfill("Symbol",function(m){if(m)return m;var n=function(x,r){this.$jscomp$symbol$id_=x;$jscomp.defineProperty(this,"description",{configurable:!0,writable:!0,value:r})};n.prototype.toString=function(){return this.$jscomp$symbol$id_};var u="jscomp_symbol_"+(1E9*Math.random()>>>0)+"_",v=0,t=function(x){if(this instanceof t)throw new TypeError("Symbol is not a constructor");return new n(u+(x||"")+"_"+v++,x)};return t},"es6","es3");
$jscomp.polyfill("Symbol.iterator",function(m){if(m)return m;m=Symbol("Symbol.iterator");for(var n="Array Int8Array Uint8Array Uint8ClampedArray Int16Array Uint16Array Int32Array Uint32Array Float32Array Float64Array".split(" "),u=0;u<n.length;u++){var v=$jscomp.global[n[u]];"function"===typeof v&&"function"!=typeof v.prototype[m]&&$jscomp.defineProperty(v.prototype,m,{configurable:!0,writable:!0,value:function(){return $jscomp.iteratorPrototype($jscomp.arrayIteratorImpl(this))}})}return m},"es6",
"es3");$jscomp.iteratorPrototype=function(m){m={next:m};m[Symbol.iterator]=function(){return this};return m};$jscomp.polyfill("Array.from",function(m){return m?m:function(n,u,v){u=null!=u?u:function(w){return w};var t=[],x="undefined"!=typeof Symbol&&Symbol.iterator&&n[Symbol.iterator];if("function"==typeof x){n=x.call(n);for(var r=0;!(x=n.next()).done;)t.push(u.call(v,x.value,r++))}else for(x=n.length,r=0;r<x;r++)t.push(u.call(v,n[r],r));return t}},"es6","es3");
$jscomp.checkStringArgs=function(m,n,u){if(null==m)throw new TypeError("The 'this' value for String.prototype."+u+" must not be null or undefined");if(n instanceof RegExp)throw new TypeError("First argument to String.prototype."+u+" must not be a regular expression");return m+""};
$jscomp.polyfill("String.prototype.codePointAt",function(m){return m?m:function(n){var u=$jscomp.checkStringArgs(this,null,"codePointAt"),v=u.length;n=Number(n)||0;if(0<=n&&n<v){n|=0;var t=u.charCodeAt(n);if(55296>t||56319<t||n+1===v)return t;n=u.charCodeAt(n+1);return 56320>n||57343<n?t:1024*(t-55296)+n+9216}}},"es6","es3");$jscomp.polyfill("Number.isFinite",function(m){return m?m:function(n){return"number"!==typeof n?!1:!isNaN(n)&&Infinity!==n&&-Infinity!==n}},"es6","es3");
$jscomp.iteratorFromArray=function(m,n){m instanceof String&&(m+="");var u=0,v=!1,t={next:function(){if(!v&&u<m.length){var x=u++;return{value:n(x,m[x]),done:!1}}v=!0;return{done:!0,value:void 0}}};t[Symbol.iterator]=function(){return t};return t};$jscomp.polyfill("Array.prototype.keys",function(m){return m?m:function(){return $jscomp.iteratorFromArray(this,function(n){return n})}},"es6","es3");
(function(m,n){"object"===typeof exports&&"undefined"!==typeof module?module.exports=n():"function"===typeof define&&define.amd?define(n):m.IntlPolyfill=n()})(this,function(){function m(f){for(var e in f)(f instanceof m||A.call(f,e))&&C(this,e,{value:f[e],enumerable:!0,writable:!0,configurable:!0})}function n(){C(this,"length",{writable:!0,value:0});arguments.length&&D.apply(this,Z.call(arguments))}function u(){if(F.disableRegExpRestore)return function(){};for(var f={lastMatch:RegExp.lastMatch||"",
leftContext:RegExp.leftContext,multiline:RegExp.multiline,input:RegExp.input},e=!1,a=1;9>=a;a++)e=(f["$"+a]=RegExp["$"+a])||e;return function(){var c=/[.?*+^$[\]\\(){}|-]/g,b=f.lastMatch.replace(c,"\\$&"),d="";if(e)for(var h=1;9>=h;h++){var g=f["$"+h];g?(g=g.replace(c,"\\$&"),d+=b.substring(0,b.indexOf(g))+"(",b=g+")"+b.substring(b.indexOf(g)+g.length)):(d+="(",b=")"+b)}d=(d+b).replace(/((^|[^\\])((\\\\)*\\[()])+|[^()])+/g,function(l){return"[\\s\\S]{"+l.replace(/\\(.)/g,"$1").length+"}"});c=new RegExp(d,
f.multiline?"gm":"g");c.lastIndex=f.leftContext.length;c.exec(f.input)}}function v(f){if(null===f)throw new TypeError("Cannot convert null or undefined to object");return"object"===("undefined"===typeof f?"undefined":Q["typeof"](f))?f:Object(f)}function t(f){return"number"===typeof f?f:Number(f)}function x(f){return A.call(f,"__getInternalProperties")?f.__getInternalProperties(aa):R(null)}function r(f){for(var e=f.length;e--;){var a=f.charAt(e);"a"<=a&&"z">=a&&(f=f.slice(0,e)+a.toUpperCase()+f.slice(e+
1))}return f}function w(f){return!Ga.test(f)||Ha.test(f)||Ia.test(f)?!1:!0}function y(f){var e=void 0;f=f.toLowerCase();f=f.split("-");for(var a=1,c=f.length;a<c;a++)if(2===f[a].length)f[a]=f[a].toUpperCase();else if(4===f[a].length)f[a]=f[a].charAt(0).toUpperCase()+f[a].slice(1);else if(1===f[a].length&&"x"!==f[a])break;f=S.call(f,"-");(e=f.match(pa))&&1<e.length&&(e.sort(),f=f.replace(RegExp("(?:"+pa.source+")+","i"),S.call(e,"")));A.call(X.tags,f)&&(f=X.tags[f]);f=f.split("-");e=1;for(a=f.length;e<
a;e++)A.call(X.subtags,f[e])?f[e]=X.subtags[f[e]]:A.call(X.extLang,f[e])&&(f[e]=X.extLang[f[e]][0],1===e&&X.extLang[f[1]][1]===f[0]&&(f=Z.call(f,e++),--a));return S.call(f,"-")}function G(f){f=r(String(f));return!1===Ja.test(f)?!1:!0}function H(f){if(void 0===f)return new n;var e=new n;f="string"===typeof f?[f]:f;f=v(f);var a=t(f.length);a=isNaN(a)?0:0===a||-0===a||Infinity===a||-Infinity===a?a:0>a?-1*Math.floor(Math.abs(a)):Math.floor(Math.abs(a));a=0>=a?0:Infinity===a?Math.pow(2,53)-1:Math.min(a,
Math.pow(2,53)-1);for(var c=0;c<a;){var b=String(c);if(b in f){b=f[b];if(null===b||"string"!==typeof b&&"object"!==("undefined"===typeof b?"undefined":Q["typeof"](b)))throw new TypeError("String or Object type expected");b=String(b);if(!w(b))throw new RangeError("'"+b+"' is not a structurally valid language tag");b=y(b);-1===W.call(e,b)&&D.call(e,b)}c++}return e}function Y(f,e){for(;e;){if(-1<W.call(f,e))return e;var a=e.lastIndexOf("-");if(0>a)break;2<=a&&"-"===e.charAt(a-2)&&(a-=2);e=e.substring(0,
a)}}function M(f,e,a,c,b){if(0===f.length)throw new ReferenceError("No locale data has been provided for this object yet.");for(var d=0,h=e.length,g=void 0,l=void 0,p=void 0;d<h&&!g;)l=e[d],p=String(l).replace(ka,""),g=Y(f,p),d++;f=new m;void 0!==g?(f["[[locale]]"]=g,String(l)!==String(p)&&(g=l.match(ka)[0],l=l.indexOf("-u-"),f["[[extension]]"]=g,f["[[extensionIndex]]"]=l)):f["[[locale]]"]=la;l=f["[[locale]]"];e=p=void 0;if(A.call(f,"[[extension]]")){g=f["[[extension]]"];p=g.length;if(0===p)p=[];
else{f=[];h=!0;for(var q=d=e=3;e<p;)45===g.codePointAt(e)&&(2===e-d?(1<d-q&&(h=g.substring(q,d-1),f.push(h)),d=g.substring(d,e),f.push(d),q=e+1,h=!1):!0===h&&(d=g.substring(d,e),f.push(d),q=e+1),d=e+1),e+=1;2===p-d&&(1<d-q&&(e=g.substring(q,d-1),f.push(e)),q=d);g=g.substring(q,p);f.push(g);p=f}e=p.length}f=new m;f["[[dataLocale]]"]=l;g="-u";d=0;for(h=c.length;d<h;){q=c[d];var z=b[l][q],E=z["0"],K="",L=W;if(void 0!==p){var I=L.call(p,q);-1!==I&&(I+1<e&&2<p[I+1].length?(I=p[I+1],-1!==L.call(z,I)&&(E=
I,K="-"+q+"-"+E)):-1!==L(z,"true")&&(E="true"))}A.call(a,"[["+q+"]]")&&(I=a["[["+q+"]]"],-1!==L.call(z,I)&&I!==E&&(E=I,K=""));f["[["+q+"]]"]=E;g+=K;d++}2<g.length&&(c=l.indexOf("-x-"),-1===c?l+=g:(a=l.substring(0,c),c=l.substring(c),l=a+g+c),l=y(l));f["[[locale]]"]=l;return f}function O(f,e,a){if(void 0!==a&&(a=new m(v(a)),a=a.localeMatcher,void 0!==a&&(a=String(a),"lookup"!==a&&"best fit"!==a)))throw new RangeError('matcher should be "lookup" or "best fit"');a=e.length;for(var c=new n,b=0;b<a;){var d=
e[b],h=String(d).replace(ka,"");void 0!==Y(f,h)&&D.call(c,d);b++}f=Z.call(c);for(var g in f)A.call(f,g)&&C(f,g,{writable:!1,configurable:!1,value:f[g]});try{C(f,"length",{writable:!1})}catch(l){}return f}function J(f,e,a,c,b){f=f[e];if(void 0!==f){f="boolean"===a?!!f:"string"===a?String(f):f;if(void 0!==c&&-1===W.call(c,f))throw new RangeError("'"+f+"' is not an allowed value for `"+e+"`");return f}return b}function P(f,e,a,c,b){f=f[e];if(void 0!==f){f=Number(f);if(isNaN(f)||f<a||f>c)throw new RangeError("Value is not a number or outside accepted range");
return Math.floor(f)}return b}function qa(f,e){return this&&this!==B?Ka(v(this),f,e):new B.NumberFormat(f,e)}function ra(f,e,a){var c=P(e,"minimumIntegerDigits",1,21,1);a=P(e,"minimumFractionDigits",0,20,a);var b=P(e,"maximumFractionDigits",a,20),d=e.minimumSignificantDigits,h=e.maximumSignificantDigits;f["[[minimumIntegerDigits]]"]=c;f["[[minimumFractionDigits]]"]=a;f["[[maximumFractionDigits]]"]=b;if(void 0!==d||void 0!==h)d=P(e,"minimumSignificantDigits",1,21,1),h=P(e,"maximumSignificantDigits",
d,21,21),f["[[minimumSignificantDigits]]"]=d,f["[[maximumSignificantDigits]]"]=h}function Ka(f,e,a){var c=x(f),b=u();if(!0===c["[[initializedIntlObject]]"])throw new TypeError("`this` object has already been initialized as an Intl object");C(f,"__getInternalProperties",{value:function(p){if(p===aa)return c}});c["[[initializedIntlObject]]"]=!0;var d=H(e);a=void 0===a?{}:v(a);var h=new m;e=J(a,"localeMatcher","string",new n("lookup","best fit"),"best fit");h["[[localeMatcher]]"]=e;e=F.NumberFormat["[[localeData]]"];
d=M(F.NumberFormat["[[availableLocales]]"],d,h,F.NumberFormat["[[relevantExtensionKeys]]"],e);c["[[locale]]"]=d["[[locale]]"];c["[[numberingSystem]]"]=d["[[nu]]"];c["[[dataLocale]]"]=d["[[dataLocale]]"];d=d["[[dataLocale]]"];h=J(a,"style","string",new n("decimal","percent","currency"),"decimal");c["[[style]]"]=h;var g=J(a,"currency","string");if(void 0!==g&&!G(g))throw new RangeError("'"+g+"' is not a valid currency code");if("currency"===h&&void 0===g)throw new TypeError("Currency code is required when style is currency");
var l=void 0;"currency"===h&&(g=g.toUpperCase(),c["[[currency]]"]=g,l=void 0!==sa[g]?sa[g]:2);g=J(a,"currencyDisplay","string",new n("code","symbol","name"),"symbol");"currency"===h&&(c["[[currencyDisplay]]"]=g);ra(c,a,"currency"===h?l:0);void 0===c["[[maximumFractionDigits]]"]&&(c["[[maximumFractionDigits]]"]="currency"===h?Math.max(c["[[minimumFractionDigits]]"],l):"percent"===h?Math.max(c["[[minimumFractionDigits]]"],0):Math.max(c["[[minimumFractionDigits]]"],3));a=J(a,"useGrouping","boolean",
void 0,!0);c["[[useGrouping]]"]=a;a=e[d].patterns[h];c["[[positivePattern]]"]=a.positivePattern;c["[[negativePattern]]"]=a.negativePattern;c["[[boundFormat]]"]=void 0;c["[[initializedNumberFormat]]"]=!0;ta&&(f.format=ua.call(f));b();return f}function ua(){var f=null!==this&&"object"===Q["typeof"](this)&&x(this);if(!f||!f["[[initializedNumberFormat]]"])throw new TypeError("`this` value for format() is not an initialized Intl.NumberFormat object.");if(void 0===f["[[boundFormat]]"]){var e=ba.call(function(a){return fa(this,
Number(a))},this);f["[[boundFormat]]"]=e}return f["[[boundFormat]]"]}function La(f,e){var a=x(f);if(A.call(a,"[[minimumSignificantDigits]]")&&A.call(a,"[[maximumSignificantDigits]]")){f=a["[[minimumSignificantDigits]]"];var c=a["[[maximumSignificantDigits]]"];if(0===e)e=S.call(Array(c+1),"0"),a=0;else{a=Math.abs(e);if("function"===typeof Math.log10)a=Math.floor(Math.log10(a));else{var b=Math.round(Math.log(a)*Math.LOG10E);a=b-(Number("1e"+b)>a)}b=Math.round(Math.exp(Math.abs(a-c+1)*Math.LN10));e=
String(Math.round(0>a-c+1?e*b:e/b))}if(a>=c)f=e+S.call(Array(a-c+2),"0");else{if(a!==c-1&&(0<=a?e=e.slice(0,a+1)+"."+e.slice(a+1):0>a&&(e="0."+S.call(Array(-(a+1)+1),"0")+e),0<=e.indexOf(".")&&c>f)){for(f=c-f;0<f&&"0"===e.charAt(e.length-1);)e=e.slice(0,-1),f--;"."===e.charAt(e.length-1)&&(e=e.slice(0,-1))}f=e}}else{f=a["[[minimumIntegerDigits]]"];c=a["[[minimumFractionDigits]]"];a=a["[[maximumFractionDigits]]"];e*=Math.pow(10,a);e=0===e?"0":e.toFixed(0);b=void 0;var d=-1<(b=e.indexOf("e"))?e.slice(b+
1):0;d&&(e=e.slice(0,b).replace(".",""),e+=S.call(Array(d-(e.length-1)+1),"0"));0!==a?(d=e.length,d<=a&&(e=S.call(Array(a+1-d+1),"0")+e,d=a+1),b=e.substring(0,d-a),e=e.substring(d-a,e.length),e=b+"."+e,b=b.length):b=e.length;for(c=a-c;0<c&&"0"===e.slice(-1);)e=e.slice(0,-1),c--;"."===e.slice(-1)&&(e=e.slice(0,-1));b<f&&(e=S.call(Array(f-b+1),"0")+e);f=e}return f}function va(f,e){var a=x(f),c=a["[[numberingSystem]]"],b=F.NumberFormat["[[localeData]]"][a["[[dataLocale]]"]],d=b.symbols[c]||b.symbols.latn,
h=void 0;!isNaN(e)&&0>e?(e=-e,h=a["[[negativePattern]]"]):h=a["[[positivePattern]]"];for(var g=new n,l=h.indexOf("{",0),p=0,q=0,z=h.length;-1<l&&l<z;){p=h.indexOf("}",l);if(-1===p)throw Error();l>q&&(q=h.substring(q,l),D.call(g,{"[[type]]":"literal","[[value]]":q}));q=h.substring(l+1,p);if("number"===q)if(isNaN(e))D.call(g,{"[[type]]":"nan","[[value]]":d.nan});else if(isFinite(e)){"percent"===a["[[style]]"]&&(e*=100);var E=La(f,e);wa[c]?function(){var Ma=wa[c];E=String(E).replace(/\d/g,function(Na){return Ma[Na]})}():
E=String(E);q=l=void 0;q=E.indexOf(".",0);0<q?(l=E.substring(0,q),q=E.substring(q+1,q.length)):(l=E,q=void 0);if(!0===a["[[useGrouping]]"]){var K=d.group,L=[],I=b.patterns.primaryGroupSize||3,ma=b.patterns.secondaryGroupSize||I;if(l.length>I){I=l.length-I;var ca=I%ma,xa=l.slice(0,ca);for(xa.length&&D.call(L,xa);ca<I;)D.call(L,l.slice(ca,ca+ma)),ca+=ma;D.call(L,l.slice(I))}else D.call(L,l);if(0===L.length)throw Error();for(;L.length;)l=ya.call(L),D.call(g,{"[[type]]":"integer","[[value]]":l}),L.length&&
D.call(g,{"[[type]]":"group","[[value]]":K})}else D.call(g,{"[[type]]":"integer","[[value]]":l});void 0!==q&&(D.call(g,{"[[type]]":"decimal","[[value]]":d.decimal}),D.call(g,{"[[type]]":"fraction","[[value]]":q}))}else D.call(g,{"[[type]]":"infinity","[[value]]":d.infinity});else"plusSign"===q?D.call(g,{"[[type]]":"plusSign","[[value]]":d.plusSign}):"minusSign"===q?D.call(g,{"[[type]]":"minusSign","[[value]]":d.minusSign}):"percentSign"===q&&"percent"===a["[[style]]"]?D.call(g,{"[[type]]":"literal",
"[[value]]":d.percentSign}):"currency"===q&&"currency"===a["[[style]]"]?(l=a["[[currency]]"],q=void 0,"code"===a["[[currencyDisplay]]"]?q=l:"symbol"===a["[[currencyDisplay]]"]?q=b.currencies[l]||l:"name"===a["[[currencyDisplay]]"]&&(q=l),D.call(g,{"[[type]]":"currency","[[value]]":q})):(l=h.substring(l,p),D.call(g,{"[[type]]":"literal","[[value]]":l}));q=p+1;l=h.indexOf("{",q)}q<z&&(f=h.substring(q,z),D.call(g,{"[[type]]":"literal","[[value]]":f}));return g}function fa(f,e){f=va(f,e);e="";for(var a=
0;f.length>a;a++)e+=f[a]["[[value]]"];return e}function za(f){f.pattern12=f.extendedPattern.replace(/'([^']*)'/g,function(e,a){return a?a:"'"});f.pattern=f.pattern12.replace("{ampm}","").replace(Oa,"");return f}function Aa(f,e){switch(f.charAt(0)){case "G":return e.era=["short","short","short","long","narrow"][f.length-1],"{era}";case "y":case "Y":case "u":case "U":case "r":return e.year=2===f.length?"2-digit":"numeric","{year}";case "Q":case "q":return e.quarter=["numeric","2-digit","short","long",
"narrow"][f.length-1],"{quarter}";case "M":case "L":return e.month=["numeric","2-digit","short","long","narrow"][f.length-1],"{month}";case "w":return e.week=2===f.length?"2-digit":"numeric","{weekday}";case "W":return e.week="numeric","{weekday}";case "d":return e.day=2===f.length?"2-digit":"numeric","{day}";case "D":case "F":case "g":return e.day="numeric","{day}";case "E":return e.weekday="short short short long narrow short".split(" ")[f.length-1],"{weekday}";case "e":return e.weekday="numeric 2-digit short long narrow short".split(" ")[f.length-
1],"{weekday}";case "c":return e.weekday=["numeric",void 0,"short","long","narrow","short"][f.length-1],"{weekday}";case "a":case "b":case "B":return e.hour12=!0,"{ampm}";case "h":case "H":return e.hour=2===f.length?"2-digit":"numeric","{hour}";case "k":case "K":return e.hour12=!0,e.hour=2===f.length?"2-digit":"numeric","{hour}";case "m":return e.minute=2===f.length?"2-digit":"numeric","{minute}";case "s":return e.second=2===f.length?"2-digit":"numeric","{second}";case "S":case "A":return e.second=
"numeric","{second}";case "z":case "Z":case "O":case "v":case "V":case "X":case "x":return e.timeZoneName=4>f.length?"short":"long","{timeZoneName}"}}function na(f,e){if(!Pa.test(e)){var a={originalPattern:e,_:{}};a.extendedPattern=e.replace(Ba,function(c){return Aa(c,a._)});f.replace(Ba,function(c){return Aa(c,a)});return za(a)}}function ha(f,e,a,c,b){f=f[e]&&f[e][a]?f[e][a]:f.gregory[a];e={narrow:["short","long"],short:["long","narrow"],long:["short","narrow"]};c=A.call(f,c)?f[c]:A.call(f,e[c][0])?
f[e[c][0]]:f[e[c][1]];return null!==b?c[b]:c}function da(f,e){return this&&this!==B?Qa(v(this),f,e):new B.DateTimeFormat(f,e)}function Qa(f,e,a){var c=x(f),b=u();if(!0===c["[[initializedIntlObject]]"])throw new TypeError("`this` object has already been initialized as an Intl object");C(f,"__getInternalProperties",{value:function(q){if(q===aa)return c}});c["[[initializedIntlObject]]"]=!0;var d=H(e);a=ia(a,"any","date");e=new m;var h=J(a,"localeMatcher","string",new n("lookup","best fit"),"best fit");
e["[[localeMatcher]]"]=h;var g=F.DateTimeFormat;h=g["[[localeData]]"];e=M(g["[[availableLocales]]"],d,e,g["[[relevantExtensionKeys]]"],h);c["[[locale]]"]=e["[[locale]]"];c["[[calendar]]"]=e["[[ca]]"];c["[[numberingSystem]]"]=e["[[nu]]"];c["[[dataLocale]]"]=e["[[dataLocale]]"];g=e["[[dataLocale]]"];e=a.timeZone;if(void 0!==e&&(e=r(e),"UTC"!==e))throw new RangeError("timeZone is not supported.");c["[[timeZone]]"]=e;e=new m;for(var l in N)A.call(N,l)&&(d=J(a,l,"string",N[l]),e["[["+l+"]]"]=d);d=void 0;
l=h[g];d=Ra(l.formats);h=J(a,"formatMatcher","string",new n("basic","best fit"),"best fit");l.formats=d;"basic"===h?d=Sa(e,d):(h=J(a,"hour12","boolean"),e.hour12=void 0===h?l.hour12:h,d=Ta(e,d));for(var p in N)A.call(N,p)&&A.call(d,p)&&(e=d[p],e=d._&&A.call(d._,p)?d._[p]:e,c["[["+p+"]]"]=e);p=void 0;a=J(a,"hour12","boolean");c["[[hour]]"]?(a=void 0===a?l.hour12:a,c["[[hour12]]"]=a,!0===a?(c["[[hourNo0]]"]=l.hourNo0,p=d.pattern12):p=d.pattern):p=d.pattern;c["[[pattern]]"]=p;c["[[boundFormat]]"]=void 0;
c["[[initializedDateTimeFormat]]"]=!0;ta&&(f.format=Ca.call(f));b();return f}function Ra(f){if("[object Array]"===Object.prototype.toString.call(f))return f;var e=f.availableFormats,a=f.timeFormats,c=f.dateFormats,b=[],d=void 0,h,g=[],l=[];for(d in e)if(e.hasOwnProperty(d)){var p=e[d];if(h=na(d,p)){b.push(h);a:{p=h;for(var q=0;q<T.length;q+=1)if(p.hasOwnProperty(T[q])){p=!1;break a}p=!0}if(p)l.push(h);else{a:{p=h;for(q=0;q<U.length;q+=1)if(p.hasOwnProperty(U[q])){p=!1;break a}p=!0}p&&g.push(h)}}}for(d in a)a.hasOwnProperty(d)&&
(p=a[d],h=na(d,p))&&(b.push(h),g.push(h));for(d in c)c.hasOwnProperty(d)&&(p=c[d],h=na(d,p))&&(b.push(h),l.push(h));for(e=0;e<g.length;e+=1)for(a=0;a<l.length;a+=1){p="long"===l[a].month?l[a].weekday?f.full:f.long:"short"===l[a].month?f.medium:f.short;d=l[a];h=g[e];c={_:{}};for(q=0;q<U.length;q+=1)d[U[q]]&&(c[U[q]]=d[U[q]]),d._[U[q]]&&(c._[U[q]]=d._[U[q]]);for(d=0;d<T.length;d+=1)h[T[d]]&&(c[T[d]]=h[T[d]]),h._[T[d]]&&(c._[T[d]]=h._[T[d]]);h=c;h.originalPattern=p;h.extendedPattern=p.replace("{0}",
g[e].extendedPattern).replace("{1}",l[a].extendedPattern).replace(/^[,\s]+|[,\s]+$/gi,"");b.push(za(h))}return b}function ia(f,e,a){if(void 0===f)f=null;else{var c=v(f);f=new m;for(var b in c)f[b]=c[b]}f=R(f);c=!0;if("date"===e||"any"===e)if(void 0!==f.weekday||void 0!==f.year||void 0!==f.month||void 0!==f.day)c=!1;if("time"===e||"any"===e)if(void 0!==f.hour||void 0!==f.minute||void 0!==f.second)c=!1;!c||"date"!==a&&"all"!==a||(f.year=f.month=f.day="numeric");!c||"time"!==a&&"all"!==a||(f.hour=f.minute=
f.second="numeric");return f}function Sa(f,e){for(var a=-Infinity,c=void 0,b=0,d=e.length;b<d;){var h=e[b],g=0,l;for(l in N)if(A.call(N,l)){var p=f["[["+l+"]]"],q=A.call(h,l)?h[l]:void 0;if(void 0===p&&void 0!==q)g-=20;else if(void 0!==p&&void 0===q)g-=120;else{var z=["2-digit","numeric","narrow","short","long"];p=W.call(z,p);q=W.call(z,q);q=Math.max(Math.min(q-p,2),-2);2===q?g-=6:1===q?g-=3:-1===q?g-=6:-2===q&&(g-=8)}}g>a&&(a=g,c=h);b++}return c}function Ta(f,e){var a=[];for(c in N)A.call(N,c)&&
void 0!==f["[["+c+"]]"]&&a.push(c);if(1===a.length){var c=a[0];a=f["[["+a[0]+"]]"];if(oa[c]&&oa[c][a]){var b;a=(b={originalPattern:oa[c][a],_:ea({},c,a),extendedPattern:"{"+c+"}"},ea(b,c,a),ea(b,"pattern12","{"+c+"}"),ea(b,"pattern","{"+c+"}"),b)}else a=void 0;if(a)return a}b=-Infinity;a=void 0;c=0;for(var d=e.length;c<d;){var h=e[c],g=0,l;for(l in N)if(A.call(N,l)){var p=f["[["+l+"]]"],q=A.call(h,l)?h[l]:void 0,z=A.call(h._,l)?h._[l]:void 0;p!==z&&(g-=2);void 0===p&&void 0!==q?g-=20:void 0!==p&&
void 0===q?g-=120:(z=["2-digit","numeric","narrow","short","long"],p=W.call(z,p),q=W.call(z,q),z=Math.max(Math.min(q-p,2),-2),1>=q&&2<=p||2<=q&&1>=p?0<z?g-=6:0>z&&(g-=8):1<z?g-=3:-1>z&&(g-=6))}h._.hour12!==f.hour12&&--g;g>b&&(b=g,a=h);c++}return a}function Ca(){var f=null!==this&&"object"===Q["typeof"](this)&&x(this);if(!f||!f["[[initializedDateTimeFormat]]"])throw new TypeError("`this` value for format() is not an initialized Intl.DateTimeFormat object.");if(void 0===f["[[boundFormat]]"]){var e=
ba.call(function(){var a=0<arguments.length&&void 0!==arguments[0]?arguments[0]:void 0;a=void 0===a?Date.now():t(a);return ja(this,a)},this);f["[[boundFormat]]"]=e}return f["[[boundFormat]]"]}function Da(f,e){if(!isFinite(e))throw new RangeError("Invalid valid date passed to format");f=f.__getInternalProperties(aa);u();var a=f["[[locale]]"],c=new B.NumberFormat([a],{useGrouping:!1}),b=new B.NumberFormat([a],{minimumIntegerDigits:2,useGrouping:!1});e=new Date(e);var d="get"+(f["[[timeZone]]"]||"");
e=new m({"[[weekday]]":e[d+"Day"](),"[[era]]":+(0<=e[d+"FullYear"]()),"[[year]]":e[d+"FullYear"](),"[[month]]":e[d+"Month"](),"[[day]]":e[d+"Date"](),"[[hour]]":e[d+"Hours"](),"[[minute]]":e[d+"Minutes"](),"[[second]]":e[d+"Seconds"](),"[[inDST]]":!1});d=f["[[pattern]]"];for(var h=new n,g=0,l=d.indexOf("{"),p=0,q=F.DateTimeFormat["[[localeData]]"][f["[[dataLocale]]"]].calendars,z=f["[[calendar]]"];-1!==l;){var E=void 0;p=d.indexOf("}",l);if(-1===p)throw Error("Unclosed pattern");l>g&&D.call(h,{type:"literal",
value:d.substring(g,l)});g=d.substring(l+1,p);if(N.hasOwnProperty(g)){l=f["[["+g+"]]"];var K=e["[["+g+"]]"];"year"===g&&0>=K?K=1-K:"month"===g?K++:"hour"===g&&!0===f["[[hour12]]"]&&(K%=12,0===K&&!0===f["[[hourNo0]]"]&&(K=12));if("numeric"===l)E=fa(c,K);else if("2-digit"===l)E=fa(b,K),2<E.length&&(E=E.slice(-2));else if(l in Ua)switch(g){case "month":E=ha(q,z,"months",l,e["[["+g+"]]"]);break;case "weekday":try{E=ha(q,z,"days",l,e["[["+g+"]]"])}catch(L){throw Error("Could not find weekday data for locale "+
a);}break;case "timeZoneName":E="";break;case "era":try{E=ha(q,z,"eras",l,e["[["+g+"]]"])}catch(L){throw Error("Could not find era data for locale "+a);}break;default:E=e["[["+g+"]]"]}D.call(h,{type:g,value:E})}else"ampm"===g?(E=ha(q,z,"dayPeriods",11<e["[[hour]]"]?"pm":"am",null),D.call(h,{type:"dayPeriod",value:E})):D.call(h,{type:"literal",value:d.substring(l,p+1)});g=p+1;l=d.indexOf("{",g)}p<d.length-1&&D.call(h,{type:"literal",value:d.substr(p+1)});return h}function ja(f,e){f=Da(f,e);e="";for(var a=
0;f.length>a;a++)e+=f[a].value;return e}function Ea(f,e){return this&&this!==B?Va(v(this),f,e):new B.PluralRules(f,e)}function Va(f,e,a){var c=x(f);if(!0===c["[[InitializedIntlObject]]"])throw new TypeError("`this` object has already been initialized as an Intl object");C(f,"__getInternalProperties",{value:function(h){if(h===aa)return c}});c["[[InitializedIntlObject]]"]=!0;e=H(e);a=void 0===a?{}:v(a);var b=J(a,"type","string",new n("cardinal","ordinal"),"cardinal");c["[[type]]"]=b;b=new m;var d=J(a,
"localeMatcher","string",new n("lookup","best fit"),"best fit");b["[[localeMatcher]]"]=d;ra(F,a,0);void 0===F["[[maximumFractionDigits]]"]&&(F["[[maximumFractionDigits]]"]=Math.max(F["[[minimumFractionDigits]]"],3));a=M(F.PluralRules["[[availableLocales]]"],e,b,F.PluralRules["[[relevantExtensionKeys]]"],F.PluralRules["[[localeData]]"]);c["[[locale]]"]=a["[[locale]]"];c["[[InitializedPluralRules]]"]=!0;return f}var k="function"===typeof Symbol&&"symbol"===typeof Symbol.iterator?function(f){return typeof f}:
function(f){return f&&"function"===typeof Symbol&&f.constructor===Symbol&&f!==Symbol.prototype?"symbol":typeof f},Wa=function(){var f="function"===typeof Symbol&&Symbol.for&&Symbol.for("react.element")||60103;return function(e,a,c,b){var d=e&&e.defaultProps,h=arguments.length-3;a||0===h||(a={});if(a&&d)for(var g in d)void 0===a[g]&&(a[g]=d[g]);else a||(a=d||{});if(1===h)a.children=b;else if(1<h){d=Array(h);for(g=0;g<h;g++)d[g]=arguments[g+3];a.children=d}return{$$typeof:f,type:e,key:void 0===c?null:
""+c,ref:null,props:a,_owner:null}}}(),Xa=function(){function f(a){this.value=a}function e(a){function c(g,l){try{var p=a[g](l),q=p.value;q instanceof f?Promise.resolve(q.value).then(function(z){c("next",z)},function(z){c("throw",z)}):b(p.done?"return":"normal",p.value)}catch(z){b("throw",z)}}function b(g,l){switch(g){case "return":d.resolve({value:l,done:!0});break;case "throw":d.reject(l);break;default:d.resolve({value:l,done:!1})}(d=d.next)?c(d.key,d.arg):h=null}var d,h;this._invoke=function(g,
l){return new Promise(function(p,q){p={key:g,arg:l,resolve:p,reject:q,next:null};h?h=h.next=p:(d=h=p,c(g,l))})};"function"!==typeof a.return&&(this.return=void 0)}"function"===typeof Symbol&&Symbol.asyncIterator&&(e.prototype[Symbol.asyncIterator]=function(){return this});e.prototype.next=function(a){return this._invoke("next",a)};e.prototype.throw=function(a){return this._invoke("throw",a)};e.prototype.return=function(a){return this._invoke("return",a)};return{wrap:function(a){return function(){return new e(a.apply(this,
arguments))}},await:function(a){return new f(a)}}}(),Ya=function(){function f(e,a){for(var c=0;c<a.length;c++){var b=a[c];b.enumerable=b.enumerable||!1;b.configurable=!0;"value"in b&&(b.writable=!0);Object.defineProperty(e,b.key,b)}}return function(e,a,c){a&&f(e.prototype,a);c&&f(e,c);return e}}(),ea=function(f,e,a){e in f?Object.defineProperty(f,e,{value:a,enumerable:!0,configurable:!0,writable:!0}):f[e]=a;return f},Za=Object.assign||function(f){for(var e=1;e<arguments.length;e++){var a=arguments[e],
c;for(c in a)Object.prototype.hasOwnProperty.call(a,c)&&(f[c]=a[c])}return f},$a="undefined"===typeof global?self:global,ab=function(){return function(f,e){if(Array.isArray(f))return f;if(Symbol.iterator in Object(f)){var a=[],c=!0,b=!1,d=void 0;try{for(var h=f[Symbol.iterator](),g;!(c=(g=h.next()).done)&&(a.push(g.value),!e||a.length!==e);c=!0);}catch(l){b=!0,d=l}finally{try{if(!c&&h["return"])h["return"]()}finally{if(b)throw d;}}return a}throw new TypeError("Invalid attempt to destructure non-iterable instance");
}}(),Q=Object.freeze({jsx:Wa,asyncIterator:function(f){if("function"===typeof Symbol){if(Symbol.asyncIterator){var e=f[Symbol.asyncIterator];if(null!=e)return e.call(f)}if(Symbol.iterator)return f[Symbol.iterator]()}throw new TypeError("Object is not async iterable");},asyncGenerator:Xa,asyncGeneratorDelegate:function(f,e){function a(d,h){b=!0;h=new Promise(function(g){g(f[d](h))});return{done:!1,value:e(h)}}var c={},b=!1;"function"===typeof Symbol&&Symbol.iterator&&(c[Symbol.iterator]=function(){return this});
c.next=function(d){return b?(b=!1,d):a("next",d)};"function"===typeof f.throw&&(c.throw=function(d){if(b)throw b=!1,d;return a("throw",d)});"function"===typeof f.return&&(c.return=function(d){return a("return",d)});return c},asyncToGenerator:function(f){return function(){var e=f.apply(this,arguments);return new Promise(function(a,c){function b(d,h){try{var g=e[d](h),l=g.value}catch(p){c(p);return}if(g.done)a(l);else return Promise.resolve(l).then(function(p){b("next",p)},function(p){b("throw",p)})}
return b("next")})}},classCallCheck:function(f,e){if(!(f instanceof e))throw new TypeError("Cannot call a class as a function");},createClass:Ya,defineEnumerableProperties:function(f,e){for(var a in e){var c=e[a];c.configurable=c.enumerable=!0;"value"in c&&(c.writable=!0);Object.defineProperty(f,a,c)}return f},defaults:function(f,e){for(var a=Object.getOwnPropertyNames(e),c=0;c<a.length;c++){var b=a[c],d=Object.getOwnPropertyDescriptor(e,b);d&&d.configurable&&void 0===f[b]&&Object.defineProperty(f,
b,d)}return f},defineProperty:ea,get:function b(e,a,c){null===e&&(e=Function.prototype);var d=Object.getOwnPropertyDescriptor(e,a);if(void 0===d){if(e=Object.getPrototypeOf(e),null!==e)return b(e,a,c)}else{if("value"in d)return d.value;a=d.get;return void 0===a?void 0:a.call(c)}},inherits:function(e,a){if("function"!==typeof a&&null!==a)throw new TypeError("Super expression must either be null or a function, not "+typeof a);e.prototype=Object.create(a&&a.prototype,{constructor:{value:e,enumerable:!1,
writable:!0,configurable:!0}});a&&(Object.setPrototypeOf?Object.setPrototypeOf(e,a):e.__proto__=a)},interopRequireDefault:function(e){return e&&e.__esModule?e:{default:e}},interopRequireWildcard:function(e){if(e&&e.__esModule)return e;var a={};if(null!=e)for(var c in e)Object.prototype.hasOwnProperty.call(e,c)&&(a[c]=e[c]);a.default=e;return a},newArrowCheck:function(e,a){if(e!==a)throw new TypeError("Cannot instantiate an arrow function");},objectDestructuringEmpty:function(e){if(null==e)throw new TypeError("Cannot destructure undefined");
},objectWithoutProperties:function(e,a){var c={},b;for(b in e)0<=a.indexOf(b)||Object.prototype.hasOwnProperty.call(e,b)&&(c[b]=e[b]);return c},possibleConstructorReturn:function(e,a){if(!e)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return!a||"object"!==typeof a&&"function"!==typeof a?e:a},selfGlobal:$a,set:function h(a,c,b,d){var g=Object.getOwnPropertyDescriptor(a,c);void 0===g?(a=Object.getPrototypeOf(a),null!==a&&h(a,c,b,d)):"value"in g&&g.writable?g.value=
b:(c=g.set,void 0!==c&&c.call(d,b));return b},slicedToArray:ab,slicedToArrayLoose:function(a,c){if(Array.isArray(a))return a;if(Symbol.iterator in Object(a)){var b=[];a=a[Symbol.iterator]();for(var d;!(d=a.next()).done&&(b.push(d.value),!c||b.length!==c););return b}throw new TypeError("Invalid attempt to destructure non-iterable instance");},taggedTemplateLiteral:function(a,c){return Object.freeze(Object.defineProperties(a,{raw:{value:Object.freeze(c)}}))},taggedTemplateLiteralLoose:function(a,c){a.raw=
c;return a},temporalRef:function(a,c,b){if(a===b)throw new ReferenceError(c+" is not defined - temporal dead zone");return a},temporalUndefined:{},toArray:function(a){return Array.isArray(a)?a:Array.from(a)},toConsumableArray:function(a){if(Array.isArray(a)){for(var c=0,b=Array(a.length);c<a.length;c++)b[c]=a[c];return b}return Array.from(a)},typeof:k,extends:Za,instanceof:function(a,c){return null!=c&&"undefined"!==typeof Symbol&&c[Symbol.hasInstance]?c[Symbol.hasInstance](a):a instanceof c}});k=
function(){var a=function(){};try{return Object.defineProperty(a,"a",{get:function(){return 1}}),Object.defineProperty(a,"prototype",{writable:!1}),1===a.a&&a.prototype instanceof Object}catch(c){return!1}}();var ta=!k&&!Object.prototype.__defineGetter__,A=Object.prototype.hasOwnProperty,C=k?Object.defineProperty:function(a,c,b){if("get"in b&&a.__defineGetter__)a.__defineGetter__(c,b.get);else if(!A.call(a,c)||"value"in b)a[c]=b.value},W=Array.prototype.indexOf||function(a,c){if(!this.length)return-1;
c=c||0;for(var b=this.length;c<b;c++)if(this[c]===a)return c;return-1},R=Object.create||function(a,c){function b(){}var d=void 0;b.prototype=a;d=new b;for(var h in c)A.call(c,h)&&C(d,h,c[h]);return d},Z=Array.prototype.slice,bb=Array.prototype.concat,D=Array.prototype.push,S=Array.prototype.join,ya=Array.prototype.shift,ba=Function.prototype.bind||function(a){var c=this,b=Z.call(arguments,1);return function(){return c.apply(a,bb.call(b,Z.call(arguments)))}},F=R(null),aa=Math.random();m.prototype=
R(null);n.prototype=R(null);var Ga=/^(?:(?:[a-z]{2,3}(?:-[a-z]{3}(?:-[a-z]{3}){0,2})?|[a-z]{4}|[a-z]{5,8})(?:-[a-z]{4})?(?:-(?:[a-z]{2}|\d{3}))?(?:-(?:[a-z0-9]{5,8}|\d[a-z0-9]{3}))*(?:-[0-9a-wy-z](?:-[a-z0-9]{2,8})+)*(?:-x(?:-[a-z0-9]{1,8})+)?|x(?:-[a-z0-9]{1,8})+|(?:(?:en-GB-oed|i-(?:ami|bnn|default|enochian|hak|klingon|lux|mingo|navajo|pwn|tao|tay|tsu)|sgn-(?:BE-FR|BE-NL|CH-DE))|(?:art-lojban|cel-gaulish|no-bok|no-nyn|zh-(?:guoyu|hakka|min|min-nan|xiang))))$/i,Ha=/^(?!x).*?-((?:[a-z0-9]{5,8}|\d[a-z0-9]{3}))-(?:\w{4,8}-(?!x-))*\1\b/i,
Ia=/^(?!x).*?-([0-9a-wy-z])-(?:\w+-(?!x-))*\1\b/i,pa=/-[0-9a-wy-z](?:-[a-z0-9]{2,8})+/ig,la=void 0,X={tags:{"art-lojban":"jbo","i-ami":"ami","i-bnn":"bnn","i-hak":"hak","i-klingon":"tlh","i-lux":"lb","i-navajo":"nv","i-pwn":"pwn","i-tao":"tao","i-tay":"tay","i-tsu":"tsu","no-bok":"nb","no-nyn":"nn","sgn-BE-FR":"sfb","sgn-BE-NL":"vgt","sgn-CH-DE":"sgg","zh-guoyu":"cmn","zh-hakka":"hak","zh-min-nan":"nan","zh-xiang":"hsn","sgn-BR":"bzs","sgn-CO":"csn","sgn-DE":"gsg","sgn-DK":"dsl","sgn-ES":"ssp","sgn-FR":"fsl",
"sgn-GB":"bfi","sgn-GR":"gss","sgn-IE":"isg","sgn-IT":"ise","sgn-JP":"jsl","sgn-MX":"mfs","sgn-NI":"ncs","sgn-NL":"dse","sgn-NO":"nsl","sgn-PT":"psr","sgn-SE":"swl","sgn-US":"ase","sgn-ZA":"sfs","zh-cmn":"cmn","zh-cmn-Hans":"cmn-Hans","zh-cmn-Hant":"cmn-Hant","zh-gan":"gan","zh-wuu":"wuu","zh-yue":"yue"},subtags:{BU:"MM",DD:"DE",FX:"FR",TP:"TL",YD:"YE",ZR:"CD",heploc:"alalc97","in":"id",iw:"he",ji:"yi",jw:"jv",mo:"ro",ayx:"nun",bjd:"drl",ccq:"rki",cjr:"mom",cka:"cmr",cmk:"xch",drh:"khk",drw:"prs",
gav:"dev",hrr:"jal",ibi:"opa",kgh:"kml",lcq:"ppr",mst:"mry",myt:"mry",sca:"hle",tie:"ras",tkk:"twm",tlw:"weo",tnf:"prs",ybd:"rki",yma:"lrr"},extLang:{aao:["aao","ar"],abh:["abh","ar"],abv:["abv","ar"],acm:["acm","ar"],acq:["acq","ar"],acw:["acw","ar"],acx:["acx","ar"],acy:["acy","ar"],adf:["adf","ar"],ads:["ads","sgn"],aeb:["aeb","ar"],aec:["aec","ar"],aed:["aed","sgn"],aen:["aen","sgn"],afb:["afb","ar"],afg:["afg","sgn"],ajp:["ajp","ar"],apc:["apc","ar"],apd:["apd","ar"],arb:["arb","ar"],arq:["arq",
"ar"],ars:["ars","ar"],ary:["ary","ar"],arz:["arz","ar"],ase:["ase","sgn"],asf:["asf","sgn"],asp:["asp","sgn"],asq:["asq","sgn"],asw:["asw","sgn"],auz:["auz","ar"],avl:["avl","ar"],ayh:["ayh","ar"],ayl:["ayl","ar"],ayn:["ayn","ar"],ayp:["ayp","ar"],bbz:["bbz","ar"],bfi:["bfi","sgn"],bfk:["bfk","sgn"],bjn:["bjn","ms"],bog:["bog","sgn"],bqn:["bqn","sgn"],bqy:["bqy","sgn"],btj:["btj","ms"],bve:["bve","ms"],bvl:["bvl","sgn"],bvu:["bvu","ms"],bzs:["bzs","sgn"],cdo:["cdo","zh"],cds:["cds","sgn"],cjy:["cjy",
"zh"],cmn:["cmn","zh"],coa:["coa","ms"],cpx:["cpx","zh"],csc:["csc","sgn"],csd:["csd","sgn"],cse:["cse","sgn"],csf:["csf","sgn"],csg:["csg","sgn"],csl:["csl","sgn"],csn:["csn","sgn"],csq:["csq","sgn"],csr:["csr","sgn"],czh:["czh","zh"],czo:["czo","zh"],doq:["doq","sgn"],dse:["dse","sgn"],dsl:["dsl","sgn"],dup:["dup","ms"],ecs:["ecs","sgn"],esl:["esl","sgn"],esn:["esn","sgn"],eso:["eso","sgn"],eth:["eth","sgn"],fcs:["fcs","sgn"],fse:["fse","sgn"],fsl:["fsl","sgn"],fss:["fss","sgn"],gan:["gan","zh"],
gds:["gds","sgn"],gom:["gom","kok"],gse:["gse","sgn"],gsg:["gsg","sgn"],gsm:["gsm","sgn"],gss:["gss","sgn"],gus:["gus","sgn"],hab:["hab","sgn"],haf:["haf","sgn"],hak:["hak","zh"],hds:["hds","sgn"],hji:["hji","ms"],hks:["hks","sgn"],hos:["hos","sgn"],hps:["hps","sgn"],hsh:["hsh","sgn"],hsl:["hsl","sgn"],hsn:["hsn","zh"],icl:["icl","sgn"],ils:["ils","sgn"],inl:["inl","sgn"],ins:["ins","sgn"],ise:["ise","sgn"],isg:["isg","sgn"],isr:["isr","sgn"],jak:["jak","ms"],jax:["jax","ms"],jcs:["jcs","sgn"],jhs:["jhs",
"sgn"],jls:["jls","sgn"],jos:["jos","sgn"],jsl:["jsl","sgn"],jus:["jus","sgn"],kgi:["kgi","sgn"],knn:["knn","kok"],kvb:["kvb","ms"],kvk:["kvk","sgn"],kvr:["kvr","ms"],kxd:["kxd","ms"],lbs:["lbs","sgn"],lce:["lce","ms"],lcf:["lcf","ms"],liw:["liw","ms"],lls:["lls","sgn"],lsg:["lsg","sgn"],lsl:["lsl","sgn"],lso:["lso","sgn"],lsp:["lsp","sgn"],lst:["lst","sgn"],lsy:["lsy","sgn"],ltg:["ltg","lv"],lvs:["lvs","lv"],lzh:["lzh","zh"],max:["max","ms"],mdl:["mdl","sgn"],meo:["meo","ms"],mfa:["mfa","ms"],mfb:["mfb",
"ms"],mfs:["mfs","sgn"],min:["min","ms"],mnp:["mnp","zh"],mqg:["mqg","ms"],mre:["mre","sgn"],msd:["msd","sgn"],msi:["msi","ms"],msr:["msr","sgn"],mui:["mui","ms"],mzc:["mzc","sgn"],mzg:["mzg","sgn"],mzy:["mzy","sgn"],nan:["nan","zh"],nbs:["nbs","sgn"],ncs:["ncs","sgn"],nsi:["nsi","sgn"],nsl:["nsl","sgn"],nsp:["nsp","sgn"],nsr:["nsr","sgn"],nzs:["nzs","sgn"],okl:["okl","sgn"],orn:["orn","ms"],ors:["ors","ms"],pel:["pel","ms"],pga:["pga","ar"],pks:["pks","sgn"],prl:["prl","sgn"],prz:["prz","sgn"],psc:["psc",
"sgn"],psd:["psd","sgn"],pse:["pse","ms"],psg:["psg","sgn"],psl:["psl","sgn"],pso:["pso","sgn"],psp:["psp","sgn"],psr:["psr","sgn"],pys:["pys","sgn"],rms:["rms","sgn"],rsi:["rsi","sgn"],rsl:["rsl","sgn"],sdl:["sdl","sgn"],sfb:["sfb","sgn"],sfs:["sfs","sgn"],sgg:["sgg","sgn"],sgx:["sgx","sgn"],shu:["shu","ar"],slf:["slf","sgn"],sls:["sls","sgn"],sqk:["sqk","sgn"],sqs:["sqs","sgn"],ssh:["ssh","ar"],ssp:["ssp","sgn"],ssr:["ssr","sgn"],svk:["svk","sgn"],swc:["swc","sw"],swh:["swh","sw"],swl:["swl","sgn"],
syy:["syy","sgn"],tmw:["tmw","ms"],tse:["tse","sgn"],tsm:["tsm","sgn"],tsq:["tsq","sgn"],tss:["tss","sgn"],tsy:["tsy","sgn"],tza:["tza","sgn"],ugn:["ugn","sgn"],ugy:["ugy","sgn"],ukl:["ukl","sgn"],uks:["uks","sgn"],urk:["urk","ms"],uzn:["uzn","uz"],uzs:["uzs","uz"],vgt:["vgt","sgn"],vkk:["vkk","ms"],vkt:["vkt","ms"],vsi:["vsi","sgn"],vsl:["vsl","sgn"],vsv:["vsv","sgn"],wuu:["wuu","zh"],xki:["xki","sgn"],xml:["xml","sgn"],xmm:["xmm","ms"],xms:["xms","sgn"],yds:["yds","sgn"],ysl:["ysl","sgn"],yue:["yue",
"zh"],zib:["zib","sgn"],zlm:["zlm","ms"],zmi:["zmi","ms"],zsl:["zsl","sgn"],zsm:["zsm","ms"]}},Ja=/^[A-Z]{3}$/,ka=/-u(?:-[0-9a-z]{2,8})+/gi,B={};Object.defineProperty(B,"getCanonicalLocales",{enumerable:!1,configurable:!0,writable:!0,value:function(a){a=H(a);for(var c=[],b=a.length,d=0;d<b;)c[d]=a[d],d++;return c}});var sa={BHD:3,BYR:0,XOF:0,BIF:0,XAF:0,CLF:4,CLP:0,KMF:0,DJF:0,XPF:0,GNF:0,ISK:0,IQD:3,JPY:0,JOD:3,KRW:0,KWD:3,LYD:3,OMR:3,PYG:0,RWF:0,TND:3,UGX:0,UYI:0,VUV:0,VND:0};C(B,"NumberFormat",
{configurable:!0,writable:!0,value:qa});C(B.NumberFormat,"prototype",{writable:!1});F.NumberFormat={"[[availableLocales]]":[],"[[relevantExtensionKeys]]":["nu"],"[[localeData]]":{}};C(B.NumberFormat,"supportedLocalesOf",{configurable:!0,writable:!0,value:ba.call(function(a,c){if(!A.call(this,"[[availableLocales]]"))throw new TypeError("supportedLocalesOf() is not a constructor");var b=u(),d=this["[[availableLocales]]"];a=H(a);b();return O(d,a,c)},F.NumberFormat)});C(B.NumberFormat.prototype,"format",
{configurable:!0,get:ua});Object.defineProperty(B.NumberFormat.prototype,"formatToParts",{configurable:!0,enumerable:!1,writable:!0,value:function(){var a=0<arguments.length&&void 0!==arguments[0]?arguments[0]:void 0,c=null!==this&&"object"===Q["typeof"](this)&&x(this);if(!c||!c["[[initializedNumberFormat]]"])throw new TypeError("`this` value for formatToParts() is not an initialized Intl.NumberFormat object.");a=va(this,Number(a));c=[];for(var b=0,d=0;a.length>d;d++){var h=a[d],g={};g.type=h["[[type]]"];
g.value=h["[[value]]"];c[b]=g;b+=1}return c}});var wa={arab:"\u0660\u0661\u0662\u0663\u0664\u0665\u0666\u0667\u0668\u0669".split(""),arabext:"\u06f0\u06f1\u06f2\u06f3\u06f4\u06f5\u06f6\u06f7\u06f8\u06f9".split(""),bali:"\u1b50\u1b51\u1b52\u1b53\u1b54\u1b55\u1b56\u1b57\u1b58\u1b59".split(""),beng:"\u09e6\u09e7\u09e8\u09e9\u09ea\u09eb\u09ec\u09ed\u09ee\u09ef".split(""),deva:"\u0966\u0967\u0968\u0969\u096a\u096b\u096c\u096d\u096e\u096f".split(""),fullwide:"\uff10\uff11\uff12\uff13\uff14\uff15\uff16\uff17\uff18\uff19".split(""),
gujr:"\u0ae6\u0ae7\u0ae8\u0ae9\u0aea\u0aeb\u0aec\u0aed\u0aee\u0aef".split(""),guru:"\u0a66\u0a67\u0a68\u0a69\u0a6a\u0a6b\u0a6c\u0a6d\u0a6e\u0a6f".split(""),hanidec:"\u3007\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d".split(""),khmr:"\u17e0\u17e1\u17e2\u17e3\u17e4\u17e5\u17e6\u17e7\u17e8\u17e9".split(""),knda:"\u0ce6\u0ce7\u0ce8\u0ce9\u0cea\u0ceb\u0cec\u0ced\u0cee\u0cef".split(""),laoo:"\u0ed0\u0ed1\u0ed2\u0ed3\u0ed4\u0ed5\u0ed6\u0ed7\u0ed8\u0ed9".split(""),latn:"0123456789".split(""),limb:"\u1946\u1947\u1948\u1949\u194a\u194b\u194c\u194d\u194e\u194f".split(""),
mlym:"\u0d66\u0d67\u0d68\u0d69\u0d6a\u0d6b\u0d6c\u0d6d\u0d6e\u0d6f".split(""),mong:"\u1810\u1811\u1812\u1813\u1814\u1815\u1816\u1817\u1818\u1819".split(""),mymr:"\u1040\u1041\u1042\u1043\u1044\u1045\u1046\u1047\u1048\u1049".split(""),orya:"\u0b66\u0b67\u0b68\u0b69\u0b6a\u0b6b\u0b6c\u0b6d\u0b6e\u0b6f".split(""),tamldec:"\u0be6\u0be7\u0be8\u0be9\u0bea\u0beb\u0bec\u0bed\u0bee\u0bef".split(""),telu:"\u0c66\u0c67\u0c68\u0c69\u0c6a\u0c6b\u0c6c\u0c6d\u0c6e\u0c6f".split(""),thai:"\u0e50\u0e51\u0e52\u0e53\u0e54\u0e55\u0e56\u0e57\u0e58\u0e59".split(""),
tibt:"\u0f20\u0f21\u0f22\u0f23\u0f24\u0f25\u0f26\u0f27\u0f28\u0f29".split("")};C(B.NumberFormat.prototype,"resolvedOptions",{configurable:!0,writable:!0,value:function(){var a,c=new m,b="locale numberingSystem style currency currencyDisplay minimumIntegerDigits minimumFractionDigits maximumFractionDigits minimumSignificantDigits maximumSignificantDigits useGrouping".split(" "),d=null!==this&&"object"===Q["typeof"](this)&&x(this);if(!d||!d["[[initializedNumberFormat]]"])throw new TypeError("`this` value for resolvedOptions() is not an initialized Intl.NumberFormat object.");
for(var h=0,g=b.length;h<g;h++)A.call(d,a="[["+b[h]+"]]")&&(c[b[h]]={value:d[a],writable:!0,configurable:!0,enumerable:!0});return R({},c)}});var Ba=/(?:[Eec]{1,6}|G{1,5}|[Qq]{1,5}|(?:[yYur]+|U{1,5})|[ML]{1,5}|d{1,2}|D{1,3}|F{1}|[abB]{1,5}|[hkHK]{1,2}|w{1,2}|W{1}|m{1,2}|s{1,2}|[zZOvVxX]{1,4})(?=([^']*'[^']*')*[^']*$)/g,Oa=/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g,Pa=/[rqQASjJgwWIQq]/,U="era year month day weekday quarter".split(" "),T=["hour","minute","second","hour12","timeZoneName"],oa={second:{numeric:"s",
"2-digit":"ss"},minute:{numeric:"m","2-digit":"mm"},year:{numeric:"y","2-digit":"yy"},day:{numeric:"d","2-digit":"dd"},month:{numeric:"L","2-digit":"LL",narrow:"LLLLL",short:"LLL",long:"LLLL"},weekday:{narrow:"ccccc",short:"ccc",long:"cccc"}},Ua=R(null,{narrow:{},short:{},long:{}});C(B,"DateTimeFormat",{configurable:!0,writable:!0,value:da});C(da,"prototype",{writable:!1});var N={weekday:["narrow","short","long"],era:["narrow","short","long"],year:["2-digit","numeric"],month:["2-digit","numeric",
"narrow","short","long"],day:["2-digit","numeric"],hour:["2-digit","numeric"],minute:["2-digit","numeric"],second:["2-digit","numeric"],timeZoneName:["short","long"]};F.DateTimeFormat={"[[availableLocales]]":[],"[[relevantExtensionKeys]]":["ca","nu"],"[[localeData]]":{}};C(B.DateTimeFormat,"supportedLocalesOf",{configurable:!0,writable:!0,value:ba.call(function(a,c){if(!A.call(this,"[[availableLocales]]"))throw new TypeError("supportedLocalesOf() is not a constructor");var b=u(),d=this["[[availableLocales]]"];
a=H(a);b();return O(d,a,c)},F.NumberFormat)});C(B.DateTimeFormat.prototype,"format",{configurable:!0,get:Ca});Object.defineProperty(B.DateTimeFormat.prototype,"formatToParts",{enumerable:!1,writable:!0,configurable:!0,value:function(){var a=0<arguments.length&&void 0!==arguments[0]?arguments[0]:void 0,c=null!==this&&"object"===Q["typeof"](this)&&x(this);if(!c||!c["[[initializedDateTimeFormat]]"])throw new TypeError("`this` value for formatToParts() is not an initialized Intl.DateTimeFormat object.");
a=void 0===a?Date.now():t(a);a=Da(this,a);c=[];for(var b=0;a.length>b;b++){var d=a[b];c.push({type:d.type,value:d.value})}return c}});C(B.DateTimeFormat.prototype,"resolvedOptions",{writable:!0,configurable:!0,value:function(){var a,c=new m,b="locale calendar numberingSystem timeZone hour12 weekday era year month day hour minute second timeZoneName".split(" "),d=null!==this&&"object"===Q["typeof"](this)&&x(this);if(!d||!d["[[initializedDateTimeFormat]]"])throw new TypeError("`this` value for resolvedOptions() is not an initialized Intl.DateTimeFormat object.");
for(var h=0,g=b.length;h<g;h++)A.call(d,a="[["+b[h]+"]]")&&(c[b[h]]={value:d[a],writable:!0,configurable:!0,enumerable:!0});return R({},c)}});var V=B.__localeSensitiveProtos={Number:{},Date:{}};V.Number.toLocaleString=function(a,c){if("[object Number]"!==Object.prototype.toString.call(this))throw new TypeError("`this` value must be a number for Number.prototype.toLocaleString()");return fa(new qa(a,c),this)};V.Date.toLocaleString=function(a,c){if("[object Date]"!==Object.prototype.toString.call(this))throw new TypeError("`this` value must be a Date instance for Date.prototype.toLocaleString()");
var b=+this;if(isNaN(b))return"Invalid Date";c=ia(c,"any","all");a=new da(a,c);return ja(a,b)};V.Date.toLocaleDateString=function(a,c){if("[object Date]"!==Object.prototype.toString.call(this))throw new TypeError("`this` value must be a Date instance for Date.prototype.toLocaleDateString()");var b=+this;if(isNaN(b))return"Invalid Date";c=ia(c,"date","date");a=new da(a,c);return ja(a,b)};V.Date.toLocaleTimeString=function(a,c){if("[object Date]"!==Object.prototype.toString.call(this))throw new TypeError("`this` value must be a Date instance for Date.prototype.toLocaleTimeString()");
var b=+this;if(isNaN(b))return"Invalid Date";c=ia(c,"time","time");a=new da(a,c);return ja(a,b)};k=[function(a,c){return"other"},function(a,c){return c?"other":1==a?"one":"other"},function(a,c){return c?"other":0==a||1==a?"one":"other"},function(a,c){var b=!String(a).split(".")[1];return c?"other":1==a&&b?"one":"other"}];var Fa={af:k[1],ak:k[2],am:function(a,c){return c?"other":0<=a&&1>=a?"one":"other"},ar:function(a,c){var b=String(a).split(".");b=Number(b[0])==a&&b[0].slice(-2);return c?"other":
0==a?"zero":1==a?"one":2==a?"two":3<=b&&10>=b?"few":11<=b&&99>=b?"many":"other"},ars:function(a,c){var b=String(a).split(".");b=Number(b[0])==a&&b[0].slice(-2);return c?"other":0==a?"zero":1==a?"one":2==a?"two":3<=b&&10>=b?"few":11<=b&&99>=b?"many":"other"},as:function(a,c){return c?1==a||5==a||7==a||8==a||9==a||10==a?"one":2==a||3==a?"two":4==a?"few":6==a?"many":"other":0<=a&&1>=a?"one":"other"},asa:k[1],ast:k[3],az:function(a,c){var b=String(a).split(".")[0],d=b.slice(-1),h=b.slice(-2),g=b.slice(-3);
return c?1==d||2==d||5==d||7==d||8==d||20==h||50==h||70==h||80==h?"one":3==d||4==d||100==g||200==g||300==g||400==g||500==g||600==g||700==g||800==g||900==g?"few":0==b||6==d||40==h||60==h||90==h?"many":"other":1==a?"one":"other"},be:function(a,c){var b=String(a).split("."),d=(a=Number(b[0])==a)&&b[0].slice(-1);b=a&&b[0].slice(-2);return c?2!=d&&3!=d||12==b||13==b?"other":"few":1==d&&11!=b?"one":2<=d&&4>=d&&(12>b||14<b)?"few":a&&0==d||5<=d&&9>=d||11<=b&&14>=b?"many":"other"},bem:k[1],bez:k[1],bg:k[1],
bh:k[2],bm:k[0],bn:function(a,c){return c?1==a||5==a||7==a||8==a||9==a||10==a?"one":2==a||3==a?"two":4==a?"few":6==a?"many":"other":0<=a&&1>=a?"one":"other"},bo:k[0],br:function(a,c){var b=String(a).split("."),d=Number(b[0])==a,h=d&&b[0].slice(-1),g=d&&b[0].slice(-2);b=d&&b[0].slice(-6);return c?"other":1==h&&11!=g&&71!=g&&91!=g?"one":2==h&&12!=g&&72!=g&&92!=g?"two":(3==h||4==h||9==h)&&(10>g||19<g)&&(70>g||79<g)&&(90>g||99<g)?"few":0!=a&&d&&0==b?"many":"other"},brx:k[1],bs:function(a,c){var b=String(a).split("."),
d=b[0];a=b[1]||"";b=!b[1];var h=d.slice(-1);d=d.slice(-2);var g=a.slice(-1);a=a.slice(-2);return c?"other":b&&1==h&&11!=d||1==g&&11!=a?"one":b&&2<=h&&4>=h&&(12>d||14<d)||2<=g&&4>=g&&(12>a||14<a)?"few":"other"},ca:function(a,c){var b=!String(a).split(".")[1];return c?1==a||3==a?"one":2==a?"two":4==a?"few":"other":1==a&&b?"one":"other"},ce:k[1],cgg:k[1],chr:k[1],ckb:k[1],cs:function(a,c){var b=String(a).split("."),d=b[0];b=!b[1];return c?"other":1==a&&b?"one":2<=d&&4>=d&&b?"few":b?"other":"many"},cy:function(a,
c){return c?0==a||7==a||8==a||9==a?"zero":1==a?"one":2==a?"two":3==a||4==a?"few":5==a||6==a?"many":"other":0==a?"zero":1==a?"one":2==a?"two":3==a?"few":6==a?"many":"other"},da:function(a,c){var b=String(a).split("."),d=b[0];b=Number(b[0])==a;return c?"other":1!=a&&(b||0!=d&&1!=d)?"other":"one"},de:k[3],dsb:function(a,c){var b=String(a).split("."),d=b[1]||"";a=!b[1];b=b[0].slice(-2);d=d.slice(-2);return c?"other":a&&1==b||1==d?"one":a&&2==b||2==d?"two":a&&(3==b||4==b)||3==d||4==d?"few":"other"},dv:k[1],
dz:k[0],ee:k[1],el:k[1],en:function(a,c){var b=String(a).split("."),d=!b[1],h=Number(b[0])==a,g=h&&b[0].slice(-1);b=h&&b[0].slice(-2);return c?1==g&&11!=b?"one":2==g&&12!=b?"two":3==g&&13!=b?"few":"other":1==a&&d?"one":"other"},eo:k[1],es:k[1],et:k[3],eu:k[1],fa:function(a,c){return c?"other":0<=a&&1>=a?"one":"other"},ff:function(a,c){return c?"other":0<=a&&2>a?"one":"other"},fi:k[3],fil:function(a,c){var b=String(a).split("."),d=b[0],h=b[1]||"";b=!b[1];var g=d.slice(-1);h=h.slice(-1);return c?1==
a?"one":"other":b&&(1==d||2==d||3==d)||b&&4!=g&&6!=g&&9!=g||!b&&4!=h&&6!=h&&9!=h?"one":"other"},fo:k[1],fr:function(a,c){return c?1==a?"one":"other":0<=a&&2>a?"one":"other"},fur:k[1],fy:k[3],ga:function(a,c){var b=String(a).split(".");b=Number(b[0])==a;return c?1==a?"one":"other":1==a?"one":2==a?"two":b&&3<=a&&6>=a?"few":b&&7<=a&&10>=a?"many":"other"},gd:function(a,c){var b=String(a).split(".");b=Number(b[0])==a;return c?"other":1==a||11==a?"one":2==a||12==a?"two":b&&3<=a&&10>=a||b&&13<=a&&19>=a?
"few":"other"},gl:k[3],gsw:k[1],gu:function(a,c){return c?1==a?"one":2==a||3==a?"two":4==a?"few":6==a?"many":"other":0<=a&&1>=a?"one":"other"},guw:k[2],gv:function(a,c){var b=String(a).split(".");a=b[0];b=!b[1];var d=a.slice(-1);a=a.slice(-2);return c?"other":b&&1==d?"one":b&&2==d?"two":!b||0!=a&&20!=a&&40!=a&&60!=a&&80!=a?b?"other":"many":"few"},ha:k[1],haw:k[1],he:function(a,c){var b=String(a).split("."),d=b[0],h=!b[1],g=Number(b[0])==a;b=g&&b[0].slice(-1);return c?"other":1==a&&h?"one":2==d&&h?
"two":h&&(0>a||10<a)&&g&&0==b?"many":"other"},hi:function(a,c){return c?1==a?"one":2==a||3==a?"two":4==a?"few":6==a?"many":"other":0<=a&&1>=a?"one":"other"},hr:function(a,c){var b=String(a).split("."),d=b[0];a=b[1]||"";b=!b[1];var h=d.slice(-1);d=d.slice(-2);var g=a.slice(-1);a=a.slice(-2);return c?"other":b&&1==h&&11!=d||1==g&&11!=a?"one":b&&2<=h&&4>=h&&(12>d||14<d)||2<=g&&4>=g&&(12>a||14<a)?"few":"other"},hsb:function(a,c){var b=String(a).split("."),d=b[1]||"";a=!b[1];b=b[0].slice(-2);d=d.slice(-2);
return c?"other":a&&1==b||1==d?"one":a&&2==b||2==d?"two":a&&(3==b||4==b)||3==d||4==d?"few":"other"},hu:function(a,c){return c?1==a||5==a?"one":"other":1==a?"one":"other"},hy:function(a,c){return c?1==a?"one":"other":0<=a&&2>a?"one":"other"},id:k[0],ig:k[0],ii:k[0],"in":k[0],is:function(a,c){var b=String(a).split("."),d=b[0];a=Number(b[0])==a;b=d.slice(-1);d=d.slice(-2);return c?"other":a&&1==b&&11!=d||!a?"one":"other"},it:function(a,c){var b=!String(a).split(".")[1];return c?11==a||8==a||80==a||800==
a?"many":"other":1==a&&b?"one":"other"},iu:function(a,c){return c?"other":1==a?"one":2==a?"two":"other"},iw:function(a,c){var b=String(a).split("."),d=b[0],h=!b[1],g=Number(b[0])==a;b=g&&b[0].slice(-1);return c?"other":1==a&&h?"one":2==d&&h?"two":h&&(0>a||10<a)&&g&&0==b?"many":"other"},ja:k[0],jbo:k[0],jgo:k[1],ji:k[3],jmc:k[1],jv:k[0],jw:k[0],ka:function(a,c){var b=String(a).split(".")[0],d=b.slice(-2);return c?1==b?"one":0==b||2<=d&&20>=d||40==d||60==d||80==d?"many":"other":1==a?"one":"other"},
kab:function(a,c){return c?"other":0<=a&&2>a?"one":"other"},kaj:k[1],kcg:k[1],kde:k[0],kea:k[0],kk:function(a,c){var b=String(a).split("."),d=Number(b[0])==a;b=d&&b[0].slice(-1);return c?6==b||9==b||d&&0==b&&0!=a?"many":"other":1==a?"one":"other"},kkj:k[1],kl:k[1],km:k[0],kn:function(a,c){return c?"other":0<=a&&1>=a?"one":"other"},ko:k[0],ks:k[1],ksb:k[1],ksh:function(a,c){return c?"other":0==a?"zero":1==a?"one":"other"},ku:k[1],kw:function(a,c){return c?"other":1==a?"one":2==a?"two":"other"},ky:k[1],
lag:function(a,c){var b=String(a).split(".")[0];return c?"other":0==a?"zero":0!=b&&1!=b||0==a?"other":"one"},lb:k[1],lg:k[1],lkt:k[0],ln:k[2],lo:function(a,c){return c?1==a?"one":"other":"other"},lt:function(a,c){var b=String(a).split("."),d=b[1]||"",h=Number(b[0])==a;a=h&&b[0].slice(-1);b=h&&b[0].slice(-2);return c?"other":1==a&&(11>b||19<b)?"one":2<=a&&9>=a&&(11>b||19<b)?"few":0!=d?"many":"other"},lv:function(a,c){var b=String(a).split("."),d=b[1]||"",h=d.length,g=(a=Number(b[0])==a)&&b[0].slice(-1);
b=a&&b[0].slice(-2);var l=d.slice(-2);d=d.slice(-1);return c?"other":a&&0==g||11<=b&&19>=b||2==h&&11<=l&&19>=l?"zero":1==g&&11!=b||2==h&&1==d&&11!=l||2!=h&&1==d?"one":"other"},mas:k[1],mg:k[2],mgo:k[1],mk:function(a,c){var b=String(a).split("."),d=b[0];a=b[1]||"";b=!b[1];var h=d.slice(-1);d=d.slice(-2);a=a.slice(-1);return c?1==h&&11!=d?"one":2==h&&12!=d?"two":7!=h&&8!=h||17==d||18==d?"other":"many":b&&1==h||1==a?"one":"other"},ml:k[1],mn:k[1],mo:function(a,c){var b=String(a).split("."),d=!b[1];b=
Number(b[0])==a&&b[0].slice(-2);return c?1==a?"one":"other":1==a&&d?"one":!d||0==a||1!=a&&1<=b&&19>=b?"few":"other"},mr:function(a,c){return c?1==a?"one":2==a||3==a?"two":4==a?"few":"other":0<=a&&1>=a?"one":"other"},ms:function(a,c){return c?1==a?"one":"other":"other"},mt:function(a,c){var b=String(a).split(".");b=Number(b[0])==a&&b[0].slice(-2);return c?"other":1==a?"one":0==a||2<=b&&10>=b?"few":11<=b&&19>=b?"many":"other"},my:k[0],nah:k[1],naq:function(a,c){return c?"other":1==a?"one":2==a?"two":
"other"},nb:k[1],nd:k[1],ne:function(a,c){var b=String(a).split(".");b=Number(b[0])==a;return c?b&&1<=a&&4>=a?"one":"other":1==a?"one":"other"},nl:k[3],nn:k[1],nnh:k[1],no:k[1],nqo:k[0],nr:k[1],nso:k[2],ny:k[1],nyn:k[1],om:k[1],or:k[1],os:k[1],pa:k[2],pap:k[1],pl:function(a,c){var b=String(a).split("."),d=b[0];b=!b[1];var h=d.slice(-1),g=d.slice(-2);return c?"other":1==a&&b?"one":b&&2<=h&&4>=h&&(12>g||14<g)?"few":b&&1!=d&&(0==h||1==h)||b&&5<=h&&9>=h||b&&12<=g&&14>=g?"many":"other"},prg:function(a,
c){var b=String(a).split("."),d=b[1]||"",h=d.length,g=(a=Number(b[0])==a)&&b[0].slice(-1);b=a&&b[0].slice(-2);var l=d.slice(-2);d=d.slice(-1);return c?"other":a&&0==g||11<=b&&19>=b||2==h&&11<=l&&19>=l?"zero":1==g&&11!=b||2==h&&1==d&&11!=l||2!=h&&1==d?"one":"other"},ps:k[1],pt:function(a,c){var b=String(a).split(".");return c?"other":Number(b[0])==a&&0<=a&&2>=a&&2!=a?"one":"other"},"pt-PT":k[3],rm:k[1],ro:function(a,c){var b=String(a).split("."),d=!b[1];b=Number(b[0])==a&&b[0].slice(-2);return c?1==
a?"one":"other":1==a&&d?"one":!d||0==a||1!=a&&1<=b&&19>=b?"few":"other"},rof:k[1],root:k[0],ru:function(a,c){var b=String(a).split(".");a=b[0];b=!b[1];var d=a.slice(-1);a=a.slice(-2);return c?"other":b&&1==d&&11!=a?"one":b&&2<=d&&4>=d&&(12>a||14<a)?"few":b&&0==d||b&&5<=d&&9>=d||b&&11<=a&&14>=a?"many":"other"},rwk:k[1],sah:k[0],saq:k[1],sdh:k[1],se:function(a,c){return c?"other":1==a?"one":2==a?"two":"other"},seh:k[1],ses:k[0],sg:k[0],sh:function(a,c){var b=String(a).split("."),d=b[0];a=b[1]||"";b=
!b[1];var h=d.slice(-1);d=d.slice(-2);var g=a.slice(-1);a=a.slice(-2);return c?"other":b&&1==h&&11!=d||1==g&&11!=a?"one":b&&2<=h&&4>=h&&(12>d||14<d)||2<=g&&4>=g&&(12>a||14<a)?"few":"other"},shi:function(a,c){var b=String(a).split(".");b=Number(b[0])==a;return c?"other":0<=a&&1>=a?"one":b&&2<=a&&10>=a?"few":"other"},si:function(a,c){var b=String(a).split("."),d=b[0];b=b[1]||"";return c?"other":0==a||1==a||0==d&&1==b?"one":"other"},sk:function(a,c){var b=String(a).split("."),d=b[0];b=!b[1];return c?
"other":1==a&&b?"one":2<=d&&4>=d&&b?"few":b?"other":"many"},sl:function(a,c){var b=String(a).split(".");a=!b[1];b=b[0].slice(-2);return c?"other":a&&1==b?"one":a&&2==b?"two":a&&(3==b||4==b)||!a?"few":"other"},sma:function(a,c){return c?"other":1==a?"one":2==a?"two":"other"},smi:function(a,c){return c?"other":1==a?"one":2==a?"two":"other"},smj:function(a,c){return c?"other":1==a?"one":2==a?"two":"other"},smn:function(a,c){return c?"other":1==a?"one":2==a?"two":"other"},sms:function(a,c){return c?"other":
1==a?"one":2==a?"two":"other"},sn:k[1],so:k[1],sq:function(a,c){var b=String(a).split("."),d=Number(b[0])==a,h=d&&b[0].slice(-1);b=d&&b[0].slice(-2);return c?1==a?"one":4==h&&14!=b?"many":"other":1==a?"one":"other"},sr:function(a,c){var b=String(a).split("."),d=b[0];a=b[1]||"";b=!b[1];var h=d.slice(-1);d=d.slice(-2);var g=a.slice(-1);a=a.slice(-2);return c?"other":b&&1==h&&11!=d||1==g&&11!=a?"one":b&&2<=h&&4>=h&&(12>d||14<d)||2<=g&&4>=g&&(12>a||14<a)?"few":"other"},ss:k[1],ssy:k[1],st:k[1],sv:function(a,
c){var b=String(a).split("."),d=!b[1],h=Number(b[0])==a,g=h&&b[0].slice(-1);b=h&&b[0].slice(-2);return c?1!=g&&2!=g||11==b||12==b?"other":"one":1==a&&d?"one":"other"},sw:k[3],syr:k[1],ta:k[1],te:k[1],teo:k[1],th:k[0],ti:k[2],tig:k[1],tk:k[1],tl:function(a,c){var b=String(a).split("."),d=b[0],h=b[1]||"";b=!b[1];var g=d.slice(-1);h=h.slice(-1);return c?1==a?"one":"other":b&&(1==d||2==d||3==d)||b&&4!=g&&6!=g&&9!=g||!b&&4!=h&&6!=h&&9!=h?"one":"other"},tn:k[1],to:k[0],tr:k[1],ts:k[1],tzm:function(a,c){var b=
String(a).split(".");b=Number(b[0])==a;return c?"other":0==a||1==a||b&&11<=a&&99>=a?"one":"other"},ug:k[1],uk:function(a,c){var b=String(a).split("."),d=b[0],h=!b[1],g=Number(b[0])==a;a=g&&b[0].slice(-1);b=g&&b[0].slice(-2);g=d.slice(-1);d=d.slice(-2);return c?3==a&&13!=b?"few":"other":h&&1==g&&11!=d?"one":h&&2<=g&&4>=g&&(12>d||14<d)?"few":h&&0==g||h&&5<=g&&9>=g||h&&11<=d&&14>=d?"many":"other"},ur:k[3],uz:k[1],ve:k[1],vi:function(a,c){return c?1==a?"one":"other":"other"},vo:k[1],vun:k[1],wa:k[2],
wae:k[1],wo:k[0],xh:k[1],xog:k[1],yi:k[3],yo:k[0],yue:k[0],zh:k[0],zu:function(a,c){return c?"other":0<=a&&1>=a?"one":"other"}};C(B,"PluralRules",{configurable:!0,writable:!0,value:Ea});C(Ea,"prototype",{writable:!1});F.PluralRules={"[[availableLocales]]":Object.keys(Fa),"[[relevantExtensionKeys]]":[],"[[localeData]]":{}};C(B.PluralRules,"supportedLocalesOf",{configurable:!0,writable:!0,value:ba.call(function(a,c){if(!A.call(this,"[[availableLocales]]"))throw new TypeError("supportedLocalesOf() is not a constructor");
var b=u(),d=this["[[availableLocales]]"];a=H(a);b();return O(d,a,c)},F.PluralRules)});C(B.PluralRules.prototype,"select",{configurable:!0,value:function(a){a=Number(a);if(Number.isFinite(a)){var c=x(this);b:{var b=c["[[type]]"];for(c=c["[[locale]]"];c;c=c.replace(/[-_]?[^-_]*$/,"")){var d=Fa[c];if(d){a=d(a,"ordinal"===b);break b}}a="other"}}else a="other";return a}});C(B.PluralRules.prototype,"resolvedOptions",{configurable:!0,writable:!0,value:function(){var a,c=new m,b="locale type minimumIntegerDigits minimumFractionDigits maximumFractionDigits minimumSignificantDigits maximumSignificantDigits".split(" "),
d=null!==this&&"object"===Q["typeof"](this)&&x(this);if(!d||!d["[[InitializedPluralRules]]"])throw new TypeError("`this` value for resolvedOptions() is not an initialized Intl.PluralRules object.");for(var h=0,g=b.length;h<g;h++)A.call(d,a="[["+b[h]+"]]")&&(c[b[h]]={value:d[a],writable:!0,configurable:!0,enumerable:!0});return R({},c)}});C(B,"__applyLocaleSensitivePrototypes",{writable:!0,configurable:!0,value:function(){C(Number.prototype,"toLocaleString",{writable:!0,configurable:!0,value:V.Number.toLocaleString});
C(Date.prototype,"toLocaleString",{writable:!0,configurable:!0,value:V.Date.toLocaleString});for(var a in V.Date)A.call(V.Date,a)&&C(Date.prototype,a,{writable:!0,configurable:!0,value:V.Date[a]})}});C(B,"__addLocaleData",{value:function(a){if(!w(a.locale))throw Error('Invalid language tag "'+a.locale+'" when calling __addLocaleData("'+a.locale+'", ...) to register new locale data.');var c=a.locale;if(!a.number)throw Error("Object passed doesn't contain locale data for Intl.NumberFormat");var b=[c];
var d=c.split("-");for(2<d.length&&4===d[1].length&&D.call(b,d[0]+"-"+d[2]);d=ya.call(b);)D.call(F.NumberFormat["[[availableLocales]]"],d),F.NumberFormat["[[localeData]]"][d]=a.number,a.date&&(a.date.nu=a.number.nu,D.call(F.DateTimeFormat["[[availableLocales]]"],d),F.DateTimeFormat["[[localeData]]"][d]=a.date);void 0===la&&(la=c)}});C(B,"__disableRegExpRestore",{value:function(){F.disableRegExpRestore=!0}});if("undefined"===typeof Intl)try{window.Intl=B,B.__applyLocaleSensitivePrototypes()}catch(a){}return B});
