/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo2.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.pipo2.AbstractElementHandler;
import org.adempiere.pipo2.Element;
import org.adempiere.pipo2.PIPOContext;
import org.adempiere.pipo2.PackOut;
import org.adempiere.pipo2.PoExporter;
import org.adempiere.pipo2.PoFiller;
import org.adempiere.pipo2.exception.POSaveFailedException;
import org.adempiere.pipo2.handler.CommonTranslationHandler;
import org.adempiere.pipo2.handler.WorkflowNodeElementHandler;
import org.adempiere.pipo2.handler.WorkflowNodeNextConditionElementHandler;
import org.adempiere.pipo2.handler.WorkflowNodeNextElementHandler;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_AD_Package_Imp_Detail;
import org.compiere.util.Env;
import org.compiere.wf.MWFNextCondition;
import org.compiere.wf.MWFNode;
import org.compiere.wf.MWFNodeNext;
import org.compiere.wf.MWorkflow;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class WorkflowElementHandler
extends AbstractElementHandler {
    private WorkflowNodeElementHandler nodeHandler = new WorkflowNodeElementHandler();
    private WorkflowNodeNextElementHandler nodeNextHandler = new WorkflowNodeNextElementHandler();
    private WorkflowNodeNextConditionElementHandler nextConditionHandler = new WorkflowNodeNextConditionElementHandler();
    private List<Integer> workflows = new ArrayList<Integer>();

    /*
     * Enabled aggressive block sorting
     */
    public void startElement(PIPOContext ctx, Element element) throws SAXException {
        PoFiller filler;
        List notfounds;
        List excludes = this.defaultExcludeList("AD_Workflow");
        excludes.add("AD_WF_Node_ID");
        String entitytype = this.getStringValue(element, "EntityType");
        if (!this.isProcessElement(ctx.ctx, entitytype)) {
            element.skip = true;
            return;
        }
        MWorkflow mWorkflow = (MWorkflow)this.findPO(ctx, element);
        if (mWorkflow == null) {
            mWorkflow = new MWorkflow(ctx.ctx, 0, this.getTrxName(ctx));
        }
        if ((notfounds = (filler = new PoFiller(ctx, (PO)mWorkflow, element, (AbstractElementHandler)this)).autoFill(excludes)).size() > 0) {
            element.defer = true;
            element.unresolved = notfounds.toString();
            return;
        }
        element.recordId = mWorkflow.get_ID();
        if (!mWorkflow.is_new()) {
            if (!mWorkflow.is_Changed()) return;
        }
        X_AD_Package_Imp_Detail impDetail = this.createImportDetail(ctx, element.qName, "AD_Workflow", 117);
        String action = null;
        if (!mWorkflow.is_new()) {
            this.backupRecord(ctx, impDetail.getAD_Package_Imp_Detail_ID(), "AD_Workflow", (PO)mWorkflow);
            action = "Update";
        } else {
            action = "New";
        }
        if (mWorkflow.save(this.getTrxName(ctx))) {
            this.log.info("m_Workflow save success");
            this.logImportDetail(ctx, impDetail, 1, mWorkflow.getName(), mWorkflow.get_ID(), action);
            this.workflows.add(mWorkflow.getAD_Workflow_ID());
            element.recordId = mWorkflow.get_ID();
            element.requireRoleAccessUpdate = true;
            return;
        }
        this.log.info("m_Workflow save failure");
        this.logImportDetail(ctx, impDetail, 0, mWorkflow.getName(), mWorkflow.get_ID(), action);
        throw new POSaveFailedException("Failed to save MWorkflow " + mWorkflow.getName());
    }

    public void endElement(PIPOContext ctx, Element element) throws SAXException {
        String value;
        if (!element.defer && !element.skip && element.recordId > 0 && (value = this.getStringValue(element, "AD_WF_Node_ID")) != null && value.trim().length() > 0) {
            MWorkflow m_Workflow = new MWorkflow(ctx.ctx, element.recordId, this.getTrxName(ctx));
            PoFiller filler = new PoFiller(ctx, (PO)m_Workflow, element, (AbstractElementHandler)this);
            int id = filler.setTableReference("AD_WF_Node_ID");
            if (id <= 0) {
                this.log.warning("Failed to resolve start node reference for workflow element. Workflow=" + m_Workflow.getName() + " StartNode=" + value);
                return;
            }
            m_Workflow.setAD_WF_Node_ID(id);
            X_AD_Package_Imp_Detail impDetail = this.createImportDetail(ctx, element.qName, "AD_Workflow", 117);
            if (m_Workflow.save(this.getTrxName(ctx))) {
                this.log.info("m_Workflow update success");
                this.logImportDetail(ctx, impDetail, 1, m_Workflow.getName(), m_Workflow.get_ID(), "Update");
                this.workflows.add(m_Workflow.getAD_Workflow_ID());
                element.recordId = m_Workflow.getAD_Workflow_ID();
                element.requireRoleAccessUpdate = true;
            } else {
                this.log.info("m_Workflow update fail");
                this.logImportDetail(ctx, impDetail, 0, m_Workflow.getName(), m_Workflow.get_ID(), "Update");
                throw new POSaveFailedException("Failed to save MWorkflow " + m_Workflow.getName());
            }
        }
    }

    public void create(PIPOContext ctx, TransformerHandler document) throws SAXException {
        boolean createElement;
        int AD_Workflow_ID;
        block11: {
            AD_Workflow_ID = Env.getContextAsInt((Properties)ctx.ctx, (String)"AD_Workflow_ID");
            if (ctx.packOut.isExported("AD_Workflow_ID|" + AD_Workflow_ID)) {
                return;
            }
            PackOut packOut = ctx.packOut;
            AttributesImpl atts = new AttributesImpl();
            MWorkflow m_Workflow = MWorkflow.get((Properties)ctx.ctx, (int)AD_Workflow_ID);
            createElement = this.isPackOutElement(ctx, (PO)m_Workflow);
            if (createElement) {
                atts.addAttribute("", "", "type", "CDATA", "object");
                atts.addAttribute("", "", "type-name", "CDATA", "ad.workflow");
                document.startElement("", "", "AD_Workflow", atts);
                this.createWorkflowBinding(ctx, document, m_Workflow);
                packOut.getCtx().ctx.put("Table_Name", "AD_Workflow");
                try {
                    new CommonTranslationHandler().packOut(packOut, document, null, m_Workflow.get_ID());
                }
                catch (Exception e) {
                    if (!this.log.isLoggable(Level.INFO)) break block11;
                    this.log.info(e.toString());
                }
            }
        }
        try {
            List wns = new Query(ctx.ctx, "AD_WF_Node", "AD_Workflow_ID=? AND AD_Client_ID=?", this.getTrxName(ctx)).setParameters(new Object[]{AD_Workflow_ID, Env.getAD_Client_ID((Properties)ctx.ctx)}).list();
            for (MWFNode wn : wns) {
                int nodeId = wn.getAD_WF_Node_ID();
                this.createNode(ctx, document, nodeId);
                List wnns = new Query(ctx.ctx, "AD_WF_NodeNext", "AD_WF_Node_ID=? AND AD_Client_ID=?", this.getTrxName(ctx)).setParameters(new Object[]{nodeId, Env.getAD_Client_ID((Properties)ctx.ctx)}).list();
                for (MWFNodeNext wnn : wnns) {
                    int ad_wf_nodenext_id = wnn.getAD_WF_NodeNext_ID();
                    this.createNodeNext(ctx, document, ad_wf_nodenext_id);
                    List wncs = new Query(ctx.ctx, "AD_WF_NextCondition", "AD_WF_NodeNext_ID=? AND AD_Client_ID=?", this.getTrxName(ctx)).setParameters(new Object[]{ad_wf_nodenext_id, Env.getAD_Client_ID((Properties)ctx.ctx)}).list();
                    for (MWFNextCondition wnc : wncs) {
                        int ad_wf_nodenextcondition_id = wnc.getAD_WF_NextCondition_ID();
                        if (this.log.isLoggable(Level.INFO)) {
                            this.log.info("ad_wf_nodenextcondition_id: " + String.valueOf(ad_wf_nodenextcondition_id));
                        }
                        this.createNodeNextCondition(ctx, document, ad_wf_nodenextcondition_id);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new AdempiereException((Throwable)e);
        }
        if (createElement) {
            document.endElement("", "", "AD_Workflow");
        }
    }

    private void createNodeNextCondition(PIPOContext ctx, TransformerHandler document, int ad_wf_nodenextcondition_id) throws SAXException {
        Env.setContext((Properties)ctx.ctx, (String)"AD_WF_NextCondition_ID", (int)ad_wf_nodenextcondition_id);
        this.nextConditionHandler.create(ctx, document);
        ctx.ctx.remove("AD_WF_NextCondition_ID");
    }

    private void createNodeNext(PIPOContext ctx, TransformerHandler document, int ad_wf_nodenext_id) throws SAXException {
        Env.setContext((Properties)ctx.ctx, (String)"AD_WF_NodeNext_ID", (int)ad_wf_nodenext_id);
        this.nodeNextHandler.create(ctx, document);
        ctx.ctx.remove("AD_WF_NodeNext_ID");
    }

    private void createNode(PIPOContext ctx, TransformerHandler document, int AD_WF_Node_ID) throws SAXException {
        Env.setContext((Properties)ctx.ctx, (String)"AD_WF_Node_ID", (int)AD_WF_Node_ID);
        this.nodeHandler.create(ctx, document);
        ctx.ctx.remove("AD_WF_Node_ID");
    }

    private void createWorkflowBinding(PIPOContext ctx, TransformerHandler document, MWorkflow m_Workflow) {
        PoExporter filler = new PoExporter(ctx, document, (PO)m_Workflow);
        List excludes = this.defaultExcludeList("AD_Workflow");
        if (m_Workflow.getAD_Workflow_ID() <= 999999) {
            filler.add("AD_Workflow_ID", new AttributesImpl());
        }
        filler.export(excludes);
    }

    public void packOut(PackOut packout, TransformerHandler packoutHandler, TransformerHandler docHandler, int recordId) throws Exception {
        Env.setContext((Properties)packout.getCtx().ctx, (String)"AD_Workflow_ID", (int)recordId);
        this.create(packout.getCtx(), packoutHandler);
        packout.getCtx().ctx.remove("AD_Workflow_ID");
    }
}

