/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo2.handler;

import java.util.Properties;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.base.Core;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.pipo2.AbstractElementHandler;
import org.adempiere.pipo2.Element;
import org.adempiere.pipo2.ElementHandler;
import org.adempiere.pipo2.PIPOContext;
import org.adempiere.pipo2.PackOut;
import org.adempiere.pipo2.PackoutItem;
import org.compiere.model.X_AD_Package_Imp_Detail;
import org.compiere.util.Env;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ScriptJSR223ElementHandler
extends AbstractElementHandler
implements ElementHandler {
    private static final String SCRIPT_JSR223 = "ScriptJSR223";

    public void startElement(PIPOContext ctx, Element element) throws SAXException {
        X_AD_Package_Imp_Detail impDetail = this.createImportDetail(ctx, element.qName, "", 0);
        String script = this.getStringValue(element, SCRIPT_JSR223);
        String engineName = "beanshell";
        if (script.contains("@script:")) {
            Pattern pattern = Pattern.compile(".*@script:\\b(.*)\\b.*");
            Matcher matcher = pattern.matcher(script);
            matcher.find();
            if (matcher.groupCount() > 0) {
                engineName = matcher.group(1);
            }
        }
        if (engineName == null || !engineName.equals("groovy") && !engineName.equals("beanshell")) {
            throw new AdempiereException("Script engine not supported, just groovy and beanshell");
        }
        ScriptEngine engine = Core.getScriptEngine((String)engineName);
        engine.put("A_Ctx", ctx.ctx);
        engine.put("A_Trx", ctx.trx);
        engine.put("A_TrxName", ctx.trx.getTrxName());
        engine.put("A_AD_Client_ID", Env.getAD_Client_ID((Properties)ctx.ctx));
        engine.put("A_AD_User_ID", Env.getAD_User_ID((Properties)ctx.ctx));
        String msg = null;
        try {
            msg = engine.eval(script).toString();
        }
        catch (ScriptException e) {
            ctx.packIn.getNotifier().addFailureLine("Script JSR223 failed, error (" + e.getLocalizedMessage() + "):");
            this.logImportDetail(ctx, impDetail, 0, SCRIPT_JSR223, -1, "Execute", script, String.valueOf(e.getLocalizedMessage()) + "\n -> " + msg);
            ctx.packIn.getNotifier().addFailureLine("-> " + msg);
            this.log.log(Level.SEVERE, SCRIPT_JSR223, (Throwable)e);
            throw new AdempiereException((Throwable)e);
        }
        this.logImportDetail(ctx, impDetail, 1, SCRIPT_JSR223, 0, "Execute", script, msg);
        ctx.packIn.getNotifier().addSuccessLine("out -> " + msg);
    }

    public void endElement(PIPOContext ctx, Element element) throws SAXException {
    }

    public void create(PIPOContext ctx, TransformerHandler document) throws SAXException {
        String execCode = Env.getContext((Properties)ctx.ctx, (String)"ExecCode");
        AttributesImpl atts = new AttributesImpl();
        this.addTypeName(atts, "custom");
        document.startElement("", "", SCRIPT_JSR223, atts);
        this.createShellScriptBinding(document, execCode);
        document.endElement("", "", SCRIPT_JSR223);
    }

    private void createShellScriptBinding(TransformerHandler document, String execCode) throws SAXException {
        document.startElement("", "", SCRIPT_JSR223, new AttributesImpl());
        char[] contents = execCode.toCharArray();
        document.startCDATA();
        document.characters(contents, 0, contents.length);
        document.endCDATA();
        document.endElement("", "", SCRIPT_JSR223);
    }

    public void packOut(PackOut packout, TransformerHandler packoutHandler, TransformerHandler docHandler, int recordId) throws Exception {
        PackoutItem detail = packout.getCurrentPackoutItem();
        Env.setContext((Properties)packout.getCtx().ctx, (String)"ExecCode", (String)((String)detail.getProperty("ExecCode")));
        this.create(packout.getCtx(), packoutHandler);
        packout.getCtx().ctx.remove("ExecCode");
    }
}

