/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.plugin.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.plugin.utils.AbstractActivator;
import org.adempiere.plugin.utils.Version;
import org.adempiere.util.ServerContext;
import org.compiere.Adempiere;
import org.compiere.model.MSession;
import org.compiere.model.Query;
import org.compiere.model.ServerStateChangeEvent;
import org.compiere.model.ServerStateChangeListener;
import org.compiere.model.X_AD_Package_Imp;
import org.compiere.util.AdempiereSystemError;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Trx;
import org.osgi.framework.BundleContext;

public class Incremental2PackActivator
extends AbstractActivator {
    protected static final CLogger logger = CLogger.getCLogger((String)Incremental2PackActivator.class.getName());

    @Override
    public String getName() {
        return this.context.getBundle().getSymbolicName();
    }

    @Override
    public String getVersion() {
        String version = (String)this.context.getBundle().getHeaders().get("Bundle-Version");
        String[] components = version.split("[.]");
        StringBuilder versionBuilder = new StringBuilder(components[0]);
        if (components.length >= 3) {
            versionBuilder.append(".").append(components[1]).append(".").append(components[2]);
        } else if (components.length == 2) {
            versionBuilder.append(".").append(components[1]).append(".0");
        } else {
            versionBuilder.append(".0.0");
        }
        return versionBuilder.toString();
    }

    public String getDescription() {
        return this.getName();
    }

    private void installPackage() {
        String where = "Name=? AND PK_Status = 'Completed successfully'";
        Query q = new Query(Env.getCtx(), "AD_Package_Imp", where.toString(), null);
        q.setParameters(new Object[]{this.getName()});
        List pkgs = q.list();
        ArrayList<String> installedVersions = new ArrayList<String>();
        if (pkgs != null && !pkgs.isEmpty()) {
            for (X_AD_Package_Imp pkg : pkgs) {
                String packageVersionPart = pkg.getPK_Version();
                String[] part = packageVersionPart.split("[.]");
                if (part.length > 3 && (packageVersionPart.indexOf(".v") > 0 || packageVersionPart.indexOf(".qualifier") > 0)) {
                    packageVersionPart = String.valueOf(part[0]) + "." + part[1] + "." + part[2];
                }
                installedVersions.add(packageVersionPart);
            }
        }
        this.packIn(installedVersions);
        this.afterPackIn();
    }

    /*
     * Unable to fully structure code
     */
    protected void packIn(List<String> installedVersions) {
        block20: {
            block19: {
                list = new ArrayList<TwoPackEntry>();
                urls = this.context.getBundle().findEntries("/META-INF", "2Pack_*.zip", false);
                if (urls != null) ** GOTO lbl9
                return;
lbl-1000:
                // 1 sources

                {
                    u = (URL)urls.nextElement();
                    version = this.extractVersionString(u);
                    list.add(new TwoPackEntry(u, version));
lbl9:
                    // 2 sources

                    ** while (urls.hasMoreElements())
                }
lbl10:
                // 1 sources

                firstImp = (X_AD_Package_Imp)new Query(Env.getCtx(), "AD_Package_Imp", "Name=? AND PK_Version=? AND PK_Status=?", null).setParameters(new Object[]{this.getName(), "0.0.0", "Completed successfully"}).setClient_ID().first();
                if (firstImp == null) {
                    trx = Trx.get((String)Trx.createTrxName(), (boolean)true);
                    trx.setDisplayName(String.valueOf(this.getClass().getName()) + "_packIn");
                    try {
                        try {
                            Env.getCtx().put("#AD_Client_ID", (Object)0);
                            firstImp = new X_AD_Package_Imp(Env.getCtx(), 0, trx.getTrxName());
                            firstImp.setName(this.getName());
                            firstImp.setPK_Version("0.0.0");
                            firstImp.setPK_Status("Completed successfully");
                            firstImp.setProcessed(true);
                            firstImp.saveEx();
                            if (list.size() > 0 && installedVersions.size() > 0) {
                                newList = new ArrayList<TwoPackEntry>();
                                for (TwoPackEntry entry : list) {
                                    patch = false;
                                    for (String v : installedVersions) {
                                        v2 = new Version(v);
                                        c = v2.compareTo(v1 = new Version(entry.version));
                                        if (c == 0) {
                                            patch = false;
                                            break;
                                        }
                                        if (c <= 0) continue;
                                        patch = true;
                                    }
                                    if (patch) {
                                        Incremental2PackActivator.logger.log(Level.WARNING, "Patch Meta Data for " + this.getName() + " " + entry.version + " ...");
                                        pi = new X_AD_Package_Imp(Env.getCtx(), 0, trx.getTrxName());
                                        pi.setName(this.getName());
                                        pi.setPK_Version(entry.version);
                                        pi.setPK_Status("Completed successfully");
                                        pi.setProcessed(true);
                                        pi.saveEx();
                                        continue;
                                    }
                                    newList.add(entry);
                                }
                                list = newList;
                            }
                            trx.commit(true);
                        }
                        catch (Exception e) {
                            trx.rollback();
                            Incremental2PackActivator.logger.log(Level.WARNING, e.getLocalizedMessage(), (Throwable)e);
                            trx.close();
                            break block19;
                        }
                    }
                    catch (Throwable var15_18) {
                        trx.close();
                        throw var15_18;
                    }
                    trx.close();
                }
            }
            Collections.sort(list, new Comparator<TwoPackEntry>(){

                @Override
                public int compare(TwoPackEntry o1, TwoPackEntry o2) {
                    return new Version(o1.version).compareTo(new Version(o2.version));
                }
            });
            try {
                try {
                    if (this.getDBLock()) {
                        for (TwoPackEntry entry : list) {
                            if (installedVersions.contains(entry.version) || this.packIn(entry.url)) continue;
                            break block20;
                        }
                        break block20;
                    }
                    Incremental2PackActivator.logger.log(Level.WARNING, "Could not acquire the DB lock to install:" + this.getName());
                }
                catch (AdempiereSystemError e) {
                    e.printStackTrace();
                    this.releaseLock();
                }
            }
            finally {
                this.releaseLock();
            }
        }
    }

    private String extractVersionString(URL u) {
        String p = u.getPath();
        int upos = p.lastIndexOf("2Pack_");
        int dpos = p.lastIndexOf(".");
        if (p.indexOf("_") != p.lastIndexOf("_")) {
            dpos = p.lastIndexOf("_");
        }
        String v = p.substring(upos + "2Pack_".length(), dpos);
        return v;
    }

    protected boolean packIn(URL packout) {
        if (packout != null && this.service != null) {
            MSession localSession = null;
            if (Env.getContextAsInt((Properties)Env.getCtx(), (String)"#AD_Session_ID") <= 0) {
                localSession = MSession.get((Properties)Env.getCtx());
                localSession = localSession == null ? MSession.create((Properties)Env.getCtx()) : new MSession(Env.getCtx(), localSession.getAD_Session_ID(), null);
                localSession.setWebSession("Incremental2PackActivator");
                localSession.saveEx();
            }
            String path = packout.getPath();
            String suffix = "_" + path.substring(path.lastIndexOf("2Pack_"));
            logger.log(Level.WARNING, "Installing " + this.getName() + " " + path + " ...");
            FileOutputStream zipstream = null;
            InputStream stream = null;
            try {
                int read;
                stream = packout.openStream();
                File zipfile = File.createTempFile(String.valueOf(this.getName()) + "_", suffix);
                zipstream = new FileOutputStream(zipfile);
                byte[] buffer = new byte[1024];
                while ((read = stream.read(buffer)) != -1) {
                    zipstream.write(buffer, 0, read);
                }
                if (!this.merge(zipfile, this.extractVersionString(packout))) {
                    return false;
                }
            }
            catch (Throwable e) {
                logger.log(Level.WARNING, "Pack in failed.", e);
                return false;
            }
            finally {
                if (zipstream != null) {
                    try {
                        zipstream.close();
                    }
                    catch (Exception exception) {}
                }
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Exception exception) {}
                }
                if (localSession != null) {
                    localSession.logout();
                }
            }
            logger.log(Level.WARNING, String.valueOf(this.getName()) + " " + packout.getPath() + " installed");
        }
        return true;
    }

    protected BundleContext getContext() {
        return this.context;
    }

    protected void setContext(BundleContext context) {
        this.context = context;
    }

    protected void afterPackIn() {
    }

    protected void setupPackInContext() {
        Properties serverContext = new Properties();
        serverContext.setProperty("#AD_Client_ID", "0");
        ServerContext.setCurrentInstance((Properties)serverContext);
    }

    @Override
    protected void frameworkStarted() {
        if (this.service != null) {
            if (Adempiere.getThreadPoolExecutor() != null) {
                Adempiere.getThreadPoolExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        ClassLoader cl = Thread.currentThread().getContextClassLoader();
                        try {
                            Thread.currentThread().setContextClassLoader(Incremental2PackActivator.class.getClassLoader());
                            Incremental2PackActivator.this.setupPackInContext();
                            Incremental2PackActivator.this.installPackage();
                        }
                        finally {
                            ServerContext.dispose();
                            Incremental2PackActivator.this.service = null;
                            Thread.currentThread().setContextClassLoader(cl);
                        }
                    }
                });
            } else {
                Adempiere.addServerStateChangeListener((ServerStateChangeListener)new ServerStateChangeListener(){

                    public void stateChange(ServerStateChangeEvent event) {
                        if (event.getEventType() == 0 && Incremental2PackActivator.this.service != null) {
                            ClassLoader cl = Thread.currentThread().getContextClassLoader();
                            try {
                                Thread.currentThread().setContextClassLoader(Incremental2PackActivator.class.getClassLoader());
                                Incremental2PackActivator.this.setupPackInContext();
                                Incremental2PackActivator.this.installPackage();
                            }
                            finally {
                                ServerContext.dispose();
                                Incremental2PackActivator.this.service = null;
                                Thread.currentThread().setContextClassLoader(cl);
                            }
                        }
                    }
                });
            }
        }
    }

    private static class TwoPackEntry {
        private URL url;
        private String version;

        private TwoPackEntry(URL url, String version) {
            this.url = url;
            this.version = version;
        }
    }
}

