/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.plugin.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.plugin.utils.AbstractActivator;
import org.adempiere.util.ServerContext;
import org.compiere.Adempiere;
import org.compiere.model.MSession;
import org.compiere.model.Query;
import org.compiere.model.ServerStateChangeEvent;
import org.compiere.model.ServerStateChangeListener;
import org.compiere.model.X_AD_Package_Imp;
import org.compiere.util.AdempiereSystemError;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkEvent;

public class AdempiereActivator
extends AbstractActivator {
    protected static final CLogger logger = CLogger.getCLogger((String)AdempiereActivator.class.getName());

    @Override
    public String getName() {
        return this.context.getBundle().getSymbolicName();
    }

    @Override
    public String getVersion() {
        return (String)this.context.getBundle().getHeaders().get("Bundle-Version");
    }

    public String getDescription() {
        return this.getName();
    }

    private void installPackage() {
        String version = this.getPKVersion();
        String where = "Name=? AND PK_Version LIKE ?";
        Query q = new Query(Env.getCtx(), "AD_Package_Imp", where.toString(), null);
        q.setParameters(new Object[]{this.getName(), String.valueOf(version) + "%"});
        X_AD_Package_Imp pkg = (X_AD_Package_Imp)q.first();
        if (pkg == null) {
            try {
                try {
                    if (this.getDBLock()) {
                        logger.log(Level.WARNING, "Installing " + this.getName() + " " + version + " ...");
                        this.packIn();
                        this.install();
                        logger.log(Level.WARNING, String.valueOf(this.getName()) + " " + version + " installed.");
                    }
                    logger.log(Level.WARNING, "Could not acquire the DB lock to install:" + this.getName());
                }
                catch (AdempiereSystemError e) {
                    e.printStackTrace();
                    this.releaseLock();
                }
            }
            finally {
                this.releaseLock();
            }
        } else if (logger.isLoggable(Level.INFO)) {
            logger.info(String.valueOf(this.getName()) + " " + version + " was installed: " + pkg.getCreated());
        }
    }

    private String getPKVersion() {
        String version = this.getVersion();
        if (version != null) {
            int count = 0;
            int index = -1;
            int i = 0;
            while (i < version.length()) {
                if (version.charAt(i) == '.') {
                    ++count;
                }
                if (count == 3) {
                    index = i;
                    break;
                }
                ++i;
            }
            if (index == -1) {
                index = version.length();
            }
            version = version.substring(0, index);
        }
        return version;
    }

    protected void packIn() {
        URL packout = this.context.getBundle().getEntry("/META-INF/2Pack.zip");
        if (packout != null && this.service != null) {
            MSession localSession = null;
            if (Env.getContextAsInt((Properties)Env.getCtx(), (String)"#AD_Session_ID") <= 0) {
                localSession = MSession.create((Properties)Env.getCtx());
                localSession.setWebSession("AdempiereActivator");
                localSession.saveEx();
            }
            FileOutputStream zipstream = null;
            InputStream stream = null;
            try {
                try {
                    int read;
                    stream = this.context.getBundle().getEntry("/META-INF/2Pack.zip").openStream();
                    File zipfile = File.createTempFile(this.getName(), ".zip");
                    zipstream = new FileOutputStream(zipfile);
                    byte[] buffer = new byte[1024];
                    while ((read = stream.read(buffer)) != -1) {
                        zipstream.write(buffer, 0, read);
                    }
                    this.merge(zipfile, this.getPKVersion());
                }
                catch (Throwable e) {
                    logger.log(Level.WARNING, "Pack in failed.", e);
                    if (zipstream != null) {
                        try {
                            zipstream.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (localSession != null) {
                        localSession.logout();
                    }
                }
            }
            finally {
                if (zipstream != null) {
                    try {
                        zipstream.close();
                    }
                    catch (Exception exception) {}
                }
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Exception exception) {}
                }
                if (localSession != null) {
                    localSession.logout();
                }
            }
        }
    }

    protected BundleContext getContext() {
        return this.context;
    }

    protected void setContext(BundleContext context) {
        this.context = context;
    }

    protected void install() {
    }

    protected void setupPackInContext() {
        Properties serverContext = new Properties();
        serverContext.setProperty("#AD_Client_ID", "0");
        ServerContext.setCurrentInstance((Properties)serverContext);
    }

    @Override
    public void frameworkEvent(FrameworkEvent event) {
        if (event.getType() == 8) {
            this.frameworkStarted();
        }
    }

    @Override
    protected void frameworkStarted() {
        if (this.service != null) {
            if (Adempiere.getThreadPoolExecutor() != null) {
                Adempiere.getThreadPoolExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        ClassLoader cl = Thread.currentThread().getContextClassLoader();
                        try {
                            Thread.currentThread().setContextClassLoader(AdempiereActivator.class.getClassLoader());
                            AdempiereActivator.this.setupPackInContext();
                            AdempiereActivator.this.installPackage();
                        }
                        finally {
                            ServerContext.dispose();
                            AdempiereActivator.this.service = null;
                            Thread.currentThread().setContextClassLoader(cl);
                        }
                    }
                });
            } else {
                Adempiere.addServerStateChangeListener((ServerStateChangeListener)new ServerStateChangeListener(){

                    public void stateChange(ServerStateChangeEvent event) {
                        if (event.getEventType() == 0 && AdempiereActivator.this.service != null) {
                            ClassLoader cl = Thread.currentThread().getContextClassLoader();
                            try {
                                Thread.currentThread().setContextClassLoader(AdempiereActivator.class.getClassLoader());
                                AdempiereActivator.this.setupPackInContext();
                                AdempiereActivator.this.installPackage();
                            }
                            finally {
                                ServerContext.dispose();
                                AdempiereActivator.this.service = null;
                                Thread.currentThread().setContextClassLoader(cl);
                            }
                        }
                    }
                });
            }
        }
    }
}

