/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.eclipse.equinox.http.servlet;

import java.io.IOException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.adempiere.eclipse.equinox.http.servlet.Activator;
import org.adempiere.eclipse.equinox.http.servlet.DefaultHttpContext;
import org.adempiere.eclipse.equinox.http.servlet.FilterChainImpl;
import org.adempiere.eclipse.equinox.http.servlet.FilterConfigImpl;
import org.adempiere.eclipse.equinox.http.servlet.FilterRegistration;
import org.adempiere.eclipse.equinox.http.servlet.HttpServletRequestAdaptor;
import org.adempiere.eclipse.equinox.http.servlet.ProxyContext;
import org.adempiere.eclipse.equinox.http.servlet.ResourceServlet;
import org.adempiere.eclipse.equinox.http.servlet.ServletConfigImpl;
import org.adempiere.eclipse.equinox.http.servlet.ServletContextAdaptor;
import org.adempiere.eclipse.equinox.http.servlet.ServletRegistration;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.NamespaceException;

public class ProxyServlet
extends HttpServlet
implements Filter {
    private static final long serialVersionUID = 4117456123807468871L;
    private Map<String, ServletRegistration> servletRegistrations = new HashMap<String, ServletRegistration>();
    private Set<Servlet> registeredServlets = new HashSet<Servlet>();
    private Map<Filter, FilterRegistration> filterRegistrations = new HashMap<Filter, FilterRegistration>();
    private ProxyContext proxyContext;
    private String httpContext;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.proxyContext = new ProxyContext(config.getServletContext());
        this.httpContext = config.getInitParameter("HttpContext.ClassName");
        if (this.httpContext == null) {
            this.httpContext = DefaultHttpContext.class.getName();
        }
        Activator.addProxyServlet(this);
    }

    public synchronized void destroy() {
        Activator.removeProxyServlet(this);
        this.proxyContext.destroy();
        this.proxyContext = null;
        super.destroy();
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.process(req, resp, null);
    }

    protected synchronized void process(HttpServletRequest req, HttpServletResponse resp, FilterChain filterChain) throws ServletException, IOException {
        this.proxyContext.initializeServletPath(req, filterChain);
        String alias = HttpServletRequestAdaptor.getDispatchPathInfo(req, filterChain);
        if (alias == null) {
            alias = "/";
        }
        if (this.processAlias(req, resp, alias, null, filterChain)) {
            return;
        }
        String extensionAlias = this.findExtensionAlias(alias);
        alias = alias.substring(0, alias.lastIndexOf(47));
        while (alias.length() != 0) {
            if (this.processAlias(req, resp, alias, extensionAlias, filterChain)) {
                return;
            }
            alias = alias.substring(0, alias.lastIndexOf(47));
        }
        if (extensionAlias != null) {
            extensionAlias = extensionAlias.substring(1);
        }
        if (this.processAlias(req, resp, "/", extensionAlias, filterChain)) {
            return;
        }
        if (filterChain != null) {
            filterChain.doFilter((ServletRequest)req, (ServletResponse)resp);
        } else {
            resp.sendError(404, "ProxyServlet: " + req.getRequestURI());
        }
    }

    private String findExtensionAlias(String alias) {
        String lastSegment = alias.substring(alias.lastIndexOf(47) + 1);
        int dot = lastSegment.lastIndexOf(46);
        if (dot == -1) {
            return null;
        }
        String extension = lastSegment.substring(dot + 1);
        if (extension.length() == 0) {
            return null;
        }
        return "/*." + extension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean processAlias(HttpServletRequest req, HttpServletResponse resp, String alias, String extensionAlias, FilterChain filterChain) throws ServletException, IOException {
        registration = null;
        matchingFilterRegistrations = Collections.emptyList();
        dispatchPathInfo = HttpServletRequestAdaptor.getDispatchPathInfo(req, filterChain);
        var9_9 = this;
        synchronized (var9_9) {
            if (extensionAlias == null) {
                registration = this.servletRegistrations.get(alias);
            } else {
                registration = this.servletRegistrations.get(String.valueOf(alias) + extensionAlias);
                if (registration != null) {
                    if (!(registration.getServlet() instanceof ResourceServlet)) {
                        alias = HttpServletRequestAdaptor.getDispatchPathInfo(req, filterChain);
                    }
                } else {
                    registration = this.servletRegistrations.get(alias);
                }
            }
            if (registration != null) {
                registration.addReference();
                if (!this.filterRegistrations.isEmpty()) {
                    matchingFilterRegistrations = new ArrayList<T>();
                    for (FilterRegistration filterRegistration : this.filterRegistrations.values()) {
                        if (!filterRegistration.matches(dispatchPathInfo)) continue;
                        matchingFilterRegistrations.add(filterRegistration);
                        filterRegistration.addReference();
                    }
                }
            }
        }
        if (registration != null) {
            try {
                wrappedRequest = new HttpServletRequestAdaptor(req, alias, registration.getServlet(), filterChain);
                if (matchingFilterRegistrations.isEmpty()) {
                    registration.service((HttpServletRequest)wrappedRequest, resp);
                }
                Collections.sort(matchingFilterRegistrations);
                chain = new FilterChainImpl(matchingFilterRegistrations, registration);
                chain.doFilter((ServletRequest)wrappedRequest, (ServletResponse)resp);
            }
            finally {
                registration.removeReference();
                ** for (filterRegistration : matchingFilterRegistrations)
            }
lbl-1000:
            // 1 sources

            {
                filterRegistration.removeReference();
                continue;
            }
lbl44:
            // 1 sources

            return true;
        }
        return false;
    }

    synchronized void unregister(String alias, boolean destroy) {
        ServletRegistration removedRegistration = this.servletRegistrations.remove(alias);
        if (removedRegistration != null) {
            this.registeredServlets.remove(removedRegistration.getServlet());
            try {
                if (destroy) {
                    removedRegistration.destroy();
                }
            }
            finally {
                this.proxyContext.destroyContextAttributes(removedRegistration.getHttpContext());
            }
        }
    }

    synchronized void registerServlet(String alias, Servlet servlet, Dictionary<String, String> initparams, HttpContext httpContext) throws ServletException, NamespaceException {
        this.checkAlias(alias);
        if (this.servletRegistrations.containsKey(alias)) {
            throw new NamespaceException("The alias '" + alias + "' is already in use.");
        }
        if (servlet == null) {
            throw new IllegalArgumentException("Servlet cannot be null");
        }
        if (this.registeredServlets.contains(servlet)) {
            throw new ServletException("This servlet has already been registered.");
        }
        ServletRegistration registration = new ServletRegistration(servlet, httpContext);
        ServletContextAdaptor wrappedServletContext = new ServletContextAdaptor(this.proxyContext, this.getServletContext(), httpContext, AccessController.getContext());
        ServletConfigImpl servletConfig = new ServletConfigImpl(servlet, initparams, wrappedServletContext);
        boolean initialized = false;
        this.proxyContext.createContextAttributes(httpContext);
        try {
            registration.init(servletConfig);
            initialized = true;
        }
        finally {
            if (!initialized) {
                this.proxyContext.destroyContextAttributes(httpContext);
            }
        }
        this.registeredServlets.add(servlet);
        this.servletRegistrations.put(alias, registration);
    }

    synchronized void registerResources(String alias, String name, HttpContext httpContext) throws NamespaceException {
        this.checkName(name);
        ResourceServlet resourceServlet = new ResourceServlet(name, httpContext, AccessController.getContext());
        try {
            this.registerServlet(alias, (Servlet)resourceServlet, null, httpContext);
        }
        catch (ServletException e) {
            throw new IllegalStateException("Unexpected ServletException throw when registering resources at alias " + alias + ".");
        }
    }

    private void checkName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        if (name.endsWith("/") && !name.equals("/")) {
            throw new IllegalArgumentException("Invalid Name '" + name + "'");
        }
    }

    private void checkAlias(String alias) {
        if (alias == null) {
            throw new IllegalArgumentException("Alias cannot be null");
        }
        if (!alias.startsWith("/") || alias.endsWith("/") && !alias.equals("/")) {
            throw new IllegalArgumentException("Invalid alias '" + alias + "'");
        }
    }

    public synchronized void unregisterFilter(Filter filter, boolean destroy) {
        FilterRegistration removedRegistration = this.filterRegistrations.remove(filter);
        if (removedRegistration != null) {
            try {
                if (destroy) {
                    removedRegistration.destroy();
                }
            }
            finally {
                this.proxyContext.destroyContextAttributes(removedRegistration.getHttpContext());
            }
        }
    }

    public synchronized void registerFilter(String alias, Filter filter, Dictionary<String, String> initparams, HttpContext httpContext) throws ServletException {
        this.checkAlias(alias);
        if (filter == null) {
            throw new IllegalArgumentException("Filter cannot be null");
        }
        if (this.filterRegistrations.containsKey(filter)) {
            throw new ServletException("This filter has already been registered.");
        }
        int filterPriority = this.findFilterPriority(initparams);
        FilterRegistration registration = new FilterRegistration(filter, httpContext, alias, filterPriority);
        ServletContextAdaptor wrappedServletContext = new ServletContextAdaptor(this.proxyContext, this.getServletContext(), httpContext, AccessController.getContext());
        FilterConfigImpl filterConfig = new FilterConfigImpl(filter, initparams, wrappedServletContext);
        boolean initialized = false;
        this.proxyContext.createContextAttributes(httpContext);
        try {
            registration.init(filterConfig);
            initialized = true;
        }
        finally {
            if (!initialized) {
                this.proxyContext.destroyContextAttributes(httpContext);
            }
        }
        this.filterRegistrations.put(filter, registration);
    }

    private int findFilterPriority(Dictionary<String, String> initparams) {
        if (initparams == null) {
            return 0;
        }
        String filterPriority = initparams.get("filter-priority");
        if (filterPriority == null) {
            return 0;
        }
        try {
            int result = Integer.parseInt(filterPriority);
            if (result >= -1000 && result <= 1000) {
                return result;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw new IllegalArgumentException("filter-priority must be an integer between -1000 and 1000 but was: " + filterPriority);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        ServletConfigAdaptor servletConfig = new ServletConfigAdaptor(filterConfig);
        this.init(servletConfig);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        this.process(req, resp, chain);
    }

    public String getHttpContext() {
        return this.httpContext;
    }

    private static class ServletConfigAdaptor
    implements ServletConfig {
        private FilterConfig filterConfig;

        public ServletConfigAdaptor(FilterConfig filterConfig) {
            this.filterConfig = filterConfig;
        }

        public String getInitParameter(String arg0) {
            return this.filterConfig.getInitParameter(arg0);
        }

        public Enumeration<String> getInitParameterNames() {
            return this.filterConfig.getInitParameterNames();
        }

        public ServletContext getServletContext() {
            return this.filterConfig.getServletContext();
        }

        public String getServletName() {
            return this.filterConfig.getFilterName();
        }
    }
}

