/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.eclipse.equinox.http.servlet;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.adempiere.eclipse.equinox.http.servlet.HttpServiceImpl;
import org.adempiere.eclipse.equinox.http.servlet.HttpServiceProxy;
import org.adempiere.eclipse.equinox.http.servlet.ProxyServlet;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.http.HttpService;

public class HttpServiceProxyFactory
implements ServiceFactory<HttpService> {
    private static Map<String, ProxyServlet> delegateMap = new HashMap<String, ProxyServlet>();
    private static List<HttpServiceProxy> proxies = new ArrayList<HttpServiceProxy>();

    public HttpService getService(Bundle bundle, ServiceRegistration<HttpService> registration) {
        HttpServiceProxy service = new HttpServiceProxy(bundle, this);
        proxies.add(service);
        return service;
    }

    public void ungetService(Bundle bundle, ServiceRegistration<HttpService> registration, HttpService service) {
        proxies.remove(service);
    }

    public static synchronized ProxyServlet registerServletDelegate(String httpContext, ProxyServlet proxy) {
        ProxyServlet old = delegateMap.put(httpContext, proxy);
        for (HttpServiceProxy p : proxies) {
            try {
                p.processPendingRegistration(httpContext);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return old;
    }

    public static synchronized ProxyServlet unregisterServletDelegate(ProxyServlet proxy) {
        return delegateMap.remove(proxy.getHttpContext());
    }

    public HttpService getHttpServiceDelegate(Bundle bundle, String httpContext) {
        ProxyServlet proxy = delegateMap.get(httpContext);
        if (proxy != null) {
            return new HttpServiceImpl(bundle, proxy);
        }
        return null;
    }
}

