/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.eclipse.equinox.http.servlet;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.adempiere.eclipse.equinox.http.servlet.ProxyServlet;

public class BridgeServlet
extends HttpServlet {
    static final String INCLUDE_REQUEST_URI_ATTRIBUTE = "javax.servlet.include.request_uri";
    static final String INCLUDE_SERVLET_PATH_ATTRIBUTE = "javax.servlet.include.servlet_path";
    static final String INCLUDE_PATH_INFO_ATTRIBUTE = "javax.servlet.include.path_info";
    private static final long serialVersionUID = 2825667412474494674L;
    private HttpServlet delegate;
    private boolean delegateIsFilter;

    public void init() throws ServletException {
        super.init();
        this.initDelegate();
    }

    public void destroy() {
        try {
            this.initDelegate();
        }
        catch (ServletException servletException) {
            // empty catch block
        }
        super.destroy();
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.process(req, resp, null);
    }

    protected void process(HttpServletRequest req, HttpServletResponse resp, FilterChain chain) throws ServletException, IOException {
        HttpServlet servletReference;
        String servletPath;
        String includePathInfo;
        String pathInfo = BridgeServlet.getDispatchPathInfo(req, chain);
        if (pathInfo == null && this.isExtensionMapping(req.getServletPath())) {
            req = new ExtensionMappingRequest((HttpServletRequest)req);
        }
        if (req.getAttribute(INCLUDE_REQUEST_URI_ATTRIBUTE) != null && ((includePathInfo = (String)req.getAttribute(INCLUDE_PATH_INFO_ATTRIBUTE)) == null || includePathInfo.length() == 0) && this.isExtensionMapping(servletPath = (String)req.getAttribute(INCLUDE_SERVLET_PATH_ATTRIBUTE))) {
            req = new IncludedExtensionMappingRequest((HttpServletRequest)req);
        }
        if ((servletReference = this.delegate) == null) {
            if (chain != null) {
                chain.doFilter((ServletRequest)req, (ServletResponse)resp);
            } else {
                resp.sendError(404, "BridgeServlet: " + req.getRequestURI());
            }
        } else if (this.delegateIsFilter && chain != null) {
            ((Filter)servletReference).doFilter((ServletRequest)req, (ServletResponse)resp, chain);
        } else {
            servletReference.service((ServletRequest)req, (ServletResponse)resp);
        }
    }

    private boolean isExtensionMapping(String servletPath) {
        if (servletPath == null) {
            return false;
        }
        String lastSegment = servletPath;
        int lastSlash = servletPath.lastIndexOf(47);
        if (lastSlash != -1) {
            lastSegment = servletPath.substring(lastSlash + 1);
        }
        return lastSegment.indexOf(46) != -1;
    }

    private void initDelegate() throws ServletException {
        this.delegate = new ProxyServlet();
        this.delegate.init(this.getServletConfig());
        this.delegateIsFilter = this.delegate instanceof Filter;
    }

    private static String getDispatchPathInfo(HttpServletRequest req, FilterChain chain) {
        String pathInfo = req.getPathInfo();
        if (pathInfo != null) {
            return pathInfo;
        }
        if (chain == null) {
            return null;
        }
        String contextPath = req.getContextPath();
        String requestURI = req.getRequestURI();
        return requestURI.substring(contextPath.length(), requestURI.length());
    }

    static class ExtensionMappingRequest
    extends HttpServletRequestWrapper {
        public ExtensionMappingRequest(HttpServletRequest req) {
            super(req);
        }

        public String getPathInfo() {
            return super.getServletPath();
        }

        public String getServletPath() {
            return "";
        }
    }

    static class IncludedExtensionMappingRequest
    extends HttpServletRequestWrapper {
        public IncludedExtensionMappingRequest(HttpServletRequest req) {
            super(req);
        }

        public Object getAttribute(String attributeName) {
            if (attributeName.equals(BridgeServlet.INCLUDE_SERVLET_PATH_ATTRIBUTE)) {
                return "";
            }
            if (attributeName.equals(BridgeServlet.INCLUDE_PATH_INFO_ATTRIBUTE)) {
                String servletPath = (String)super.getAttribute(BridgeServlet.INCLUDE_SERVLET_PATH_ATTRIBUTE);
                return servletPath;
            }
            return super.getAttribute(attributeName);
        }
    }
}

