/*
 * Decompiled with CFR 0.152.
 */
package jpiere.plugin.matrixwindow.form;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Properties;
import java.util.TreeMap;
import jpiere.plugin.matrixwindow.form.JPMatrixGridRowRenderer;
import jpiere.plugin.matrixwindow.form.JPiereMatrixWindow;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFooter;
import org.apache.poi.hssf.usermodel.HSSFHeader;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.util.CellRangeAddress;
import org.compiere.model.GridField;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class JPiereMatrixExcelExporter {
    private JPiereMatrixWindow matrixWindow;
    private HSSFWorkbook m_workbook;
    private HashMap<String, HSSFCellStyle> m_styles = new HashMap();

    public JPiereMatrixExcelExporter(JPiereMatrixWindow matrixWindow) {
        this.matrixWindow = matrixWindow;
        this.m_workbook = new HSSFWorkbook();
    }

    public void export(File file) throws IOException {
        HSSFSheet sheet = this.m_workbook.createSheet();
        this.createTableHeader(sheet);
        this.addRecords(sheet);
        try {
            FileOutputStream out = new FileOutputStream(file);
            this.m_workbook.write((OutputStream)out);
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    protected void createHeaderFooter(HSSFSheet sheet) {
        HSSFHeader header = sheet.getHeader();
        header.setRight(String.valueOf(HSSFHeader.page()) + " / " + HSSFHeader.numPages());
        HSSFFooter footer = sheet.getFooter();
        footer.setLeft(Env.getStandardReportFooterTrademarkText());
        footer.setCenter(Env.getHeader((Properties)Env.getCtx(), (int)0));
    }

    private void createTableHeader(HSSFSheet sheet) {
        String name;
        int colCounter = 0;
        HashMap<Object, String> columnKeyNameMap = this.matrixWindow.getColumnKeyNameMap();
        ArrayList<Object> ColumnKeys = this.matrixWindow.getColumnKeys();
        HSSFRow row = sheet.createRow(0);
        HSSFCell cell = row.createCell(colCounter);
        ++colCounter;
        int cellLength = this.matrixWindow.getContentFields().length;
        for (Object obj : ColumnKeys) {
            cell = row.createCell(colCounter);
            name = columnKeyNameMap.get(obj);
            cell.setCellValue(name);
            if (cellLength > 1) {
                sheet.addMergedRegion(new CellRangeAddress(0, 0, colCounter, colCounter + this.matrixWindow.getContentFields().length - 1));
            }
            colCounter += this.matrixWindow.getContentFields().length;
        }
        colCounter = 0;
        row = sheet.createRow(1);
        HashMap<Integer, String> columnNameMap = this.matrixWindow.getColumnNameMap();
        int i = 0;
        while (i < columnNameMap.size()) {
            cell = row.createCell(colCounter);
            name = columnNameMap.get(i);
            cell.setCellValue(name);
            ++colCounter;
            ++i;
        }
    }

    private void addRecords(HSSFSheet sheet) {
        LinkedHashMap<Object, TreeMap<Integer, Object>> viewModel = this.matrixWindow.getViewModel();
        ArrayList<Object> rowKeys = this.matrixWindow.getRowKeys();
        HashMap<Integer, GridField> columnGridFieldMap = this.matrixWindow.getColumnGridFieldMap();
        JPMatrixGridRowRenderer renderer = this.matrixWindow.getRowRenderer();
        TreeMap<Integer, Object> objectList = null;
        HSSFRow row = null;
        HSSFCell cell = null;
        GridField gField = null;
        int rowCounter = 0;
        int displayType = 0;
        for (Object rowKey : rowKeys) {
            objectList = viewModel.get(rowKey);
            row = sheet.createRow(rowCounter + 2);
            int col = 0;
            while (col < objectList.size()) {
                Object obj_Value = objectList.get(col);
                if (obj_Value != null) {
                    Object value;
                    cell = row.createCell(col);
                    gField = columnGridFieldMap.get(col);
                    displayType = gField.getDisplayType();
                    if (DisplayType.isDate((int)displayType)) {
                        value = null;
                        value = obj_Value instanceof Date ? new Timestamp(((Date)obj_Value).getTime()) : (Timestamp)obj_Value;
                        cell.setCellValue((java.util.Date)value);
                    } else if (DisplayType.isNumeric((int)displayType)) {
                        double value2 = 0.0;
                        if (obj_Value instanceof Number) {
                            value2 = ((Number)obj_Value).doubleValue();
                        }
                        cell.setCellValue(value2);
                    } else if (20 == displayType) {
                        boolean value3 = false;
                        value3 = obj_Value instanceof Boolean ? ((Boolean)obj_Value).booleanValue() : "Y".equals(obj_Value);
                        cell.setCellValue((RichTextString)new HSSFRichTextString(Msg.getMsg((String)Env.getAD_Language((Properties)Env.getCtx()), (String)(value3 ? "Y" : "N"))));
                    } else if (DisplayType.isID((int)displayType) || 17 == displayType) {
                        String text = renderer.getDisplayText(obj_Value, gField, rowCounter + 2, false);
                        cell.setCellValue((RichTextString)new HSSFRichTextString(text));
                    } else {
                        value = this.fixString(obj_Value.toString());
                        cell.setCellValue((RichTextString)new HSSFRichTextString((String)value));
                    }
                    HSSFCellStyle style = this.getStyle(col, displayType);
                    cell.setCellStyle(style);
                }
                ++col;
            }
            ++rowCounter;
        }
    }

    private String fixString(String str) {
        return Util.stripDiacritics((String)str);
    }

    private HSSFCellStyle getStyle(int col, int displayType) {
        String key = "cell-" + col + "-" + displayType;
        HSSFCellStyle cs = this.m_styles.get(key);
        if (cs == null) {
            cs = this.m_workbook.createCellStyle();
            this.m_styles.put(key, cs);
        }
        return cs;
    }

    protected String getCellFormat(int displayType) {
        boolean isHighlightNegativeNumbers = true;
        String cellFormat = null;
        if (DisplayType.isNumeric((int)displayType)) {
            DecimalFormat df = DisplayType.getNumberFormat((int)displayType, (Language)Env.getLanguage((Properties)Env.getCtx()));
            cellFormat = this.getFormatString(df, isHighlightNegativeNumbers);
        }
        return cellFormat;
    }

    private String getFormatString(NumberFormat df, boolean isHighlightNegativeNumbers) {
        StringBuffer format = new StringBuffer();
        int integerDigitsMin = df.getMinimumIntegerDigits();
        int integerDigitsMax = df.getMaximumIntegerDigits();
        int i = 0;
        while (i < integerDigitsMax) {
            if (i < integerDigitsMin) {
                format.insert(0, "0");
            } else {
                format.insert(0, "#");
            }
            if (i == 2) {
                format.insert(0, ",");
            }
            ++i;
        }
        int fractionDigitsMin = df.getMinimumFractionDigits();
        int fractionDigitsMax = df.getMaximumFractionDigits();
        int i2 = 0;
        while (i2 < fractionDigitsMax) {
            if (i2 == 0) {
                format.append(".");
            }
            if (i2 < fractionDigitsMin) {
                format.append("0");
            } else {
                format.append("#");
            }
            ++i2;
        }
        if (isHighlightNegativeNumbers) {
            String f = format.toString();
            format = new StringBuffer(f).append(";[RED]-").append(f);
        }
        return format.toString();
    }
}

