/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.impl.qr;

import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.google.zxing.qrcode.encoder.ByteMatrix;
import com.google.zxing.qrcode.encoder.Encoder;
import com.google.zxing.qrcode.encoder.QRCode;
import java.awt.Dimension;
import java.util.Hashtable;
import org.krysalis.barcode4j.TwoDimBarcodeLogicHandler;
import org.krysalis.barcode4j.impl.qr.QRConstants;

public class QRLogicImpl
implements QRConstants {
    public void generateBarcodeLogic(TwoDimBarcodeLogicHandler logic, String msg, String encoding, char errorCorrectionLevel, Dimension minSize, Dimension maxSize) {
        ErrorCorrectionLevel zxingErrLevel = QRLogicImpl.getZXingErrorLevel(errorCorrectionLevel);
        Hashtable<EncodeHintType, String> hints = QRLogicImpl.createHints(encoding);
        QRCode code = new QRCode();
        try {
            code = Encoder.encode((String)msg, (ErrorCorrectionLevel)zxingErrLevel, hints);
        }
        catch (WriterException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        ByteMatrix matrix = code.getMatrix();
        logic.startBarcode(msg, msg);
        this.encodeLowLevel(logic, matrix);
        logic.endBarcode();
    }

    static Hashtable<EncodeHintType, String> createHints(String encoding) {
        Hashtable<EncodeHintType, String> hints = null;
        if (!"ISO-8859-1".equals(encoding)) {
            hints = new Hashtable<EncodeHintType, String>();
            hints.put(EncodeHintType.CHARACTER_SET, encoding);
        }
        return hints;
    }

    static ErrorCorrectionLevel getZXingErrorLevel(char errorCorrectionLevel) {
        ErrorCorrectionLevel zxingErrLevel;
        switch (errorCorrectionLevel) {
            case 'L': {
                zxingErrLevel = ErrorCorrectionLevel.L;
                break;
            }
            case 'M': {
                zxingErrLevel = ErrorCorrectionLevel.M;
                break;
            }
            case 'Q': {
                zxingErrLevel = ErrorCorrectionLevel.Q;
                break;
            }
            case 'H': {
                zxingErrLevel = ErrorCorrectionLevel.H;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid error correction level: " + errorCorrectionLevel);
            }
        }
        return zxingErrLevel;
    }

    private void encodeLowLevel(TwoDimBarcodeLogicHandler logic, ByteMatrix matrix) {
        int symbolWidth = matrix.getWidth();
        int symbolHeight = matrix.getHeight();
        int y = 0;
        while (y < symbolHeight) {
            logic.startRow();
            int x = 0;
            while (x < symbolWidth) {
                logic.addBar(matrix.get(x, y) == 1, 1);
                ++x;
            }
            logic.endRow();
            ++y;
        }
    }
}

