/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.process;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.adempiere.exceptions.DBException;
import org.compiere.model.MChangeLog;
import org.compiere.model.MColumn;
import org.compiere.model.MProcessPara;
import org.compiere.model.MTable;
import org.compiere.model.MUser;
import org.compiere.model.MVerifyMigration;
import org.compiere.model.MViewColumn;
import org.compiere.model.MViewComponent;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Msg;

@Process
public class VerifyMigration
extends SvrProcess {
    private Timestamp p_DateTo = null;
    private int m_SeqNo = 0;
    int m_cnt = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] processInfoParameterArray = this.getParameter();
        int n = processInfoParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name;
            ProcessInfoParameter para = processInfoParameterArray[n2];
            switch (name = para.getParameterName()) {
                case "DateTo": {
                    this.p_DateTo = para.getParameterAsTimestamp();
                    break;
                }
                default: {
                    MProcessPara.validateUnknownParameter(this.getProcessInfo().getAD_Process_ID(), para);
                }
            }
            ++n2;
        }
    }

    @Override
    protected String doIt() throws Exception {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("DateTo" + this.p_DateTo);
        }
        this.verifyCustomizationsInChangeLog();
        this.verifyCustomViewColumns();
        this.addLog(this.getAD_PInstance_ID(), null, null, String.valueOf(Msg.getElement(this.getCtx(), "AD_PInstance_ID")) + " " + this.getAD_PInstance_ID(), 282, this.getAD_PInstance_ID());
        return "@Inserted@ " + this.m_cnt;
    }

    private void verifyCustomizationsInChangeLog() {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT * ");
        sql.append("FROM   AD_ChangeLog cl ");
        sql.append("WHERE  cl.AD_Client_ID = 0 ");
        sql.append("       AND cl.AD_Table_ID<=").append(999999);
        sql.append("       AND cl.Record_ID<=").append(999999);
        sql.append("       AND cl.EventChangeLog = 'U' ");
        sql.append("       AND cl.AD_ChangeLog_ID = (SELECT MAX(clm.AD_ChangeLog_ID) ");
        sql.append("                                 FROM   AD_ChangeLog clm ");
        sql.append("                                 WHERE  cl.AD_Client_ID = clm.AD_Client_ID ");
        sql.append("                                        AND cl.AD_Table_ID = clm.AD_Table_ID ");
        sql.append("                                        AND cl.Record_ID = clm.Record_ID ");
        sql.append("                                        AND cl.AD_Column_ID = clm.AD_Column_ID ");
        sql.append("                                        AND cl.EventChangeLog = clm.EventChangeLog) ");
        sql.append("ORDER  BY cl.AD_Table_ID, ");
        sql.append("          cl.AD_Column_ID, ");
        sql.append("          cl.Record_ID");
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), this.get_TrxName());){
                ResultSet rs = pstmt.executeQuery();
                while (rs.next()) {
                    MChangeLog cl = new MChangeLog(this.getCtx(), rs, this.get_TrxName());
                    MTable table2 = MTable.get(cl.getAD_Table_ID());
                    MColumn column = MColumn.get(cl.getAD_Column_ID());
                    if (!column.isAllowLogging() || !table2.isChangeLog()) continue;
                    String tabcol = String.valueOf(table2.getTableName()) + "." + column.getColumnName();
                    MUser user = MUser.get(cl.getCreatedBy());
                    PO po = table2.getPO(cl.getRecord_ID(), this.get_TrxName());
                    if (po == null) {
                        String msg = Msg.getMsg(this.getCtx(), "VM_CustomizedRecordDoesNotExist", new Object[]{tabcol, cl.getCreated(), user.getName(), cl.getRecord_ID()});
                        this.addVerifyMigration(cl.getAD_Table_ID(), cl.getAD_Column_ID(), cl.getRecord_ID(), cl.getAD_ChangeLog_ID(), msg, null, null, "5");
                        continue;
                    }
                    Object currentValue = po.get_Value(column.getColumnName());
                    String expectedValue = cl.getNewValue();
                    if (!(currentValue == null && expectedValue != null || currentValue != null && expectedValue == null) && (currentValue == null || currentValue.toString().equals(expectedValue)) || MVerifyMigration.isIgnored(cl.getAD_ChangeLog_ID(), cl.getAD_Table_ID(), cl.getAD_Column_ID(), cl.getRecord_ID(), this.get_TrxName())) continue;
                    String msg = Msg.getMsg(this.getCtx(), "VM_ExpectedValueDiffersFromCurrentValue", new Object[]{tabcol, po.toString(), cl.getCreated(), user.getName()});
                    this.addVerifyMigration(cl.getAD_Table_ID(), cl.getAD_Column_ID(), cl.getRecord_ID(), cl.getAD_ChangeLog_ID(), msg, currentValue, expectedValue, "3");
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException(e, sql.toString());
        }
    }

    private void verifyCustomViewColumns() throws SQLException {
        List viewColumns = new Query(this.getCtx(), "AD_ViewColumn", "EntityType!='D'", this.get_TrxName()).setOnlyActiveRecords(true).list();
        for (MViewColumn viewColumn : viewColumns) {
            MViewComponent viewComponent = new MViewComponent(this.getCtx(), viewColumn.getAD_ViewComponent_ID(), this.get_TrxName());
            MTable table2 = MTable.get(viewComponent.getAD_Table_ID());
            Connection conn = null;
            ResultSet rs = null;
            try {
                conn = DB.getConnection();
                DatabaseMetaData md = conn.getMetaData();
                String catalog = DB.getDatabase().getCatalog();
                String schema = DB.getDatabase().getSchema();
                String tableName = table2.getTableName();
                if (md.storesUpperCaseIdentifiers()) {
                    tableName = tableName.toUpperCase();
                } else if (md.storesLowerCaseIdentifiers()) {
                    tableName = tableName.toLowerCase();
                }
                rs = md.getColumns(catalog, schema, tableName, null);
                boolean found = false;
                while (rs.next()) {
                    String columnName = rs.getString("COLUMN_NAME");
                    if (!columnName.equalsIgnoreCase(viewColumn.getColumnName())) continue;
                    found = true;
                }
                if (!found && !MVerifyMigration.isIgnored(-1, 200088, -1, viewColumn.getAD_ViewColumn_ID(), this.get_TrxName())) {
                    String tabcol = String.valueOf(table2.getTableName()) + "." + viewColumn.getColumnName();
                    MUser user = MUser.get(viewColumn.getCreatedBy());
                    String msg = Msg.getMsg(this.getCtx(), "VM_CustomViewColumnNotInDB", new Object[]{tabcol, viewColumn.getCreated(), user.getName()});
                    this.addVerifyMigration(200088, -1, viewColumn.getAD_ViewColumn_ID(), -1, msg, null, null, "3");
                }
            }
            catch (Throwable throwable) {
                DB.close(rs);
                rs = null;
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            DB.close(rs);
            rs = null;
            if (conn == null) continue;
            try {
                conn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void addVerifyMigration(int tableId, int columnId, int recordId, int changeLogId, String msg, Object currentValue, String expectedValue, String priorityRule) {
        this.m_SeqNo += 10;
        MVerifyMigration vm = new MVerifyMigration(this.getCtx(), this.getAD_PInstance_ID(), tableId, columnId, recordId, changeLogId, msg, this.m_SeqNo, currentValue, expectedValue, priorityRule, this.get_TrxName());
        vm.saveEx();
        ++this.m_cnt;
    }
}

