/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.process;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.db.CConnection;
import org.compiere.model.MColumn;
import org.compiere.model.MProcessPara;
import org.compiere.model.MSequence;
import org.compiere.model.MTable;
import org.compiere.model.Query;
import org.compiere.model.X_AD_Package_UUID_Map;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.DB;
import org.compiere.util.Util;

@Process
public class MoveClient
extends SvrProcess {
    private boolean p_IsCopyClient;
    private String p_JDBC_URL;
    private String p_UserName;
    private String p_Password;
    private String p_TablesToExclude;
    private String p_ClientsToInclude;
    private String p_ClientsToExclude;
    private boolean p_IsValidateOnly;
    private String p_TablesToPreserveIDs;
    private String p_ClientName;
    private String p_ClientValue;
    private boolean p_IsSkipSomeValidations;
    static final String insertConversionId = "INSERT INTO T_MoveClient (AD_PInstance_ID, TableName, Source_ID, Target_ID) VALUES (?, ?, ?, ?)";
    private Connection externalConn;
    private StringBuffer p_excludeTablesWhere = new StringBuffer();
    private StringBuffer p_whereClient = new StringBuffer();
    private List<String> p_errorList = new ArrayList<String>();
    private List<String> p_tablesVerifiedList = new ArrayList<String>();
    private List<String> p_tablesToPreserveIDsList = new ArrayList<String>();
    private List<String> p_tablesToExcludeList = new ArrayList<String>();
    private List<String> p_columnsVerifiedList = new ArrayList<String>();
    private List<String> p_idSystemConversionList = new ArrayList<String>();
    private boolean p_isPreserveAll = false;

    @Override
    protected void prepare() {
        this.p_IsValidateOnly = true;
        ProcessInfoParameter[] processInfoParameterArray = this.getParameter();
        int n = processInfoParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessInfoParameter para = processInfoParameterArray[n2];
            String name = para.getParameterName();
            if ("IsCopyClient".equals(name)) {
                this.p_IsCopyClient = para.getParameterAsBoolean();
            } else if ("JDBC_URL".equals(name)) {
                this.p_JDBC_URL = para.getParameterAsString();
            } else if ("UserName".equals(name)) {
                this.p_UserName = para.getParameterAsString();
            } else if ("Password".equals(name)) {
                this.p_Password = para.getParameterAsString();
            } else if ("ClientName".equals(name)) {
                this.p_ClientName = para.getParameterAsString();
            } else if ("ClientValue".equals(name)) {
                this.p_ClientValue = para.getParameterAsString();
            } else if ("TablesToExclude".equals(name)) {
                this.p_TablesToExclude = para.getParameterAsString();
            } else if ("ClientsToInclude".equals(name)) {
                this.p_ClientsToInclude = para.getParameterAsString();
            } else if ("ClientsToExclude".equals(name)) {
                this.p_ClientsToExclude = para.getParameterAsString();
            } else if ("IsValidateOnly".equals(name)) {
                this.p_IsValidateOnly = para.getParameterAsBoolean();
            } else if ("IsPreserveIDs".equals(name)) {
                this.p_TablesToPreserveIDs = para.getParameterAsString();
            } else if ("IsSkipSomeValidations".equals(name)) {
                this.p_IsSkipSomeValidations = para.getParameterAsBoolean();
            } else {
                MProcessPara.validateUnknownParameter(this.getProcessInfo().getAD_Process_ID(), para);
            }
            ++n2;
        }
    }

    @Override
    protected String doIt() throws Exception {
        int n;
        int n2;
        String[] stringArray;
        if (this.p_IsCopyClient) {
            if (!Util.isEmpty(this.p_ClientsToExclude, true)) {
                throw new AdempiereException("Tenants to exclude must be empty when copying from template");
            }
            if (!Util.isEmpty(this.p_TablesToPreserveIDs, true)) {
                throw new AdempiereException("Preserve IDs must be empty when copying from template");
            }
            try {
                Integer.parseInt(this.p_ClientsToInclude);
            }
            catch (NumberFormatException e) {
                throw new AdempiereException("Error in parameter Tenants to Include, must be just one integer");
            }
        } else if (Util.isEmpty(this.p_JDBC_URL, true)) {
            throw new AdempiereException("Fill mandatory JDBC_URL");
        }
        if (!Util.isEmpty(this.p_ClientsToInclude, true) && !Util.isEmpty(this.p_ClientsToExclude, true)) {
            throw new AdempiereException("Tenants to exclude and include cannot be used at the same time");
        }
        if (Util.isEmpty(this.p_UserName, true)) {
            this.p_UserName = CConnection.get().getDbUid();
        }
        if (Util.isEmpty(this.p_Password, true)) {
            this.p_Password = CConnection.get().getDbPwd();
        }
        this.p_excludeTablesWhere.append("(UPPER(AD_Table.TableName) NOT LIKE 'T|_%' ESCAPE '|'");
        if (this.p_IsCopyClient) {
            this.p_excludeTablesWhere.append(" AND UPPER(TableName) != 'AD_CHANGELOG'");
        }
        if (Util.isEmpty(this.p_TablesToExclude, true)) {
            this.p_excludeTablesWhere.append(")");
        } else {
            this.p_excludeTablesWhere.append(" AND UPPER(TableName) NOT IN (");
            boolean addComma = false;
            stringArray = this.p_TablesToExclude.split(",");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                String tableName = stringArray[n];
                this.p_tablesToExcludeList.add(tableName.toUpperCase());
                if (addComma) {
                    this.p_excludeTablesWhere.append(",");
                } else {
                    addComma = true;
                }
                this.p_excludeTablesWhere.append(DB.TO_STRING(tableName.toUpperCase()));
                ++n;
            }
            this.p_excludeTablesWhere.append("))");
        }
        this.p_whereClient.append("AD_Client.AD_Client_ID NOT IN (0");
        if (!Util.isEmpty(this.p_ClientsToExclude, true)) {
            String[] stringArray2 = this.p_ClientsToExclude.split(",");
            n = stringArray2.length;
            int tableName = 0;
            while (tableName < n) {
                int clientInt;
                String clientStr = stringArray2[tableName];
                this.p_whereClient.append(",");
                try {
                    clientInt = Integer.parseInt(clientStr);
                }
                catch (NumberFormatException e) {
                    throw new AdempiereException("Error in parameter Tenants to Exclude, must be a list of integer separated by commas, wrong format: " + clientStr);
                }
                this.p_whereClient.append(clientInt);
                ++tableName;
            }
        }
        this.p_whereClient.append(")");
        if (!Util.isEmpty(this.p_ClientsToInclude, true)) {
            this.p_whereClient.append(" AND AD_Client.AD_Client_ID IN (");
            boolean addComma = false;
            stringArray = this.p_ClientsToInclude.split(",");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                int clientInt;
                String clientStr = stringArray[n];
                if (addComma) {
                    this.p_whereClient.append(",");
                } else {
                    addComma = true;
                }
                try {
                    clientInt = Integer.parseInt(clientStr);
                }
                catch (NumberFormatException e) {
                    throw new AdempiereException("Error in parameter Tenants to Include, must be a list of integer separated by commas, wrong format: " + clientStr);
                }
                this.p_whereClient.append(clientInt);
                ++n;
            }
            this.p_whereClient.append(")");
        }
        if (!Util.isEmpty(this.p_TablesToPreserveIDs, true)) {
            if ("*".equals(this.p_TablesToPreserveIDs)) {
                this.p_isPreserveAll = true;
            } else {
                this.p_isPreserveAll = false;
                String[] stringArray3 = this.p_TablesToPreserveIDs.split(",");
                n = stringArray3.length;
                int n3 = 0;
                while (n3 < n) {
                    String tableName = stringArray3[n3];
                    this.p_tablesToPreserveIDsList.add(tableName.toUpperCase());
                    ++n3;
                }
            }
        }
        this.externalConn = null;
        try {
            try {
                this.externalConn = this.p_IsCopyClient ? DB.getConnection() : DB.getDatabase(this.p_JDBC_URL).getDriverConnection(this.p_JDBC_URL, this.p_UserName, this.p_Password);
            }
            catch (Exception e) {
                throw new AdempiereException("Could not get a connection to " + this.p_JDBC_URL + ",\nCause: " + e.getLocalizedMessage());
            }
            this.validate();
            if (this.p_errorList.size() > 0) {
                for (String err : this.p_errorList) {
                    this.addLog(err);
                }
                return "@Error@";
            }
            if (!this.p_IsValidateOnly) {
                this.moveClient();
            }
        }
        finally {
            if (this.externalConn != null) {
                this.externalConn.close();
            }
        }
        this.checkSequences();
        return "@OK@";
    }

    private void validate() {
        if (this.p_IsCopyClient) {
            int cntCN = DB.getSQLValueEx(this.get_TrxName(), "SELECT COUNT(*) FROM AD_Client WHERE Name=?", this.p_ClientName);
            if (cntCN > 0) {
                throw new AdempiereUserError("Tenant with name " + this.p_ClientName + " already exists in database");
            }
            int cntCV = DB.getSQLValueEx(this.get_TrxName(), "SELECT COUNT(*) FROM AD_Client WHERE Value=?", this.p_ClientValue);
            if (cntCV > 0) {
                throw new AdempiereUserError("Tenant with search key " + this.p_ClientValue + " already exists in database");
            }
            int cntCW = DB.getSQLValueEx(this.get_TrxName(), "SELECT COUNT(*) FROM W_Store WHERE WebContext=?", this.p_ClientValue.toLowerCase());
            if (cntCW > 0) {
                throw new AdempiereUserError("WebStore with context " + this.p_ClientValue.toLowerCase() + " already exists in database");
            }
        }
        StringBuilder sqlValidClientsSB = new StringBuilder().append("SELECT AD_Client_ID, Value, Name, AD_Client_UU FROM AD_Client WHERE ").append(this.p_whereClient).append(" ORDER BY Value");
        StringBuilder sqlValidateLocalClient = new StringBuilder().append("SELECT COUNT(*) FROM AD_Client WHERE Value=? OR Name=? OR AD_Client_UU=?");
        if (this.p_isPreserveAll || this.p_tablesToPreserveIDsList.contains("AD_CLIENT")) {
            sqlValidateLocalClient.append(" OR AD_Client_ID=?");
        }
        String sqlValidClients = DB.getDatabase().convertStatement(sqlValidClientsSB.toString());
        PreparedStatement stmtVC = null;
        ResultSet rsVC = null;
        int noClients = 0;
        try {
            try {
                stmtVC = this.externalConn.prepareStatement(sqlValidClients, 1003, 1007);
                rsVC = stmtVC.executeQuery();
                while (rsVC.next()) {
                    ++noClients;
                    int clientID = rsVC.getInt(1);
                    String clientValue = rsVC.getString(2);
                    String clientName = rsVC.getString(3);
                    String clientUUID = rsVC.getString(4);
                    if (this.p_IsCopyClient) continue;
                    int cnt = 0;
                    cnt = this.p_isPreserveAll || this.p_tablesToPreserveIDsList.contains("AD_CLIENT") ? DB.getSQLValueEx(this.get_TrxName(), sqlValidateLocalClient.toString(), clientValue, clientName, clientUUID, clientID) : DB.getSQLValueEx(this.get_TrxName(), sqlValidateLocalClient.toString(), clientValue, clientName, clientUUID);
                    if (cnt <= 0) continue;
                    String msg = "Tenant " + clientValue + "/" + clientName + " already exists.  UUID=" + clientUUID;
                    if (this.p_isPreserveAll || this.p_tablesToPreserveIDsList.contains("AD_CLIENT")) {
                        msg = String.valueOf(msg) + ", ID=" + clientID;
                    }
                    this.p_errorList.add(msg);
                }
            }
            catch (SQLException e) {
                throw new AdempiereException("Could not execute external query: " + sqlValidClients + "\nCause = " + e.getLocalizedMessage());
            }
        }
        catch (Throwable throwable) {
            DB.close(rsVC, stmtVC);
            throw throwable;
        }
        DB.close(rsVC, stmtVC);
        if (noClients <= 0) {
            throw new AdempiereUserError("No tenants to move");
        }
        if (this.p_errorList.size() > 0) {
            return;
        }
        if (!this.p_excludeTablesWhere.toString().contains("'AD_ATTACHMENT'")) {
            this.statusUpdate("Checking storage for attachments");
            StringBuilder sqlExternalAttachment = new StringBuilder().append("SELECT COUNT(*) FROM AD_Attachment").append(" JOIN AD_Client ON (AD_Attachment.AD_Client_ID=AD_Client.AD_Client_ID)").append(" JOIN AD_ClientInfo ON (AD_Attachment.AD_Client_ID=AD_ClientInfo.AD_Client_ID)").append(" JOIN AD_Table ON (AD_Attachment.AD_Table_ID=AD_Table.AD_Table_ID)").append(" LEFT JOIN AD_StorageProvider ON (AD_StorageProvider.AD_StorageProvider_ID=AD_ClientInfo.AD_StorageProvider_ID)").append(" WHERE AD_StorageProvider.Method IS NOT NULL AND AD_StorageProvider.Method!='DB'").append(" AND ").append(this.p_whereClient).append(" AND ").append(this.p_excludeTablesWhere);
            int cntES = this.countInExternal(sqlExternalAttachment.toString());
            if (cntES > 0) {
                throw new AdempiereUserError("There are attachments using external storage provider - that's not implemented yet");
            }
        }
        if (!this.p_excludeTablesWhere.toString().contains("'AD_ARCHIVE'")) {
            this.statusUpdate("Checking storage for archives");
            StringBuilder sqlExternalArchive = new StringBuilder().append("SELECT COUNT(*) FROM AD_Archive").append(" JOIN AD_Client ON (AD_Archive.AD_Client_ID=AD_Client.AD_Client_ID)").append(" JOIN AD_ClientInfo ON (AD_Archive.AD_Client_ID=AD_ClientInfo.AD_Client_ID)").append(" JOIN AD_Table ON (AD_Archive.AD_Table_ID=AD_Table.AD_Table_ID)").append(" LEFT JOIN AD_StorageProvider ON (AD_StorageProvider.AD_StorageProvider_ID=AD_ClientInfo.StorageArchive_ID)").append(" WHERE AD_StorageProvider.Method IS NOT NULL AND AD_StorageProvider.Method!='DB'").append(" AND ").append(this.p_whereClient).append(" AND ").append(this.p_excludeTablesWhere);
            int cntEA = this.countInExternal(sqlExternalArchive.toString());
            if (cntEA > 0) {
                throw new AdempiereUserError("There are archives using external storage provider - that's not implemented yet");
            }
        }
        StringBuilder sqlTablesSB = new StringBuilder().append("SELECT TableName FROM AD_Table WHERE IsActive='Y' AND IsView='N' AND ").append(this.p_excludeTablesWhere).append(" ORDER BY TableName");
        String sqlRemoteTables = DB.getDatabase().convertStatement(sqlTablesSB.toString());
        PreparedStatement stmtRT = null;
        ResultSet rsRT = null;
        try {
            try {
                stmtRT = this.externalConn.prepareStatement(sqlRemoteTables, 1003, 1007);
                rsRT = stmtRT.executeQuery();
                while (rsRT.next()) {
                    String tableName = rsRT.getString(1);
                    this.validateExternalTable(tableName);
                }
            }
            catch (SQLException e) {
                throw new AdempiereException("Could not execute external query: " + sqlRemoteTables + "\nCause = " + e.getLocalizedMessage());
            }
        }
        catch (Throwable throwable) {
            DB.close(rsRT, stmtRT);
            throw throwable;
        }
        DB.close(rsRT, stmtRT);
        if (!this.p_IsSkipSomeValidations) {
            for (String tableName : this.p_tablesVerifiedList) {
                this.validateOrphan(tableName);
            }
        }
    }

    private void validateExternalTable(String tableName) {
        MTable localTable;
        this.statusUpdate("Validating table " + tableName);
        if (!"AD_Client".equalsIgnoreCase(tableName)) {
            StringBuilder sqlCountData = new StringBuilder().append("SELECT COUNT(*) FROM ").append(tableName);
            if ("AD_Attribute_Value".equalsIgnoreCase(tableName)) {
                sqlCountData.append(" JOIN AD_Attribute ON (AD_Attribute_Value.AD_Attribute_ID=AD_Attribute.AD_Attribute_ID)");
                sqlCountData.append(" JOIN AD_Client ON (AD_Attribute.AD_Client_ID=AD_Client.AD_Client_ID)");
            } else if ("AD_PInstance_Log".equalsIgnoreCase(tableName)) {
                sqlCountData.append(" JOIN AD_PInstance ON (AD_PInstance_Log.AD_PInstance_ID=AD_PInstance.AD_PInstance_ID)");
                sqlCountData.append(" JOIN AD_Client ON (AD_PInstance.AD_Client_ID=AD_Client.AD_Client_ID)");
            } else {
                sqlCountData.append(" JOIN AD_Client ON (").append(tableName).append(".AD_Client_ID=AD_Client.AD_Client_ID)");
            }
            sqlCountData.append(" WHERE ").append(this.p_whereClient);
            int cntCD = this.countInExternal(sqlCountData.toString());
            if (cntCD == 0) {
                if (this.log.isLoggable(Level.INFO)) {
                    this.log.info("Ignoring " + tableName + ", doesn't have tenant data");
                }
                return;
            }
            if (cntCD > 0 && "AD_Attribute_Value".equalsIgnoreCase(tableName)) {
                throw new AdempiereUserError("Table " + tableName + " has data, migration not supported");
            }
        }
        if ((localTable = MTable.get(this.getCtx(), tableName)) == null || localTable.getAD_Table_ID() <= 0) {
            this.p_errorList.add("Table " + tableName + " doesn't exist");
            return;
        }
        String sqlRemoteColumnsST = " SELECT AD_Column.ColumnName, AD_Column.AD_Reference_ID, AD_Column.FieldLength FROM AD_Column JOIN AD_Table ON (AD_Table.AD_Table_ID=AD_Column.AD_Table_ID) WHERE UPPER(AD_Table.TableName)=? AND AD_Column.IsActive='Y' AND AD_Column.ColumnSQL IS NULL ORDER BY AD_Column.ColumnName";
        String sqlRemoteColumns = DB.getDatabase().convertStatement(" SELECT AD_Column.ColumnName, AD_Column.AD_Reference_ID, AD_Column.FieldLength FROM AD_Column JOIN AD_Table ON (AD_Table.AD_Table_ID=AD_Column.AD_Table_ID) WHERE UPPER(AD_Table.TableName)=? AND AD_Column.IsActive='Y' AND AD_Column.ColumnSQL IS NULL ORDER BY AD_Column.ColumnName");
        PreparedStatement stmtRC = null;
        ResultSet rsRC = null;
        try {
            try {
                stmtRC = this.externalConn.prepareStatement(sqlRemoteColumns, 1003, 1007);
                stmtRC.setString(1, tableName.toUpperCase());
                rsRC = stmtRC.executeQuery();
                while (rsRC.next()) {
                    String columnName = rsRC.getString(1);
                    int refID = rsRC.getInt(2);
                    int length = rsRC.getInt(3);
                    if (columnName.equalsIgnoreCase("AD_Client_ID")) {
                        this.p_columnsVerifiedList.add(String.valueOf(tableName.toUpperCase()) + "." + columnName.toUpperCase());
                        continue;
                    }
                    this.validateExternalColumn(tableName, columnName, refID, length);
                }
            }
            catch (SQLException e) {
                throw new AdempiereException("Could not execute external query: " + sqlRemoteColumns + "\nCause = " + e.getLocalizedMessage());
            }
        }
        catch (Throwable throwable) {
            DB.close(rsRC, stmtRC);
            throw throwable;
        }
        DB.close(rsRC, stmtRC);
        this.p_tablesVerifiedList.add(tableName.toUpperCase());
    }

    private void validateExternalColumn(String tableName, String columnName, int refID, int length) {
        int cntET;
        int cntMI;
        MColumn localColumn = MColumn.get(this.getCtx(), tableName, columnName);
        if (localColumn == null || localColumn.getAD_Column_ID() <= 0) {
            this.p_errorList.add("Column " + tableName + "." + columnName + " doesn't exist");
            return;
        }
        if (refID <= 999999 && localColumn.getAD_Reference_ID() <= 999999 && refID != localColumn.getAD_Reference_ID()) {
            this.p_errorList.add("Column " + tableName + "." + columnName + " has different type in dictionary, external: " + refID + ", local: " + localColumn.getAD_Reference_ID());
        }
        if (length != localColumn.getFieldLength()) {
            this.p_errorList.add("Column " + tableName + "." + columnName + " has different length in dictionary, external: " + length + ", local: " + localColumn.getFieldLength());
        }
        StringBuilder sqlDataNotNullInColumn = new StringBuilder().append("SELECT COUNT(*) FROM ").append(tableName).append(" JOIN AD_Client ON (").append(tableName).append(".AD_Client_ID=AD_Client.AD_Client_ID)").append(" WHERE ").append(tableName).append(".").append(columnName).append(" IS NOT NULL").append(" AND ").append(this.p_whereClient);
        if ((refID == 200127 || refID == 200128) && (cntMI = this.countInExternal(sqlDataNotNullInColumn.toString())) > 0) {
            throw new AdempiereUserError("There is data in unsupported Multi-ID column " + tableName + "." + columnName);
        }
        if (!this.p_IsSkipSomeValidations && refID > 999999 && (cntET = this.countInExternal(sqlDataNotNullInColumn.toString())) > 0) {
            throw new AdempiereUserError("There is data in unsupported non-official data type for column " + tableName + "." + columnName);
        }
        String foreignTable = localColumn.getReferenceTableName();
        if (foreignTable != null && (foreignTable.equalsIgnoreCase(tableName) || "AD_PInstance_Log".equalsIgnoreCase(tableName))) {
            foreignTable = "";
        } else if ("C_BPartner".equalsIgnoreCase(tableName) && "AD_OrgBP_ID".equalsIgnoreCase(columnName)) {
            foreignTable = "AD_Org";
        } else if ("C_Project".equalsIgnoreCase(tableName) && "C_ProjectType_ID".equalsIgnoreCase(columnName)) {
            foreignTable = "C_ProjectType";
        }
        if (!Util.isEmpty(foreignTable)) {
            String uuidCol = MTable.getUUIDColumnName(foreignTable);
            StringBuilder sqlForeignClientSB = new StringBuilder();
            if ("AD_Ref_List".equalsIgnoreCase(foreignTable)) {
                sqlForeignClientSB.append("SELECT DISTINCT AD_Ref_List.AD_Client_ID, AD_Ref_List.AD_Ref_List_ID, AD_Ref_List.").append(uuidCol).append(" FROM ").append(tableName);
                if (!"AD_Client".equalsIgnoreCase(tableName)) {
                    sqlForeignClientSB.append(" JOIN AD_Client ON (").append(tableName).append(".AD_Client_ID=AD_Client.AD_Client_ID)");
                }
                sqlForeignClientSB.append(" JOIN AD_Ref_List ON (").append(tableName).append(".").append(columnName).append("=AD_Ref_List.");
                if ("AD_Ref_List_ID".equalsIgnoreCase(columnName)) {
                    sqlForeignClientSB.append("AD_Ref_List_ID");
                } else {
                    sqlForeignClientSB.append("Value");
                }
                sqlForeignClientSB.append(" AND AD_Ref_List.AD_Reference_ID=").append(" (SELECT AD_Column.AD_Reference_Value_ID FROM AD_Column").append(" JOIN AD_Table ON (AD_Column.AD_Table_ID=AD_Table.AD_Table_ID)").append(" WHERE UPPER(AD_Table.TableName)='").append(tableName.toUpperCase()).append("' AND UPPER(AD_Column.ColumnName)='").append(columnName.toUpperCase()).append("'))").append(" WHERE ").append(this.p_whereClient).append(" AND ").append(foreignTable).append(".AD_Client_ID!=").append(tableName).append(".AD_Client_ID").append(" ORDER BY 2");
            } else {
                sqlForeignClientSB.append("SELECT DISTINCT ").append(foreignTable).append(".AD_Client_ID, ").append(foreignTable).append(".").append(foreignTable).append("_ID, ").append(foreignTable).append(".").append(uuidCol).append(" FROM ").append(tableName);
                if (!"AD_Client".equalsIgnoreCase(tableName)) {
                    sqlForeignClientSB.append(" JOIN AD_Client ON (").append(tableName).append(".AD_Client_ID=AD_Client.AD_Client_ID)");
                }
                if ("AD_Client".equalsIgnoreCase(foreignTable)) {
                    sqlForeignClientSB.append(" JOIN ").append(foreignTable).append(" c ON (").append(tableName).append(".").append(columnName).append("=c.");
                } else {
                    sqlForeignClientSB.append(" JOIN ").append(foreignTable).append(" ON (").append(tableName).append(".").append(columnName).append("=").append(foreignTable).append(".");
                }
                if ("AD_Language".equalsIgnoreCase(foreignTable) && !columnName.equalsIgnoreCase("AD_Language_ID")) {
                    sqlForeignClientSB.append("AD_Language");
                } else if ("AD_EntityType".equalsIgnoreCase(foreignTable) && !columnName.equalsIgnoreCase("AD_EntityType_ID")) {
                    sqlForeignClientSB.append("EntityType");
                } else {
                    sqlForeignClientSB.append(foreignTable).append("_ID");
                }
                sqlForeignClientSB.append(")").append(" WHERE ").append(this.p_whereClient).append(" AND ").append(foreignTable).append(".AD_Client_ID!=").append(tableName).append(".AD_Client_ID").append(" ORDER BY 2");
            }
            String sqlForeignClient = DB.getDatabase().convertStatement(sqlForeignClientSB.toString());
            PreparedStatement stmtFC = null;
            ResultSet rsFC = null;
            try {
                try {
                    stmtFC = this.externalConn.prepareStatement(sqlForeignClient, 1003, 1007);
                    rsFC = stmtFC.executeQuery();
                    while (rsFC.next()) {
                        int localID;
                        int clientID = rsFC.getInt(1);
                        int foreignID = rsFC.getInt(2);
                        String foreignUU = rsFC.getString(3);
                        if (clientID > 0) {
                            this.p_errorList.add("Column " + tableName + "." + columnName + " has invalid cross-tenant reference to tenant " + clientID + " on ID=" + foreignID);
                            continue;
                        }
                        if (foreignID > 0 && !this.p_idSystemConversionList.contains(String.valueOf(foreignTable.toUpperCase()) + "." + foreignID) && (localID = this.getFromUUID(foreignTable, uuidCol, tableName, columnName, foreignUU, foreignID)) >= 0) continue;
                    }
                }
                catch (SQLException e) {
                    throw new AdempiereException("Could not execute external query: " + sqlForeignClient + "\nCause = " + e.getLocalizedMessage());
                }
            }
            catch (Throwable throwable) {
                DB.close(rsFC, stmtFC);
                throw throwable;
            }
            DB.close(rsFC, stmtFC);
        }
        this.p_columnsVerifiedList.add(String.valueOf(tableName.toUpperCase()) + "." + columnName.toUpperCase());
    }

    private void validateOrphan(String tableName) {
        MTable table2 = MTable.get(this.getCtx(), tableName);
        MColumn[] mColumnArray = table2.getColumns(false);
        int n = mColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            String columnName;
            MColumn column = mColumnArray[n2];
            if (column.isActive() && column.getColumnSQL() == null && !"AD_Client_ID".equalsIgnoreCase(columnName = column.getColumnName())) {
                StringBuilder sqlVerifFKSB;
                int cntFk;
                MTable tableFK;
                String foreignTable = column.getReferenceTableName();
                if ("C_BPartner".equalsIgnoreCase(tableName) && "AD_OrgBP_ID".equalsIgnoreCase(columnName)) {
                    foreignTable = "AD_Org";
                } else if ("C_Project".equalsIgnoreCase(tableName) && "C_ProjectType_ID".equalsIgnoreCase(columnName)) {
                    foreignTable = "C_ProjectType";
                }
                if (!(Util.isEmpty(foreignTable) || "AD_Ref_List".equalsIgnoreCase(foreignTable) || (tableFK = MTable.get(this.getCtx(), foreignTable)) == null || "4".equals(tableFK.getAccessLevel()) || (cntFk = this.countInExternal((sqlVerifFKSB = new StringBuilder().append("SELECT COUNT(*) ").append("FROM   AD_Table t ").append("       JOIN AD_Column c ").append("         ON ( c.AD_Table_ID = t.AD_Table_ID ) ").append("WHERE  UPPER(t.TableName)=").append(DB.TO_STRING(tableName.toUpperCase())).append("       AND UPPER(c.ColumnName)=").append(DB.TO_STRING(columnName.toUpperCase())).append("       AND ( c.FKConstraintType IS NULL OR c.FKConstraintType=").append(DB.TO_STRING("D")).append(")")).toString())) <= 0)) {
                    this.statusUpdate("Validating orphans for " + table2.getTableName() + "." + columnName);
                    StringBuilder sqlExternalOrgOrphanSB = new StringBuilder().append("SELECT COUNT(*) FROM ").append(tableName);
                    if (!"AD_Client".equalsIgnoreCase(tableName)) {
                        sqlExternalOrgOrphanSB.append(" JOIN AD_Client ON (").append(tableName).append(".AD_Client_ID=AD_Client.AD_Client_ID)");
                    }
                    sqlExternalOrgOrphanSB.append(" WHERE ").append(tableName).append(".").append(columnName).append(">0 AND ").append(" ").append(tableName).append(".").append(columnName).append(" NOT IN (").append(" SELECT ").append(foreignTable).append(".").append(foreignTable).append("_ID").append(" FROM ").append(foreignTable).append(" WHERE ").append(foreignTable).append(".AD_Client_ID IN (0,").append(tableName).append(".AD_Client_ID)").append(")").append(" AND ").append(this.p_whereClient);
                    int cntOr = this.countInExternal(sqlExternalOrgOrphanSB.toString());
                    if (cntOr > 0) {
                        this.p_errorList.add("Column " + tableName + "." + columnName + " has orphan records in table " + foreignTable);
                    }
                }
            }
            ++n2;
        }
    }

    private int countInExternal(String sql) {
        int cnt = 0;
        sql = DB.getDatabase().convertStatement(sql);
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                stmt = this.externalConn.prepareStatement(sql, 1003, 1007);
                rs = stmt.executeQuery();
                if (rs.next()) {
                    cnt = rs.getInt(1);
                }
            }
            catch (SQLException e) {
                throw new AdempiereException("Could not execute external query: " + sql + "\nCause = " + e.getLocalizedMessage());
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, stmt);
            throw throwable;
        }
        DB.close(rs, stmt);
        return cnt;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void moveClient() {
        List tables = new Query(this.getCtx(), "AD_Table", "IsView='N' AND " + this.p_excludeTablesWhere, this.get_TrxName()).setOnlyActiveRecords(true).setOrderBy("TableName").list();
        for (MTable table2 : tables) {
            String tableName = table2.getTableName();
            if (!this.p_tablesVerifiedList.contains(tableName.toUpperCase()) || !this.p_columnsVerifiedList.contains(String.valueOf(tableName.toUpperCase()) + "." + tableName.toUpperCase() + "_ID")) continue;
            this.statusUpdate("Converting IDs for table " + tableName);
            StringBuilder selectVerifyIdSB = new StringBuilder().append("SELECT ").append(tableName).append("_ID FROM ").append(tableName).append(" WHERE ").append(tableName).append("_ID=?");
            StringBuilder selectGetIdsSB = new StringBuilder().append("SELECT ").append(tableName).append(".").append(tableName).append("_ID FROM ").append(tableName);
            if (!"AD_Client".equalsIgnoreCase(tableName)) {
                selectGetIdsSB.append(" JOIN AD_Client ON (").append(tableName).append(".AD_Client_ID=AD_Client.AD_Client_ID)");
            }
            selectGetIdsSB.append(" WHERE ").append(this.p_whereClient).append(" ORDER BY ").append(tableName).append("_ID");
            String selectGetIds = DB.getDatabase().convertStatement(selectGetIdsSB.toString());
            PreparedStatement stmtGI = null;
            ResultSet rsGI = null;
            try {
                try {
                    stmtGI = this.externalConn.prepareStatement(selectGetIds, 1003, 1007);
                    rsGI = stmtGI.executeQuery();
                    while (rsGI.next()) {
                        int sourceID = rsGI.getInt(1);
                        int targetID = -1;
                        if (this.p_isPreserveAll || this.p_tablesToPreserveIDsList.contains(tableName.toUpperCase())) {
                            int localID = DB.getSQLValueEx(this.get_TrxName(), selectVerifyIdSB.toString(), sourceID);
                            if (localID >= 0) throw new AdempiereException("In " + tableName + "." + tableName + "_ID already exist the ID=" + sourceID);
                            targetID = sourceID;
                        } else if ("AD_ChangeLog".equalsIgnoreCase(tableName)) {
                            int clId = DB.getSQLValueEx(this.get_TrxName(), "SELECT Target_ID FROM T_MoveClient WHERE AD_PInstance_ID=? AND TableName=? AND Source_ID=?", this.getAD_PInstance_ID(), "AD_CHANGELOG", sourceID);
                            if (clId == -1) {
                                targetID = DB.getNextID(this.getAD_Client_ID(), tableName, this.get_TrxName());
                            }
                        } else {
                            targetID = DB.getNextID(this.getAD_Client_ID(), tableName, this.get_TrxName());
                        }
                        if (targetID < 0) continue;
                        DB.executeUpdateEx(insertConversionId, new Object[]{this.getAD_PInstance_ID(), tableName.toUpperCase(), sourceID, targetID}, this.get_TrxName());
                    }
                }
                catch (SQLException e) {
                    throw new AdempiereException("Could not execute external query: " + selectGetIds + "\nCause = " + e.getLocalizedMessage());
                }
            }
            catch (Throwable throwable) {
                DB.close(rsGI, stmtGI);
                throw throwable;
            }
            DB.close(rsGI, stmtGI);
        }
        try {
            this.commitEx();
        }
        catch (SQLException e1) {
            throw new AdempiereException(e1);
        }
        int newADClientID = -1;
        String oldClientValue = null;
        if (this.p_IsCopyClient) {
            int clientInt;
            try {
                clientInt = Integer.parseInt(this.p_ClientsToInclude);
            }
            catch (NumberFormatException e) {
                throw new AdempiereException("Error in parameter Tenants to Include, must be just one integer");
            }
            newADClientID = DB.getSQLValueEx(this.get_TrxName(), "SELECT Target_ID FROM T_MoveClient WHERE AD_PInstance_ID=? AND TableName=? AND Source_ID=?", this.getAD_PInstance_ID(), "AD_CLIENT", clientInt);
            oldClientValue = DB.getSQLValueStringEx(this.get_TrxName(), "SELECT Value FROM AD_Client WHERE AD_Client_ID=?", clientInt);
        }
        for (MTable table3 : tables) {
            String tableName = table3.getTableName();
            if (!this.p_tablesVerifiedList.contains(tableName.toUpperCase())) continue;
            this.statusUpdate("Inserting data for table " + tableName);
            StringBuilder valuesSB = new StringBuilder();
            StringBuilder columnsSB = new StringBuilder();
            StringBuilder qColumnsSB = new StringBuilder();
            int ncols = 0;
            ArrayList<MColumn> columns = new ArrayList<MColumn>();
            MColumn[] mColumnArray = table3.getColumns(false);
            int n = mColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                MColumn column = mColumnArray[n2];
                if (column.isActive() && column.getColumnSQL() == null) {
                    String columnName = column.getColumnName();
                    if (this.p_columnsVerifiedList.contains(String.valueOf(tableName.toUpperCase()) + "." + columnName.toUpperCase())) {
                        if (columnsSB.length() > 0) {
                            qColumnsSB.append(",");
                            columnsSB.append(",");
                            valuesSB.append(",");
                        }
                        String quoteColumnName = DB.getDatabase().quoteColumnName(columnName);
                        qColumnsSB.append(tableName).append(".").append(quoteColumnName);
                        columnsSB.append(quoteColumnName);
                        valuesSB.append("?");
                        columns.add(column);
                        ++ncols;
                    }
                }
                ++n2;
            }
            StringBuilder insertSB = new StringBuilder().append("INSERT INTO ").append(tableName).append("(").append((CharSequence)columnsSB).append(") VALUES (").append((CharSequence)valuesSB).append(")");
            StringBuilder selectGetDataSB = new StringBuilder().append("SELECT ").append((CharSequence)qColumnsSB).append(" FROM ").append(tableName);
            if ("AD_PInstance_Log".equalsIgnoreCase(tableName)) {
                selectGetDataSB.append(" JOIN AD_PInstance ON (AD_PInstance_Log.AD_PInstance_ID=AD_PInstance.AD_PInstance_ID)");
                selectGetDataSB.append(" JOIN AD_Client ON (AD_PInstance.AD_Client_ID=AD_Client.AD_Client_ID)");
            } else if (!"AD_Client".equalsIgnoreCase(tableName)) {
                selectGetDataSB.append(" JOIN AD_Client ON (").append(tableName).append(".AD_Client_ID=AD_Client.AD_Client_ID)");
            }
            selectGetDataSB.append(" WHERE ").append(this.p_whereClient);
            String selectGetData = DB.getDatabase().convertStatement(selectGetDataSB.toString());
            PreparedStatement stmtGD = null;
            ResultSet rsGD = null;
            Object[] parameters = new Object[ncols];
            try {
                try {
                    stmtGD = this.externalConn.prepareStatement(selectGetData, 1003, 1007);
                    rsGD = stmtGD.executeQuery();
                    while (rsGD.next()) {
                        boolean insertRecord = true;
                        int i2 = 0;
                        while (i2 < ncols) {
                            MColumn column = (MColumn)columns.get(i2);
                            String columnName = column.getColumnName();
                            String convertTable = column.getReferenceTableName();
                            if ((String.valueOf(tableName) + "_ID").equalsIgnoreCase(columnName)) {
                                convertTable = tableName;
                            } else if ("C_BPartner".equalsIgnoreCase(tableName) && "AD_OrgBP_ID".equalsIgnoreCase(columnName)) {
                                convertTable = "AD_Org";
                            } else if ("C_Project".equalsIgnoreCase(tableName) && "C_ProjectType_ID".equalsIgnoreCase(columnName)) {
                                convertTable = "C_ProjectType";
                            } else if (convertTable != null && ("AD_Ref_List".equalsIgnoreCase(convertTable) || "AD_Language".equalsIgnoreCase(columnName) || "EntityType".equalsIgnoreCase(columnName))) {
                                convertTable = "";
                            } else if ("Record_ID".equalsIgnoreCase(columnName) && table3.columnExistsInDB("AD_Table_ID")) {
                                int tableId = rsGD.getInt("AD_Table_ID");
                                convertTable = tableId > 0 ? this.getExternalTableName(tableId) : "";
                            } else if ("Node_ID".equalsIgnoreCase(columnName) && "AD_TreeBar".equalsIgnoreCase(tableName)) {
                                convertTable = "AD_Menu";
                            } else if (("Node_ID".equalsIgnoreCase(columnName) || "Parent_ID".equalsIgnoreCase(columnName)) && "AD_TreeNodeMM".equalsIgnoreCase(tableName)) {
                                convertTable = "AD_Menu";
                            } else if (("Node_ID".equalsIgnoreCase(columnName) || "Parent_ID".equalsIgnoreCase(columnName)) && "AD_TreeNodeBP".equalsIgnoreCase(tableName)) {
                                convertTable = "C_BPartner";
                            } else if (("Node_ID".equalsIgnoreCase(columnName) || "Parent_ID".equalsIgnoreCase(columnName)) && "AD_TreeNodeCMC".equalsIgnoreCase(tableName)) {
                                convertTable = "CM_Container";
                            } else if (("Node_ID".equalsIgnoreCase(columnName) || "Parent_ID".equalsIgnoreCase(columnName)) && "AD_TreeNodeCMM".equalsIgnoreCase(tableName)) {
                                convertTable = "CM_Media";
                            } else if (("Node_ID".equalsIgnoreCase(columnName) || "Parent_ID".equalsIgnoreCase(columnName)) && "AD_TreeNodeCMS".equalsIgnoreCase(tableName)) {
                                convertTable = "CM_CStage";
                            } else if (("Node_ID".equalsIgnoreCase(columnName) || "Parent_ID".equalsIgnoreCase(columnName)) && "AD_TreeNodeCMT".equalsIgnoreCase(tableName)) {
                                convertTable = "CM_Template";
                            } else if (("Node_ID".equalsIgnoreCase(columnName) || "Parent_ID".equalsIgnoreCase(columnName)) && "AD_TreeNodePR".equalsIgnoreCase(tableName)) {
                                convertTable = "M_Product";
                            } else if (("Node_ID".equalsIgnoreCase(columnName) || "Parent_ID".equalsIgnoreCase(columnName)) && ("AD_TreeNodeU1".equalsIgnoreCase(tableName) || "AD_TreeNodeU2".equalsIgnoreCase(tableName) || "AD_TreeNodeU3".equalsIgnoreCase(tableName) || "AD_TreeNodeU4".equalsIgnoreCase(tableName))) {
                                convertTable = "C_ElementValue";
                            } else if (("Node_ID".equalsIgnoreCase(columnName) || "Parent_ID".equalsIgnoreCase(columnName)) && "AD_TreeNode".equalsIgnoreCase(tableName)) {
                                int treeId = rsGD.getInt("AD_Tree_ID");
                                convertTable = this.getExternalTableFromTree(treeId);
                            } else if ("AD_Preference".equalsIgnoreCase(tableName) && "Value".equalsIgnoreCase(columnName)) {
                                String att = rsGD.getString("Attribute");
                                if (att.toUpperCase().endsWith("_ID")) {
                                    convertTable = att.substring(0, att.length() - 3);
                                    if ("C_DocTypeTarget".equals(convertTable)) {
                                        convertTable = "C_DocType";
                                    } else if (MTable.getTable_ID(convertTable, this.get_TrxName()) <= 0) {
                                        convertTable = "";
                                    }
                                } else {
                                    convertTable = "";
                                }
                            }
                            if (!Util.isEmpty(convertTable)) {
                                int id = rsGD.getInt(i2 + 1);
                                if (rsGD.wasNull()) {
                                    parameters[i2] = null;
                                } else {
                                    if (!(id == 0 && ("Parent_ID".equalsIgnoreCase(columnName) || "Node_ID".equalsIgnoreCase(columnName)) || id < 999999 && !this.p_IsCopyClient)) {
                                        int convertedId = -1;
                                        String query = "SELECT Target_ID FROM T_MoveClient WHERE AD_PInstance_ID=? AND TableName=? AND Source_ID=?";
                                        try {
                                            convertedId = DB.getSQLValueEx(this.get_TrxName(), "SELECT Target_ID FROM T_MoveClient WHERE AD_PInstance_ID=? AND TableName=? AND Source_ID=?", this.getAD_PInstance_ID(), convertTable.toUpperCase(), id);
                                        }
                                        catch (Exception e) {
                                            throw new AdempiereException("Could not execute query: SELECT Target_ID FROM T_MoveClient WHERE AD_PInstance_ID=? AND TableName=? AND Source_ID=?\nCause = " + e.getLocalizedMessage());
                                        }
                                        if (convertedId < 0 && (convertedId = this.getLocalIDFor(convertTable, id, tableName)) < 0) {
                                            if (("Record_ID".equalsIgnoreCase(columnName) && table3.columnExistsInDB("AD_Table_ID") || ("Node_ID".equalsIgnoreCase(columnName) || "Parent_ID".equalsIgnoreCase(columnName)) && ("AD_TreeNode".equalsIgnoreCase(tableName) || "AD_TreeNodeMM".equalsIgnoreCase(tableName) || "AD_TreeNodeBP".equalsIgnoreCase(tableName) || "AD_TreeNodeCMC".equalsIgnoreCase(tableName) || "AD_TreeNodeCMM".equalsIgnoreCase(tableName) || "AD_TreeNodeCMS".equalsIgnoreCase(tableName) || "AD_TreeNodeCMT".equalsIgnoreCase(tableName) || "AD_TreeNodePR".equalsIgnoreCase(tableName) || "AD_TreeNodeU1".equalsIgnoreCase(tableName) || "AD_TreeNodeU2".equalsIgnoreCase(tableName) || "AD_TreeNodeU3".equalsIgnoreCase(tableName) || "AD_TreeNodeU4".equalsIgnoreCase(tableName) || "AD_TreeBar".equalsIgnoreCase(tableName))) && this.p_tablesToExcludeList.contains(convertTable.toUpperCase())) {
                                                insertRecord = false;
                                                break;
                                            }
                                            if (!"AD_ChangeLog".equalsIgnoreCase(tableName)) throw new AdempiereException("Found orphan record in " + tableName + "." + columnName + ": " + id + " related to table " + convertTable);
                                            insertRecord = false;
                                            break;
                                        }
                                        id = convertedId;
                                    }
                                    parameters[i2] = "AD_Preference".equalsIgnoreCase(tableName) && "Value".equalsIgnoreCase(columnName) ? String.valueOf(id) : Integer.valueOf(id);
                                }
                            } else {
                                parameters[i2] = rsGD.getObject(i2 + 1);
                                if (rsGD.wasNull()) {
                                    parameters[i2] = null;
                                }
                                if (this.p_IsCopyClient) {
                                    String uuidCol = MTable.getUUIDColumnName(tableName);
                                    if (columnName.equals(uuidCol)) {
                                        String oldUUID = (String)parameters[i2];
                                        String newUUID = UUID.randomUUID().toString();
                                        parameters[i2] = newUUID;
                                        if (!Util.isEmpty(oldUUID)) {
                                            X_AD_Package_UUID_Map map = new X_AD_Package_UUID_Map(this.getCtx(), 0, this.get_TrxName());
                                            map.setAD_Table_ID(table3.getAD_Table_ID());
                                            map.set_ValueNoCheck("AD_Client_ID", newADClientID);
                                            map.setSource_UUID(oldUUID);
                                            map.setTarget_UUID(newUUID);
                                            map.saveEx();
                                        }
                                    } else if ("AD_Client".equalsIgnoreCase(tableName) && "Value".equalsIgnoreCase(columnName)) {
                                        parameters[i2] = this.p_ClientValue;
                                    } else if ("AD_Client".equalsIgnoreCase(tableName) && "Name".equalsIgnoreCase(columnName)) {
                                        parameters[i2] = this.p_ClientName;
                                    } else if ("W_Store".equalsIgnoreCase(tableName) && "WebContext".equalsIgnoreCase(columnName) || "AD_User".equalsIgnoreCase(tableName) && "Value".equalsIgnoreCase(columnName)) {
                                        parameters[i2] = this.p_ClientValue.toLowerCase();
                                    } else if ("AD_User".equalsIgnoreCase(tableName) && "Password".equalsIgnoreCase(columnName) || "AD_User".equalsIgnoreCase(tableName) && "Salt".equalsIgnoreCase(columnName)) {
                                        parameters[i2] = null;
                                    } else if (("AD_Org".equalsIgnoreCase(tableName) && "Value".equalsIgnoreCase(columnName) || "AD_Org".equalsIgnoreCase(tableName) && "Name".equalsIgnoreCase(columnName) || "AD_Role".equalsIgnoreCase(tableName) && "Name".equalsIgnoreCase(columnName) || "AD_Tree".equalsIgnoreCase(tableName) && "Name".equalsIgnoreCase(columnName) || "AD_User".equalsIgnoreCase(tableName) && "Name".equalsIgnoreCase(columnName) || "AD_User".equalsIgnoreCase(tableName) && "Description".equalsIgnoreCase(columnName) || "C_AcctProcessor".equalsIgnoreCase(tableName) && "Name".equalsIgnoreCase(columnName) || "C_AcctSchema".equalsIgnoreCase(tableName) && "Name".equalsIgnoreCase(columnName) || "C_BPartner".equalsIgnoreCase(tableName) && "Value".equalsIgnoreCase(columnName) || "C_BPartner".equalsIgnoreCase(tableName) && "Name".equalsIgnoreCase(columnName) || "C_Calendar".equalsIgnoreCase(tableName) && "Name".equalsIgnoreCase(columnName) || "C_Element".equalsIgnoreCase(tableName) && "Name".equalsIgnoreCase(columnName) || "M_CostType".equalsIgnoreCase(tableName) && "Name".equalsIgnoreCase(columnName) || "R_RequestProcessor".equalsIgnoreCase(tableName) && "Name".equalsIgnoreCase(columnName)) && parameters[i2] != null) {
                                        String value = parameters[i2].toString();
                                        parameters[i2] = value.replaceFirst(oldClientValue, this.p_ClientValue);
                                    }
                                }
                            }
                            ++i2;
                        }
                        if (!insertRecord) continue;
                        try {
                            DB.executeUpdateEx(insertSB.toString(), parameters, this.get_TrxName());
                        }
                        catch (Exception e) {
                            throw new AdempiereException("Could not execute: " + insertSB + "\nCause = " + e.getLocalizedMessage());
                        }
                    }
                }
                catch (SQLException e) {
                    throw new AdempiereException("Could not execute external query: " + selectGetData + "\nCause = " + e.getLocalizedMessage());
                }
            }
            catch (Throwable throwable) {
                DB.close(rsGD, stmtGD);
                throw throwable;
            }
            DB.close(rsGD, stmtGD);
        }
        this.statusUpdate("Committing.  Validating foreign keys");
        try {
            this.commitEx();
            return;
        }
        catch (SQLException e) {
            throw new AdempiereException("Could not commit,\nCause: " + e.getLocalizedMessage());
        }
    }

    private String getExternalTableFromTree(int treeId) {
        String tableName = null;
        String sqlTableTree = "SELECT CASE          WHEN TreeType = 'AY' THEN 'C_Activity'          WHEN TreeType = 'BB' THEN 'M_BOM'          WHEN TreeType = 'BP' THEN 'C_BPartner'          WHEN TreeType = 'CC' THEN 'CM_Container'          WHEN TreeType = 'CM' THEN 'CM_Media'          WHEN TreeType = 'CS' THEN 'CM_CStage'          WHEN TreeType = 'CT' THEN 'CM_Template'          WHEN TreeType = 'EV' THEN 'C_ElementValue'          WHEN TreeType = 'MC' THEN 'C_Campaign'          WHEN TreeType = 'MM' THEN 'AD_Menu'          WHEN TreeType = 'OO' THEN 'AD_Org'          WHEN TreeType = 'PC' THEN 'M_Product_Category'          WHEN TreeType = 'PJ' THEN 'C_Project'          WHEN TreeType = 'PR' THEN 'M_Product'          WHEN TreeType = 'SR' THEN 'C_SalesRegion'          WHEN TreeType = 'U1' THEN 'C_ElementValue'          WHEN TreeType = 'U2' THEN 'C_ElementValue'          WHEN TreeType = 'U3' THEN 'C_ElementValue'          WHEN TreeType = 'U4' THEN 'C_ElementValue'          WHEN TreeType = 'TL' THEN AD_Table.TableName          ELSE NULL        END FROM   AD_Tree        LEFT JOIN AD_Table ON ( AD_Table.AD_Table_ID = AD_Tree.AD_Table_ID ) WHERE  AD_Tree_ID = ?";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                stmt = this.externalConn.prepareStatement("SELECT CASE          WHEN TreeType = 'AY' THEN 'C_Activity'          WHEN TreeType = 'BB' THEN 'M_BOM'          WHEN TreeType = 'BP' THEN 'C_BPartner'          WHEN TreeType = 'CC' THEN 'CM_Container'          WHEN TreeType = 'CM' THEN 'CM_Media'          WHEN TreeType = 'CS' THEN 'CM_CStage'          WHEN TreeType = 'CT' THEN 'CM_Template'          WHEN TreeType = 'EV' THEN 'C_ElementValue'          WHEN TreeType = 'MC' THEN 'C_Campaign'          WHEN TreeType = 'MM' THEN 'AD_Menu'          WHEN TreeType = 'OO' THEN 'AD_Org'          WHEN TreeType = 'PC' THEN 'M_Product_Category'          WHEN TreeType = 'PJ' THEN 'C_Project'          WHEN TreeType = 'PR' THEN 'M_Product'          WHEN TreeType = 'SR' THEN 'C_SalesRegion'          WHEN TreeType = 'U1' THEN 'C_ElementValue'          WHEN TreeType = 'U2' THEN 'C_ElementValue'          WHEN TreeType = 'U3' THEN 'C_ElementValue'          WHEN TreeType = 'U4' THEN 'C_ElementValue'          WHEN TreeType = 'TL' THEN AD_Table.TableName          ELSE NULL        END FROM   AD_Tree        LEFT JOIN AD_Table ON ( AD_Table.AD_Table_ID = AD_Tree.AD_Table_ID ) WHERE  AD_Tree_ID = ?", 1003, 1007);
                stmt.setInt(1, treeId);
                rs = stmt.executeQuery();
                if (rs.next()) {
                    tableName = rs.getString(1);
                }
            }
            catch (SQLException e) {
                throw new AdempiereException("Could not execute external query: SELECT CASE          WHEN TreeType = 'AY' THEN 'C_Activity'          WHEN TreeType = 'BB' THEN 'M_BOM'          WHEN TreeType = 'BP' THEN 'C_BPartner'          WHEN TreeType = 'CC' THEN 'CM_Container'          WHEN TreeType = 'CM' THEN 'CM_Media'          WHEN TreeType = 'CS' THEN 'CM_CStage'          WHEN TreeType = 'CT' THEN 'CM_Template'          WHEN TreeType = 'EV' THEN 'C_ElementValue'          WHEN TreeType = 'MC' THEN 'C_Campaign'          WHEN TreeType = 'MM' THEN 'AD_Menu'          WHEN TreeType = 'OO' THEN 'AD_Org'          WHEN TreeType = 'PC' THEN 'M_Product_Category'          WHEN TreeType = 'PJ' THEN 'C_Project'          WHEN TreeType = 'PR' THEN 'M_Product'          WHEN TreeType = 'SR' THEN 'C_SalesRegion'          WHEN TreeType = 'U1' THEN 'C_ElementValue'          WHEN TreeType = 'U2' THEN 'C_ElementValue'          WHEN TreeType = 'U3' THEN 'C_ElementValue'          WHEN TreeType = 'U4' THEN 'C_ElementValue'          WHEN TreeType = 'TL' THEN AD_Table.TableName          ELSE NULL        END FROM   AD_Tree        LEFT JOIN AD_Table ON ( AD_Table.AD_Table_ID = AD_Tree.AD_Table_ID ) WHERE  AD_Tree_ID = ?\nCause = " + e.getLocalizedMessage());
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, stmt);
            throw throwable;
        }
        DB.close(rs, stmt);
        return tableName;
    }

    private String getExternalTableName(int tableId) {
        String tableName = null;
        String sql = DB.getDatabase().convertStatement("SELECT TableName FROM AD_Table WHERE AD_Table_ID=?");
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                stmt = this.externalConn.prepareStatement(sql, 1003, 1007);
                stmt.setInt(1, tableId);
                rs = stmt.executeQuery();
                if (rs.next()) {
                    tableName = rs.getString(1);
                }
            }
            catch (SQLException e) {
                throw new AdempiereException("Could not execute external query: " + sql + "\nCause = " + e.getLocalizedMessage());
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, stmt);
            throw throwable;
        }
        DB.close(rs, stmt);
        return tableName;
    }

    private void checkSequences() {
        if (this.p_isPreserveAll) {
            for (String tableName : this.p_tablesVerifiedList) {
                MSequence seq = MSequence.get(this.getCtx(), tableName, this.get_TrxName());
                if (seq == null) continue;
                seq.validateTableIDValue();
            }
        } else {
            for (String tableName : this.p_tablesToPreserveIDsList) {
                MSequence seq = MSequence.get(this.getCtx(), tableName, this.get_TrxName());
                if (seq == null) continue;
                seq.validateTableIDValue();
            }
        }
    }

    private int getLocalIDFor(String tableName, int foreignId, String tableNameSource) {
        String uuidCol = MTable.getUUIDColumnName(tableName);
        StringBuilder sqlRemoteUUSB = new StringBuilder().append("SELECT ").append(uuidCol).append(" FROM ").append(tableName).append(" WHERE ").append(tableName).append("_ID=?");
        String sqlRemoteUU = DB.getDatabase().convertStatement(sqlRemoteUUSB.toString());
        PreparedStatement stmtUU = null;
        ResultSet rs = null;
        String remoteUUID = null;
        try {
            try {
                stmtUU = this.externalConn.prepareStatement(sqlRemoteUU, 1003, 1007);
                stmtUU.setInt(1, foreignId);
                rs = stmtUU.executeQuery();
                if (rs.next()) {
                    remoteUUID = rs.getString(1);
                }
            }
            catch (SQLException e) {
                throw new AdempiereException("Could not execute external query for table " + tableNameSource + ": " + sqlRemoteUU + "\nCause = " + e.getLocalizedMessage());
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, stmtUU);
            throw throwable;
        }
        DB.close(rs, stmtUU);
        int localID = -1;
        if (remoteUUID != null) {
            localID = this.getFromUUID(tableName, uuidCol, null, null, remoteUUID, foreignId);
        }
        return localID;
    }

    private int getFromUUID(String foreignTable, String uuidCol, String tableName, String columnName, String foreignUU, int foreignID) {
        StringBuilder sqlCheckLocalUU = new StringBuilder().append("SELECT ").append(foreignTable).append("_ID FROM ").append(foreignTable).append(" WHERE ").append(uuidCol).append("=?");
        int localID = DB.getSQLValueEx(this.get_TrxName(), sqlCheckLocalUU.toString(), foreignUU);
        if (localID < 0) {
            this.p_errorList.add("Column " + tableName + "." + columnName + " has system reference not convertible, " + foreignTable + "." + uuidCol + "=" + foreignUU);
            return -1;
        }
        DB.executeUpdateEx(insertConversionId, new Object[]{this.getAD_PInstance_ID(), foreignTable.toUpperCase(), foreignID, localID}, this.get_TrxName());
        this.p_idSystemConversionList.add(String.valueOf(foreignTable.toUpperCase()) + "." + foreignID);
        return localID;
    }
}

