/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.process;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.adempiere.base.annotation.Process;
import org.compiere.model.MProcessPara;
import org.compiere.model.MSequence;
import org.compiere.model.MTable;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.DB;
import org.compiere.util.Util;

@Process
public class MigraID
extends SvrProcess {
    private int p_AD_Table_ID = -1;
    private int p_ID_From = -1;
    private int p_ID_To = -1;
    private String p_UUID_From = null;
    private String p_UUID_To = null;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] processInfoParameterArray = this.getParameter();
        int n = processInfoParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessInfoParameter para = processInfoParameterArray[n2];
            String name = para.getParameterName();
            if ("AD_Table_ID".equals(name)) {
                this.p_AD_Table_ID = para.getParameterAsInt();
            } else if ("Record_ID".equals(name)) {
                this.p_ID_From = para.getParameterAsInt();
            } else if ("To_Record_ID".equals(name)) {
                this.p_ID_To = para.getParameterAsInt();
            } else if ("Source_UUID".equals(name)) {
                this.p_UUID_From = para.getParameterAsString();
            } else if ("Target_UUID".equals(name)) {
                this.p_UUID_To = para.getParameterAsString();
            } else {
                MProcessPara.validateUnknownParameter(this.getProcessInfo().getAD_Process_ID(), para);
            }
            ++n2;
        }
    }

    @Override
    protected String doIt() throws Exception {
        if (this.p_ID_From <= 0 && Util.isEmpty(this.p_UUID_From)) {
            throw new AdempiereUserError("Fill Record ID or UUID to convert");
        }
        if (this.p_ID_From > 0 && !Util.isEmpty(this.p_UUID_From)) {
            throw new AdempiereUserError("Record ID and UUID are excluyent, just one can be converted at the same time");
        }
        if (this.p_ID_From > 0 && this.p_ID_From == this.p_ID_To) {
            throw new AdempiereUserError("Same ID");
        }
        if (!Util.isEmpty(this.p_UUID_From) && this.p_UUID_From.equals(this.p_UUID_To)) {
            throw new AdempiereUserError("Same UUID");
        }
        MTable table2 = MTable.get(this.getCtx(), this.p_AD_Table_ID, this.get_TrxName());
        String tableName = table2.getTableName();
        String msg = "";
        if (!Util.isEmpty(this.p_UUID_From)) {
            StringBuilder updUUIDSB;
            int cnt;
            String uuidCol = MTable.getUUIDColumnName(tableName);
            if (Util.isEmpty(this.p_UUID_To)) {
                this.p_UUID_To = UUID.randomUUID().toString();
            }
            if ((cnt = DB.executeUpdateEx((updUUIDSB = new StringBuilder().append("UPDATE ").append(tableName).append(" SET ").append(uuidCol).append("=?").append(" WHERE ").append(uuidCol).append("=?")).toString(), new Object[]{this.p_UUID_To, this.p_UUID_From}, this.get_TrxName())) <= 0) {
                msg = "@Error@: UUID " + this.p_UUID_From + " not found on table " + tableName;
            } else {
                msg = "UUID changed on table " + tableName + " from " + this.p_UUID_From + " to " + this.p_UUID_To;
                StringBuilder sqlSB = new StringBuilder().append("SELECT  ").append(tableName).append("_ID").append(" FROM ").append(tableName).append(" WHERE ").append(uuidCol).append("=?");
                int id = DB.getSQLValueEx(this.get_TrxName(), sqlSB.toString(), this.p_UUID_To);
                this.addBufferLog(id, null, null, msg, this.p_AD_Table_ID, id);
                msg = "@OK@";
            }
        } else {
            MSequence seq;
            boolean seqCheck = false;
            String idCol = String.valueOf(tableName) + "_ID";
            if (this.p_ID_To <= 0) {
                this.p_ID_To = DB.getNextID(this.getAD_Client_ID(), tableName, this.get_TrxName());
            } else {
                StringBuilder sqlMaxSB = new StringBuilder().append("SELECT  MAX(").append(tableName).append("_ID)").append(" FROM ").append(tableName);
                int maxID = DB.getSQLValueEx(this.get_TrxName(), sqlMaxSB.toString(), new Object[0]);
                if (this.p_ID_To > maxID) {
                    seqCheck = true;
                }
            }
            int cnt = this.updID(tableName, idCol);
            if (cnt <= 0) {
                msg = "@Error@: ID " + this.p_ID_From + " not found on table " + tableName;
            } else {
                msg = "ID changed on table " + tableName + " from " + this.p_ID_From + " to " + this.p_ID_To;
                this.addBufferLog(this.p_ID_From, null, null, msg, this.p_AD_Table_ID, this.p_ID_To);
                msg = "@OK@";
            }
            this.migrateReference(tableName);
            this.migrateChildren(tableName);
            this.migrateRecordID();
            this.migrateAD_Preference(idCol);
            this.migrateTrees(tableName);
            if ("C_DocType_ID".equals(idCol)) {
                this.migrateAD_Preference("C_DocTypeTarget_ID");
            }
            if (seqCheck && (seq = MSequence.get(this.getCtx(), tableName, this.get_TrxName())) != null) {
                seq.validateTableIDValue(this.get_TrxName());
            }
        }
        return msg;
    }

    private int updID(String tableName, String idCol) {
        StringBuilder updIDSB = new StringBuilder().append("UPDATE ").append(tableName).append(" SET ").append(idCol).append("=?").append(" WHERE ").append(idCol).append("=?");
        int cnt = DB.executeUpdateEx(updIDSB.toString(), new Object[]{this.p_ID_To, this.p_ID_From}, this.get_TrxName());
        return cnt;
    }

    private void migrateReference(String tableName) {
        int refID = -1;
        switch (tableName) {
            case "C_Location": {
                refID = 21;
                break;
            }
            case "C_ValidCombination": {
                refID = 25;
                break;
            }
            case "M_Locator": {
                refID = 31;
                break;
            }
            case "M_AttributeSetInstance": {
                refID = 35;
                break;
            }
            case "S_ResourceAssignment": {
                refID = 33;
                break;
            }
            case "AD_Image": {
                refID = 32;
                break;
            }
            case "AD_Color": {
                refID = 27;
                break;
            }
            case "AD_Chart": {
                refID = 53370;
            }
        }
        if (refID > 0) {
            String selRef = "SELECT t.TableName, c.ColumnName FROM AD_Table t JOIN AD_Column c ON (t.AD_Table_ID=c.AD_Table_ID) WHERE t.IsView='N' AND t.IsActive='Y' AND c.IsActive='Y' AND c.ColumnSQL IS NULL AND c.AD_Reference_ID=? ORDER BY t.TableName, c.ColumnName";
            List<List<Object>> rows = DB.getSQLArrayObjectsEx(this.get_TrxName(), "SELECT t.TableName, c.ColumnName FROM AD_Table t JOIN AD_Column c ON (t.AD_Table_ID=c.AD_Table_ID) WHERE t.IsView='N' AND t.IsActive='Y' AND c.IsActive='Y' AND c.ColumnSQL IS NULL AND c.AD_Reference_ID=? ORDER BY t.TableName, c.ColumnName", refID);
            if (rows != null && rows.size() > 0) {
                for (List<Object> row : rows) {
                    String columnRef;
                    String tableRef = (String)row.get(0);
                    int cnt = this.updID(tableRef, columnRef = (String)row.get(1));
                    if (cnt <= 0) continue;
                    String msg = String.valueOf(cnt) + " reference records updated in " + tableRef + "." + columnRef;
                    this.addBufferLog(this.p_ID_From, null, null, msg, 0, 0);
                }
            }
        }
    }

    private void migrateChildren(String tableName) {
        String columnRef;
        String tableRef;
        int cnt;
        String sqlFK = "SELECT t.TableName, c.ColumnName FROM   AD_Table t, AD_Column c, AD_Reference r WHERE  t.AD_Table_ID = c.AD_Table_ID        AND t.IsActive = 'Y' AND t.IsView = 'N'        AND c.IsActive = 'Y' AND c.ColumnSql IS NULL        AND c.AD_Reference_ID = r.AD_Reference_ID        AND ( c.AD_Reference_ID IN ( 19/*Table Direct*/ )               OR ( c.AD_Reference_ID IN ( 30/*Search*/ )                    AND c.AD_Reference_Value_ID IS NULL ) )        AND UPPER(c.ColumnName) = UPPER(? || '_ID') UNION SELECT t.TableName, c.ColumnName FROM   AD_Table t, AD_Column c, AD_Reference r, AD_Ref_Table rt, AD_Table tr WHERE  t.AD_Table_ID = c.AD_Table_ID        AND t.IsActive = 'Y' AND t.IsView = 'N'        AND c.IsActive = 'Y' AND c.ColumnSql IS NULL        AND c.AD_Reference_ID = r.AD_Reference_ID        AND ( c.AD_Reference_ID IN ( 18/*Table*/ )               OR ( c.AD_Reference_ID IN ( 30/*Search*/ )                    AND c.AD_Reference_Value_ID IS NOT NULL ) )        AND c.AD_Reference_Value_ID = rt.AD_Reference_ID        AND rt.AD_Table_ID = tr.AD_Table_ID        AND UPPER(tr.TableName) = UPPER(?) ORDER  BY 1, 2";
        List<List<Object>> rows = DB.getSQLArrayObjectsEx(this.get_TrxName(), "SELECT t.TableName, c.ColumnName FROM   AD_Table t, AD_Column c, AD_Reference r WHERE  t.AD_Table_ID = c.AD_Table_ID        AND t.IsActive = 'Y' AND t.IsView = 'N'        AND c.IsActive = 'Y' AND c.ColumnSql IS NULL        AND c.AD_Reference_ID = r.AD_Reference_ID        AND ( c.AD_Reference_ID IN ( 19/*Table Direct*/ )               OR ( c.AD_Reference_ID IN ( 30/*Search*/ )                    AND c.AD_Reference_Value_ID IS NULL ) )        AND UPPER(c.ColumnName) = UPPER(? || '_ID') UNION SELECT t.TableName, c.ColumnName FROM   AD_Table t, AD_Column c, AD_Reference r, AD_Ref_Table rt, AD_Table tr WHERE  t.AD_Table_ID = c.AD_Table_ID        AND t.IsActive = 'Y' AND t.IsView = 'N'        AND c.IsActive = 'Y' AND c.ColumnSql IS NULL        AND c.AD_Reference_ID = r.AD_Reference_ID        AND ( c.AD_Reference_ID IN ( 18/*Table*/ )               OR ( c.AD_Reference_ID IN ( 30/*Search*/ )                    AND c.AD_Reference_Value_ID IS NOT NULL ) )        AND c.AD_Reference_Value_ID = rt.AD_Reference_ID        AND rt.AD_Table_ID = tr.AD_Table_ID        AND UPPER(tr.TableName) = UPPER(?) ORDER  BY 1, 2", tableName, tableName);
        if (rows != null && rows.size() > 0) {
            for (List<Object> row : rows) {
                int cnt2;
                String tableRef2 = (String)row.get(0);
                String columnRef2 = (String)row.get(1);
                if ("EntityType".equals(columnRef2) || "AD_Language".equals(columnRef2) || (cnt2 = this.updID(tableRef2, columnRef2)) <= 0) continue;
                String msg = String.valueOf(cnt2) + " children records updated in " + tableRef2 + "." + columnRef2;
                this.addBufferLog(this.p_ID_From, null, null, msg, 0, 0);
            }
        }
        if ("AD_Org".equalsIgnoreCase(tableName) && (cnt = this.updID(tableRef = "C_BPartner", columnRef = "AD_OrgBP_ID")) > 0) {
            String msg = String.valueOf(cnt) + " children records updated in " + tableRef + "." + columnRef;
            this.addBufferLog(this.p_ID_From, null, null, msg, 0, 0);
        }
    }

    private void migrateRecordID() {
        String whereClause = "IsView='N' AND IsActive='Y' AND EXISTS (SELECT 1 FROM AD_Column ct WHERE ct.AD_Table_ID=AD_Table.AD_Table_ID AND ct.ColumnName='AD_Table_ID' AND ct.ColumnSQL IS NULL AND ct.IsActive='Y') AND EXISTS (SELECT 1 FROM AD_Column cr WHERE cr.AD_Table_ID=AD_Table.AD_Table_ID AND cr.ColumnName='Record_ID'   AND cr.ColumnSQL IS NULL AND cr.IsActive='Y')";
        List tablesWithRecordID = new Query(this.getCtx(), "AD_Table", "IsView='N' AND IsActive='Y' AND EXISTS (SELECT 1 FROM AD_Column ct WHERE ct.AD_Table_ID=AD_Table.AD_Table_ID AND ct.ColumnName='AD_Table_ID' AND ct.ColumnSQL IS NULL AND ct.IsActive='Y') AND EXISTS (SELECT 1 FROM AD_Column cr WHERE cr.AD_Table_ID=AD_Table.AD_Table_ID AND cr.ColumnName='Record_ID'   AND cr.ColumnSQL IS NULL AND cr.IsActive='Y')", this.get_TrxName()).setOrderBy("TableName").list();
        for (MTable table2 : tablesWithRecordID) {
            String tableName = table2.getTableName();
            StringBuilder updRISB = new StringBuilder().append("UPDATE ").append(tableName).append(" SET Record_ID=?").append(" WHERE Record_ID=? AND AD_Table_ID=?");
            int cnt = DB.executeUpdateEx(updRISB.toString(), new Object[]{this.p_ID_To, this.p_ID_From, this.p_AD_Table_ID}, this.get_TrxName());
            if (cnt <= 0) continue;
            String msg = String.valueOf(cnt) + " weak reference records updated in " + tableName;
            this.addBufferLog(this.p_ID_From, null, null, msg, 0, 0);
        }
    }

    private void migrateAD_Preference(String columnName) {
        String updPref = "UPDATE AD_Preference SET Value=? WHERE Value=? AND Attribute=?";
        int cnt = DB.executeUpdateEx("UPDATE AD_Preference SET Value=? WHERE Value=? AND Attribute=?", new Object[]{String.valueOf(this.p_ID_To), String.valueOf(this.p_ID_From), columnName}, this.get_TrxName());
        if (cnt > 0) {
            String msg = String.valueOf(cnt) + " preference records updated in AD_Preference for " + columnName;
            this.addBufferLog(this.p_ID_From, null, null, msg, 0, 0);
        }
    }

    private void migrateTrees(String tableName) {
        switch (tableName) {
            case "AD_Menu": {
                this.migraTree("AD_TreeBar", "MM");
                this.migraTree("AD_TreeNodeMM", "MM");
                break;
            }
            case "C_BPartner": {
                this.migraTree("AD_TreeNodeBP", "BP");
                break;
            }
            case "CM_Container": {
                this.migraTree("AD_TreeNodeCMC", "CC");
                break;
            }
            case "CM_Media": {
                this.migraTree("AD_TreeNodeCMM", "CM");
                break;
            }
            case "CM_CStage": {
                this.migraTree("AD_TreeNodeCMS", "CS");
                break;
            }
            case "CM_Template": {
                this.migraTree("AD_TreeNodeCMT", "CT");
                break;
            }
            case "M_Product": {
                this.migraTree("AD_TreeNodePR", "PR");
                break;
            }
            case "C_ElementValue": {
                this.migraTree("AD_TreeNodeU1", "U1");
                this.migraTree("AD_TreeNodeU2", "U2");
                this.migraTree("AD_TreeNodeU3", "U3");
                this.migraTree("AD_TreeNodeU4", "U4");
                break;
            }
            case "AD_Org": {
                this.migraTree("AD_TreeNode", "OO");
                break;
            }
            case "M_Product_Category": {
                this.migraTree("AD_TreeNode", "PC");
                break;
            }
            case "M_BOM": {
                this.migraTree("AD_TreeNode", "BB");
                break;
            }
            case "C_Campaign": {
                this.migraTree("AD_TreeNode", "MC");
                break;
            }
            case "C_Project": {
                this.migraTree("AD_TreeNode", "PJ");
                break;
            }
            case "C_Activity": {
                this.migraTree("AD_TreeNode", "AY");
                break;
            }
            case "C_SalesRegion": {
                this.migraTree("AD_TreeNode", "SR");
            }
        }
        this.migraTree("AD_TreeNode", "TL");
    }

    private void migraTree(String menuTable, String treeType) {
        ArrayList<String> columns = new ArrayList<String>();
        columns.add("Node_ID");
        if (!"AD_TreeBar".equalsIgnoreCase(menuTable)) {
            columns.add("Parent_ID");
        }
        for (String col : columns) {
            StringBuilder sqlUpdTreeSB = new StringBuilder().append("UPDATE ").append(menuTable).append(" SET ").append(col).append("=? WHERE ").append(col).append("=? AND AD_Tree_ID IN (SELECT AD_Tree_ID FROM AD_Tree WHERE TreeType=?");
            if ("TL".equals(treeType)) {
                sqlUpdTreeSB.append(" AND AD_Table_ID=").append(this.p_AD_Table_ID);
            }
            sqlUpdTreeSB.append(")");
            int cnt = DB.executeUpdateEx(sqlUpdTreeSB.toString(), new Object[]{this.p_ID_To, this.p_ID_From, treeType}, this.get_TrxName());
            if (cnt <= 0) continue;
            String msg = String.valueOf(cnt) + " tree records updated in " + menuTable + "." + col;
            this.addBufferLog(this.p_ID_From, null, null, msg, 0, 0);
        }
    }
}

