/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.model;

import io.github.classgraph.AnnotationInfo;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.logging.Level;
import org.adempiere.base.IModelFactory;
import org.adempiere.base.Model;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.idempiere.model.IMappedModelFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.component.annotations.Component;

@Component(name="org.idempiere.model.MappedModelFactory", immediate=true, service={IModelFactory.class, IMappedModelFactory.class}, property={"service.ranking:Integer=1"})
public class MappedModelFactory
implements IModelFactory,
IMappedModelFactory {
    private final ConcurrentHashMap<String, Supplier<Class<?>>> classMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, BiFunction<Integer, String, ? extends PO>> recordIdMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, BiFunction<ResultSet, String, ? extends PO>> resultSetMap = new ConcurrentHashMap();
    private static final CLogger s_log = CLogger.getCLogger(MappedModelFactory.class);

    @Override
    public Class<?> getClass(String tableName) {
        Supplier<Class<?>> supplier = this.classMap.get(tableName);
        return supplier != null ? supplier.get() : null;
    }

    @Override
    public PO getPO(String tableName, int Record_ID, String trxName) {
        BiFunction<Integer, String, ? extends PO> function = this.recordIdMap.get(tableName);
        return function != null ? function.apply(Record_ID, trxName) : null;
    }

    @Override
    public PO getPO(String tableName, ResultSet rs, String trxName) {
        BiFunction<ResultSet, String, ? extends PO> function = this.resultSetMap.get(tableName);
        return function != null ? function.apply(rs, trxName) : null;
    }

    @Override
    public void addMapping(String tableName, Supplier<Class<?>> classSupplier, BiFunction<Integer, String, ? extends PO> recordIdFunction, BiFunction<ResultSet, String, ? extends PO> resultSetFunction) {
        this.classMap.put(tableName, classSupplier);
        this.recordIdMap.put(tableName, recordIdFunction);
        this.resultSetMap.put(tableName, resultSetFunction);
    }

    @Override
    public void removeMapping(String tableName) {
        this.classMap.remove(tableName);
        this.recordIdMap.remove(tableName);
        this.resultSetMap.remove(tableName);
    }

    @Override
    public void scan(BundleContext context, String ... packages) {
        ClassLoader classLoader = ((BundleWiring)context.getBundle().adapt(BundleWiring.class)).getClassLoader();
        ClassGraph graph = new ClassGraph().enableAnnotationInfo().overrideClassLoaders(new ClassLoader[]{classLoader}).disableNestedJarScanning().disableModuleScanning().acceptPackagesNonRecursive(packages);
        Throwable throwable = null;
        Object var6_7 = null;
        try (ScanResult scanResult = graph.scan();){
            for (ClassInfo classInfo : scanResult.getClassesWithAnnotation(Model.class)) {
                if (classInfo.isAbstract()) continue;
                String className = classInfo.getName();
                AnnotationInfo annotationInfo = classInfo.getAnnotationInfo(Model.class);
                String tableName = (String)annotationInfo.getParameterValues().getValue("table");
                ClassInfoList subclasses = classInfo.getSubclasses().directOnly();
                while (!subclasses.isEmpty()) {
                    className = ((ClassInfo)subclasses.get(0)).getName();
                    subclasses = ((ClassInfo)subclasses.get(0)).getSubclasses().directOnly();
                }
                try {
                    Class<?> clazz = classLoader.loadClass(className);
                    Supplier<Class<?>> classSupplier = () -> clazz;
                    Constructor<?> idConstructor = clazz.getDeclaredConstructor(Properties.class, Integer.TYPE, String.class);
                    RecordIdFunction recordIdFunction = new RecordIdFunction(idConstructor);
                    Constructor<?> rsConstructor = clazz.getDeclaredConstructor(Properties.class, ResultSet.class, String.class);
                    ResultSetFunction resultSetFunction = new ResultSetFunction(rsConstructor);
                    this.addMapping(tableName, classSupplier, recordIdFunction, resultSetFunction);
                }
                catch (Exception e) {
                    if (!s_log.isLoggable(Level.INFO)) continue;
                    s_log.log(Level.INFO, e.getMessage(), e);
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static final class RecordIdFunction
    implements BiFunction<Integer, String, PO> {
        private Constructor<?> constructor;

        private RecordIdFunction(Constructor<?> constructor) {
            this.constructor = constructor;
        }

        @Override
        public PO apply(Integer id, String trxName) {
            if (this.constructor != null) {
                try {
                    return (PO)this.constructor.newInstance(Env.getCtx(), id, trxName);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                    this.constructor = null;
                    throw new RuntimeException(e);
                }
            }
            return null;
        }
    }

    private static final class ResultSetFunction
    implements BiFunction<ResultSet, String, PO> {
        private Constructor<?> constructor;

        private ResultSetFunction(Constructor<?> constructor) {
            this.constructor = constructor;
        }

        @Override
        public PO apply(ResultSet rs, String trxName) {
            if (this.constructor != null) {
                try {
                    return (PO)this.constructor.newInstance(Env.getCtx(), rs, trxName);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                    this.constructor = null;
                    throw new RuntimeException(e);
                }
            }
            return null;
        }
    }
}

