/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.mfa;

import dev.samstevens.totp.code.CodeGenerator;
import dev.samstevens.totp.code.DefaultCodeGenerator;
import dev.samstevens.totp.code.DefaultCodeVerifier;
import dev.samstevens.totp.exceptions.QrGenerationException;
import dev.samstevens.totp.qr.QrData;
import dev.samstevens.totp.qr.ZxingPngQrGenerator;
import dev.samstevens.totp.secret.DefaultSecretGenerator;
import dev.samstevens.totp.time.NtpTimeProvider;
import dev.samstevens.totp.time.SystemTimeProvider;
import dev.samstevens.totp.time.TimeProvider;
import dev.samstevens.totp.util.Utils;
import java.net.UnknownHostException;
import java.sql.Timestamp;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.IMFAMechanism;
import org.compiere.model.MMFAMethod;
import org.compiere.model.MMFARegistration;
import org.compiere.model.MSysConfig;
import org.compiere.model.MUser;
import org.compiere.model.PO;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class TOTPMechanism
implements IMFAMechanism {
    @Override
    public Object[] register(Properties ctx, MMFAMethod method, String prm, String trxName) {
        byte[] imageData;
        if (Util.isEmpty(method.getMFAIssuer())) {
            throw new AdempiereException(Msg.getMsg(ctx, "MFATOTPIssuerRequired"));
        }
        if (MMFARegistration.alreadyExistsValid(method, prm)) {
            throw new AdempiereException(Msg.getMsg(ctx, "MFAMethodAlreadyRegistered"));
        }
        MUser user = MUser.get(ctx);
        boolean email_login = MSysConfig.getBooleanValue("USE_EMAIL_FOR_LOGIN", false);
        String label2 = email_login ? user.getEMail() : user.getName();
        DefaultSecretGenerator secretGenerator = new DefaultSecretGenerator();
        String secret = secretGenerator.generate();
        QrData data = new QrData.Builder().label(label2).secret(secret).issuer(method.getMFAIssuer()).build();
        ZxingPngQrGenerator generator = new ZxingPngQrGenerator();
        try {
            imageData = generator.generate(data);
        }
        catch (QrGenerationException e) {
            throw new AdempiereException(Msg.getMsg(Env.getCtx(), "MFATOTPErrorGeneratingQR"), e);
        }
        String mimeType = generator.getImageMimeType();
        String dataUri = Utils.getDataUriForImage((byte[])imageData, (String)mimeType);
        int expireMinutes = method.getExpireInMinutes();
        MMFARegistration reg = new MMFARegistration(ctx, 0, trxName);
        reg.set_ValueOfColumn("AD_Client_ID", (Object)user.getAD_Client_ID());
        reg.setAD_Org_ID(0);
        if (!Util.isEmpty(prm)) {
            reg.setName(prm);
            reg.setParameterValue(prm);
        } else {
            reg.setName(label2);
        }
        reg.setMFA_Method_ID(method.getMFA_Method_ID());
        reg.setAD_User_ID(user.getAD_User_ID());
        reg.setMFASecret(secret);
        reg.setIsValid(false);
        reg.setIsUserMFAPreferred(false);
        if (expireMinutes > 0) {
            reg.setExpiration(new Timestamp(System.currentTimeMillis() + (long)(expireMinutes * 60000)));
        }
        this.saveRegistration(reg);
        MMFARegistration.invalidatePreviousPending(method, prm, reg);
        Object[] ret = new Object[]{Msg.getMsg(Env.getCtx(), "MFATOTPRegistered"), reg, Msg.getMsg(Env.getCtx(), "MFATOTPImage"), dataUri, Msg.getMsg(Env.getCtx(), "MFATOTPSecret"), secret};
        return ret;
    }

    @Override
    public String complete(Properties ctx, MMFARegistration reg, String code, String name, boolean preferred, String trxName) {
        if (!this.isValidCode(ctx, reg, code, trxName)) {
            throw new AdempiereException(Msg.getMsg(ctx, "MFACodeInvalid"));
        }
        reg.setIsValid(true);
        reg.setMFAValidatedAt(new Timestamp(System.currentTimeMillis()));
        reg.setExpiration(null);
        if (!Util.isEmpty(name)) {
            reg.setName(name);
        }
        if (preferred) {
            reg.setIsUserMFAPreferred(true);
        }
        this.saveRegistration(reg);
        return Msg.getMsg(ctx, "MFARegistrationCompleted");
    }

    private boolean isValidCode(Properties ctx, MMFARegistration reg, String code, String trxName) {
        boolean valid;
        SystemTimeProvider timeProvider;
        MMFAMethod method = new MMFAMethod(ctx, reg.getMFA_Method_ID(), trxName);
        if ("N".equals(method.getMFATimeProvider())) {
            String ntpServer = method.getMFATimeServer();
            if (Util.isEmpty(ntpServer)) {
                ntpServer = "pool.ntp.org";
            }
            int timeout = MSysConfig.getIntValue("MFA_NTP_TIMEOUT_IN_MILLISECONDS", 5000);
            try {
                timeProvider = new NtpTimeProvider(ntpServer, timeout);
            }
            catch (UnknownHostException e) {
                throw new AdempiereException(String.valueOf(Msg.getMsg(ctx, "MFANTPServerError")) + e.getLocalizedMessage(), e);
            }
        } else {
            timeProvider = new SystemTimeProvider();
        }
        DefaultCodeGenerator codeGenerator = new DefaultCodeGenerator();
        DefaultCodeVerifier verifier = new DefaultCodeVerifier((CodeGenerator)codeGenerator, (TimeProvider)timeProvider);
        if (method.getMFAAllowedTimeDiscrepancy() > 0) {
            verifier.setAllowedTimePeriodDiscrepancy(method.getMFAAllowedTimeDiscrepancy());
        }
        if (valid = verifier.isValidCode(reg.getMFASecret(), code)) {
            reg.setMFALastSecret(code);
            reg.setLastSuccess(new Timestamp(System.currentTimeMillis()));
            reg.setFailedLoginCount(0);
        } else {
            reg.setLastFailure(new Timestamp(System.currentTimeMillis()));
            reg.setFailedLoginCount(reg.getFailedLoginCount() + 1);
        }
        this.saveRegistration(reg);
        return valid;
    }

    @Override
    public String generateValidationCode(MMFARegistration reg) {
        return Msg.getMsg(Env.getCtx(), "MFATOTPEnterValidationCode");
    }

    @Override
    public String validateCode(MMFARegistration reg, String code, boolean setPreferred) {
        Properties ctx = reg.getCtx();
        if (code.equals(reg.getMFALastSecret())) {
            return Msg.getMsg(ctx, "MFACodeAlreadyConsumed");
        }
        if (!this.isValidCode(ctx, reg, code, reg.get_TrxName())) {
            return Msg.getMsg(ctx, "MFACodeInvalid");
        }
        if (setPreferred) {
            reg.setIsUserMFAPreferred(true);
            this.saveRegistration(reg);
        }
        return null;
    }

    private void saveRegistration(MMFARegistration reg) {
        try {
            PO.setCrossTenantSafe();
            reg.saveEx();
        }
        finally {
            PO.clearCrossTenantSafe();
        }
    }
}

