/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.fa.util;

import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.idempiere.fa.util.Util;

public final class POCacheLocal<T extends PO> {
    private final PO parent;
    private final String idColumnName;
    private final String po_tableName;
    private T po = null;

    public static <T extends PO> POCacheLocal<T> newInstance(PO parent, Class<T> cl) {
        return new POCacheLocal<T>(parent, cl);
    }

    public static <T extends PO> POCacheLocal<T> newInstance(PO parent, Class<T> cl, String idColumnName) {
        return new POCacheLocal<T>(parent, cl, idColumnName);
    }

    private POCacheLocal(PO parent, Class<T> cl) {
        this(parent, cl, null);
    }

    private POCacheLocal(PO parent, Class<T> cl, String idColumnName) {
        this.parent = parent;
        try {
            this.po_tableName = (String)cl.getField("Table_Name").get(null);
        }
        catch (Exception e) {
            throw new AdempiereException(e);
        }
        this.idColumnName = idColumnName == null ? String.valueOf(this.po_tableName) + "_ID" : idColumnName;
    }

    public T get(boolean requery) {
        int id = this.get_id();
        if (id <= 0) {
            this.po = null;
            return null;
        }
        if (requery || !this.isValidPO(this.po)) {
            this.po = this.load(this.parent.getCtx(), id, this.parent.get_TrxName());
        }
        return this.po;
    }

    public void set(T po) {
        if (this.isValidPO(po)) {
            this.po = po;
        }
    }

    private boolean isValidPO(T po) {
        int id = this.get_id();
        return id > 0 && po != null && ((PO)po).get_ID() == id && Util.equals(this.parent.get_TrxName(), ((PO)po).get_TrxName());
    }

    protected T load(Properties ctx, int id, String trxName) {
        return (T)MTable.get(ctx, this.po_tableName).getPO(id, trxName);
    }

    private int get_id() {
        return this.parent.get_ValueAsInt(this.idColumnName);
    }
}

