/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.fa.process;

import java.sql.Timestamp;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.compiere.model.MAssetAddition;
import org.compiere.model.MProcessPara;
import org.compiere.model.MProduct;
import org.compiere.model.MProductCategory;
import org.compiere.model.MProject;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Msg;

@Process
public class ProjectCreateAsset
extends SvrProcess {
    private int m_C_Project_ID = 0;
    private int m_Product_ID = 0;
    private Timestamp m_DateTrx = null;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i2 = 0;
        while (i2 < para.length) {
            if (para[i2].getParameter() != null) {
                if (para[i2].getParameterName().equalsIgnoreCase("C_Project_ID")) {
                    this.m_C_Project_ID = para[i2].getParameterAsInt();
                } else if (para[i2].getParameterName().equalsIgnoreCase("M_Product_ID")) {
                    this.m_Product_ID = para[i2].getParameterAsInt();
                } else if (!para[i2].getParameterName().equalsIgnoreCase("UseLifeYears")) {
                    if (para[i2].getParameterName().equalsIgnoreCase("DateTrx")) {
                        this.m_DateTrx = (Timestamp)para[i2].getParameter();
                    } else {
                        MProcessPara.validateUnknownParameter(this.getProcessInfo().getAD_Process_ID(), para[i2]);
                    }
                }
            }
            ++i2;
        }
    }

    @Override
    protected String doIt() throws Exception {
        if (this.m_C_Project_ID == 0 || this.m_Product_ID == 0) {
            return "Missing Mandatory Field Value (Project / Product)";
        }
        MProject project = new MProject(this.getCtx(), this.m_C_Project_ID, this.get_TrxName());
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("doIt - " + project);
        }
        MProduct product = new MProduct(this.getCtx(), this.m_Product_ID, this.get_TrxName());
        MProductCategory pc = MProductCategory.get(this.getCtx(), product.getM_Product_Category_ID());
        if (pc.getA_Asset_Group_ID() == 0) {
            return "Product is not asset type";
        }
        MAssetAddition assetAdd = MAssetAddition.createAsset(project, product);
        assetAdd.setDateAcct(this.m_DateTrx);
        assetAdd.setDateDoc(this.m_DateTrx);
        assetAdd.setM_Product_ID(this.m_Product_ID);
        assetAdd.saveEx();
        if (!assetAdd.processIt("CO")) {
            return "Error Process Asset Addition: " + assetAdd.getProcessMsg();
        }
        assetAdd.saveEx();
        String message = Msg.parseTranslation(this.getCtx(), "@A_Asset_Addition_ID@ - " + assetAdd);
        this.addBufferLog(0, null, null, message, 53137, assetAdd.getA_Asset_Addition_ID());
        return "@Created@";
    }
}

