/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.db.util;

import java.sql.Connection;
import java.sql.SQLException;
import org.compiere.util.DB;

public class AutoCommitConnectionBroker {
    private static ThreadLocal<ConnectionReference> threadLocalConnection = new ThreadLocal<ConnectionReference>(){

        @Override
        protected ConnectionReference initialValue() {
            return null;
        }
    };

    public static Connection getConnection() {
        ConnectionReference connReference = threadLocalConnection.get();
        try {
            if (connReference != null && !connReference.connection.isClosed()) {
                ++connReference.referenceCount;
                return connReference.connection;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        Connection connection = DB.createConnection(true, 2);
        connReference = new ConnectionReference(connection);
        threadLocalConnection.set(connReference);
        return connection;
    }

    public static void releaseConnection(Connection conn) {
        ConnectionReference connReference = threadLocalConnection.get();
        if (connReference != null && connReference.connection == conn) {
            --connReference.referenceCount;
            if (connReference.referenceCount <= 0) {
                threadLocalConnection.set(null);
                try {
                    connReference.connection.close();
                }
                catch (SQLException sQLException) {}
            }
        } else {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private static class ConnectionReference {
        protected Connection connection;
        protected int referenceCount;

        protected ConnectionReference(Connection conn) {
            this.connection = conn;
            this.referenceCount = 1;
        }
    }
}

