/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.cache;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import java.util.function.UnaryOperator;
import org.compiere.model.PO;
import org.compiere.util.CCache;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class POCopyCache<K, V extends PO>
extends CCache<K, V> {
    private static final long serialVersionUID = 7463584909438958260L;

    public POCopyCache(String name, int initialCapacity, int expireMinutes, boolean distributed, int maxSize) {
        super(name, initialCapacity, expireMinutes, distributed, maxSize);
    }

    public POCopyCache(String name, int initialCapacity, int expireMinutes, boolean distributed) {
        super(name, initialCapacity, expireMinutes, distributed);
    }

    public POCopyCache(String name, int initialCapacity, int expireMinutes) {
        super(name, initialCapacity, expireMinutes);
    }

    public POCopyCache(String name, int initialCapacity) {
        super(name, initialCapacity);
    }

    public POCopyCache(String tableName, String name, int initialCapacity, boolean distributed) {
        super(tableName, name, initialCapacity, distributed);
    }

    public POCopyCache(String tableName, String name, int initialCapacity, int expireMinutes, boolean distributed, int maxSize) {
        super(tableName, name, initialCapacity, expireMinutes, distributed, maxSize);
    }

    public POCopyCache(String tableName, String name, int initialCapacity, int expireMinutes, boolean distributed) {
        super(tableName, name, initialCapacity, expireMinutes, distributed);
    }

    public POCopyCache(String tableName, String name, int initialCapacity) {
        super(tableName, name, initialCapacity);
    }

    @Override
    public V put(K key, V value) {
        return this.put(key, value, null);
    }

    public V put(K key, V po, UnaryOperator<V> copyOperator) {
        if (po == null) {
            super.put(key, po);
            return null;
        }
        if (copyOperator == null) {
            try {
                V copy2;
                try {
                    copy2 = this.copyOf(Env.getCtx(), po);
                    if (copy2 != null) {
                        super.put(key, copy2);
                        return copy2;
                    }
                }
                catch (Exception copy2) {
                    // empty catch block
                }
                copy2 = this.copyOf(Env.getCtx(), po, null);
                if (copy2 != null) {
                    super.put(key, copy2);
                    return copy2;
                }
                throw new RuntimeException("No copy constructor for " + po.getClass().getName());
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new RuntimeException("Error calling copy constructor for " + po.getClass().getName() + " : " + e.getMessage(), e);
            }
        }
        PO copy = (PO)copyOperator.apply(po);
        super.put(key, copy);
        return (V)copy;
    }

    @Override
    public V get(Object key) {
        try {
            return this.get(null, key);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public V get(Properties ctx, K key) {
        return this.get(ctx, key, null);
    }

    public V get(Properties ctx, K key, String trxName) {
        PO value = (PO)super.get(key);
        if (value == null) {
            return null;
        }
        if (ctx == null) {
            ctx = Env.getCtx();
        }
        try {
            PO copy2;
            if (Util.isEmpty(trxName, true)) {
                try {
                    copy2 = this.copyOf(ctx, value);
                    if (copy2 != null) {
                        return (V)copy2;
                    }
                }
                catch (Exception copy2) {
                    // empty catch block
                }
            }
            if ((copy2 = this.copyOf(ctx, value, trxName)) != null) {
                return (V)copy2;
            }
            throw new RuntimeException("No copy constructor for " + value.getClass().getName());
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException("Error calling copy constructor for " + value.getClass().getName() + " : " + e.getMessage(), e);
        }
    }

    public V get(K key, UnaryOperator<V> copyOperator) {
        PO value = (PO)super.get(key);
        if (value == null) {
            return null;
        }
        PO copy = (PO)copyOperator.apply(value);
        return (V)copy;
    }

    private V copyOf(Properties ctx, V value, String trxName) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<?> copyConstructor = value.getClass().getDeclaredConstructor(Properties.class, value.getClass(), String.class);
        if (copyConstructor != null) {
            PO copy = (PO)copyConstructor.newInstance(ctx, value, trxName);
            return (V)copy;
        }
        return null;
    }

    private V copyOf(Properties ctx, V value) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<?> copyConstructor = value.getClass().getDeclaredConstructor(Properties.class, value.getClass());
        if (copyConstructor != null) {
            PO copy = (PO)copyConstructor.newInstance(ctx, value);
            return (V)copy;
        }
        return null;
    }
}

