/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.compiere.model.MProduct;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.eevolution.model.MPPProductBOMLine;
import org.eevolution.model.MPPProductPlanning;
import org.eevolution.model.X_PP_Product_BOM;
import org.idempiere.cache.ImmutableIntPOCache;
import org.idempiere.cache.ImmutablePOSupport;

public class MPPProductBOM
extends X_PP_Product_BOM
implements ImmutablePOSupport {
    private static final long serialVersionUID = -5048325803007991296L;
    private static ImmutableIntPOCache<Integer, MPPProductBOM> s_cache = new ImmutableIntPOCache("PP_Product_BOM", 40, 5);
    private List<MPPProductBOMLine> m_lines = null;

    public static boolean isProductMakeToOrder(Properties ctx, int productId, String trxName) {
        String whereClause = "BOMType IN (?,?) AND BOMUse=? AND M_Product_ID=?";
        return new Query(ctx, "PP_Product_BOM", "BOMType IN (?,?) AND BOMUse=? AND M_Product_ID=?", trxName).setClient_ID().setParameters("O", "K", "M", productId).match();
    }

    public static List<MPPProductBOM> getProductBOMs(MProduct product) {
        String whereClause = "M_Product_ID=?";
        return new Query(product.getCtx(), "PP_Product_BOM", whereClause, product.get_TrxName()).setClient_ID().setParameters(product.getM_Product_ID()).setOnlyActiveRecords(true).list();
    }

    public static MPPProductBOM get(int PP_Product_BOM_ID) {
        return MPPProductBOM.get(Env.getCtx(), PP_Product_BOM_ID);
    }

    public static MPPProductBOM get(Properties ctx, int PP_Product_BOM_ID) {
        if (PP_Product_BOM_ID <= 0) {
            return null;
        }
        MPPProductBOM bom = s_cache.get(ctx, PP_Product_BOM_ID, e -> new MPPProductBOM(ctx, (MPPProductBOM)e));
        if (bom != null) {
            return bom;
        }
        bom = new MPPProductBOM(ctx, PP_Product_BOM_ID, null);
        if (bom.get_ID() == PP_Product_BOM_ID) {
            s_cache.put(PP_Product_BOM_ID, bom, e -> new MPPProductBOM(Env.getCtx(), (MPPProductBOM)e));
            return bom;
        }
        return null;
    }

    public static MPPProductBOM getCopy(Properties ctx, int PP_Product_BOM_ID, String trxName) {
        MPPProductBOM bom = MPPProductBOM.get(PP_Product_BOM_ID);
        if (bom != null) {
            bom = new MPPProductBOM(ctx, bom, trxName);
        }
        return bom;
    }

    public static int getBOMSearchKey(MProduct product) {
        int AD_Client_ID = Env.getAD_Client_ID(product.getCtx());
        String sql = "SELECT PP_Product_BOM_ID FROM PP_Product_BOM WHERE Value=? AND M_Product_ID=? AND AD_Client_ID=?";
        return DB.getSQLValueEx(null, sql, product.getValue(), product.get_ID(), AD_Client_ID);
    }

    public static MPPProductBOM getDefault(MProduct product, String trxName) {
        List list;
        MPPProductBOM bom = null;
        int AD_Org_ID = Env.getAD_Org_ID(Env.getCtx());
        String filter = "M_Product_ID=? AND BOMUse=? AND BOMType=? ";
        if (AD_Org_ID > 0) {
            filter = String.valueOf(filter) + "AND AD_Org_ID IN (0, " + AD_Org_ID + ") ";
        }
        Query query = new Query(product.getCtx(), "PP_Product_BOM", filter, trxName).setParameters(product.getM_Product_ID(), "A", "A").setOnlyActiveRecords(true).setClient_ID();
        if (AD_Org_ID > 0) {
            query.setOrderBy("AD_Org_ID Desc");
        }
        if (!((list = query.list()).isEmpty() || AD_Org_ID <= 0 && list.size() != 1)) {
            bom = (MPPProductBOM)list.get(0);
        }
        if (bom != null && trxName == null) {
            s_cache.put(bom.get_ID(), bom);
        }
        return bom;
    }

    public static MPPProductBOM get(MProduct product, int ad_org_id, String trxName) {
        MPPProductPlanning pp;
        MPPProductBOM bom = null;
        Properties ctx = product.getCtx();
        if (ad_org_id > 0 && (pp = MPPProductPlanning.get(ctx, product.getAD_Client_ID(), ad_org_id, product.getM_Product_ID(), trxName)) != null && pp.getPP_Product_BOM_ID() > 0) {
            bom = new MPPProductBOM(ctx, pp.getPP_Product_BOM_ID(), trxName);
        }
        if (bom == null) {
            bom = MPPProductBOM.getDefault(product, trxName);
        }
        return bom;
    }

    public static MPPProductBOM get(MProduct product, int ad_org_id, Timestamp valid, String trxName) {
        MPPProductBOM bom = MPPProductBOM.get(product, ad_org_id, trxName);
        if (bom != null && bom.isValidFromTo(valid)) {
            return bom;
        }
        return null;
    }

    public MPPProductBOM(Properties ctx, int PP_Product_BOM_ID, String trxName) {
        super(ctx, PP_Product_BOM_ID, trxName);
    }

    public MPPProductBOM(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MPPProductBOM(MPPProductBOM copy) {
        this(Env.getCtx(), copy);
    }

    public MPPProductBOM(Properties ctx, MPPProductBOM copy) {
        this(ctx, copy, null);
    }

    public MPPProductBOM(Properties ctx, MPPProductBOM copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
        this.m_lines = copy.m_lines != null ? (List)copy.m_lines.stream().map(e -> new MPPProductBOMLine(ctx, (MPPProductBOMLine)e, trxName)).collect(Collectors.toCollection(ArrayList::new)) : null;
    }

    public MPPProductBOM(Properties ctx, int PP_Product_BOM_ID, String trxName, String ... virtualColumns) {
        super(ctx, PP_Product_BOM_ID, trxName, virtualColumns);
    }

    public MPPProductBOMLine[] getLines(Timestamp valid) {
        ArrayList<MPPProductBOMLine> list = new ArrayList<MPPProductBOMLine>();
        MPPProductBOMLine[] mPPProductBOMLineArray = this.getLines(true);
        int n = mPPProductBOMLineArray.length;
        int n2 = 0;
        while (n2 < n) {
            MPPProductBOMLine bl = mPPProductBOMLineArray[n2];
            if (bl.isValidFromTo(valid)) {
                list.add(bl);
            }
            ++n2;
        }
        return list.toArray(new MPPProductBOMLine[list.size()]);
    }

    public MPPProductBOMLine[] getLines() {
        return this.getLines(false);
    }

    public MPPProductBOMLine[] getLines(boolean reload) {
        if (this.m_lines == null || reload) {
            String whereClause = "PP_Product_BOM_ID=?";
            this.m_lines = new Query(this.getCtx(), "PP_Product_BOMLine", "PP_Product_BOM_ID=?", this.get_TrxName()).setParameters(this.getPP_Product_BOM_ID()).setClient_ID().setOnlyActiveRecords(true).setOrderBy("Line").list();
            if (this.m_lines.size() > 0 && this.is_Immutable()) {
                this.m_lines.stream().forEach(e -> {
                    MPPProductBOMLine mPPProductBOMLine = e.markImmutable();
                });
            }
        }
        return this.m_lines.toArray(new MPPProductBOMLine[this.m_lines.size()]);
    }

    public boolean isValidFromTo(Timestamp date) {
        Timestamp validFrom = this.getValidFrom();
        Timestamp validTo = this.getValidTo();
        if (validFrom != null && date.before(validFrom)) {
            return false;
        }
        return validTo == null || !date.after(validTo);
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (!success) {
            return false;
        }
        this.updateProduct();
        return true;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        int id;
        boolean b2 = super.beforeSave(newRecord);
        if (b2 && "A".equals(this.getBOMType()) && "A".equals(this.getBOMUse()) && this.isActive() && (newRecord || this.is_ValueChanged("BOMType") || this.is_ValueChanged("BOMUse") || this.is_ValueChanged("IsActive") || this.is_ValueChanged("M_Product_ID")) && (id = DB.getSQLValue(this.get_TrxName(), "SELECT PP_Product_BOM_ID FROM PP_Product_BOM WHERE M_Product_ID=? AND BOMType='A' AND BOMUse='A' AND IsActive='Y'  AND PP_Product_BOM_ID != ? AND AD_Org_ID=?", this.getM_Product_ID(), this.getPP_Product_BOM_ID(), this.getAD_Org_ID())) > 0) {
            b2 = false;
            CLogger.getCLogger(this.getClass()).saveError("OnlyOneCurrentActiveMasterBOM", "");
        }
        return b2;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        MProduct product;
        if (!success) {
            return false;
        }
        if (newRecord || this.is_ValueChanged("IsActive")) {
            this.updateProduct();
        }
        if ((product = new MProduct(this.getCtx(), this.getM_Product_ID(), this.get_TrxName())).isBOM() && product.isVerified() && ("A".equals(this.getBOMType()) && "A".equals(this.getBOMUse()) || "A".equals(this.get_ValueOld("BOMType")) && "A".equals(this.get_ValueOld("BOMUse"))) && (this.is_ValueChanged("IsActive") || this.is_ValueChanged("BOMType") || this.is_ValueChanged("BOMUse") || newRecord)) {
            product.setIsVerified(false);
            product.saveEx();
        }
        return true;
    }

    private void updateProduct() {
        int count = new Query(this.getCtx(), "PP_Product_BOM", "M_Product_ID=?", this.get_TrxName()).setParameters(this.getM_Product_ID()).setClient_ID().setOnlyActiveRecords(true).count();
        MProduct product = new MProduct(this.getCtx(), this.getM_Product_ID(), this.get_TrxName());
        product.setIsBOM(count > 0);
        product.saveEx();
    }

    @Override
    public MPPProductBOM markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        if (this.m_lines != null && this.m_lines.size() > 0) {
            this.m_lines.stream().forEach(e -> {
                MPPProductBOMLine mPPProductBOMLine = e.markImmutable();
            });
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MPPProductBOM[").append(this.get_ID()).append("-").append(this.getValue()).append("]");
        return sb.toString();
    }
}

