/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.NegativeInventoryDisallowedException;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MDocType;
import org.compiere.model.MLocator;
import org.compiere.model.MMovement;
import org.compiere.model.MPeriod;
import org.compiere.model.MProduct;
import org.compiere.model.MProject;
import org.compiere.model.MRefList;
import org.compiere.model.MStorageOnHand;
import org.compiere.model.MUser;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.print.ReportEngine;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.eevolution.model.MDDOrderLine;
import org.eevolution.model.X_DD_Order;

public class MDDOrder
extends X_DD_Order
implements DocAction {
    private static final long serialVersionUID = -5997157712614274458L;
    private MDDOrderLine[] m_lines = null;
    private boolean m_forceCreation = false;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;

    public static MDDOrder copyFrom(MDDOrder from, Timestamp dateDoc, int C_DocTypeTarget_ID, boolean isSOTrx, boolean counter, boolean copyASI, String trxName) {
        MDDOrder to = new MDDOrder(from.getCtx(), 0, trxName);
        to.set_TrxName(trxName);
        PO.copyValues(from, to, from.getAD_Client_ID(), from.getAD_Org_ID());
        to.set_ValueNoCheck("DD_Order_ID", I_ZERO);
        to.set_ValueNoCheck("DocumentNo", null);
        to.setDocStatus("DR");
        to.setDocAction("CO");
        to.setC_DocType_ID(0);
        to.setIsSOTrx(isSOTrx);
        to.setIsSelected(false);
        to.setDateOrdered(dateDoc);
        to.setDatePromised(dateDoc);
        to.setDatePrinted(null);
        to.setIsPrinted(false);
        to.setIsApproved(false);
        to.setIsDelivered(false);
        to.setPosted(false);
        to.setProcessed(false);
        if (counter) {
            to.setRef_Order_ID(from.getDD_Order_ID());
        } else {
            to.setRef_Order_ID(0);
        }
        if (!to.save(trxName)) {
            throw new IllegalStateException("Could not create Order");
        }
        if (counter) {
            from.setRef_Order_ID(to.getDD_Order_ID());
        }
        if (to.copyLinesFrom(from, counter, copyASI) == 0) {
            throw new IllegalStateException("Could not create Order Lines");
        }
        return to;
    }

    public MDDOrder(Properties ctx, int DD_Order_ID, String trxName) {
        super(ctx, DD_Order_ID, trxName);
        if (DD_Order_ID == 0) {
            this.setDocStatus("DR");
            this.setDocAction("PR");
            this.setDeliveryRule("A");
            this.setFreightCostRule("I");
            this.setPriorityRule("5");
            this.setDeliveryViaRule("P");
            this.setIsSelected(false);
            this.setIsSOTrx(true);
            this.setIsDropShip(false);
            this.setSendEMail(false);
            this.setIsApproved(false);
            this.setIsPrinted(false);
            this.setIsDelivered(false);
            super.setProcessed(false);
            this.setProcessing(false);
            this.setPosted(false);
            this.setDatePromised(new Timestamp(System.currentTimeMillis()));
            this.setDateOrdered(new Timestamp(System.currentTimeMillis()));
            this.setFreightAmt(Env.ZERO);
            this.setChargeAmt(Env.ZERO);
        }
    }

    public MDDOrder(MProject project, boolean IsSOTrx, String DocSubTypeSO) {
        this(project.getCtx(), 0, project.get_TrxName());
        this.setAD_Client_ID(project.getAD_Client_ID());
        this.setAD_Org_ID(project.getAD_Org_ID());
        this.setC_Campaign_ID(project.getC_Campaign_ID());
        this.setSalesRep_ID(project.getSalesRep_ID());
        this.setC_Project_ID(project.getC_Project_ID());
        this.setDescription(project.getName());
        Timestamp ts = project.getDateContract();
        if (ts != null) {
            this.setDateOrdered(ts);
        }
        if ((ts = project.getDateFinish()) != null) {
            this.setDatePromised(ts);
        }
        this.setC_BPartner_ID(project.getC_BPartner_ID());
        this.setC_BPartner_Location_ID(project.getC_BPartner_Location_ID());
        this.setAD_User_ID(project.getAD_User_ID());
        this.setM_Warehouse_ID(project.getM_Warehouse_ID());
        this.setIsSOTrx(IsSOTrx);
    }

    public MDDOrder(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MDDOrder(Properties ctx, int DD_Order_ID, String trxName, String ... virtualColumns) {
        super(ctx, DD_Order_ID, trxName, virtualColumns);
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(String.valueOf(desc) + " | " + description);
        }
    }

    public void setShip_BPartner_ID(int C_BPartner_ID) {
        super.setC_BPartner_ID(C_BPartner_ID);
    }

    public void setShip_Location_ID(int C_BPartner_Location_ID) {
        super.setC_BPartner_Location_ID(C_BPartner_Location_ID);
    }

    public void setShip_User_ID(int AD_User_ID) {
        super.setAD_User_ID(AD_User_ID);
    }

    public void setBPartner(MBPartner bp) {
        MUser[] contacts;
        MBPartnerLocation[] locs;
        if (bp == null) {
            return;
        }
        this.setC_BPartner_ID(bp.getC_BPartner_ID());
        int ii = 0;
        ii = this.isSOTrx() ? bp.getC_PaymentTerm_ID() : bp.getPO_PaymentTerm_ID();
        ii = this.isSOTrx() ? bp.getM_PriceList_ID() : bp.getPO_PriceList_ID();
        String ss = bp.getDeliveryRule();
        if (ss != null) {
            this.setDeliveryRule(ss);
        }
        if ((ss = bp.getDeliveryViaRule()) != null) {
            this.setDeliveryViaRule(ss);
        }
        ss = bp.getInvoiceRule();
        if (this.getSalesRep_ID() == 0 && (ii = Env.getAD_User_ID(this.getCtx())) != 0) {
            this.setSalesRep_ID(ii);
        }
        if ((locs = bp.getLocations(false)) != null) {
            int i2 = 0;
            while (i2 < locs.length) {
                if (locs[i2].isShipTo()) {
                    super.setC_BPartner_Location_ID(locs[i2].getC_BPartner_Location_ID());
                }
                ++i2;
            }
            if (this.getC_BPartner_Location_ID() == 0 && locs.length > 0) {
                super.setC_BPartner_Location_ID(locs[0].getC_BPartner_Location_ID());
            }
        }
        if (this.getC_BPartner_Location_ID() == 0) {
            this.log.log(Level.SEVERE, "MDDOrder.setBPartner - Has no Ship To Address: " + bp);
        }
        if ((contacts = bp.getContacts(false)) != null && contacts.length == 1) {
            this.setAD_User_ID(contacts[0].getAD_User_ID());
        }
    }

    public int copyLinesFrom(MDDOrder otherOrder, boolean counter, boolean copyASI) {
        if (this.isProcessed() || this.isPosted() || otherOrder == null) {
            return 0;
        }
        MDDOrderLine[] fromLines = otherOrder.getLines(false, null);
        int count = 0;
        int i2 = 0;
        while (i2 < fromLines.length) {
            MDDOrderLine line = new MDDOrderLine(this);
            PO.copyValues(fromLines[i2], line, this.getAD_Client_ID(), this.getAD_Org_ID());
            line.setDD_Order_ID(this.getDD_Order_ID());
            line.setOrder(this);
            if (!copyASI) {
                line.setM_AttributeSetInstance_ID(0);
            }
            line.setQtyDelivered(Env.ZERO);
            line.setQtyReserved(Env.ZERO);
            line.setDateDelivered(null);
            line.setProcessed(false);
            if (line.save(this.get_TrxName())) {
                ++count;
            }
            ++i2;
        }
        if (fromLines.length != count) {
            this.log.log(Level.SEVERE, "Line difference - From=" + fromLines.length + " <> Saved=" + count);
        }
        return count;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MDDOrder[").append(this.get_ID()).append("-").append(this.getDocumentNo()).append(",IsSOTrx=").append(this.isSOTrx()).append(",C_DocType_ID=").append(this.getC_DocType_ID()).append("]");
        return sb.toString();
    }

    @Override
    public String getDocumentInfo() {
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        return String.valueOf(dt.getNameTrl()) + " " + this.getDocumentNo();
    }

    @Override
    public File createPDF() {
        try {
            File temp = File.createTempFile(String.valueOf(this.get_TableName()) + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        ReportEngine re = ReportEngine.get(this.getCtx(), 9, this.getDD_Order_ID());
        if (re == null) {
            return null;
        }
        return re.getPDF(file);
    }

    public MDDOrderLine[] getLines(String whereClause, String orderClause) {
        StringBuilder whereClauseFinal = new StringBuilder("DD_Order_ID").append("=?");
        if (!Util.isEmpty(whereClause, true)) {
            whereClauseFinal.append(" AND (").append(whereClause).append(")");
        }
        List<MDDOrderLine> list = new Query(this.getCtx(), "DD_OrderLine", whereClauseFinal.toString(), this.get_TrxName()).setParameters(this.getDD_Order_ID()).setOrderBy(orderClause).list();
        return list.toArray(new MDDOrderLine[list.size()]);
    }

    public MDDOrderLine[] getLines(boolean requery, String orderBy) {
        if (this.m_lines != null && !requery) {
            MDDOrder.set_TrxName(this.m_lines, this.get_TrxName());
            return this.m_lines;
        }
        String orderClause = "";
        orderClause = orderBy != null && orderBy.length() > 0 ? String.valueOf(orderClause) + orderBy : String.valueOf(orderClause) + "Line";
        this.m_lines = this.getLines(null, orderClause);
        return this.m_lines;
    }

    public MDDOrderLine[] getLines() {
        return this.getLines(false, null);
    }

    public void renumberLines(int step) {
        int number = step;
        MDDOrderLine[] lines = this.getLines(true, null);
        int i2 = 0;
        while (i2 < lines.length) {
            MDDOrderLine line = lines[i2];
            line.setLine(number);
            line.saveEx(this.get_TrxName());
            number += step;
            ++i2;
        }
        this.m_lines = null;
    }

    public MMovement[] getMovement() {
        ArrayList<MMovement> list;
        block6: {
            list = new ArrayList<MMovement>();
            String sql = "SELECT DISTINCT io.* FROM M_MovementLine ml INNER JOIN M_Movement m ON (m.M_Movement_ID = ml.M_Movement_ID) INNER JOIN DD_ORDERLINE ol ON (ol.DD_ORDERLINE_ID=ml.DD_ORDERLINE_ID) INNER JOIN DD_ORDER o ON (o.DD_ORDER_ID=ol.DD_ORDER_ID) WHERE\to.DD_ORDER_ID=? ORDER BY m.Created DESC";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    pstmt.setInt(1, this.getDD_Order_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MMovement(this.getCtx(), rs, this.get_TrxName()));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        MMovement[] retValue = new MMovement[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public String getDocStatusName() {
        return MRefList.getListName(this.getCtx(), 131, this.getDocStatus());
    }

    @Override
    public void setDocAction(String DocAction2) {
        this.setDocAction(DocAction2, false);
    }

    @Override
    public void setProcessed(boolean processed) {
        super.setProcessed(processed);
        if (this.get_ID() == 0) {
            return;
        }
        String set = "SET Processed='" + (processed ? "Y" : "N") + "' WHERE DD_Order_ID=" + this.getDD_Order_ID();
        int noLine = DB.executeUpdate("UPDATE DD_OrderLine " + set, this.get_TrxName());
        this.m_lines = null;
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("setProcessed - " + processed + " - Lines=" + noLine);
        }
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        int ii;
        int context_AD_Org_ID;
        if (this.getAD_Org_ID() == 0 && (context_AD_Org_ID = Env.getAD_Org_ID(this.getCtx())) != 0) {
            this.setAD_Org_ID(context_AD_Org_ID);
            this.log.warning("Changed Org to Context=" + context_AD_Org_ID);
        }
        if (this.getAD_Client_ID() == 0) {
            this.m_processMsg = "AD_Client_ID = 0";
            return false;
        }
        if (newRecord && this.getC_DocType_ID() == 0) {
            this.setC_DocType_ID(0);
        }
        if (this.getM_Warehouse_ID() == 0) {
            int ii2 = Env.getContextAsInt(this.getCtx(), "#M_Warehouse_ID");
            if (ii2 != 0) {
                this.setM_Warehouse_ID(ii2);
            } else {
                this.log.saveError("FillMandatory", Msg.getElement(this.getCtx(), "M_Warehouse_ID"));
                return false;
            }
        }
        if (!newRecord && this.is_ValueChanged("M_Warehouse_ID")) {
            MDDOrderLine[] lines = this.getLines(false, null);
            int i2 = 0;
            while (i2 < lines.length) {
                if (!lines[i2].canChangeWarehouse()) {
                    return false;
                }
                ++i2;
            }
        }
        if (this.getC_BPartner_ID() == 0) {
            this.setBPartner(MBPartner.getTemplate(this.getCtx(), this.getAD_Client_ID()));
        }
        if (this.getC_BPartner_Location_ID() == 0) {
            this.setBPartner(new MBPartner(this.getCtx(), this.getC_BPartner_ID(), null));
        }
        if (this.getSalesRep_ID() == 0 && (ii = Env.getContextAsInt(this.getCtx(), "#AD_User_ID")) != 0) {
            this.setSalesRep_ID(ii);
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success || newRecord) {
            return success;
        }
        if (this.is_ValueChanged("Description") || this.is_ValueChanged("POReference")) {
            String sql = "UPDATE M_Movement i SET (Description,POReference)=(SELECT Description,POReference FROM DD_Order o WHERE i.DD_Order_ID=o.DD_Order_ID) WHERE DocStatus NOT IN ('RE','CL') AND DD_Order_ID=" + this.getDD_Order_ID();
            int no = DB.executeUpdate(sql, this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Description -> #" + no);
            }
        }
        this.afterSaveSync("AD_Org_ID");
        this.afterSaveSync("C_BPartner_ID");
        this.afterSaveSync("C_BPartner_Location_ID");
        this.afterSaveSync("DateOrdered");
        this.afterSaveSync("DatePromised");
        this.afterSaveSync("M_Shipper_ID");
        return true;
    }

    private void afterSaveSync(String columnName) {
        if (this.is_ValueChanged(columnName)) {
            String whereClause = "DD_Order_ID=?";
            List lines = new Query(this.getCtx(), "DD_OrderLine", "DD_Order_ID=?", this.get_TrxName()).setParameters(this.getDD_Order_ID()).list();
            for (MDDOrderLine line : lines) {
                line.set_ValueOfColumn(columnName, this.get_Value(columnName));
                line.saveEx();
                if (!this.log.isLoggable(Level.FINE)) continue;
                this.log.fine(String.valueOf(columnName) + " Lines -> #" + this.get_Value(columnName));
            }
        }
    }

    public void setDocAction(String DocAction2, boolean forceCreation) {
        super.setDocAction(DocAction2);
        this.m_forceCreation = forceCreation;
    }

    @Override
    protected boolean beforeDelete() {
        if (this.isProcessed()) {
            return false;
        }
        this.getLines();
        int i2 = 0;
        while (i2 < this.m_lines.length) {
            this.m_lines[i2].delete(true);
            ++i2;
        }
        return true;
    }

    @Override
    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine(this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("unlockIt - " + this.toString());
        }
        this.setProcessing(false);
        return true;
    }

    @Override
    public boolean invalidateIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.setDocAction("PR");
        return true;
    }

    @Override
    public String prepareIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (!MPeriod.isOpen(this.getCtx(), this.getDateOrdered(), dt.getDocBaseType(), this.getAD_Org_ID())) {
            this.m_processMsg = "@PeriodClosed@";
            return "IN";
        }
        MDDOrderLine[] lines = this.getLines(true, "M_Product_ID");
        if (lines.length == 0) {
            this.m_processMsg = "@NoLines@";
            return "IN";
        }
        if (this.getDeliveryRule() != null && this.getDeliveryRule().equals("O")) {
            int i2 = 0;
            while (i2 < lines.length) {
                MDDOrderLine line = lines[i2];
                MProduct product = line.getProduct();
                if (product != null && product.isExcludeAutoDelivery()) {
                    this.m_processMsg = "@M_Product_ID@ " + product.getValue() + " @IsExcludeAutoDelivery@";
                    return "IN";
                }
                ++i2;
            }
        }
        String mandatoryType = "='Y'";
        String sql = "SELECT COUNT(*) FROM DD_OrderLine ol INNER JOIN M_Product p ON (ol.M_Product_ID=p.M_Product_ID) INNER JOIN M_AttributeSet pas ON (p.M_AttributeSet_ID=pas.M_AttributeSet_ID) WHERE pas.MandatoryType" + mandatoryType + " AND ol.M_AttributeSetInstance_ID IS NULL" + " AND ol.DD_Order_ID=?";
        int no = DB.getSQLValue(this.get_TrxName(), sql, this.getDD_Order_ID());
        if (no != 0) {
            this.m_processMsg = "@LinesWithoutProductAttribute@ (" + no + ")";
            return "IN";
        }
        this.reserveStock(lines);
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        return "IP";
    }

    public void reserveStock(MDDOrderLine[] lines) {
        BigDecimal Volume = Env.ZERO;
        BigDecimal Weight = Env.ZERO;
        StringBuilder errors = new StringBuilder();
        MDDOrderLine[] mDDOrderLineArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            MProduct product;
            MDDOrderLine line = mDDOrderLineArray[n2];
            MLocator locator_from = MLocator.get(this.getCtx(), line.getM_Locator_ID());
            MLocator locator_to = MLocator.get(this.getCtx(), line.getM_LocatorTo_ID());
            BigDecimal reserved_ordered = line.getQtyOrdered().subtract(line.getQtyReserved()).subtract(line.getQtyDelivered());
            if (reserved_ordered.signum() == 0) {
                product = line.getProduct();
                if (product != null) {
                    Volume = Volume.add(product.getVolume().multiply(line.getQtyOrdered()));
                    Weight = Weight.add(product.getWeight().multiply(line.getQtyOrdered()));
                }
            } else {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Line=" + line.getLine() + " - Ordered=" + line.getQtyOrdered() + ",Reserved=" + line.getQtyReserved() + ",Delivered=" + line.getQtyDelivered());
                }
                if ((product = line.getProduct()) != null) {
                    try {
                        if (product.isStocked()) {
                            if (!MStorageOnHand.add(this.getCtx(), locator_to.getM_Locator_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), Env.ZERO, null, this.get_TrxName())) {
                                throw new AdempiereException();
                            }
                            if (!MStorageOnHand.add(this.getCtx(), locator_from.getM_Locator_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstanceTo_ID(), Env.ZERO, null, this.get_TrxName())) {
                                throw new AdempiereException();
                            }
                        }
                        line.setQtyReserved(line.getQtyReserved().add(reserved_ordered));
                        line.saveEx();
                        Volume = Volume.add(product.getVolume().multiply(line.getQtyOrdered()));
                        Weight = Weight.add(product.getWeight().multiply(line.getQtyOrdered()));
                    }
                    catch (NegativeInventoryDisallowedException e) {
                        this.log.severe(e.getMessage());
                        errors.append(Msg.getElement(this.getCtx(), "Line")).append(" ").append(line.getLine()).append(": ");
                        errors.append(e.getMessage()).append("\n");
                    }
                }
            }
            ++n2;
        }
        if (errors.toString().length() > 0) {
            throw new AdempiereException(errors.toString());
        }
        this.setVolume(Volume);
        this.setWeight(Weight);
    }

    @Override
    public boolean approveIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("approveIt - " + this.toString());
        }
        this.setIsApproved(true);
        return true;
    }

    @Override
    public boolean rejectIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("rejectIt - " + this.toString());
        }
        this.setIsApproved(false);
        return true;
    }

    @Override
    public String completeIt() {
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if ("PR".equals(this.getDocAction())) {
            this.setProcessed(false);
            return "IP";
        }
        if (!this.m_justPrepared) {
            String status = this.prepareIt();
            this.m_justPrepared = false;
            if (!"IP".equals(status)) {
                return status;
            }
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.getLines(true, null);
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        StringBuilder info = new StringBuilder();
        String valid = ModelValidationEngine.get().fireDocValidate(this, 9);
        if (valid != null) {
            if (info.length() > 0) {
                info.append(" - ");
            }
            info.append(valid);
            this.m_processMsg = info.toString();
            return "IN";
        }
        this.setProcessed(true);
        this.m_processMsg = info.toString();
        this.setDocAction("CL");
        return "CO";
    }

    @Override
    public boolean voidIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 2);
        if (this.m_processMsg != null) {
            return false;
        }
        MDDOrderLine[] lines = this.getLines(true, "M_Product_ID");
        int i2 = 0;
        while (i2 < lines.length) {
            MDDOrderLine line = lines[i2];
            BigDecimal old = line.getQtyOrdered();
            if (old.signum() != 0) {
                line.addDescription(String.valueOf(Msg.getMsg(this.getCtx(), "Voided")) + " (" + old + ")");
                line.saveEx(this.get_TrxName());
            }
            ++i2;
        }
        this.addDescription(Msg.getMsg(this.getCtx(), "Voided"));
        this.reserveStock(lines);
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 10);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    @Override
    public boolean closeIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 3);
        if (this.m_processMsg != null) {
            return false;
        }
        MDDOrderLine[] lines = this.getLines(true, "M_Product_ID");
        int i2 = 0;
        while (i2 < lines.length) {
            MDDOrderLine line = lines[i2];
            BigDecimal old = line.getQtyOrdered();
            if (old.compareTo(line.getQtyDelivered()) != 0) {
                line.setQtyOrdered(line.getQtyDelivered());
                line.addDescription("Close (" + old + ")");
                line.saveEx(this.get_TrxName());
            }
            ++i2;
        }
        this.reserveStock(lines);
        this.setProcessed(true);
        this.setDocAction("--");
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 11);
        return this.m_processMsg == null;
    }

    @Override
    public boolean reverseCorrectIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 5);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 13);
        if (this.m_processMsg != null) {
            return false;
        }
        return this.voidIt();
    }

    @Override
    public boolean reverseAccrualIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 6);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 14);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public boolean reActivateIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 4);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 12);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setDocAction("CO");
        this.setProcessed(false);
        return true;
    }

    @Override
    public String getSummary() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getDocumentNo());
        if (this.m_lines != null) {
            sb.append(" (#").append(this.m_lines.length).append(")");
        }
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    @Override
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    public int getDoc_User_ID() {
        return this.getSalesRep_ID();
    }

    @Override
    public BigDecimal getApprovalAmt() {
        return null;
    }

    @Override
    public int getC_Currency_ID() {
        return 0;
    }

    public boolean isComplete() {
        String ds = this.getDocStatus();
        return "CO".equals(ds) || "CL".equals(ds) || "RE".equals(ds);
    }
}

