/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.util.CLogger;
import org.compiere.util.Secure;
import org.compiere.util.SecureInterface;

public class SecureEngine {
    private static final String TEST = "This is a 0123456789 .,; -= Test!";
    private static volatile SecureEngine s_engine = null;
    private SecureInterface implementation = null;
    private static CLogger log = CLogger.getCLogger(SecureEngine.class.getName());

    public static void init(Properties ctx) {
        if (s_engine == null) {
            String className = ctx.getProperty("ADEMPIERE_SECURE");
            s_engine = new SecureEngine(className);
        }
    }

    public static void init(String className) {
        if (s_engine == null) {
            s_engine = new SecureEngine(className);
        } else if (className != null && !className.equals(SecureEngine.getClassName())) {
            String msg = "Requested Security class = " + className + " is not the same as the active class = " + SecureEngine.getClassName() + "\nMake sure to set the security class in the start script";
            log.severe(msg);
            System.err.println(msg);
            System.exit(10);
        }
    }

    public static String getClassName() {
        if (s_engine == null) {
            return null;
        }
        return SecureEngine.s_engine.implementation.getClass().getName();
    }

    public static String getSHA512Hash(int iterations, String value, byte[] salt) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        if (s_engine == null) {
            SecureEngine.init(System.getProperties());
        }
        return SecureEngine.s_engine.implementation.getSHA512Hash(iterations, value, salt);
    }

    public static String getDigest(String value) {
        if (s_engine == null) {
            SecureEngine.init(System.getProperties());
        }
        return SecureEngine.s_engine.implementation.getDigest(value);
    }

    public static String encrypt(String value, int AD_Client_ID) {
        boolean inQuotes;
        if (value == null || value.length() == 0) {
            return value;
        }
        if (s_engine == null) {
            SecureEngine.init(System.getProperties());
        }
        boolean bl = inQuotes = value.startsWith("'") && value.endsWith("'");
        if (inQuotes) {
            value = value.substring(1, value.length() - 1);
        }
        String retValue = SecureEngine.s_engine.implementation.encrypt(value, AD_Client_ID);
        if (inQuotes) {
            return "'" + retValue + "'";
        }
        return retValue;
    }

    public static String decrypt(String value, int AD_Client_ID) {
        boolean inQuotes;
        if (value == null) {
            return null;
        }
        if (s_engine == null) {
            SecureEngine.init(System.getProperties());
        }
        boolean bl = inQuotes = value.startsWith("'") && value.endsWith("'");
        if (inQuotes) {
            value = value.substring(1, value.length() - 1);
        }
        String retValue = null;
        retValue = value.startsWith("xyz") && value.endsWith("") ? value.substring("xyz".length(), value.length() - "".length()) : SecureEngine.s_engine.implementation.decrypt(value, AD_Client_ID);
        if (inQuotes) {
            return "'" + retValue + "'";
        }
        return retValue;
    }

    public static Object encrypt(Object value, int AD_Client_ID) {
        if (value instanceof String) {
            return SecureEngine.encrypt((String)value, AD_Client_ID);
        }
        return value;
    }

    public static Object decrypt(Object value, int AD_Client_ID) {
        if (value instanceof String) {
            return SecureEngine.decrypt((String)value, AD_Client_ID);
        }
        return value;
    }

    private SecureEngine(String className) {
        String testE;
        String testC;
        String realClass = className;
        if (realClass == null || realClass.length() == 0) {
            realClass = "org.compiere.util.Secure";
        }
        Exception cause = null;
        try {
            Class<?> clazz = Class.forName(realClass);
            this.implementation = (SecureInterface)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            cause = e;
        }
        if (this.implementation == null) {
            String msg = "Could not initialize: " + realClass + " - " + cause.toString() + "\nCheck start script parameter ADEMPIERE_SECURE";
            log.severe(msg);
            System.err.println(msg);
            System.exit(10);
        }
        if (!(testC = this.implementation.decrypt(testE = this.implementation.encrypt(TEST, 0), 0)).equals(TEST)) {
            throw new IllegalStateException(String.valueOf(realClass) + ": " + TEST + "->" + testE + "->" + testC);
        }
        if (log.isLoggable(Level.CONFIG)) {
            log.config(String.valueOf(realClass) + " initialized - " + this.implementation);
        }
    }

    public static boolean isMatchHash(String hashedText, String hexSalt, String planText) {
        boolean valid = false;
        if (hashedText == null) {
            hashedText = "0000000000000000";
        }
        if (hexSalt == null) {
            hexSalt = "0000000000000000";
        }
        try {
            valid = SecureEngine.getSHA512Hash(1000, planText, Secure.convertHexString(hexSalt)).equals(hashedText);
        }
        catch (NoSuchAlgorithmException ignored) {
            log.log(Level.WARNING, "Password hashing not supported by JVM");
        }
        catch (UnsupportedEncodingException ignored) {
            log.log(Level.WARNING, "Password hashing not supported by JVM");
        }
        return valid;
    }

    private static String test(Object test, Object should) {
        StringBuilder sb = new StringBuilder();
        sb.append(test);
        if (test == null) {
            if (should == null) {
                sb.append(" - ok");
            } else {
                sb.append(" [Should=").append(should).append("] - ERROR");
            }
        } else if (test.equals(should)) {
            sb.append(" - ok");
        } else {
            sb.append(" [Should=").append(should).append("] - ERROR");
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        SecureEngine.init(System.getProperties());
        if (log.isLoggable(Level.INFO)) {
            log.info("Decrypt {test} =" + SecureEngine.test(SecureEngine.decrypt("af2309f390afed74", 0), "test"));
            log.info("Decrypt ~{test}~ =" + SecureEngine.test(SecureEngine.decrypt("~af2309f390afed74~", 0), "test"));
            log.info("Encrypt test =" + SecureEngine.test(SecureEngine.encrypt("test", 0), "af2309f390afed74"));
        }
    }
}

