/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.math.BigDecimal;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.compiere.util.CLogger;
import org.compiere.util.Evaluatee;
import org.compiere.util.Util;

public final class LegacyLogicEvaluator {
    private static final CLogger s_log = CLogger.getCLogger(LegacyLogicEvaluator.class);

    private LegacyLogicEvaluator() {
    }

    public static boolean evaluateLogic(Evaluatee source, String logic) {
        StringTokenizer st = new StringTokenizer(logic.trim(), "&|", true);
        int it = st.countTokens();
        if (it / 2 - (it + 1) / 2 == 0) {
            s_log.severe("Logic does not comply with format '<expression> [<logic> <expression>]' => " + logic);
            return false;
        }
        String exprStrand = st.nextToken().trim();
        if (exprStrand.matches("^@\\d+$") || "@P".equals(exprStrand)) {
            exprStrand = exprStrand.concat(st.nextToken());
            exprStrand = exprStrand.concat(st.nextToken());
        }
        boolean retValue = LegacyLogicEvaluator.evaluateLogicTuple(source, exprStrand);
        while (st.hasMoreTokens()) {
            String logOp = st.nextToken().trim();
            exprStrand = st.nextToken().trim();
            if (exprStrand.matches("^@\\d+$") || "@P".equals(exprStrand)) {
                exprStrand = exprStrand.concat(st.nextToken());
                exprStrand = exprStrand.concat(st.nextToken());
            }
            boolean temp = LegacyLogicEvaluator.evaluateLogicTuple(source, exprStrand);
            if (logOp.equals("&")) {
                retValue &= temp;
                continue;
            }
            if (logOp.equals("|")) {
                retValue |= temp;
                continue;
            }
            s_log.log(Level.SEVERE, "Logic operand '|' or '&' expected => " + logic);
            return false;
        }
        return retValue;
    }

    private static boolean evaluateLogicTuple(Evaluatee source, String logic) {
        String[] list;
        StringTokenizer st = new StringTokenizer(logic.trim(), "!=^><", true);
        if (st.countTokens() != 3) {
            s_log.log(Level.SEVERE, "Logic tuple does not comply with format '@context@=value' where operand could be one of '=!^><' => " + logic);
            return false;
        }
        String first = st.nextToken().trim();
        String firstEval = first.trim();
        if (first.indexOf(64) != -1) {
            first = first.replace('@', ' ').trim();
            String defaultValue = "";
            int idx = first.indexOf(":");
            if (idx >= 0) {
                defaultValue = first.substring(idx + 1, first.length());
                first = first.substring(0, idx);
            }
            if (Util.isEmpty(firstEval = source.get_ValueAsString(first)) && !Util.isEmpty(defaultValue)) {
                firstEval = defaultValue;
            }
        }
        if (firstEval == null) {
            firstEval = "";
        }
        firstEval = firstEval.replace('\'', ' ').replace('\"', ' ').trim();
        String operand = st.nextToken();
        String rightToken = st.nextToken();
        String[] stringArray = list = rightToken.split("[,]");
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            String second = stringArray[n2];
            String secondEval = second.trim();
            if (second.indexOf(64) != -1) {
                second = second.replace('@', ' ').trim();
                secondEval = source.get_ValueAsString(second);
            }
            secondEval = secondEval.replace('\'', ' ').replace('\"', ' ').trim();
            if (first.trim().endsWith("_ID") && firstEval.length() == 0) {
                firstEval = "0";
            }
            if (second.trim().endsWith("_ID") && secondEval.length() == 0) {
                secondEval = "0";
            }
            boolean result = LegacyLogicEvaluator.evaluateLogicTuple(firstEval, operand, secondEval);
            if (s_log.isLoggable(Level.FINEST)) {
                s_log.finest(String.valueOf(logic) + " => \"" + firstEval + "\" " + operand + " \"" + secondEval + "\" => " + result);
            }
            if (result) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean evaluateLogicTuple(String value1, String operand, String value2) {
        if (value1 == null || operand == null || value2 == null) {
            return false;
        }
        BigDecimal value1bd = null;
        BigDecimal value2bd = null;
        try {
            if (!value1.startsWith("'")) {
                value1bd = new BigDecimal(value1);
            }
            if (!value2.startsWith("'")) {
                value2bd = new BigDecimal(value2);
            }
        }
        catch (Exception e) {
            value1bd = null;
            value2bd = null;
        }
        if (operand.equals("=")) {
            if (value1bd != null && value2bd != null) {
                return value1bd.compareTo(value2bd) == 0;
            }
            return value1.compareTo(value2) == 0;
        }
        if (operand.equals("<")) {
            if (value1bd != null && value2bd != null) {
                return value1bd.compareTo(value2bd) < 0;
            }
            return value1.compareTo(value2) < 0;
        }
        if (operand.equals(">")) {
            if (value1bd != null && value2bd != null) {
                return value1bd.compareTo(value2bd) > 0;
            }
            return value1.compareTo(value2) > 0;
        }
        if (value1bd != null && value2bd != null) {
            return value1bd.compareTo(value2bd) != 0;
        }
        return value1.compareTo(value2) != 0;
    }
}

