/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Folder;
import javax.mail.FolderClosedException;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.StoreClosedException;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeUtility;
import javax.xml.bind.DatatypeConverter;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAuthorizationAccount;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;

public class EmailSrv {
    protected static transient CLogger log = CLogger.getCLogger(EmailSrv.class);
    protected String imapHost;
    protected String imapUser;
    protected String imapPass;
    protected int imapPort = 143;
    protected boolean isSSL = false;
    protected Session mailSession;
    protected Store mailStore;

    public EmailSrv(String imapHost, String imapUser, String imapPass, int imapPort, Boolean isSSL) {
        this.imapHost = imapHost;
        this.imapUser = imapUser;
        this.imapPass = imapPass;
        if (isSSL != null) {
            this.isSSL = isSSL;
        } else {
            this.isSSL = this.imapHost.toLowerCase().startsWith("imap.gmail.com");
            if (!this.isSSL && imapPort == 993) {
                this.isSSL = true;
            }
            if (this.isSSL && imapPort != 993) {
                log.warning("because imap is gmail server, force port to 993");
                imapPort = 993;
            }
        }
        this.imapPort = imapPort;
    }

    public EmailSrv(String imapHost, String imapUser, String imapPass) {
        this(imapHost, imapUser, imapPass, imapHost != null && imapHost.toLowerCase().startsWith("imap.gmail.com") ? 993 : 143, imapHost != null && imapHost.toLowerCase().startsWith("imap.gmail.com"));
    }

    public static void logMailPartInfo(Part msg, CLogger log) throws MessagingException {
        StringBuilder emailPartLogInfo = new StringBuilder();
        if (msg instanceof Message) {
            emailPartLogInfo.append("\r\n");
            emailPartLogInfo.append("=============Analysis email:");
            emailPartLogInfo.append(((Message)msg).getSubject());
            emailPartLogInfo.append("=============");
            emailPartLogInfo.append("\r\n");
        } else {
            emailPartLogInfo.append("\r\n");
            emailPartLogInfo.append("  ==mail part==\r\n");
        }
        emailPartLogInfo.append("  Content type:");
        emailPartLogInfo.append(msg.getContentType());
        emailPartLogInfo.append("\r\n");
        emailPartLogInfo.append("  Content type raw:");
        String[] lsContentTypeRaw = msg.getHeader("Content-Type");
        if (lsContentTypeRaw != null) {
            String[] stringArray = lsContentTypeRaw;
            int n = lsContentTypeRaw.length;
            int n2 = 0;
            while (n2 < n) {
                String contentType = stringArray[n2];
                emailPartLogInfo.append(contentType);
                emailPartLogInfo.append("; ");
                ++n2;
            }
        }
        emailPartLogInfo.append("\r\n");
        emailPartLogInfo.append("  Disposition:");
        emailPartLogInfo.append(msg.getDisposition());
        emailPartLogInfo.append("\r\n");
        emailPartLogInfo.append("  ALL heads:");
        emailPartLogInfo.append("\r\n");
        Enumeration allHead = msg.getAllHeaders();
        if (allHead != null) {
            while (allHead.hasMoreElements()) {
                Header head2 = (Header)allHead.nextElement();
                emailPartLogInfo.append("          ");
                emailPartLogInfo.append(head2.getName());
                emailPartLogInfo.append(":");
                emailPartLogInfo.append(head2.getValue());
                emailPartLogInfo.append("\r\n");
            }
        }
        emailPartLogInfo.append("\r\n");
        if (EmailSrv.isBinaryPart(msg) && (msg.getDisposition() == null || msg.getDisposition().trim().equals(""))) {
            log.warning("can't detect attach type");
        }
        if (EmailSrv.isBinaryPart(msg) && "inline".equalsIgnoreCase(msg.getDisposition()) && EmailSrv.getContentID(msg) == null) {
            log.warning("an inline content but has no content-id");
        }
        log.info(emailPartLogInfo.toString());
    }

    protected Session getMailSession() throws Exception {
        boolean isOAuth2;
        if (this.mailSession != null) {
            return this.mailSession;
        }
        Properties props = new Properties();
        props.putAll((Map<?, ?>)System.getProperties());
        String protocol = "imap";
        if (this.isSSL) {
            protocol = "imaps";
        }
        props.put("mail.store.protocol", protocol);
        props.put("mail.host", this.imapHost);
        props.put("mail." + protocol + ".port", (Object)this.imapPort);
        MAuthorizationAccount authAccount = MAuthorizationAccount.getEMailAccount(this.imapUser);
        boolean bl = isOAuth2 = authAccount != null;
        if (isOAuth2) {
            props.put("mail." + protocol + ".ssl.enable", "true");
            props.put("mail." + protocol + ".auth.mechanisms", "XOAUTH2");
            this.imapPass = authAccount.refreshAndGetAccessToken();
        }
        this.mailSession = Session.getInstance((Properties)props);
        this.mailSession.setDebug(CLogMgt.isLevelFinest());
        return this.mailSession;
    }

    public Store getMailStore() throws Exception {
        if (this.mailStore != null) {
            return this.mailStore;
        }
        this.mailStore = this.getMailSession().getStore();
        this.mailStore.connect(this.imapHost, this.imapUser, this.imapPass);
        return this.mailStore;
    }

    public void clearResource() {
        if (this.mailStore != null && this.mailStore.isConnected()) {
            try {
                this.mailStore.close();
            }
            catch (MessagingException e) {
                e.printStackTrace();
            }
        }
    }

    public static Folder getFolder(Store mailStore, String folderName, Boolean isNestInbox, boolean createWhenNonExists) throws MessagingException {
        if (folderName == null || "".equals(folderName.trim())) {
            throw new AdempiereException("Can't open a folder with empty name");
        }
        char folderSeparate = '\\';
        Folder openFolder = null;
        if (isNestInbox.booleanValue()) {
            Folder inboxFolder = mailStore.getDefaultFolder();
            if (!inboxFolder.exists()) {
                throw new AdempiereException("This mail account hasn't an inbox folder");
            }
            folderSeparate = inboxFolder.getSeparator();
            openFolder = inboxFolder.getFolder(folderName.replace('\\', folderSeparate));
        } else {
            String[] lsFolderName = folderName.split("\\\\");
            if (lsFolderName.length > 0) {
                Folder testFolder = mailStore.getFolder(lsFolderName[0]);
                folderSeparate = testFolder.getSeparator();
                folderName = folderName.replace('\\', folderSeparate);
            }
            openFolder = mailStore.getFolder(folderName);
        }
        openFolder = mailStore.getFolder(folderName);
        if (!openFolder.exists()) {
            if (createWhenNonExists) {
                if (!openFolder.create(1)) {
                    throw new AdempiereException("folder doesn't exist and can't create:" + folderName);
                }
            } else {
                throw new AdempiereException("doesn't exists folder:" + folderName);
            }
        }
        openFolder.open(2);
        return openFolder;
    }

    public static boolean readEmailFolder(EmailSrv emailSrv, String folderName, Boolean isNestInbox, ProcessEmailHandle processEmailHandle) {
        Message[] lsMsg = null;
        Folder readerFolder = null;
        Store mailStore = null;
        ClassLoader tcl = null;
        try {
            tcl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(Session.class.getClassLoader());
                mailStore = emailSrv.getMailStore();
                readerFolder = EmailSrv.getFolder(mailStore, folderName, isNestInbox, false);
                lsMsg = readerFolder.getMessages();
            }
            catch (MessagingException e) {
                e.printStackTrace();
                emailSrv.clearResource();
                throw new AdempiereException(e.getMessage());
            }
            catch (AdempiereException appEx) {
                throw appEx;
            }
            catch (Exception e) {
                e.printStackTrace();
                emailSrv.clearResource();
                throw new AdempiereException(e.getMessage());
            }
            int numOfTry = 0;
            int numeOfContinueErrorEmail = 0;
            int i2 = 0;
            while (i2 < lsMsg.length) {
                EmailContent processEmail = null;
                Message readerMsg = lsMsg[i2];
                try {
                    if (!mailStore.isConnected()) {
                        mailStore.connect();
                    }
                    if (!readerFolder.isOpen()) {
                        readerFolder.open(2);
                    }
                    if (processEmailHandle != null && processEmailHandle.getListFolder() != null && processEmailHandle.getListFolder().size() > 0) {
                        for (Folder exFolder : processEmailHandle.getListFolder()) {
                            if (exFolder.isOpen()) continue;
                            exFolder.open(2);
                        }
                    }
                    processEmail = EmailSrv.processMessage(readerMsg, processEmailHandle, mailStore, readerFolder);
                    ++i2;
                    numOfTry = 0;
                    numeOfContinueErrorEmail = 0;
                }
                catch (Exception e) {
                    block21: {
                        if ((e instanceof FolderClosedException || e instanceof StoreClosedException || e instanceof IOException) && numOfTry < 3) {
                            log.warning("network disconnect, retry read email");
                            try {
                                Thread.sleep(5000L);
                                ++numOfTry;
                            }
                            catch (InterruptedException e1) {
                                e1.printStackTrace();
                            }
                            continue;
                        }
                        ++numeOfContinueErrorEmail;
                        ++i2;
                        try {
                            processEmailHandle.processEmailError(processEmail, readerMsg, mailStore, readerFolder);
                        }
                        catch (MessagingException e1) {
                            if (processEmail == null) {
                                log.log(Level.SEVERE, String.format("can't complete handle error when process message with exception:%1$s", e1.getMessage()));
                                break block21;
                            }
                            log.log(Level.SEVERE, String.format("can't complete handle error when process message with exception:%1$s-%2$s-%3$s", processEmail.subject, processEmail.messageID, e1.getMessage()));
                        }
                    }
                    if (e instanceof FolderClosedException || e instanceof StoreClosedException || e instanceof IOException) {
                        throw new AdempiereException("can't reopen email store for process after three tries");
                    }
                    if (numeOfContinueErrorEmail <= 5) continue;
                    emailSrv.clearResource();
                    throw new AdempiereException("have 5 email errors when process");
                }
            }
            emailSrv.clearResource();
        }
        finally {
            Thread.currentThread().setContextClassLoader(tcl);
        }
        return true;
    }

    public static EmailContent processMessage(Message msg) throws MessagingException, IOException {
        return EmailSrv.processMessage(msg, null, null, null);
    }

    public static EmailContent processMessage(Message msg, ProcessEmailHandle evaluateEmailHead, Store mailStore, Folder mailFolder) throws MessagingException, IOException {
        String[] lsMessageId;
        EmailContent emailInfo = new EmailContent();
        Address[] from = msg.getFrom();
        if (from != null) {
            Address[] addressArray = from;
            int n = from.length;
            int n2 = 0;
            while (n2 < n) {
                Address fromAddress = addressArray[n2];
                String address = null;
                address = fromAddress.toString().startsWith("<") && fromAddress.toString().endsWith(">") ? fromAddress.toString().substring(1, fromAddress.toString().length() - 1) : fromAddress.toString();
                emailInfo.fromAddress.add(address);
                ++n2;
            }
        }
        if ((lsMessageId = EmailSrv.getPartHeader((Part)msg, "Message-ID")) != null) {
            emailInfo.messageID = lsMessageId[0];
        }
        emailInfo.subject = msg.getSubject();
        emailInfo.sentDate = msg.getSentDate();
        if (evaluateEmailHead != null && evaluateEmailHead.checkEmailHeader(emailInfo, msg)) {
            return null;
        }
        EmailSrv.analysisEmailStructure((Part)msg, emailInfo, true);
        if (evaluateEmailHead != null) {
            evaluateEmailHead.processEmailContent(emailInfo, msg, mailStore, mailFolder);
        }
        return emailInfo;
    }

    public static void analysisEmailStructure(Part msg, EmailContent emailContent) throws MessagingException, IOException {
        EmailSrv.analysisEmailStructure(msg, emailContent, false);
    }

    public static void analysisEmailStructure(Part msg, EmailContent emailContent, boolean isRoot) throws MessagingException, IOException {
        EmailSrv.logMailPartInfo(msg, log);
        boolean isUnknowPart = false;
        if (msg.isMimeType("text/*")) {
            if ("attachment".equalsIgnoreCase(msg.getDisposition())) {
                if (msg instanceof BodyPart) {
                    emailContent.lsAttachPart.add((BodyPart)msg);
                } else {
                    log.warning("can't detect where this file from");
                }
                return;
            }
            String txtContent = msg.getContent().toString();
            if (txtContent != null && msg.isMimeType("text/html")) {
                emailContent.htmlContentBuild.append(EmailSrv.getTextFromMailPart(msg));
            } else if (txtContent != null) {
                emailContent.textContentBuil.append(EmailSrv.getTextFromMailPart(msg));
            } else {
                log.info("has non content in this part");
            }
        } else if (msg.isMimeType("message/rfc822")) {
            log.warning("check html content of message/rfc822");
            emailContent.textContentBuil.append(msg.getContent());
        } else if (msg.isMimeType("multipart/*")) {
            Multipart mp = (Multipart)msg.getContent();
            int count = mp.getCount();
            int i2 = 0;
            while (i2 < count) {
                BodyPart part = mp.getBodyPart(i2);
                EmailSrv.analysisEmailStructure((Part)part, emailContent);
                ++i2;
            }
        } else if (EmailSrv.isBinaryPart(msg)) {
            if (msg instanceof BodyPart) {
                BodyPart attachPart = (BodyPart)msg;
                if (attachPart.getDisposition() == null || attachPart.getDisposition().equalsIgnoreCase("inline")) {
                    emailContent.lsEmbedPart.add(attachPart);
                } else if (attachPart.getDisposition().equalsIgnoreCase("attachment")) {
                    emailContent.lsAttachPart.add(attachPart);
                } else {
                    isUnknowPart = true;
                }
            } else {
                log.warning("TODO:content type is a binary, but isn't a instance of BodyPart");
            }
        } else {
            isUnknowPart = true;
        }
        if (isUnknowPart) {
            emailContent.lsUnknowPart.add(msg);
            log.warning("an unknown part, this content will miss");
        }
    }

    public static String getTextFromMailPart(Part txtPart) throws MessagingException, IOException {
        String text;
        block15: {
            StringBuilder sb;
            text = null;
            try {
                Object content = txtPart.getContent();
                if (content != null) {
                    text = content.toString();
                }
                break block15;
            }
            catch (UnsupportedEncodingException uex) {
                log.info("http://www.oracle.com/technetwork/java/javamail/faq/index.html#unsupen");
                log.warning(uex.getMessage());
                ContentType cType = new ContentType(txtPart.getContentType());
                String emailCharsetStr = cType.getParameter("charset");
                String javaCharset = MimeUtility.javaCharset((String)emailCharsetStr);
                Charset emailCharset = Charset.forName("ISO_8859_1");
                if (Charset.isSupported(javaCharset)) {
                    emailCharset = Charset.forName(javaCharset);
                }
                log.warning("try read with charset " + emailCharset.displayName() + " maybe make break text");
                String str = null;
                sb = new StringBuilder(8192);
                InputStream is = null;
                try {
                    is = txtPart.getInputStream();
                    BufferedReader bufferReader = new BufferedReader(new InputStreamReader(is, emailCharset));
                    while ((str = bufferReader.readLine()) != null) {
                        sb.append(str);
                    }
                }
                finally {
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
            text = sb.toString();
        }
        return text;
    }

    public static byte[] getBinaryData(Part binaryPart) throws IOException, MessagingException {
        InputStream in = null;
        try {
            in = binaryPart.getInputStream();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int BUF_SIZE = 256;
            byte[] buffer = new byte[256];
            int bytesRead = -1;
            while ((bytesRead = in.read(buffer)) > -1) {
                out.write(buffer, 0, bytesRead);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (IOException ioe) {
            log.warning("exception when read attach in email");
            throw ioe;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static String getBinaryAsBASE64(BodyPart mailPart) throws IOException, MessagingException {
        return DatatypeConverter.printBase64Binary((byte[])EmailSrv.getBinaryData((Part)mailPart));
    }

    public static String embedImgToEmail(String mailContent, ProvideBase64Data provideBase64Data) throws Exception {
        return EmailSrv.embedImgToEmail(mailContent, provideBase64Data, "\\s+src\\s*=\\s*\"cid:(.*?)\"");
    }

    public static String embedImgToEmail(String mailContent, ProvideBase64Data provideBase64Data, String embedPattern) throws MessagingException, IOException {
        String startString;
        String origonSign = mailContent;
        Pattern imgPattern = Pattern.compile(embedPattern);
        Matcher imgMatcher = imgPattern.matcher(origonSign);
        ArrayList<String> lsPart = new ArrayList<String>();
        ArrayList<String> lsImgSrc = new ArrayList<String>();
        int startIndex = 0;
        int startIndexMatch = 0;
        int endIndexMatch = 0;
        while (imgMatcher.find()) {
            startIndexMatch = imgMatcher.start();
            endIndexMatch = imgMatcher.end();
            startString = origonSign.substring(startIndex, startIndexMatch);
            lsPart.add(startString);
            lsImgSrc.add(imgMatcher.group(1).trim());
            startIndex = endIndexMatch;
        }
        startString = origonSign.substring(startIndex);
        lsPart.add(startString);
        if (lsPart.size() == 0 || lsImgSrc.size() == 0) {
            return origonSign;
        }
        StringBuilder reconstructSign = new StringBuilder();
        int i2 = 0;
        while (i2 < lsImgSrc.size()) {
            String imageBase64;
            if (i2 == 0) {
                reconstructSign.append((String)lsPart.get(0));
            }
            if ((imageBase64 = provideBase64Data.getBase64Data((String)lsImgSrc.get(i2))) == null) {
                log.warning("miss data of image has id is:" + (String)lsImgSrc.get(i2));
            } else {
                reconstructSign.append(" alt=\"inline_image_").append((String)lsImgSrc.get(i2)).append("\" src=\"data:image/jpeg;base64,").append(imageBase64).append("\"");
            }
            reconstructSign.append((String)lsPart.get(i2 + 1));
            ++i2;
        }
        return reconstructSign.toString();
    }

    public static ArrayList<BodyPart> getEmbededImages(String mailContent, ProvideBase64Data provideBase64Data, String embedPattern) throws MessagingException, IOException {
        ArrayList<BodyPart> bodyPartImagesList = new ArrayList<BodyPart>();
        String origonSign = mailContent;
        Pattern imgPattern = Pattern.compile(embedPattern);
        Matcher imgMatcher = imgPattern.matcher(origonSign);
        ArrayList<String> lsImgSrc = new ArrayList<String>();
        while (imgMatcher.find()) {
            lsImgSrc.add(imgMatcher.group(1).trim());
        }
        if (lsImgSrc.size() == 0) {
            return bodyPartImagesList;
        }
        int i2 = 0;
        while (i2 < lsImgSrc.size()) {
            BodyPart image = provideBase64Data.getBodyPart((String)lsImgSrc.get(i2));
            if (image == null) {
                log.warning("miss data of image has id is:" + (String)lsImgSrc.get(i2));
            } else {
                bodyPartImagesList.add(image);
            }
            ++i2;
        }
        return bodyPartImagesList;
    }

    public static boolean isBinaryPart(Part binaryPart) throws MessagingException {
        return binaryPart.isMimeType("application/*") || binaryPart.isMimeType("image/*");
    }

    public static String getContentID(Part attachPart) throws MessagingException {
        String contentValue;
        int n;
        int n2;
        String[] stringArray;
        String[] lsContentID = attachPart.getHeader("Content-Id");
        String contentID = null;
        if (lsContentID != null) {
            stringArray = lsContentID;
            n2 = lsContentID.length;
            n = 0;
            while (n < n2) {
                contentValue = stringArray[n];
                if (contentValue != null && !"".equals(contentValue.trim())) {
                    if (contentID != null && !contentID.equals(contentValue.trim())) {
                        log.warning("has difference value of Content-Id");
                    }
                    contentID = contentValue;
                }
                ++n;
            }
        }
        if (contentID != null && contentID.startsWith("<") && contentID.endsWith(">")) {
            contentID = contentID.substring(1, contentID.length() - 1);
        }
        if ((lsContentID = attachPart.getHeader("X-Attachment-Id")) != null) {
            stringArray = lsContentID;
            n2 = lsContentID.length;
            n = 0;
            while (n < n2) {
                contentValue = stringArray[n];
                if (contentValue != null && !"".equals(contentValue.trim())) {
                    if (contentID != null && !contentID.equals(contentValue.trim())) {
                        log.warning("value of X-Attachment-Id difference value of Content-Id");
                    }
                    if (contentID == null) {
                        contentID = contentValue;
                    }
                }
                ++n;
            }
        }
        return contentID;
    }

    public static String[] getPartHeader(Part msg, String headerName) throws MessagingException {
        String[] headers = msg.getHeader(headerName);
        if (headers != null) {
            int i2 = 0;
            while (i2 < headers.length) {
                String head2 = headers[i2];
                if (head2.toString().startsWith("<") && head2.endsWith(">")) {
                    headers[i2] = head2 = head2.substring(1, head2.length() - 1);
                }
                ++i2;
            }
        }
        return headers;
    }

    public static class EmailContent {
        public List<String> fromAddress = new ArrayList<String>();
        public String messageID;
        public String subject;
        public Date sentDate;
        public StringBuilder textContentBuil = new StringBuilder();
        public StringBuilder htmlContentBuild = new StringBuilder();
        public List<BodyPart> lsAttachPart = new ArrayList<BodyPart>();
        public List<BodyPart> lsEmbedPart = new ArrayList<BodyPart>();
        public List<Part> lsUnknowPart = new ArrayList<Part>();

        public String getHtmlContent(boolean withEmbedImg) throws MessagingException, IOException {
            if (this.htmlContentBuild == null || this.htmlContentBuild.length() == 0) {
                return null;
            }
            EmailEmbedProvideBase64Data provideBase64Data = new EmailEmbedProvideBase64Data(this);
            return EmailSrv.embedImgToEmail(this.htmlContentBuild.toString(), provideBase64Data, "\\s+src\\s*=\\s*(?:3D)?\\s*\"cid:(.*?)\"");
        }

        public ArrayList<BodyPart> getHTMLImageBodyParts() throws MessagingException, IOException {
            if (this.htmlContentBuild == null || this.htmlContentBuild.length() == 0) {
                return null;
            }
            EmailEmbedProvideBase64Data provideBase64Data = new EmailEmbedProvideBase64Data(this);
            return EmailSrv.getEmbededImages(this.htmlContentBuild.toString(), provideBase64Data, "\\s+src\\s*=\\s*(?:3D)?\\s*\"cid:(.*?)\"");
        }

        public String getTextContent() {
            return this.textContentBuil.toString();
        }
    }

    public static class EmailEmbedProvideBase64Data
    implements ProvideBase64Data {
        private EmailContent emailContent;

        public EmailEmbedProvideBase64Data(EmailContent emailContent) {
            this.emailContent = emailContent;
        }

        @Override
        public String getBase64Data(String contentId) throws MessagingException, IOException {
            if (contentId == null) {
                return null;
            }
            for (BodyPart imageEmbed : this.emailContent.lsEmbedPart) {
                if (!contentId.equalsIgnoreCase(EmailSrv.getContentID((Part)imageEmbed))) continue;
                return EmailSrv.getBinaryAsBASE64(imageEmbed);
            }
            return null;
        }

        @Override
        public BodyPart getBodyPart(String contentId) throws MessagingException, IOException {
            if (contentId == null) {
                return null;
            }
            for (BodyPart imageEmbed : this.emailContent.lsEmbedPart) {
                if (!contentId.equalsIgnoreCase(EmailSrv.getContentID((Part)imageEmbed))) continue;
                return imageEmbed;
            }
            return null;
        }
    }

    public static interface ProcessEmailHandle {
        public boolean checkEmailHeader(EmailContent var1, Message var2) throws MessagingException;

        public void processEmailError(EmailContent var1, Message var2, Store var3, Folder var4) throws MessagingException;

        public void processEmailContent(EmailContent var1, Message var2, Store var3, Folder var4) throws MessagingException, IOException;

        public List<Folder> getListFolder();
    }

    public static interface ProvideBase64Data {
        public String getBase64Data(String var1) throws MessagingException, IOException;

        public BodyPart getBodyPart(String var1) throws MessagingException, IOException;
    }
}

