/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.adempiere.base.Core;
import org.compiere.Adempiere;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CacheChangeListener;
import org.compiere.util.CacheInfo;
import org.compiere.util.CacheInterface;
import org.compiere.util.CacheNewRecordCallable;
import org.compiere.util.ResetCacheCallable;
import org.idempiere.distributed.ICacheService;
import org.idempiere.distributed.IClusterMember;
import org.idempiere.distributed.IClusterService;

public class CacheMgt {
    private static CacheMgt s_cache;
    private ArrayList<CacheInterface> m_instances = new ArrayList();
    private ArrayList<String> m_tableNames = new ArrayList();
    private static CLogger log;
    private List<CacheChangeListener> m_listeners = new ArrayList<CacheChangeListener>();
    private static final CacheMonitor s_monitor;
    public static int MAX_SIZE;

    static {
        block5: {
            s_cache = null;
            log = CLogger.getCLogger(CacheMgt.class);
            s_monitor = new CacheMonitor();
            MAX_SIZE = 1000;
            try {
                String maxSize = System.getProperty("Cache.MaxSize");
                if (maxSize == null || maxSize.trim().length() <= 0) break block5;
                int max = 0;
                try {
                    max = Integer.parseInt(maxSize.trim());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (max > 0) {
                    MAX_SIZE = max;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static synchronized CacheMgt get() {
        if (s_cache == null) {
            s_cache = new CacheMgt();
            CacheMgt.startCacheMonitor();
        }
        return s_cache;
    }

    private CacheMgt() {
    }

    public synchronized <K, V> Map<K, V> register(CCache<K, V> instance, boolean distributed) {
        IClusterService clusterService;
        ICacheService provider;
        if (instance == null) {
            return null;
        }
        String name = instance.getName();
        String tableName = instance.getTableName();
        if (tableName != null) {
            this.m_tableNames.add(tableName);
        }
        this.m_instances.add(instance);
        if (tableName == null && instance instanceof CacheChangeListener) {
            this.m_listeners.add((CacheChangeListener)((Object)instance));
        }
        Map map = null;
        if (distributed && (provider = Core.getCacheService()) != null && (clusterService = Core.getClusterService()) != null && !clusterService.isStandAlone()) {
            map = provider.getMap(name);
        }
        if (map == null) {
            map = Collections.synchronizedMap(new MaxSizeHashMap(instance.getMaxSize()));
        }
        return map;
    }

    public synchronized boolean unregister(CacheInterface instance) {
        if (instance == null) {
            return false;
        }
        boolean found = false;
        int i2 = this.m_instances.size() - 1;
        while (i2 >= 0) {
            CacheInterface stored = this.m_instances.get(i2);
            if (instance.equals(stored)) {
                this.m_instances.remove(i2);
                found = true;
            }
            --i2;
        }
        return found;
    }

    private int clusterReset() {
        return this.clusterReset(null, -1);
    }

    private int clusterReset(String tableName, int recordId) {
        IClusterService service = Core.getClusterService();
        if (service != null) {
            ResetCacheCallable callable = new ResetCacheCallable(tableName, recordId);
            Map<IClusterMember, Future<Integer>> futureMap = service.execute(callable, service.getMembers());
            if (futureMap != null) {
                int total = 0;
                try {
                    Collection<Future<Integer>> results = futureMap.values();
                    for (Future<Integer> i2 : results) {
                        total += i2.get().intValue();
                    }
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                catch (ExecutionException e) {
                    if (e.getCause() != null) {
                        if (e.getCause() instanceof RuntimeException) {
                            throw (RuntimeException)e.getCause();
                        }
                        throw new RuntimeException(e.getCause());
                    }
                    throw new RuntimeException(e);
                }
                return total;
            }
            return this.resetLocalCache(tableName, recordId);
        }
        return this.resetLocalCache(tableName, recordId);
    }

    private void clusterNewRecord(String tableName, int recordId) {
        IClusterService service = Core.getClusterService();
        if (service != null) {
            CacheNewRecordCallable callable = new CacheNewRecordCallable(tableName, recordId);
            if (service.execute(callable, service.getMembers()) == null) {
                this.localNewRecord(tableName, recordId);
            }
        } else {
            this.localNewRecord(tableName, recordId);
        }
    }

    public int reset() {
        return this.clusterReset();
    }

    public int reset(String tableName) {
        return this.reset(tableName, -1);
    }

    public int reset(String tableName, int Record_ID) {
        return this.clusterReset(tableName, Record_ID);
    }

    public int resetLocalCache() {
        CacheInterface[] instances;
        int counter = 0;
        int total = 0;
        CacheInterface[] cacheInterfaceArray = instances = this.getInstancesAsArray();
        int n = instances.length;
        int n2 = 0;
        while (n2 < n) {
            CacheInterface stored = cacheInterfaceArray[n2];
            if (stored != null && stored.size() > 0) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(stored.toString());
                }
                total += stored.reset();
                ++counter;
            }
            ++n2;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("#" + counter + " (" + total + ")");
        }
        return total;
    }

    public synchronized CacheInterface[] getInstancesAsArray() {
        return this.m_instances.toArray(new CacheInterface[0]);
    }

    protected int resetLocalCache(String tableName, int Record_ID) {
        CacheChangeListener[] listeners;
        CacheInterface[] instances;
        if (tableName == null) {
            return this.resetLocalCache();
        }
        if (!this.m_tableNames.contains(tableName)) {
            return 0;
        }
        int counter = 0;
        int total = 0;
        CacheInterface[] cacheInterfaceArray = instances = this.getInstancesAsArray();
        int n = instances.length;
        int n2 = 0;
        while (n2 < n) {
            CCache cc;
            CacheInterface stored = cacheInterfaceArray[n2];
            if (stored != null && stored instanceof CCache && (cc = (CCache)stored).getTableName() != null && cc.getTableName().startsWith(tableName)) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("(all) - " + stored);
                }
                total += stored.reset(Record_ID);
                ++counter;
            }
            ++n2;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.valueOf(tableName) + ": #" + counter + " (" + total + ")");
        }
        CacheChangeListener[] cacheChangeListenerArray = listeners = this.m_listeners.toArray(new CacheChangeListener[0]);
        int n3 = listeners.length;
        n = 0;
        while (n < n3) {
            CacheChangeListener listener = cacheChangeListenerArray[n];
            if (Record_ID == -1) {
                listener.reset(tableName);
            } else {
                listener.reset(tableName, Record_ID);
            }
            ++n;
        }
        return total;
    }

    protected void localNewRecord(String tableName, int Record_ID) {
        CacheInterface[] instances;
        if (tableName == null) {
            return;
        }
        if (!this.m_tableNames.contains(tableName)) {
            return;
        }
        CacheInterface[] cacheInterfaceArray = instances = this.getInstancesAsArray();
        int n = instances.length;
        int n2 = 0;
        while (n2 < n) {
            CCache cc;
            CacheInterface stored = cacheInterfaceArray[n2];
            if (stored != null && stored instanceof CCache && (cc = (CCache)stored).getTableName() != null && cc.getTableName().startsWith(tableName)) {
                stored.newRecord(Record_ID);
            }
            ++n2;
        }
    }

    public int getElementCount() {
        CacheInterface[] instances;
        int total = 0;
        CacheInterface[] cacheInterfaceArray = instances = this.getInstancesAsArray();
        int n = instances.length;
        int n2 = 0;
        while (n2 < n) {
            CacheInterface stored = cacheInterfaceArray[n2];
            if (stored != null && stored.size() > 0) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(stored.toString());
                }
                total = stored instanceof CCache ? (total += ((CCache)stored).sizeNoExpire()) : (total += stored.size());
            }
            ++n2;
        }
        return total;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CacheMgt[");
        sb.append("Instances=").append(this.m_instances.size()).append("]");
        return sb.toString();
    }

    public String toStringX() {
        StringBuilder sb = new StringBuilder("CacheMgt[");
        sb.append("Instances=").append(this.m_instances.size()).append(", Elements=").append(this.getElementCount()).append("]");
        return sb.toString();
    }

    public void newRecord(String tableName, int recordId) {
        this.clusterNewRecord(tableName, recordId);
    }

    public List<CacheInfo> getCacheInfos() {
        CacheInterface[] instances;
        ArrayList<CacheInfo> infos = new ArrayList<CacheInfo>();
        CacheInterface[] cacheInterfaceArray = instances = this.getInstancesAsArray();
        int n = instances.length;
        int n2 = 0;
        while (n2 < n) {
            CacheInterface ci = cacheInterfaceArray[n2];
            if (ci instanceof CCache) {
                infos.add(new CacheInfo((CCache)ci));
            }
            ++n2;
        }
        return infos;
    }

    private static synchronized void startCacheMonitor() {
        Adempiere.getThreadPoolExecutor().scheduleWithFixedDelay(s_monitor, 5L, 5L, TimeUnit.MINUTES);
    }

    public boolean hasCache(String tableName) {
        return this.m_tableNames.contains(tableName);
    }

    private static class CacheMonitor
    implements Runnable {
        private CacheMonitor() {
        }

        @Override
        public void run() {
            CacheMgt instance = CacheMgt.get();
            if (!instance.m_instances.isEmpty()) {
                CacheInterface[] caches = instance.m_instances.toArray(new CacheInterface[0]);
                int i2 = 0;
                while (i2 < caches.length) {
                    CCache cache;
                    if (caches[i2] instanceof CCache && !(cache = (CCache)caches[i2]).isDistributed() && cache.getExpireMinutes() > 0 && cache.isExpire()) {
                        cache.reset();
                    }
                    ++i2;
                }
            }
        }
    }

    private static class MaxSizeHashMap<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = 5532596165440544235L;
        private final int maxSize;

        public MaxSizeHashMap(int maxSize) {
            this.maxSize = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.maxSize <= 0 ? false : this.size() > this.maxSize;
        }
    }
}

