/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.io.File;
import java.io.FileWriter;
import java.sql.Timestamp;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.compiere.util.CLogFilter;
import org.compiere.util.CLogFormatter;
import org.compiere.util.CLogMgt;
import org.compiere.util.Ini;

public class CLogFile
extends Handler {
    private String m_idempiereHome = null;
    private boolean m_doneHeader = false;
    private File m_file = null;
    private FileWriter m_writer = null;
    private String m_fileNameDate = "";
    private int m_records = 0;
    private File m_previousFile;

    public CLogFile(String idempiereHome, boolean createLogDir, boolean isClient) {
        this.m_idempiereHome = idempiereHome != null && idempiereHome.length() > 0 ? idempiereHome : Ini.findAdempiereHome();
        this.initialize(this.m_idempiereHome, createLogDir, isClient);
    }

    private void initialize(String idempiereHome, boolean createLogDir, boolean isClient) {
        if (this.m_writer != null) {
            this.close();
        }
        this.m_doneHeader = false;
        if (!this.createFile(idempiereHome, createLogDir, isClient)) {
            return;
        }
        try {
            this.m_writer = new FileWriter(this.m_file, true);
            this.m_records = 0;
        }
        catch (Exception ex) {
            this.reportError("writer", ex, 4);
            this.m_writer = null;
        }
        this.setFormatter(CLogFormatter.get());
        this.setLevel(Level.ALL);
        this.setFilter(CLogFilter.get());
    }

    private boolean createFile(String baseDirName, boolean createLogDir, boolean isClient) {
        String fileName = baseDirName;
        try {
            File file;
            String finalName;
            File dir;
            if (!(fileName == null || (dir = new File(fileName)).exists() && dir.isDirectory())) {
                this.reportError("Invalid base directory: " + fileName, null, 4);
                fileName = null;
            }
            if (fileName != null && createLogDir) {
                dir = new File(fileName = String.valueOf(fileName) + File.separator + "log");
                if (!dir.exists()) {
                    dir.mkdir();
                }
                if (!dir.exists() || !dir.isDirectory()) {
                    this.reportError("Invalid log directory: " + fileName, null, 4);
                    fileName = null;
                }
            }
            if (fileName != null) {
                String dateFileName = String.valueOf(fileName) + File.separator;
                dateFileName = isClient ? String.valueOf(dateFileName) + "client." : String.valueOf(dateFileName) + "idempiere.";
                this.m_fileNameDate = CLogFile.getFileNameDate(System.currentTimeMillis());
                dateFileName = String.valueOf(dateFileName) + this.m_fileNameDate + "_";
                int i2 = 0;
                while (i2 < 100) {
                    finalName = String.valueOf(dateFileName) + i2 + ".log";
                    file = new File(finalName);
                    if (!file.exists()) {
                        this.m_file = file;
                        break;
                    }
                    ++i2;
                }
            }
            if (this.m_file == null) {
                String timeFileName = String.valueOf(fileName) + File.separator;
                timeFileName = isClient ? String.valueOf(timeFileName) + "client." : String.valueOf(timeFileName) + "idempiere.";
                String fileNameTime = CLogFile.getFileNameDateTime(System.currentTimeMillis());
                finalName = String.valueOf(timeFileName) + fileNameTime + ".log";
                file = new File(finalName);
                if (!file.exists()) {
                    this.m_file = file;
                }
            }
            if (this.m_file == null) {
                this.m_fileNameDate = CLogFile.getFileNameDate(System.currentTimeMillis());
                this.m_file = File.createTempFile("idempiere" + this.m_fileNameDate + "_", ".log");
            }
        }
        catch (Exception ex) {
            this.reportError("file", ex, 4);
            this.m_file = null;
            return false;
        }
        return true;
    }

    public static String getFileNameDate(long time) {
        Timestamp ts = new Timestamp(time);
        String s = ts.toString();
        return s.substring(0, 10);
    }

    public static String getFileNameDateTime(long time) {
        Timestamp ts = new Timestamp(time);
        String s = ts.toString();
        s = s.replaceAll("[ :]", "-");
        return s.substring(0, 19);
    }

    private void rotateLog(long time) {
        if (this.m_fileNameDate == null || this.m_fileNameDate.equals(CLogFile.getFileNameDate(time))) {
            return;
        }
        this.rotateLog();
    }

    public void rotateLog() {
        this.initialize(this.m_idempiereHome, true, Ini.isClient());
    }

    public void reopen() {
        if (this.m_previousFile != null && this.m_previousFile.exists() && this.m_file == null && this.m_writer == null) {
            try {
                this.m_file = this.m_previousFile;
                this.m_writer = new FileWriter(this.m_file, true);
                this.m_records = 0;
            }
            catch (Exception ex) {
                this.reportError("writer", ex, 4);
                this.m_writer = null;
                this.m_file = null;
            }
        }
    }

    public String getFileName() {
        if (this.m_file != null) {
            return this.m_file.getAbsolutePath();
        }
        return "";
    }

    public File getLogDirectory() {
        if (this.m_file != null) {
            return this.m_file.getParentFile();
        }
        return null;
    }

    @Override
    public synchronized void setLevel(Level newLevel) throws SecurityException {
        if (newLevel == null) {
            return;
        }
        super.setLevel(newLevel);
    }

    @Override
    public synchronized void publish(LogRecord record) {
        if (!this.isLoggable(record) || this.m_writer == null) {
            return;
        }
        this.rotateLog(record.getMillis());
        String msg = null;
        try {
            msg = this.getFormatter().format(record);
        }
        catch (Exception ex) {
            this.reportError("formatting", ex, 5);
            return;
        }
        try {
            if (!this.m_doneHeader) {
                this.m_writer.write(this.getFormatter().getHead(this));
                this.m_doneHeader = true;
            }
            this.m_writer.write(msg);
            ++this.m_records;
            if (record.getLevel() == Level.SEVERE || record.getLevel() == Level.WARNING || record.getLevel() == Level.OFF || this.m_records % 10 == 0) {
                this.flush();
            }
        }
        catch (Exception ex) {
            this.reportError("writing", ex, 1);
        }
    }

    @Override
    public void flush() {
        try {
            if (this.m_writer != null) {
                this.m_writer.flush();
            }
        }
        catch (Exception ex) {
            this.reportError("flush", ex, 2);
        }
    }

    @Override
    public synchronized void close() throws SecurityException {
        if (this.m_writer == null) {
            return;
        }
        try {
            if (!this.m_doneHeader) {
                this.m_writer.write(this.getFormatter().getHead(this));
            }
            this.m_writer.write(this.getFormatter().getTail(this));
        }
        catch (Exception ex) {
            this.reportError("tail", ex, 1);
        }
        this.flush();
        try {
            this.m_writer.close();
        }
        catch (Exception ex) {
            this.reportError("close", ex, 3);
        }
        this.m_writer = null;
        this.m_previousFile = this.m_file;
        this.m_file = null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CLogFile[");
        sb.append(this.getFileName()).append(",Level=").append(this.getLevel()).append("]");
        return sb.toString();
    }

    public static CLogFile get(boolean create, String idempiereHome, boolean isClient) {
        Handler handler;
        Handler[] handlers;
        Handler[] handlerArray = handlers = CLogMgt.getHandlers();
        int n = handlers.length;
        int n2 = 0;
        while (n2 < n) {
            handler = handlerArray[n2];
            if (handler instanceof CLogFile) {
                return (CLogFile)handler;
            }
            ++n2;
        }
        if (create) {
            handler = new CLogFile(idempiereHome, true, isClient);
            CLogMgt.addHandler(handler);
            return handler;
        }
        return null;
    }
}

