/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import org.compiere.util.AmtInWords;

public class AmtInWords_BG
implements AmtInWords {
    private static final String zero = "\u041d\u0443\u043b\u0430";
    private static final String negative = "\u041d\u0443\u043b\u0430";
    private static final String concat = "\u0438";
    private static final String[] lev = new String[]{"\u043b\u0435\u0432", "\u043b\u0435\u0432\u0430"};
    private static final String[][] majorNames = new String[][]{{"", ""}, {"\u0425\u0438\u043b\u044f\u0434\u0430", "\u0425\u0438\u043b\u044f\u0434\u0438"}, {"\u041c\u0438\u043b\u0438\u043e\u043d", "\u041c\u0438\u043b\u0438\u043e\u043d\u0430"}, {"\u041c\u0438\u043b\u0438\u0430\u0440\u0434", "\u041c\u0438\u043b\u0438\u0430\u0440\u0434\u0430"}, {"\u0422\u0440\u0438\u043b\u0438\u043e\u043d", "\u0422\u0440\u0438\u043b\u0438\u043e\u043d\u0430"}, {"\u041a\u0432\u0430\u0434\u0440\u0430\u043b\u0438\u043e\u043d", "\u041a\u0432\u0430\u0434\u0440\u0430\u043b\u0438\u043e\u043d\u0430"}, {"\u041a\u0432\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d", "\u041a\u0432\u0438\u043d\u0442\u0438\u043b\u0438\u043e\u043d\u0430"}};
    private static final String[] tensNames = new String[]{"", "\u0414\u0435\u0441\u0435\u0442", "\u0414\u0432\u0430\u0434\u0435\u0441\u0435\u0442", "\u0422\u0440\u0438\u0434\u0435\u0441\u0435\u0442", "\u0427\u0435\u0442\u0438\u0440\u0438\u0434\u0435\u0441\u0435\u0442", "\u041f\u0435\u0442\u0434\u0435\u0441\u0435\u0442", "\u0428\u0435\u0441\u0442\u0434\u0435\u0441\u0435\u0442", "\u0421\u0435\u0434\u0435\u043c\u0434\u0435\u0441\u0435\u0442", "\u041e\u0441\u0435\u043c\u0434\u0435\u0441\u0435\u0442", "\u0414\u0435\u0432\u0435\u0442\u0434\u0435\u0441\u0435\u0442"};
    private static final String[] hundredNames = new String[]{"", "\u0421\u0442\u043e", "\u0414\u0432\u0435\u0441\u0442\u0430", "\u0422\u0440\u0438\u0441\u0442\u0430", "\u0427\u0435\u0442\u0438\u0440\u0438\u0441\u0442\u043e\u0442\u0438\u043d", "\u041f\u0435\u0442\u0441\u0442\u043e\u0442\u0438\u043d", "\u0428\u0435\u0441\u0442\u0441\u0442\u043e\u0442\u0438\u043d", "\u0421\u0435\u0434\u0435\u043c\u0441\u0442\u043e\u0442\u0438\u043d", "\u041e\u0441\u0435\u043c\u0441\u0442\u043e\u0442\u0438\u043d", "\u0414\u0435\u0432\u0435\u0442\u0441\u0442\u043e\u0442\u0438\u043d"};
    private static final String[][] numNames = new String[][]{{"", ""}, {"\u0415\u0434\u0438\u043d", "\u0415\u0434\u043d\u0430"}, {"\u0414\u0432\u0430", "\u0414\u0432\u0435"}, {"\u0422\u0440\u0438", "\u0422\u0440\u0438"}, {"\u0427\u0435\u0442\u0438\u0440\u0438", "\u0427\u0435\u0442\u0438\u0440\u0438"}, {"\u041f\u0435\u0442", "\u041f\u0435\u0442"}, {"\u0428\u0435\u0441\u0442", "\u0428\u0435\u0441\u0442"}, {"\u0421\u0435\u0434\u0435\u043c", "\u0421\u0435\u0434\u0435\u043c"}, {"\u041e\u0441\u0435\u043c", "\u041e\u0441\u0435\u043c"}, {"\u0414\u0435\u0432\u0435\u0442", "\u0414\u0435\u0432\u0435\u0442"}, {"\u0414\u0435\u0441\u0435\u0442", "\u0414\u0435\u0441\u0435\u0442"}, {"\u0415\u0434\u0438\u043d\u0430\u0434\u0435\u0441\u0435\u0442", "\u0415\u0434\u0438\u043d\u0430\u0434\u0435\u0441\u0435\u0442"}, {"\u0414\u0432\u0430\u043d\u0430\u0434\u0435\u0441\u0435\u0442", "\u0414\u0432\u0430\u043d\u0430\u0434\u0435\u0441\u0435\u0442"}, {"\u0422\u0440\u0438\u043d\u0430\u0434\u0435\u0441\u0435\u0442", "\u0422\u0440\u0438\u043d\u0430\u0434\u0435\u0441\u0435\u0442"}, {"\u0427\u0435\u0442\u0438\u0440\u0438\u043d\u0430\u0434\u0435\u0441\u0442", "\u0427\u0435\u0442\u0438\u0440\u0438\u043d\u0430\u0434\u0435\u0441\u0442"}, {"\u041f\u0435\u0442\u043d\u0430\u0434\u0435\u0441\u0435\u0442", "\u041f\u0435\u0442\u043d\u0430\u0434\u0435\u0441\u0435\u0442"}, {"\u0428\u0435\u0441\u0442\u043d\u0430\u0434\u0435\u0441\u0435\u0442", "\u0428\u0435\u0441\u0442\u043d\u0430\u0434\u0435\u0441\u0435\u0442"}, {"\u0421\u0435\u0434\u0435\u043c\u043d\u0430\u0434\u0435\u0441\u0435\u0442", "\u0421\u0435\u0434\u0435\u043c\u043d\u0430\u0434\u0435\u0441\u0435\u0442"}, {"\u041e\u0441\u0435\u043c\u043d\u0430\u0434\u0435\u0441\u0435\u0442", "\u041e\u0441\u0435\u043c\u043d\u0430\u0434\u0435\u0441\u0435\u0442"}, {"\u0414\u0435\u0432\u0435\u0442\u043d\u0430\u0434\u0435\u0441\u0435\u0442", "\u0414\u0435\u0432\u0435\u0442\u043d\u0430\u0434\u0435\u0441\u0435\u0442"}};

    private String convertLessThanOneThousand(int number, int w) {
        String soFar;
        if (number % 100 < 20) {
            soFar = numNames[number % 100][w];
            number /= 100;
        } else {
            soFar = numNames[number % 10][w];
            soFar = soFar.compareTo("") == 0 ? tensNames[number % 10] : String.valueOf(tensNames[(number /= 10) % 10]) + " " + concat + " " + soFar;
            number /= 10;
        }
        if (number == 0) {
            return soFar;
        }
        return String.valueOf(hundredNames[number]) + " " + soFar;
    }

    private String convert(long number) {
        if (number == 0L) {
            return "\u041d\u0443\u043b\u0430";
        }
        String prefix = "";
        if (number < 0L) {
            number = -number;
            prefix = "\u041d\u0443\u043b\u0430 ";
        }
        String soFar = "";
        int place = 0;
        do {
            long n;
            if ((n = number % 1000L) != 0L) {
                String s = this.convertLessThanOneThousand((int)n, place == 1 ? 1 : 0);
                soFar = place == 1 && s.compareTo(numNames[1][1]) == 0 ? " " + majorNames[place][0] + " " + soFar : String.valueOf(s) + " " + majorNames[place][n > 1L ? 1 : 0] + " " + soFar;
            }
            ++place;
        } while ((number /= 1000L) > 0L);
        return (String.valueOf(prefix) + soFar).trim();
    }

    @Override
    public String getAmtInWords(String amount) throws Exception {
        if (amount == null) {
            return amount;
        }
        StringBuilder sb = new StringBuilder();
        int sep = (amount = amount.replaceAll(" ", "").replaceAll("\u00a0", "")).contains(",") ? 44 : 46;
        int pos = amount.lastIndexOf(sep);
        long levs = Long.parseLong(pos >= 0 ? amount.substring(0, pos) : amount);
        sb.append(String.valueOf(this.convert(levs)) + " " + lev[levs == 1L ? 0 : 1]);
        if (pos > 0) {
            String stotinki = amount.substring(pos + 1);
            if (stotinki.length() > 2) {
                stotinki = stotinki.substring(0, 2);
            }
            sb.append(" \u0438 ").append(this.convert(Long.parseLong(stotinki))).append(" \u0441\u0442\u043e\u0442\u0438\u043d\u043a\u0438");
        }
        return sb.toString();
    }

    private void print(String amt) {
        try {
            System.out.println(String.valueOf(amt) + " = " + this.getAmtInWords(amt));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        AmtInWords_BG aiw = new AmtInWords_BG();
        aiw.print("0.23");
        aiw.print("23");
        aiw.print("0,23");
        aiw.print("1,23");
        aiw.print("12,345");
        aiw.print("123,45");
        aiw.print("1 234,56");
        aiw.print("12 345,78");
        aiw.print("123 457,89");
        aiw.print("1 234 578,90");
        aiw.print("10,00");
        aiw.print("50,00");
        aiw.print("100,00");
        aiw.print("300,00");
        aiw.print("1 000,00");
        aiw.print("3 000,00");
        aiw.print("10 000,00");
        aiw.print("1 000 000,00");
        aiw.print("100 000 000,00");
        aiw.print("100 000 000 000 000 0000,00");
    }
}

