/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class Strip {
    private static final boolean VERBOSE = false;

    public void stripDirectory(String directory, String nameMustContain) {
        if (directory == null) {
            throw new NullPointerException("Strip: directory cannot be null");
        }
        File dir = new File(directory);
        if (!dir.exists() || !dir.isDirectory()) {
            throw new IllegalArgumentException("Strip: directory  does not exist or is not a directory: " + dir);
        }
        File[] list = dir.listFiles();
        if (list == null) {
            return;
        }
        int i2 = 0;
        while (i2 < list.length) {
            String name = list[i2].getAbsolutePath();
            if (list[i2].isDirectory()) {
                this.stripDirectory(name, nameMustContain);
            } else if (nameMustContain == null || name.indexOf(nameMustContain) != -1) {
                this.strip(list[i2], null);
            }
            ++i2;
        }
    }

    public boolean strip(String infile, String outfile) {
        if (infile == null) {
            throw new NullPointerException("Strip: infile cannot be null");
        }
        File in = new File(infile);
        File out = null;
        if (outfile != null) {
            out = new File(outfile);
        }
        return this.strip(in, out);
    }

    public boolean strip(File infile, File outfile) {
        if (infile == null) {
            throw new NullPointerException("Strip: infile cannot ne null");
        }
        if (!infile.exists() || !infile.isFile()) {
            throw new IllegalArgumentException("Strip: infile does not exist or is not a file: " + infile);
        }
        System.out.println("Stripping file: " + infile);
        if (infile.equals(outfile)) {
            outfile = null;
        }
        boolean tempfile = false;
        if (outfile == null) {
            try {
                outfile = File.createTempFile("strip", ".txt");
            }
            catch (IOException ioe) {
                System.err.println(ioe);
                return false;
            }
            tempfile = true;
        }
        try {
            outfile.createNewFile();
        }
        catch (IOException ioe) {
            System.err.println(ioe);
            return false;
        }
        if (!outfile.exists() || !outfile.canWrite()) {
            throw new IllegalArgumentException("Strip output file cannot be created or written: " + outfile);
        }
        if (!this.copy(infile, outfile)) {
            return false;
        }
        if (tempfile) {
            if (!infile.renameTo(new File(String.valueOf(infile.getAbsolutePath()) + ".bak"))) {
                System.err.println("Could not rename original file: " + infile);
            }
            if (!outfile.renameTo(infile)) {
                System.err.println("Could not rename " + outfile + " to: " + infile);
            }
        }
        return true;
    }

    private boolean copy(File infile, File outfile) {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            try {
                int c;
                fis = new FileInputStream(infile);
                fos = new FileOutputStream(outfile, false);
                int noIn = 0;
                int noOut = 0;
                int noLines = 1;
                while ((c = fis.read()) != -1) {
                    ++noIn;
                    if (c != 10) {
                        fos.write(c);
                        ++noOut;
                    }
                    if (c != 13) continue;
                    ++noLines;
                }
                System.out.println("  read: " + noIn + ", written: " + noOut + " - lines: " + noLines);
            }
            catch (IOException ioe) {
                System.err.println(ioe);
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return false;
            }
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("Syntax: Strip infile outfile");
            System.exit(-1);
        }
        String p2 = null;
        if (args.length > 1) {
            p2 = args[1];
        }
        new Strip().strip(args[0], p2);
    }
}

