/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.report;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.tree.TreeNode;
import org.compiere.model.MAcctSchemaElement;
import org.compiere.model.MHierarchy;
import org.compiere.model.MRole;
import org.compiere.model.MTree;
import org.compiere.model.MTreeNode;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MReportTree {
    private static CCache<String, MReportTree> s_trees = new CCache(null, "MReportTree", 20, false);
    private int m_PA_Hierarchy_ID = 0;
    private String m_ElementType = null;
    private Properties m_ctx = null;
    private String m_TreeType = null;
    private MTree m_tree = null;
    private CLogger log = CLogger.getCLogger(this.getClass());

    public static MReportTree get(Properties ctx, int PA_Hierarchy_ID, String ElementType2) {
        MReportTree tree;
        MRole role = MRole.getDefault();
        String key = String.valueOf(Env.getAD_Client_ID(ctx)) + "_" + role.getAD_Role_ID() + "_" + PA_Hierarchy_ID + "_" + ElementType2;
        if (!role.isAccessAllOrgs() && role.isUseUserOrgAccess()) {
            key = String.valueOf(Env.getAD_Client_ID(ctx)) + "_" + Env.getAD_User_ID(ctx) + "_" + role.getAD_Role_ID() + "_" + PA_Hierarchy_ID + "_" + ElementType2;
        }
        if ((tree = s_trees.get(key)) == null) {
            tree = new MReportTree(ctx, PA_Hierarchy_ID, ElementType2);
            s_trees.put(key, tree);
        }
        return tree;
    }

    public static String getWhereClause(Properties ctx, int PA_Hierarchy_ID, String ElementType2, int ID) {
        MReportTree tree = MReportTree.get(ctx, PA_Hierarchy_ID, ElementType2);
        return tree.getWhereClause(ID);
    }

    public static Integer[] getChildIDs(Properties ctx, int PA_Hierarchy_ID, String ElementType2, int ID) {
        MReportTree tree = MReportTree.get(ctx, PA_Hierarchy_ID, ElementType2);
        return tree.getChildIDs(ID);
    }

    public MReportTree(Properties ctx, int PA_Hierarchy_ID, String ElementType2) {
        this(ctx, PA_Hierarchy_ID, false, ElementType2);
    }

    public MReportTree(Properties ctx, int PA_Hierarchy_ID, boolean allNodes, String ElementType2) {
        this.m_TreeType = this.m_ElementType = ElementType2;
        if ("AC".equals(this.m_ElementType) || "U1".equals(this.m_ElementType) || "U2".equals(this.m_ElementType)) {
            this.m_TreeType = "EV";
        }
        if ("OT".equals(this.m_ElementType)) {
            this.m_TreeType = "OO";
        }
        this.m_PA_Hierarchy_ID = PA_Hierarchy_ID;
        this.m_ctx = ctx;
        int AD_Tree_ID = this.getAD_Tree_ID();
        if (AD_Tree_ID == 0) {
            throw new IllegalArgumentException("No AD_Tree_ID for TreeType=" + this.m_TreeType + ", PA_Hierarchy_ID=" + PA_Hierarchy_ID);
        }
        boolean clientTree = true;
        this.m_tree = new MTree(ctx, AD_Tree_ID, true, clientTree, allNodes, null);
        this.m_tree.trimTree();
    }

    protected int getAD_Tree_ID() {
        if (this.m_PA_Hierarchy_ID == 0) {
            return this.getDefaultAD_Tree_ID();
        }
        MHierarchy hierarchy = MHierarchy.get(this.m_ctx, this.m_PA_Hierarchy_ID);
        int AD_Tree_ID = hierarchy.getAD_Tree_ID(this.m_TreeType);
        if (AD_Tree_ID == 0) {
            return this.getDefaultAD_Tree_ID();
        }
        return AD_Tree_ID;
    }

    protected int getDefaultAD_Tree_ID() {
        int AD_Tree_ID;
        block6: {
            AD_Tree_ID = 0;
            int AD_Client_ID = Env.getAD_Client_ID(this.m_ctx);
            String sql = "SELECT AD_Tree_ID, Name FROM AD_Tree WHERE AD_Client_ID=? AND TreeType=? AND IsActive='Y' AND IsAllNodes='Y' ORDER BY IsDefault DESC, AD_Tree_ID";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, AD_Client_ID);
                    pstmt.setString(2, this.m_TreeType);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        AD_Tree_ID = rs.getInt(1);
                    }
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return AD_Tree_ID;
    }

    public String getElementType() {
        return this.m_ElementType;
    }

    public String getTreeType() {
        return this.m_TreeType;
    }

    public MTree getTree() {
        return this.m_tree;
    }

    public String getWhereClause(int ID) {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("(" + this.m_ElementType + ") ID=" + ID);
        }
        String ColumnName = MAcctSchemaElement.getColumnName(this.m_ElementType);
        MTreeNode node = this.m_tree.getRoot().findNode(ID);
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("Root=" + node);
        }
        StringBuilder result = null;
        if (node != null && node.isSummary()) {
            Enumeration<TreeNode> en = node.preorderEnumeration();
            StringBuilder sb = new StringBuilder();
            while (en.hasMoreElements()) {
                MTreeNode nn = (MTreeNode)en.nextElement();
                if (!nn.isSummary()) {
                    if (sb.length() > 0) {
                        sb.append(" OR ");
                    }
                    sb.append(ColumnName);
                    sb.append('=');
                    sb.append(nn.getNode_ID());
                    if (!this.log.isLoggable(Level.FINEST)) continue;
                    this.log.finest("- " + nn);
                    continue;
                }
                if (!this.log.isLoggable(Level.FINEST)) continue;
                this.log.finest("- skipped parent (" + nn + ")");
            }
            result = new StringBuilder(" ( ");
            result.append((CharSequence)sb);
            result.append(" ) ");
        } else {
            result = new StringBuilder(ColumnName).append("=").append(ID);
        }
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest(result.toString());
        }
        return result.toString();
    }

    public Integer[] getChildIDs(int ID) {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("(" + this.m_ElementType + ") ID=" + ID);
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        MTreeNode node = this.m_tree.getRoot().findNode(ID);
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("Root=" + node);
        }
        if (node != null && node.isSummary()) {
            Enumeration<TreeNode> en = node.preorderEnumeration();
            while (en.hasMoreElements()) {
                MTreeNode nn = (MTreeNode)en.nextElement();
                if (!nn.isSummary()) {
                    list.add(nn.getNode_ID());
                    if (!this.log.isLoggable(Level.FINEST)) continue;
                    this.log.finest("- " + nn);
                    continue;
                }
                if (!this.log.isLoggable(Level.FINEST)) continue;
                this.log.finest("- skipped parent (" + nn + ")");
            }
        } else {
            list.add(ID);
        }
        Integer[] retValue = new Integer[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MReportTree[ElementType=");
        sb.append(this.m_ElementType).append(",TreeType=").append(this.m_TreeType).append(",").append(this.m_tree).append("]");
        return sb.toString();
    }
}

