/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.report;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.X_PA_ReportColumn;
import org.compiere.report.MReportTree;

public class MReportColumn
extends X_PA_ReportColumn {
    private static final long serialVersionUID = 2584173320087743126L;

    public MReportColumn(Properties ctx, int PA_ReportColumn_ID, String trxName) {
        super(ctx, PA_ReportColumn_ID, trxName);
        if (PA_ReportColumn_ID == 0) {
            this.setIsPrinted(true);
            this.setSeqNo(0);
        }
    }

    public MReportColumn(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public String getSelectClause(boolean withSum) {
        String amountType = this.getPAAmountType();
        StringBuilder sb = new StringBuilder();
        if (withSum) {
            sb.append("SUM(");
        }
        if ("B".equals(amountType)) {
            sb.append("acctBalance(Account_ID,AmtAcctDr,AmtAcctCr)");
        } else if ("S".equals(amountType)) {
            sb.append("AmtAcctDr-AmtAcctCr");
        } else if ("C".equals(amountType)) {
            sb.append("AmtAcctCr");
        } else if ("D".equals(amountType)) {
            sb.append("AmtAcctDr");
        } else if ("R".equals(amountType)) {
            sb.append("Qty");
        } else if ("Q".equals(amountType)) {
            sb.append("acctBalance(Account_ID,Qty,0)");
        } else {
            this.log.log(Level.SEVERE, "AmountType=" + this.getPAAmountType() + ", at=" + amountType);
            return "NULL";
        }
        if (withSum) {
            sb.append(")");
        }
        return sb.toString();
    }

    public boolean isPeriod() {
        String pt = this.getPAPeriodType();
        if (pt == null) {
            return false;
        }
        return "P".equals(pt);
    }

    public boolean isYear() {
        String pt = this.getPAPeriodType();
        if (pt == null) {
            return false;
        }
        return "Y".equals(pt);
    }

    public boolean isTotal() {
        String pt = this.getPAPeriodType();
        if (pt == null) {
            return false;
        }
        return "T".equals(pt);
    }

    public boolean isNatural() {
        String pt = this.getPAPeriodType();
        if (pt == null) {
            return false;
        }
        return "N".equals(pt);
    }

    public String getWhereClause(int PA_Hierarchy_ID) {
        if (!this.isColumnTypeSegmentValue()) {
            return "";
        }
        String et = this.getElementType();
        int ID = 0;
        if ("AC".equals(et)) {
            ID = this.getC_ElementValue_ID();
        } else if ("AY".equals(et)) {
            ID = this.getC_Activity_ID();
        } else if ("BP".equals(et)) {
            ID = this.getC_BPartner_ID();
        } else if ("MC".equals(et)) {
            ID = this.getC_Campaign_ID();
        } else if ("LF".equals(et)) {
            ID = this.getC_Location_ID();
        } else if ("LT".equals(et)) {
            ID = this.getC_Location_ID();
        } else if ("OO".equals(et)) {
            ID = this.getOrg_ID();
        } else if ("PR".equals(et)) {
            ID = this.getM_Product_ID();
        } else if ("PJ".equals(et)) {
            ID = this.getC_Project_ID();
        } else if ("SR".equals(et)) {
            ID = this.getC_SalesRegion_ID();
        } else if ("OT".equals(et)) {
            ID = this.getOrg_ID();
        } else if ("U1".equals(et)) {
            ID = this.getC_ElementValue_ID();
        } else if ("U2".equals(et)) {
            ID = this.getC_ElementValue_ID();
        } else {
            if ("X1".equals(et)) {
                return " AND UserElement1_ID=" + this.getUserElement1_ID();
            }
            if ("X2".equals(et)) {
                return " AND UserElement2_ID=" + this.getUserElement2_ID();
            }
            if ("CO".equals(et)) {
                return this.getWhereCombination(PA_Hierarchy_ID);
            }
            this.log.warning("Unsupported Element Type=" + et);
        }
        if (ID == 0) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("No Restrictions - No ID for EntityType=" + et);
            }
            return "";
        }
        return " AND " + MReportTree.getWhereClause(this.getCtx(), PA_Hierarchy_ID, et, ID);
    }

    private String getWhereCombination(int PA_Hierarchy_ID) {
        String whtree;
        StringBuilder whcomb = new StringBuilder();
        if (this.getC_ElementValue_ID() > 0) {
            whtree = MReportTree.getWhereClause(this.getCtx(), PA_Hierarchy_ID, "AC", this.getC_ElementValue_ID());
            if (this.isIncludeNullsElementValue()) {
                whcomb.append(" AND (Account_ID IS NULL OR ").append(whtree).append(")");
            } else {
                whcomb.append(" AND ").append(whtree);
            }
        } else if (this.isIncludeNullsElementValue()) {
            whcomb.append(" AND Account_ID IS NULL");
        }
        if (this.getC_Activity_ID() > 0) {
            whtree = MReportTree.getWhereClause(this.getCtx(), PA_Hierarchy_ID, "AY", this.getC_Activity_ID());
            if (this.isIncludeNullsActivity()) {
                whcomb.append(" AND (C_Activity_ID IS NULL OR ").append(whtree).append(")");
            } else {
                whcomb.append(" AND ").append(whtree);
            }
        } else if (this.isIncludeNullsActivity()) {
            whcomb.append(" AND C_Activity_ID IS NULL");
        }
        if (this.getC_BPartner_ID() > 0) {
            whtree = MReportTree.getWhereClause(this.getCtx(), PA_Hierarchy_ID, "BP", this.getC_BPartner_ID());
            if (this.isIncludeNullsBPartner()) {
                whcomb.append(" AND (C_BPartner_ID IS NULL OR ").append(whtree).append(")");
            } else {
                whcomb.append(" AND ").append(whtree);
            }
        } else if (this.isIncludeNullsBPartner()) {
            whcomb.append(" AND C_BPartner_ID IS NULL");
        }
        if (this.getC_Campaign_ID() > 0) {
            whtree = MReportTree.getWhereClause(this.getCtx(), PA_Hierarchy_ID, "MC", this.getC_Campaign_ID());
            if (this.isIncludeNullsCampaign()) {
                whcomb.append(" AND (C_Campaign_ID IS NULL OR ").append(whtree).append(")");
            } else {
                whcomb.append(" AND ").append(whtree);
            }
        } else if (this.isIncludeNullsCampaign()) {
            whcomb.append(" AND C_Campaign_ID IS NULL");
        }
        if (this.getC_Location_ID() > 0) {
            whtree = MReportTree.getWhereClause(this.getCtx(), PA_Hierarchy_ID, "LF", this.getC_Location_ID());
            if (this.isIncludeNullsLocation()) {
                whcomb.append(" AND (C_LocFrom_ID IS NULL OR ").append(whtree).append(")");
            } else {
                whcomb.append(" AND ").append(whtree);
            }
        } else if (this.isIncludeNullsLocation()) {
            whcomb.append(" AND C_LocFrom_ID IS NULL");
        }
        if (this.getOrg_ID() > 0) {
            whtree = MReportTree.getWhereClause(this.getCtx(), PA_Hierarchy_ID, "OO", this.getOrg_ID());
            if (this.isIncludeNullsOrg()) {
                whcomb.append(" AND (AD_Org_ID IS NULL OR ").append(whtree).append(")");
            } else {
                whcomb.append(" AND ").append(whtree);
            }
        } else if (this.isIncludeNullsOrg()) {
            whcomb.append(" AND AD_Org_ID IS NULL");
        }
        if (this.getAD_OrgTrx_ID() > 0) {
            whtree = MReportTree.getWhereClause(this.getCtx(), PA_Hierarchy_ID, "OT", this.getAD_OrgTrx_ID());
            if (this.isIncludeNullsOrgTrx()) {
                whcomb.append(" AND (AD_OrgTrx_ID IS NULL OR ").append(whtree).append(")");
            } else {
                whcomb.append(" AND ").append(whtree);
            }
        } else if (this.isIncludeNullsOrgTrx()) {
            whcomb.append(" AND AD_OrgTrx_ID IS NULL");
        }
        if (this.getM_Product_ID() > 0) {
            whtree = MReportTree.getWhereClause(this.getCtx(), PA_Hierarchy_ID, "PR", this.getM_Product_ID());
            if (this.isIncludeNullsProduct()) {
                whcomb.append(" AND (M_Product_ID IS NULL OR ").append(whtree).append(")");
            } else {
                whcomb.append(" AND ").append(whtree);
            }
        } else if (this.isIncludeNullsProduct()) {
            whcomb.append(" AND M_Product_ID IS NULL");
        }
        if (this.getC_Project_ID() > 0) {
            whtree = MReportTree.getWhereClause(this.getCtx(), PA_Hierarchy_ID, "PJ", this.getC_Project_ID());
            if (this.isIncludeNullsProject()) {
                whcomb.append(" AND (C_Project_ID IS NULL OR ").append(whtree).append(")");
            } else {
                whcomb.append(" AND ").append(whtree);
            }
        } else if (this.isIncludeNullsProject()) {
            whcomb.append(" AND C_Project_ID IS NULL");
        }
        if (this.getC_SalesRegion_ID() > 0) {
            whtree = MReportTree.getWhereClause(this.getCtx(), PA_Hierarchy_ID, "SR", this.getC_SalesRegion_ID());
            if (this.isIncludeNullsSalesRegion()) {
                whcomb.append(" AND (C_SalesRegion_ID IS NULL OR ").append(whtree).append(")");
            } else {
                whcomb.append(" AND ").append(whtree);
            }
        } else if (this.isIncludeNullsSalesRegion()) {
            whcomb.append(" AND C_SalesRegion_ID IS NULL");
        }
        if (this.getUserElement1_ID() > 0) {
            whtree = "UserElement1_ID=" + this.getUserElement1_ID();
            if (this.isIncludeNullsUserElement1()) {
                whcomb.append(" AND (UserElement1_ID IS NULL OR ").append(whtree).append(")");
            } else {
                whcomb.append(" AND ").append(whtree);
            }
        } else if (this.isIncludeNullsUserElement1()) {
            whcomb.append(" AND UserElement1_ID IS NULL");
        }
        if (this.getUserElement2_ID() > 0) {
            whtree = "UserElement2_ID=" + this.getUserElement2_ID();
            if (this.isIncludeNullsUserElement2()) {
                whcomb.append(" AND (UserElement2_ID IS NULL OR ").append(whtree).append(")");
            } else {
                whcomb.append(" AND ").append(whtree);
            }
        } else if (this.isIncludeNullsUserElement2()) {
            whcomb.append(" AND UserElement2_ID IS NULL");
        }
        return whcomb.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MReportColumn[").append(this.get_ID()).append(" - ").append(this.getName()).append(" - ").append(this.getDescription()).append(", SeqNo=").append(this.getSeqNo()).append(", AmountType=").append(this.getPAAmountType()).append(", PeriodType=").append(this.getPAPeriodType()).append(", CurrencyType=").append(this.getCurrencyType()).append("/").append(this.getC_Currency_ID()).append(" - ColumnType=").append(this.getColumnType());
        if (this.isColumnTypeCalculation()) {
            sb.append(" - Calculation=").append(this.getCalculationType()).append(" - ").append(this.getOper_1_ID()).append(" - ").append(this.getOper_2_ID());
        } else if (this.isColumnTypeRelativePeriod()) {
            sb.append(" - Period=").append(this.getRelativePeriod());
        } else {
            sb.append(" - SegmentValue ElementType=").append(this.getElementType());
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean isCalculationTypeRange() {
        return "R".equals(this.getCalculationType());
    }

    public boolean isCalculationTypeAdd() {
        return "A".equals(this.getCalculationType());
    }

    public boolean isCalculationTypeSubtract() {
        return "S".equals(this.getCalculationType());
    }

    public boolean isCalculationTypePercent() {
        return "P".equals(this.getCalculationType());
    }

    public boolean isColumnTypeCalculation() {
        return "C".equals(this.getColumnType());
    }

    public boolean isColumnTypeRelativePeriod() {
        return "R".equals(this.getColumnType());
    }

    public boolean isColumnTypeSegmentValue() {
        return "S".equals(this.getColumnType());
    }

    public int getRelativePeriodAsInt() {
        BigDecimal bd = this.getRelativePeriod();
        if (bd == null) {
            return 0;
        }
        return bd.intValue();
    }

    @Override
    public BigDecimal getRelativePeriod() {
        if (this.getColumnType().equals("R") || this.getColumnType().equals("S")) {
            return super.getRelativePeriod();
        }
        return null;
    }

    @Override
    public BigDecimal getRelativePeriodTo() {
        if (this.getColumnType().equals("R") || this.getColumnType().equals("S")) {
            return (BigDecimal)this.get_Value("RelativePeriodTo");
        }
        return null;
    }

    @Override
    public String getElementType() {
        if (this.getColumnType().equals("S")) {
            return super.getElementType();
        }
        return null;
    }

    @Override
    public String getCalculationType() {
        if (this.getColumnType().equals("C")) {
            return super.getCalculationType();
        }
        return null;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        String ct = this.getColumnType();
        if (ct.equals("R")) {
            this.setElementType(null);
            this.setCalculationType(null);
        } else if (ct.equals("C")) {
            this.setElementType(null);
            this.setRelativePeriod(null);
        } else if (ct.equals("S")) {
            this.setCalculationType(null);
        }
        return true;
    }

    public static MReportColumn copy(Properties ctx, int AD_Client_ID, int AD_Org_ID, int PA_ReportColumnSet_ID, MReportColumn source, String trxName) {
        MReportColumn retValue = new MReportColumn(ctx, 0, trxName);
        MReportColumn.copyValues(source, retValue, AD_Client_ID, AD_Org_ID);
        retValue.setPA_ReportColumnSet_ID(PA_ReportColumnSet_ID);
        retValue.setOper_1_ID(0);
        retValue.setOper_2_ID(0);
        return retValue;
    }
}

