/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.report;

import java.math.BigDecimal;
import java.sql.Timestamp;
import org.adempiere.base.annotation.Process;
import org.compiere.model.MPeriod;
import org.compiere.model.MProcessPara;
import org.compiere.print.MPrintFormat;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Msg;

@Process
public class BankRegister
extends SvrProcess {
    private int p_C_Bank_ID = 0;
    private int p_C_BankAccount_ID = 0;
    private Timestamp p_DateAcct_From = null;
    private Timestamp p_DateAcct_To = null;
    private int p_C_BPartner_ID = 0;
    private StringBuffer m_parameterWhere = new StringBuffer();
    private long m_start = System.currentTimeMillis();

    @Override
    protected void prepare() {
        StringBuilder sb = new StringBuilder("Record_ID=").append(this.getRecord_ID());
        ProcessInfoParameter[] para = this.getParameter();
        int i2 = 0;
        while (i2 < para.length) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() != null || para[i2].getParameter_To() != null) {
                if (name.equals("C_Bank_ID")) {
                    this.p_C_Bank_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                } else if (name.equals("DateAcct")) {
                    this.p_DateAcct_From = (Timestamp)para[i2].getParameter();
                    this.p_DateAcct_To = (Timestamp)para[i2].getParameter_To();
                } else if (name.equals("C_BPartner_ID")) {
                    this.p_C_BPartner_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                } else if (name.equals("C_BankAccount_ID")) {
                    this.p_C_BankAccount_ID = para[i2].getParameterAsInt();
                } else {
                    MProcessPara.validateUnknownParameter(this.getProcessInfo().getAD_Process_ID(), para[i2]);
                }
            }
            ++i2;
        }
        this.m_parameterWhere.append(" fa.AD_Table_ID = (Select AD_Table_ID From AD_Table Where TableName = 'C_Payment') ");
        this.m_parameterWhere.append(" And b.C_Bank_ID = " + this.p_C_Bank_ID);
        if (this.p_C_BankAccount_ID > 0) {
            this.m_parameterWhere.append(" AND ba.C_BankAccount_ID = " + this.p_C_BankAccount_ID);
        }
        this.setDateAcct();
        sb.append(" - DateAcct ").append(this.p_DateAcct_From).append("-").append(this.p_DateAcct_To);
        sb.append(" - Where=").append(this.m_parameterWhere);
        this.log.fine(sb.toString());
    }

    private void setDateAcct() {
        if (this.p_DateAcct_From == null && this.p_DateAcct_To == null) {
            this.p_DateAcct_From = new Timestamp(System.currentTimeMillis());
            this.p_DateAcct_To = new Timestamp(System.currentTimeMillis());
        } else if (this.p_DateAcct_From != null && this.p_DateAcct_To == null) {
            this.p_DateAcct_To = new Timestamp(System.currentTimeMillis());
        } else if (this.p_DateAcct_From == null && this.p_DateAcct_To != null) {
            MPeriod first = MPeriod.getFirstInYear(this.getCtx(), this.p_DateAcct_To, Env.getAD_Org_ID(this.getCtx()));
            this.p_DateAcct_From = first.getStartDate();
        }
    }

    @Override
    protected String doIt() {
        this.createBalanceLine();
        this.createDetailLines();
        int AD_PrintFormat_ID = DB.getSQLValue(this.get_TrxName(), "Select AD_PrintFormat_ID from AD_PrintFormat Where name = 'Bank Register Report'");
        if (AD_PrintFormat_ID > 0) {
            if (Ini.isClient()) {
                this.getProcessInfo().setTransientObject(MPrintFormat.get(this.getCtx(), AD_PrintFormat_ID, false));
            } else {
                this.getProcessInfo().setSerializableObject(MPrintFormat.get(this.getCtx(), AD_PrintFormat_ID, false));
            }
        }
        this.log.fine(String.valueOf(System.currentTimeMillis() - this.m_start) + " ms");
        return "";
    }

    private void createBalanceLine() {
        StringBuilder sb = new StringBuilder("INSERT INTO T_BankRegister (AD_PInstance_ID, AD_Client_ID, AD_Org_ID, DateAcct, C_Bank_ID, BankName, C_BPartner_ID, BPartner, DocumentNo,AmtAcctDr, AmtAcctCr, Balance) ");
        sb.append("SELECT ").append(this.getAD_PInstance_ID()).append(", ").append(Env.getAD_Client_ID(this.getCtx())).append(", ").append(Env.getAD_Org_ID(this.getCtx())).append(", ").append(DB.TO_DATE(this.p_DateAcct_From, true)).append(", ").append(this.p_C_Bank_ID).append(", ").append(DB.TO_STRING(Msg.getMsg(Env.getCtx(), "Beginning Balance"))).append(", ").append(this.p_C_BPartner_ID).append(", NULL, NULL, COALESCE(SUM(fa.AmtAcctDr),0), COALESCE(SUM(fa.AmtAcctCr),0), COALESCE(SUM(fa.AmtAcctDr-fa.AmtAcctCr),0) From Fact_Acct fa Inner Join C_Payment p On p.C_Payment_ID = fa.Record_ID AND p.docstatus IN ('CO', 'CL') Inner Join C_BankAccount ba On ba.C_BankAccount_ID = p.C_BankAccount_ID Inner Join C_Bank b On ba.C_Bank_ID = b.C_Bank_ID Inner Join C_BankAccount_Acct baa On p.C_BankAccount_ID = baa.C_BankAccount_ID Inner Join C_VALIDCOMBINATION vc On (vc.C_VALIDCOMBINATION_id = baa.B_InTransit_Acct Or vc.C_VALIDCOMBINATION_id = baa.B_Asset_Acct) Inner Join C_ElementValue ev On ev.C_ElementValue_ID = vc.Account_ID Left Outer Join C_BPartner bp On bp.C_BPartner_ID = fa.C_BPartner_ID WHERE ").append(this.m_parameterWhere).append(" AND TRUNC(fa.DateAcct) < ").append(DB.TO_DATE(this.p_DateAcct_From)).append(" And fa.Account_ID = vc.Account_ID ");
        if (this.p_C_BPartner_ID != 0) {
            sb.append(" And fa.C_BPartner_ID = " + this.p_C_BPartner_ID);
        }
        int no = DB.executeUpdate(sb.toString(), this.get_TrxName());
        this.log.fine("#" + no);
        this.log.finest(sb.toString());
    }

    private void createDetailLines() {
        StringBuilder sb = new StringBuilder("INSERT INTO T_BankRegister (AD_PInstance_ID, AD_Client_ID, AD_Org_ID, DateAcct, C_Bank_ID, BankName, C_BPartner_ID, BPartner, DocumentNo, AmtAcctDr, AmtAcctCr, Balance) ");
        sb.append("SELECT DISTINCT ").append(this.getAD_PInstance_ID()).append(", fa.AD_Client_ID, fa.AD_Org_ID, ").append("TRUNC(fa.DateAcct), b.C_Bank_ID, b.name, bp.C_BPartner_ID, bp.name, p.documentNo, fa.AmtAcctDr, fa.AmtAcctCr, fa.AmtAcctDr-fa.AmtAcctCr From Fact_Acct fa Inner Join C_Payment p On p.C_Payment_ID = fa.Record_ID AND p.docstatus IN ('CO', 'CL') Inner Join C_BankAccount ba On ba.C_BankAccount_ID = p.C_BankAccount_ID Inner Join C_Bank b On ba.C_Bank_ID = b.C_Bank_ID Inner Join C_BankAccount_Acct baa On p.C_BankAccount_ID = baa.C_BankAccount_ID Inner Join C_VALIDCOMBINATION vc On (vc.C_VALIDCOMBINATION_id = baa.B_InTransit_Acct Or vc.C_VALIDCOMBINATION_id = baa.B_Asset_Acct) Inner Join C_ElementValue ev On (ev.C_ElementValue_ID = vc.Account_ID) Left Outer Join C_BPartner bp On bp.C_BPartner_ID = fa.C_BPartner_ID WHERE ").append(this.m_parameterWhere).append(" AND TRUNC(fa.DateAcct) BETWEEN ").append(DB.TO_DATE(this.p_DateAcct_From)).append(" AND ").append(DB.TO_DATE(this.p_DateAcct_To)).append(" And fa.Account_ID = vc.Account_ID ");
        if (this.p_C_BPartner_ID != 0) {
            sb.append(" And fa.C_BPartner_ID = " + this.p_C_BPartner_ID);
        }
        sb.append(" order by fa.AD_Client_ID, fa.AD_Org_ID, b.name, bp.name, p.documentNo, TRUNC(fa.DateAcct) ");
        int no = DB.executeUpdate(sb.toString(), this.get_TrxName());
        this.log.fine("#" + no);
        this.log.finest(sb.toString());
    }
}

