/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.Properties;
import org.adempiere.base.annotation.Process;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MIndexColumn;
import org.compiere.model.MTableIndex;
import org.compiere.process.ProcessInfo;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Msg;
import org.compiere.util.Trx;

@Process
public class TableIndexValidate
extends SvrProcess {
    private int p_AD_TableIndex_ID = 0;

    @Override
    protected void prepare() {
        this.p_AD_TableIndex_ID = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        MTableIndex index = new MTableIndex(this.getCtx(), this.p_AD_TableIndex_ID, this.get_TrxName());
        this.log.info(index.toString());
        return TableIndexValidate.validateTableIndex(this.getCtx(), index, this.get_TrxName(), this.getProcessInfo());
    }

    public static String validateTableIndex(Properties ctx, MTableIndex index, String trxName, ProcessInfo pi) throws Exception {
        Trx trx = Trx.get(trxName, true);
        DatabaseMetaData md = trx.getConnection().getMetaData();
        String tableName = index.getTableName();
        if (md.storesUpperCaseIdentifiers()) {
            tableName = tableName.toUpperCase();
        } else if (md.storesLowerCaseIdentifiers()) {
            tableName = tableName.toLowerCase();
        }
        String catalog = "REFERENCE";
        String schema = null;
        String[] indexColsFromDB = new String[30];
        String[] ascOrDescColsFromDB = new String[30];
        int numIndexColsFromDB = 0;
        boolean indexNUniqueInDB = true;
        boolean found = false;
        ResultSet rs = md.getIndexInfo(catalog, schema, tableName, false, true);
        while (rs.next()) {
            String dbIndexName = rs.getString("INDEX_NAME");
            if (dbIndexName == null || !index.getName().equalsIgnoreCase(dbIndexName)) continue;
            found = true;
            String columnName = rs.getString("COLUMN_NAME");
            short pos = rs.getShort("ORDINAL_POSITION");
            if (pos > 0) {
                indexColsFromDB[pos - 1] = columnName;
                ascOrDescColsFromDB[pos - 1] = rs.getString("ASC_OR_DESC");
            }
            indexNUniqueInDB = rs.getBoolean("NON_UNIQUE");
        }
        rs.close();
        MIndexColumn[] indexCols = index.getColumns(true, true);
        boolean modified = false;
        if (indexCols.length <= 0) {
            throw new AdempiereException(Msg.getMsg(ctx, "NoIndexColumnsSpecified"));
        }
        if (!found) {
            String sql = index.getDDL();
            int rvalue = DB.executeUpdateEx(sql, null, trxName);
            if (pi != null) {
                pi.addLog(0, null, new BigDecimal(rvalue), sql);
            }
            return Msg.getMsg(ctx, "CreatedIndexSuccess");
        }
        int i2 = 0;
        while (i2 < 30) {
            if (indexColsFromDB[i2] == null) break;
            ++numIndexColsFromDB;
            ++i2;
        }
        if (numIndexColsFromDB != indexCols.length) {
            modified = true;
        } else if (!indexNUniqueInDB != index.isUnique()) {
            modified = true;
        } else {
            int j = 0;
            while (j < indexCols.length) {
                String indexColFromDBWithAscOrDesc = indexColsFromDB[j];
                String ascOrDesc = ascOrDescColsFromDB[j];
                if (ascOrDesc != null && ascOrDesc.equals("D")) {
                    indexColFromDBWithAscOrDesc = String.valueOf(indexColFromDBWithAscOrDesc) + " DESC";
                } else if (ascOrDesc != null && ascOrDesc.equals("A")) {
                    indexColFromDBWithAscOrDesc = String.valueOf(indexColFromDBWithAscOrDesc) + " ASC";
                }
                if (!indexCols[j].getColumnName().equalsIgnoreCase(indexColsFromDB[j]) && !indexCols[j].getColumnName().equalsIgnoreCase(indexColFromDBWithAscOrDesc)) {
                    if (indexColsFromDB[j].startsWith("\"") && indexColsFromDB[j].endsWith("\"")) {
                        String cname = indexColsFromDB[j].substring(1, indexColsFromDB[j].length() - 1);
                        if (!cname.equalsIgnoreCase(indexCols[j].getColumnName())) {
                            modified = true;
                            break;
                        }
                    } else {
                        modified = true;
                        break;
                    }
                }
                ++j;
            }
        }
        if (modified) {
            String sql = index.getDropDDL();
            int rvalue = DB.executeUpdate(sql, null, true, trxName);
            if (pi != null) {
                pi.addLog(0, null, new BigDecimal(rvalue), sql);
            }
            sql = index.getDDL();
            rvalue = DB.executeUpdate(sql, null, true, trxName);
            if (pi != null) {
                pi.addLog(0, null, new BigDecimal(rvalue), sql);
            }
            if (rvalue == -1) {
                throw new AdempiereException(Msg.getMsg(ctx, "FailedModifyIndex"));
            }
            return Msg.getMsg(ctx, "ModifiedIndexSuccess");
        }
        return Msg.getMsg(ctx, "NoChangesToIndex");
    }
}

